/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.dataitems;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.dataitems.DataItemTreeNodeInfo;
import com.sas.swing.visuals.dataselectors.dataitems.DisabledNode;
import com.sas.visuals.Resources;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

@SASScope(value="ALL")
public class DisabledDataItemRenderer
extends DefaultTreeCellRenderer {
    protected Icon disabledLeafIcon;
    protected Icon disabledOpenIcon;
    protected Icon disabledClosedIcon;
    public static final String HIERARCHIES = "Hierarchies";
    public static final String LEVELS = "Levels";
    public static final String MEASURES = "Measures";
    public static final String DIMENSIONS = "Dimensions";
    public static final String COLUMNS = "Columns";

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof DisabledNode)) {
            return null;
        }
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        boolean treeIsEnabled = tree.isEnabled();
        boolean nodeIsEnabled = ((DisabledNode)value).isEnabled();
        boolean isEnabled = treeIsEnabled && nodeIsEnabled;
        boolean allowsChildren = ((DisabledNode)value).getAllowsChildren();
        DataItemTreeNodeInfo iteminfo = (DataItemTreeNodeInfo)((DisabledNode)value).getUserObject();
        String itemCategory = iteminfo.getCategory();
        if (itemCategory != null) {
            String disabledImage;
            String imagePath = iteminfo.getImagePath();
            String defaultImage = iteminfo.getDefaultImage();
            if (defaultImage != null && defaultImage.length() == 0) {
                defaultImage = null;
            }
            if ((disabledImage = iteminfo.getDisabledImage()) != null && disabledImage.length() == 0) {
                disabledImage = null;
            }
            if (defaultImage != null && imagePath != null) {
                defaultImage = imagePath + defaultImage;
            }
            if (disabledImage != null && imagePath != null) {
                disabledImage = imagePath + disabledImage;
            }
            if (itemCategory.equalsIgnoreCase(HIERARCHIES)) {
                this.setLeafIcon(new ImageIcon(Resources.getImage((String)(defaultImage != null ? defaultImage : "GIF_16/OLAPHierarchy"))));
                this.setDisabledLeafIcon(new ImageIcon(Resources.getImage((String)(disabledImage != null ? disabledImage : "GIF_16/OLAPHierarchy_disabled"))));
            } else if (itemCategory.equalsIgnoreCase(LEVELS)) {
                this.setLeafIcon(new ImageIcon(Resources.getImage((String)(defaultImage != null ? defaultImage : "GIF_16/OLAPLevel"))));
                this.setDisabledLeafIcon(new ImageIcon(Resources.getImage((String)(disabledImage != null ? disabledImage : "GIF_16/OLAPLevel_disabled"))));
            } else if (itemCategory.equalsIgnoreCase(MEASURES)) {
                this.setLeafIcon(new ImageIcon(Resources.getImage((String)(defaultImage != null ? defaultImage : "GIF_16/OLAPMeasure"))));
                this.setDisabledLeafIcon(new ImageIcon(Resources.getImage((String)(disabledImage != null ? disabledImage : "GIF_16/OLAPMeasure_disabled"))));
            } else if (itemCategory.equalsIgnoreCase(COLUMNS)) {
                this.setLeafIcon(new ImageIcon(Resources.getImage((String)(defaultImage != null ? defaultImage : "GIF_16/CategoryItemType"))));
                this.setDisabledLeafIcon(new ImageIcon(Resources.getImage((String)(disabledImage != null ? disabledImage : "GIF_16/CategoryItemType_disabled"))));
            }
        }
        this.setEnabled(isEnabled);
        if (isEnabled) {
            this.selected = sel;
            if (leaf && !allowsChildren) {
                this.setIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        } else {
            this.selected = false;
            if (leaf) {
                if (nodeIsEnabled) {
                    this.setDisabledIcon(this.getLeafIcon());
                } else {
                    this.setDisabledIcon(this.disabledLeafIcon);
                }
            } else if (expanded) {
                if (nodeIsEnabled) {
                    this.setDisabledIcon(this.getOpenIcon());
                } else {
                    this.setDisabledIcon(this.disabledOpenIcon);
                }
            } else if (nodeIsEnabled) {
                this.setDisabledIcon(this.getClosedIcon());
            } else {
                this.setDisabledIcon(this.disabledClosedIcon);
            }
        }
        return this;
    }

    public void setDisabledLeafIcon(Icon icon) {
        this.disabledLeafIcon = icon;
    }

    public void setDisabledOpenIcon(Icon icon) {
        this.disabledOpenIcon = icon;
    }

    public void setDisabledClosedIcon(Icon icon) {
        this.disabledClosedIcon = icon;
    }
}

