/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.dataitems;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.dataitems.DataItemSelectorInterface;
import com.sas.dataselectors.dataitems.DataItemTreeNodeInfo;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.dataitems.DisabledDataItemRenderer;
import com.sas.swing.visuals.dataselectors.dataitems.DisabledNode;
import com.sas.swing.visuals.dataselectors.dataitems.RB;
import com.sas.swing.visuals.dualselector.DualTreeSelector;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.util.RoleInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

@SASScope(value="ALL")
public class DataItemSelector
extends BaseSwingSelectorPanel
implements LayoutConstants,
TreeModelListener,
TreeSelectionListener,
ActionListener {
    @SASScope
    public static final String RB_KEY = "DataItemSelector.";
    protected JLabel roleLabel;
    protected JComboBox roleComboBox;
    protected DualTreeSelector dualSelector;
    protected JLabel viewItemsLabel;
    protected JComboBox viewItemsComboBox;
    protected JButton moveItemButton;
    protected JTextArea messageTextArea;
    protected JLabel queryTypeLabel;
    protected JRadioButton groupByRadioButton;
    protected JRadioButton detailRadioButton;
    protected DataItemSelectorInterface model;
    protected JPanel querySelectionPanel;
    protected JPanel lowerPanel;
    protected JPanel sourceContainer;
    protected JPanel viewItemsPanel;
    protected JPanel positionPanel;
    protected JPanel messagePanel;
    protected JPanel queryTypePanel;
    private String selectedRole;
    private boolean isOLAP;
    @SASScope
    public static final String HIERARCHIES = "Hierarchies";
    @SASScope
    public static final String LEVELS = "Levels";
    @SASScope
    public static final String MEASURES = "Measures";
    private static final String COLUMN_ROLE = RB.getStringResource("DataItemSelector.", "columnRole.txt");
    private static final String ROW_ROLE = RB.getStringResource("DataItemSelector.", "rowRole.txt");

    public DataItemSelector() {
        this.createComponents();
        this.addListeners();
    }

    protected void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        mainLayout.setRemainderRow(1);
        this.setLayout(mainLayout);
        this.querySelectionPanel = new JPanel();
        this.querySelectionPanel.setBorder(Util.getGroupBoxBorder(RB.getStringResource(RB_KEY, "dataSelection.txt"), 5, 5, 5, 5));
        AutoSizingGridLayout upperLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        upperLayout.setIgnoreSizeOfNonVisibleComponents(true);
        upperLayout.setRemainderRow(1);
        this.querySelectionPanel.setLayout(upperLayout);
        this.lowerPanel = new JPanel();
        this.messageTextArea = new JTextArea();
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setBackground(this.getBackground());
        this.dualSelector = new DualTreeSelector();
        this.dualSelector.setPreferredSize(new Dimension(50, 200));
        this.dualSelector.setSourceLabel(RB.getStringResource(RB_KEY, "availableItems.txt"));
        this.dualSelector.setTargetLabel(RB.getStringResource(RB_KEY, "selectedItems.txt"));
        this.dualSelector.setTransferAllControlsVisible(false);
        this.dualSelector.setAlternatingSingleButtonStyle(false);
        this.dualSelector.setSourceRootVisible(false);
        this.dualSelector.setTargetRootVisible(false);
        this.dualSelector.setCopyModeEnabled(true);
        this.dualSelector.setCopyModeDuplicatesAllowed(false);
        this.dualSelector.setTargetControlsVisible(false);
        this.dualSelector.setParentNodesMoveable(false);
        this.roleLabel = new JLabel();
        this.roleLabel.setText(RB.getStringResource(RB_KEY, "assignTo.txt"));
        this.roleComboBox = new JComboBox();
        this.roleComboBox.setEditable(false);
        this.moveItemButton = new JButton();
        this.moveItemButton.setLabel(RB.getStringResource(RB_KEY, "moveItem.txt"));
        this.moveItemButton.setEnabled(false);
        this.sourceContainer = this.dualSelector.getSourceTopActionButtonContainer();
        AutoSizingGridLayout sourceContainerLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        sourceContainerLayout.setDefaultCellGravity(256);
        this.sourceContainer.add(this.roleLabel);
        this.sourceContainer.add(this.roleComboBox);
        this.sourceContainer.setLayout(sourceContainerLayout);
        AutoSizingGridLayout lowerLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        this.positionPanel = new JPanel();
        AutoSizingGridLayout positionLayout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, false);
        positionLayout.setGridGravity(2);
        this.positionPanel.add(this.moveItemButton);
        this.positionPanel.setLayout(positionLayout);
        this.lowerPanel.add(this.positionPanel);
        lowerLayout.setDefaultCellGravity(256);
        double[] percentages = new double[]{0.5, 0.5};
        ProportionalSpacePartitioner partitioner = new ProportionalSpacePartitioner(percentages);
        lowerLayout.setColumnSpacePartitioner(partitioner);
        this.lowerPanel.setLayout(lowerLayout);
        this.messagePanel = new JPanel();
        AutoSizingGridLayout messageLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        this.messagePanel.setLayout(messageLayout);
        JScrollPane scroller = new JScrollPane(this.messageTextArea);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setHorizontalScrollBarPolicy(30);
        scroller.setPreferredSize(new Dimension(450, scroller.getPreferredSize().height));
        this.messagePanel.add(scroller);
        this.queryTypePanel = new JPanel();
        TitledBorder queryTypePanelBorder = BorderFactory.createTitledBorder(RB.getStringResource(RB_KEY, "queryType.txt"));
        this.queryTypePanel.setBorder(queryTypePanelBorder);
        AutoSizingGridLayout queryTypeLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        this.queryTypePanel.setLayout(queryTypeLayout);
        this.groupByRadioButton = new JRadioButton(RB.getStringResource(RB_KEY, "groupByCategory.txt"));
        this.detailRadioButton = new JRadioButton(RB.getStringResource(RB_KEY, "detailValues.txt"));
        ButtonGroup queryRadioGroup = new ButtonGroup();
        queryRadioGroup.add(this.groupByRadioButton);
        queryRadioGroup.add(this.detailRadioButton);
        this.queryTypePanel.add(this.groupByRadioButton);
        this.queryTypePanel.add(this.detailRadioButton);
        this.lowerPanel.setVisible(false);
        this.querySelectionPanel.add(this.dualSelector);
        this.querySelectionPanel.add(this.lowerPanel);
        this.querySelectionPanel.add(this.messagePanel);
        this.add(this.querySelectionPanel);
        this.add(this.queryTypePanel);
        this.setPreferredSize(this.getPreferredSize());
    }

    @Override
    public void onApply() {
        this.setContentsValid(true);
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        String status = roleProvider.getStatusMessage();
        if (status != null) {
            String title = RB.getStringResource(RB_KEY, "invalidRoleTitle.txt");
            String errorMessage = status;
            LabelView errorMessageLabel = new LabelView();
            errorMessageLabel.setPreferredSpanSize(new Dimension(400, -1));
            errorMessageLabel.setText(errorMessage);
            JOptionPane.showMessageDialog(this, errorMessageLabel, title, 0);
            this.contentsValid = false;
        } else if (!this.isOLAP) {
            if (this.detailRadioButton.isSelected()) {
                roleProvider.setQueryType("detail");
            } else {
                roleProvider.setQueryType("group");
            }
        }
    }

    protected void addListeners() {
        ((JTree)this.dualSelector.getSourceComponent()).addTreeSelectionListener(this);
        ((JTree)this.dualSelector.getTargetComponent()).addTreeSelectionListener(this);
        this.roleComboBox.addActionListener(this);
        this.moveItemButton.addActionListener(this);
        this.groupByRadioButton.addActionListener(this);
        this.detailRadioButton.addActionListener(this);
    }

    @Override
    public void setSelectorModel(Object model) {
        if (this.selectorModel != model && (model instanceof DataItemSelectorInterface || model == null)) {
            RoleInterface[] availableRoles = ((DataItemSelectorInterface)model).getRoles();
            int numRoles = availableRoles.length;
            this.isOLAP = numRoles > 1;
            Object old = this.selectorModel;
            this.selectorModel = (DataItemSelectorInterface)model;
            if (this.isOLAP) {
                this.setRoleComboBoxModel();
                this.queryTypePanel.setVisible(false);
                this.lowerPanel.setVisible(true);
            } else {
                this.lowerPanel.setVisible(false);
                this.queryTypePanel.setVisible(true);
                if (((DataItemSelectorInterface)model).isCalculatedItemSelected() || !((DataItemSelectorInterface)model).queryItemsSupportDetailUsage()) {
                    this.groupByRadioButton.setSelected(true);
                    this.groupByRadioButton.setEnabled(false);
                    this.detailRadioButton.setEnabled(false);
                } else {
                    if (((DataItemSelectorInterface)model).allQueryItemsAreDetailUsage()) {
                        this.detailRadioButton.setSelected(true);
                    } else {
                        this.groupByRadioButton.setSelected(true);
                    }
                    this.setSelectorModelQueryType();
                }
                this.selectedRole = COLUMN_ROLE;
                this.roleLabel.setVisible(false);
                this.roleComboBox.setVisible(false);
                this.moveItemButton.setVisible(false);
                JPanel sourceContainer = this.dualSelector.getSourceTopActionButtonContainer();
                sourceContainer.removeAll();
            }
            this.setTreeModels();
            DisabledDataItemRenderer sourceRenderer = new DisabledDataItemRenderer();
            this.dualSelector.setSourceCellRenderer(sourceRenderer);
            DisabledDataItemRenderer targetRenderer = new DisabledDataItemRenderer();
            this.dualSelector.setTargetCellRenderer(targetRenderer);
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    public void setRoleComboBoxModel() {
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
        RoleInterface[] availableRoles = ((DataItemSelectorInterface)this.selectorModel).getRoles();
        boolean selectedIndex = false;
        int numRoles = availableRoles.length;
        String roleLabel = null;
        for (int i = 0; i < numRoles; ++i) {
            roleLabel = availableRoles[i].getRoleLabel();
            cbModel.addElement(roleLabel);
            if (i != 0) continue;
            this.selectedRole = roleLabel;
        }
        this.roleComboBox.setModel(cbModel);
    }

    public void setTreeModels() {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        DefaultTreeModel availableModel = (DefaultTreeModel)roleProvider.getAvailableTreeModel(null, this.selectedRole);
        DefaultTreeModel selectedModel = (DefaultTreeModel)roleProvider.getSelectedTreeModel(null, this.selectedRole);
        selectedModel.addTreeModelListener(this);
        selectedModel.setAsksAllowsChildren(true);
        this.dualSelector.setModel(availableModel);
        this.dualSelector.setTargetModel(selectedModel);
        JTree sourcetree = (JTree)this.dualSelector.getSourceComponent();
        this.expandAvailableNodes(sourcetree, availableModel);
        Object availableRootNode = availableModel.getRoot();
        int numAvail = availableModel.getChildCount(availableRootNode);
        JTree targettree = (JTree)this.dualSelector.getTargetComponent();
        Object selectedRootNode = selectedModel.getRoot();
        DisabledNode thisnode = null;
        int numChildren = selectedModel.getChildCount(selectedRootNode);
        if (this.isOLAP) {
            JTree targetJTree = (JTree)this.dualSelector.getTargetComponent();
            TreeSelectionModel targetTreeSelectionModel = targetJTree.getSelectionModel();
            targetTreeSelectionModel.setSelectionMode(1);
            JTree sourceJTree = (JTree)this.dualSelector.getSourceComponent();
            TreeSelectionModel sourceTreeSelectionModel = sourceJTree.getSelectionModel();
            sourceTreeSelectionModel.setSelectionMode(1);
            for (int i = 0; i < numChildren; ++i) {
                thisnode = (DisabledNode)selectedModel.getChild(selectedRootNode, i);
                DataItemTreeNodeInfo tninfo = (DataItemTreeNodeInfo)thisnode.getUserObject();
                if (!tninfo.getItemText().equalsIgnoreCase((String)this.roleComboBox.getSelectedItem())) continue;
                targettree.expandRow(i);
                this.dualSelector.setSourceTargetNode(thisnode);
            }
        }
    }

    private void expandAvailableNodes(JTree sourceTree, DefaultTreeModel treemodel) {
        int numChildren;
        Object availableRootNode = treemodel.getRoot();
        for (int i = numChildren = treemodel.getChildCount(availableRootNode); i >= 0; --i) {
            sourceTree.expandRow(i);
        }
    }

    @Override
    public String getDialogTitle() {
        return RB.getStringResource(RB_KEY, "dialogTitle.txt");
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        JTree targettree = (JTree)this.dualSelector.getTargetComponent();
        JTree sourcetree = (JTree)this.dualSelector.getSourceComponent();
        TreePath path = e.getPath();
        Object eventSource = e.getSource();
        if (path != null) {
            DisabledNode parentnode = null;
            parentnode = this.isOLAP && path.getPathCount() > 2 ? (DisabledNode)path.getPathComponent(2) : (DisabledNode)path.getPathComponent(1);
            DataItemTreeNodeInfo tninfo = (DataItemTreeNodeInfo)parentnode.getUserObject();
            if (eventSource == sourcetree && sourcetree.getSelectionCount() > 0 || eventSource == targettree && targettree.getSelectionCount() > 0) {
                this.messageTextArea.setText(tninfo.getItemDescription());
            }
            if (this.isOLAP && this.moveItemButton.isVisible()) {
                if (eventSource.equals(targettree)) {
                    if (parentnode.isLeaf() && parentnode.getLevel() > 1) {
                        this.moveItemButton.setEnabled(true);
                    } else {
                        this.moveItemButton.setEnabled(false);
                    }
                } else if (sourcetree.getSelectionCount() > 0) {
                    this.moveItemButton.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        JTree targetTree = (JTree)this.dualSelector.getTargetComponent();
        JTree sourcetree = (JTree)this.dualSelector.getSourceComponent();
        String selectedrole = null;
        if (this.roleComboBox != null) {
            selectedrole = (String)this.roleComboBox.getSelectedItem();
        }
        String alpha = RB.getStringResource(RB_KEY, "alphabetically.txt");
        String byitemtype = RB.getStringResource(RB_KEY, "byItemType.txt");
        DefaultTreeModel newModel = null;
        String viewItemsValue = null;
        if (this.viewItemsComboBox != null) {
            viewItemsValue = (String)this.viewItemsComboBox.getSelectedItem();
        }
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        if (source == this.roleComboBox) {
            DataItemTreeNodeInfo tninfo;
            int i;
            DefaultTreeModel selectedModel = (DefaultTreeModel)this.dualSelector.getTargetModel();
            Object selectedRootNode = selectedModel.getRoot();
            DisabledNode thisnode = null;
            int numChildren = selectedModel.getChildCount(selectedRootNode);
            for (i = numChildren - 1; i >= 0; --i) {
                thisnode = (DisabledNode)selectedModel.getChild(selectedRootNode, i);
                tninfo = (DataItemTreeNodeInfo)thisnode.getUserObject();
                if (tninfo == null) continue;
                targetTree.collapseRow(i);
            }
            for (i = 0; i < numChildren; ++i) {
                thisnode = (DisabledNode)selectedModel.getChild(selectedRootNode, i);
                tninfo = (DataItemTreeNodeInfo)thisnode.getUserObject();
                if (tninfo == null || !tninfo.getItemText().equalsIgnoreCase((String)this.roleComboBox.getSelectedItem())) continue;
                targetTree.expandRow(i);
                this.dualSelector.setSourceTargetNode(thisnode);
            }
            newModel = (DefaultTreeModel)roleProvider.getAvailableTreeModel(null, selectedrole);
            sourcetree.setModel(newModel);
            this.expandAvailableNodes(sourcetree, newModel);
            targetTree.repaint();
            sourcetree.repaint();
        } else if (source == this.viewItemsComboBox) {
            if (viewItemsValue.equalsIgnoreCase(alpha)) {
                newModel = this.getAlphaTreeModel(roleProvider, selectedrole);
            } else if (viewItemsValue.equalsIgnoreCase(byitemtype)) {
                newModel = (DefaultTreeModel)roleProvider.getAvailableTreeModel(null, selectedrole);
            }
            sourcetree.setModel(newModel);
            if (viewItemsValue.equalsIgnoreCase(byitemtype)) {
                this.expandAvailableNodes(sourcetree, newModel);
            }
            sourcetree.repaint();
        } else if (source == this.moveItemButton) {
            Map itemmap = roleProvider.getDataItemMap();
            JTree targettree = (JTree)this.dualSelector.getTargetComponent();
            DefaultTreeModel targetmodel = (DefaultTreeModel)targettree.getModel();
            TreePath selectedpath = targettree.getSelectionPath();
            if (selectedpath != null) {
                DisabledNode rootnode = (DisabledNode)selectedpath.getPathComponent(0);
                DisabledNode selectednode = (DisabledNode)selectedpath.getPathComponent(2);
                DataItemTreeNodeInfo tninfo = (DataItemTreeNodeInfo)selectednode.getUserObject();
                DisabledNode rolenode = (DisabledNode)selectedpath.getPathComponent(1);
                DataItemTreeNodeInfo roletninfo = (DataItemTreeNodeInfo)rolenode.getUserObject();
                String role = roletninfo.getItemText();
                RoleInterface workingRole = this.getWorkingRole(role);
                String moveToRole = null;
                if (role.equalsIgnoreCase(COLUMN_ROLE)) {
                    moveToRole = ROW_ROLE;
                } else if (role.equalsIgnoreCase(ROW_ROLE)) {
                    moveToRole = COLUMN_ROLE;
                }
                RoleInterface targetRole = this.getWorkingRole(moveToRole);
                String selectednodeid = tninfo.getItemId();
                String selectedCategory = tninfo.getCategory();
                Object moveItem = itemmap.get(selectednodeid);
                boolean moveAllMeasures = false;
                if (selectedCategory.equalsIgnoreCase(MEASURES)) {
                    moveAllMeasures = true;
                }
                ArrayList<DisabledNode> itemlist = new ArrayList<DisabledNode>();
                HashMap refIdMap = new HashMap();
                if (moveAllMeasures) {
                    int numChildren = rolenode.getChildCount();
                    DisabledNode childnode = null;
                    DataItemTreeNodeInfo childinfo = null;
                    String childid = null;
                    String childCategory = null;
                    for (int i = 0; i < numChildren; ++i) {
                        childnode = (DisabledNode)rolenode.getChildAt(i);
                        childinfo = (DataItemTreeNodeInfo)childnode.getUserObject();
                        childid = childinfo.getItemId();
                        childCategory = childinfo.getCategory();
                        if (!childCategory.equalsIgnoreCase(MEASURES)) continue;
                        itemlist.add(childnode);
                        this.updateRefIdMap(childnode, refIdMap, workingRole, roleProvider);
                    }
                } else {
                    itemlist.add(selectednode);
                    this.updateRefIdMap(selectednode, refIdMap, workingRole, roleProvider);
                }
                int numRoleNodes = rootnode.getChildCount();
                DisabledNode targetnode = null;
                DataItemTreeNodeInfo targetnodeinfo = null;
                for (int i = 0; i < numRoleNodes && !(targetnodeinfo = (DataItemTreeNodeInfo)(targetnode = (DisabledNode)rootnode.getChildAt(i)).getUserObject()).getItemText().equalsIgnoreCase(moveToRole); ++i) {
                }
                for (int j = 0; j < itemlist.size(); ++j) {
                    targetmodel.removeNodeFromParent((DisabledNode)itemlist.get(j));
                }
                String itemid = null;
                Set idValues = refIdMap.keySet();
                for (int j = 0; j < itemlist.size(); ++j) {
                    DisabledNode itemNode = (DisabledNode)itemlist.get(j);
                    DataItemTreeNodeInfo nodeinfo = (DataItemTreeNodeInfo)itemNode.getUserObject();
                    itemid = nodeinfo.getItemId();
                    if (roleProvider.isThisItemAReferenceInItemMap(itemid) && !roleProvider.isThisItemInAvailableList(itemid, targetRole)) {
                        nodeinfo.setItemId(roleProvider.getBaseItemId(nodeinfo.getItemId()));
                    }
                    if (!idValues.contains(itemid)) continue;
                    nodeinfo.setItemId((String)refIdMap.get(itemid));
                }
                int numberOfChildren = 0;
                for (int j = 0; j < itemlist.size(); ++j) {
                    numberOfChildren = targetnode.getChildCount();
                    targetmodel.insertNodeInto((DisabledNode)itemlist.get(j), targetnode, numberOfChildren);
                }
                targettree.repaint();
            }
            newModel = (DefaultTreeModel)roleProvider.getAvailableTreeModel(null, selectedrole);
            sourcetree.setModel(newModel);
            this.expandAvailableNodes(sourcetree, newModel);
            sourcetree.repaint();
        } else if (source == this.groupByRadioButton || source == this.detailRadioButton) {
            this.updateSourceTree();
        }
    }

    private void updateRefIdMap(DisabledNode selectednode, Map refIdMap, RoleInterface workingRole, DataItemSelectorInterface roleProvider) {
        DataItemTreeNodeInfo nodeinfo = (DataItemTreeNodeInfo)selectednode.getUserObject();
        String itemid = nodeinfo.getItemId();
        if (roleProvider.isThisItemInRoleRefList(itemid, workingRole)) {
            String baseitemId = roleProvider.getBaseItemId(itemid);
            refIdMap.put(itemid, baseitemId);
        }
    }

    private DefaultTreeModel getAlphaTreeModel(DataItemSelectorInterface rpi, String selectedrole) {
        List listOfItems = rpi.getAvailableItemInfoList(selectedrole);
        Collections.sort(listOfItems);
        DataItemTreeNodeInfo rootinfo = new DataItemTreeNodeInfo("rootnode", "rootnode", "rootnode");
        DisabledNode newRootNode = new DisabledNode(rootinfo);
        DefaultTreeModel newModel = new DefaultTreeModel(newRootNode);
        int numItems = listOfItems.size();
        for (int j = 0; j < numItems; ++j) {
            DataItemTreeNodeInfo thisiteminfo = (DataItemTreeNodeInfo)listOfItems.get(j);
            DisabledNode leafNode = new DisabledNode(thisiteminfo);
            leafNode.setEnabled(thisiteminfo.getEnabled());
            leafNode.setAllowsChildren(false);
            newRootNode.add(leafNode);
        }
        return newModel;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    private RoleInterface getWorkingRole(String role) {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        RoleInterface workingRole = null;
        RoleInterface[] availableRoles = roleProvider.getRoles();
        int numRoles = availableRoles.length;
        int i = 0;
        for (i = 0; i < numRoles; ++i) {
            if (!availableRoles[i].getRoleName().equalsIgnoreCase(role) && !availableRoles[i].getRoleLabel().equalsIgnoreCase(role)) continue;
            workingRole = availableRoles[i];
            break;
        }
        return workingRole;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        String role = null;
        if (this.isOLAP) {
            Object[] path = e.getPath();
            if (path.length <= 1) {
                return;
            }
            role = path[1].toString();
        } else {
            role = COLUMN_ROLE;
        }
        RoleInterface workingRole = this.getWorkingRole(role);
        Object[] children = e.getChildren();
        List addItemsList = this.createAddItemsList(children);
        List badItems = workingRole.addRoleItems(addItemsList);
        if (badItems != null) {
            throw new IllegalArgumentException(RB.getStringResource("DataItemSelector.addError.txt"));
        }
        if (this.isOLAP) {
            this.updateSourceTree();
        }
        this.updateTargetTree();
        this.setQueryTypeRadioButtonStatus(roleProvider);
    }

    private void setQueryTypeRadioButtonStatus(DataItemSelectorInterface roleprovider) {
        if (!this.isOLAP) {
            boolean buttonStatus = roleprovider.queryItemsSupportDetailUsage();
            this.groupByRadioButton.setEnabled(buttonStatus);
            this.detailRadioButton.setEnabled(buttonStatus);
        }
    }

    private List createAddItemsList(Object[] addArray) {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        ArrayList<Object> itemsList = new ArrayList<Object>();
        DisabledNode thisnode = null;
        DataItemTreeNodeInfo tninfo = null;
        String itemid = null;
        for (int i = 0; i < addArray.length; ++i) {
            thisnode = (DisabledNode)addArray[i];
            if (!thisnode.isEnabled()) continue;
            tninfo = (DataItemTreeNodeInfo)thisnode.getUserObject();
            itemid = tninfo.getItemId();
            Object addItem = roleProvider.getItemFromItemMap(itemid);
            itemsList.add(addItem);
        }
        return itemsList;
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        String role = null;
        if (this.isOLAP) {
            Object[] path = e.getPath();
            if (path.length <= 1) {
                this.updateTargetTree();
                return;
            }
            role = path[1].toString();
        } else {
            role = COLUMN_ROLE;
        }
        RoleInterface workingRole = this.getWorkingRole(role);
        Map itemmap = roleProvider.getDataItemMap();
        Object[] children = e.getChildren();
        DisabledNode thisnode = null;
        DataItemTreeNodeInfo tninfo = null;
        String itemid = null;
        for (int i = 0; i < children.length; ++i) {
            thisnode = (DisabledNode)children[i];
            tninfo = (DataItemTreeNodeInfo)thisnode.getUserObject();
            itemid = tninfo.getItemId();
            Object itemObj = itemmap.get(itemid);
            workingRole.removeRoleItem(itemObj);
        }
        if (this.isOLAP) {
            this.updateSourceTree();
        }
        this.setQueryTypeRadioButtonStatus(roleProvider);
    }

    private void setSelectorModelQueryType() {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        String querytype = null;
        querytype = this.detailRadioButton.isSelected() ? "detail" : "group";
        roleProvider.setQueryType(querytype);
    }

    private void updateSourceTree() {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        String alpha = RB.getStringResource(RB_KEY, "alphabetically.txt");
        String byitemtype = RB.getStringResource(RB_KEY, "byItemType.txt");
        DefaultTreeModel newModel = null;
        String selectedrole = null;
        selectedrole = this.roleComboBox != null && this.roleComboBox.isVisible() ? (String)this.roleComboBox.getSelectedItem() : COLUMN_ROLE;
        if (this.isOLAP) {
            newModel = (DefaultTreeModel)roleProvider.getAvailableTreeModel(null, selectedrole);
        } else {
            this.setSelectorModelQueryType();
            newModel = (DefaultTreeModel)roleProvider.getAvailableTreeModel(null, selectedrole);
        }
        JTree sourcetree = (JTree)this.dualSelector.getSourceComponent();
        sourcetree.setModel(newModel);
        this.expandAvailableNodes(sourcetree, newModel);
        sourcetree.repaint();
    }

    private void updateTargetTree() {
        DataItemSelectorInterface roleProvider = (DataItemSelectorInterface)this.selectorModel;
        DefaultTreeModel newModel = null;
        String selectedrole = null;
        selectedrole = this.roleComboBox != null && this.roleComboBox.isVisible() ? (String)this.roleComboBox.getSelectedItem() : COLUMN_ROLE;
        newModel = (DefaultTreeModel)roleProvider.getSelectedTreeModel(null, this.selectedRole);
        newModel.addTreeModelListener(this);
        this.dualSelector.setTargetModel(newModel);
        JTree targettree = (JTree)this.dualSelector.getTargetComponent();
        Object selectedRootNode = newModel.getRoot();
        DisabledNode thisnode = null;
        int numChildren = newModel.getChildCount(selectedRootNode);
        if (this.isOLAP) {
            for (int i = 0; i < numChildren; ++i) {
                thisnode = (DisabledNode)newModel.getChild(selectedRootNode, i);
                DataItemTreeNodeInfo tninfo = (DataItemTreeNodeInfo)thisnode.getUserObject();
                if (!tninfo.getItemText().equalsIgnoreCase((String)this.roleComboBox.getSelectedItem())) continue;
                targettree.expandRow(i);
                this.dualSelector.setSourceTargetNode(thisnode);
            }
        }
        targettree.setModel(newModel);
        targettree.repaint();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }
}

