/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculateditems;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.LabelView;
import com.sas.util.ChainedException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;

@SASScope
public class BasicWindowUtil {
    public static void smartPopMenuShow(JPopupMenu popmenu, JComponent source, int xLoc, int yLoc) {
        popmenu.pack();
        if (popmenu != null && popmenu.getSubElements().length != 0) {
            source.add(popmenu);
            popmenu.show(source, xLoc, yLoc);
            Rectangle popmenuBox = popmenu.getBounds();
            popmenu.setVisible(false);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            Point parentLoc = source.getLocationOnScreen();
            if (parentLoc.x + popmenuBox.width + xLoc > screenSize.width) {
                xLoc -= popmenuBox.width;
            }
            if (parentLoc.y + popmenuBox.height + yLoc > screenSize.height) {
                yLoc -= popmenuBox.height;
            }
            popmenu.show(source, xLoc, yLoc);
            popmenu.requestFocus();
        }
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        BasicWindowUtil.drawFocusRect(g, x, y, width, height, true);
    }

    public static final void busyOn(Component awtComponent) {
        BasicWindowUtil.getParentFrame(awtComponent).setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(Component awtComponent) {
        BasicWindowUtil.getParentFrame(awtComponent).setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(JComponent c) {
        c.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(JComponent c) {
        c.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(JDialog c) {
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(JDialog c) {
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(Frame c) {
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(Frame c) {
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void sleep(int ms) {
        try {
            Thread.currentThread();
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height, boolean useXOR) {
        int i;
        g.setColor(Color.black);
        if (useXOR) {
            g.setXORMode(Color.white);
        }
        for (i = 0; i < width; i += 2) {
            g.drawLine(x + i, y, x + i, y);
            g.drawLine(x + i, y + height - 1, x + i, y + height - 1);
        }
        for (i = 0; i < height; i += 2) {
            g.drawLine(x, y + i, x, y + i);
            g.drawLine(x + width - 1, y + i, x + width - 1, y + i);
        }
        if (useXOR) {
            g.setPaintMode();
        }
    }

    public static void center(Window window) {
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }

    public static void centerOver(Window window, Component component) {
        int amountOver;
        Point location = component.getLocationOnScreen();
        Dimension componentSize = component.getSize();
        location.x += componentSize.width / 2;
        location.y += componentSize.height / 2;
        Dimension size = window.getSize();
        int x = location.x - size.width / 2;
        int y = location.y - size.height / 2;
        Dimension screenSize = window.getToolkit().getScreenSize();
        if (x + size.width > screenSize.width && (amountOver = x + size.width - screenSize.width) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + size.height > screenSize.height && (amountOver = y + size.height - screenSize.height) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static void centerOverWindow(Window window, Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component != null) {
            BasicWindowUtil.centerOver(window, component);
        }
    }

    public static Frame getParentFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public static Window getParentWindow(Component comp) {
        Window parentWindow = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Window) {
                parentWindow = (Window)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentWindow;
    }

    public static Dimension getBestWindowSize(Dimension x) {
        Toolkit tkt = Toolkit.getDefaultToolkit();
        Dimension realSize = tkt.getScreenSize();
        Dimension retDim = new Dimension(x);
        if (x.height > realSize.height || x.width > realSize.width) {
            retDim.height = realSize.height;
            retDim.width = realSize.width;
        }
        return retDim;
    }

    public static void makeButtonsUniform(JButton[] buttonArray) {
        int i;
        Dimension buttonSize = new Dimension(0, 0);
        for (i = 0; i < buttonArray.length; ++i) {
            Dimension preferredSize = buttonArray[i].getPreferredSize();
            buttonSize.width = Math.max(buttonSize.width, preferredSize.width);
            buttonSize.height = Math.max(buttonSize.height, preferredSize.height);
        }
        for (i = 0; i < buttonArray.length; ++i) {
            buttonArray[i].setPreferredSize(buttonSize);
        }
    }

    public static List exceptionToStringArray(String messageStart, Throwable thrownStart) {
        ArrayList<String> list = new ArrayList<String>();
        String thrownMessage = null;
        Throwable thrownCause = null;
        String causeMessage = null;
        if (messageStart != null) {
            list.add(messageStart);
        }
        if (thrownStart != null) {
            thrownMessage = thrownStart.getLocalizedMessage();
            if (thrownMessage == null) {
                thrownMessage = thrownStart.getMessage();
            }
            if (thrownMessage == null) {
                thrownMessage = thrownStart.toString();
            }
            if (thrownMessage != null && (messageStart == null || thrownMessage.compareTo(messageStart) != 0)) {
                list.add(thrownMessage);
            }
            if (thrownStart instanceof ChainedException) {
                ChainedException ce = (ChainedException)thrownStart;
                thrownCause = ce.getRootException();
            }
            if (thrownCause == null) {
                thrownCause = thrownStart.getCause();
            }
            if (thrownCause != null) {
                causeMessage = thrownCause.getLocalizedMessage();
                if (causeMessage == null) {
                    causeMessage = thrownCause.getMessage();
                }
                if (causeMessage == null) {
                    causeMessage = thrownCause.toString();
                }
            }
            if (!(causeMessage == null || messageStart != null && causeMessage.compareTo(messageStart) == 0 || thrownMessage != null && causeMessage.compareTo(thrownMessage) == 0)) {
                list.add(causeMessage);
            }
        }
        return list;
    }

    public static List listToWrappingTextComponents(List list, int width) {
        ArrayList newList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof String) {
                obj = BasicWindowUtil.stringToWrappingTextComponent((String)obj, width);
            }
            newList.add(obj);
        }
        return newList;
    }

    public static Component stringToWrappingTextComponent(String string, int width) {
        LabelView errorMessageLabel = new LabelView();
        errorMessageLabel.setPreferredSpanSize(new Dimension(width, -1));
        errorMessageLabel.setText(string);
        return errorMessageLabel;
    }
}

