/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ViewQueryCacheInterface;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.models.ValueItemsToTableModelAdapter;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.EditorFactory;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.ValueListEditor;
import com.sas.swing.visuals.ValuePickerDialog;
import com.sas.swing.visuals.ValuePickerRendererHandler;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.ValueProviderDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.ValueProviderTableSelector;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.swing.visuals.util.TreeUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.PreorderTreeModelIterator;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

@SASScope
public class ValuePicker
extends JPanel
implements PanelInterface,
ListSelectionListener,
EditorInterface,
TreeSelectionListener,
EditorListener,
MutableSupportedSpecialValuesInterface,
ActionListener,
SupportsGenericErrorHandlerInterface,
PropertyChangeListener {
    public static final String RB_KEY = "ValuePicker.";
    private static final long serialVersionUID = 4516597690031764979L;
    public static final int SINGLE_SELECTION = 300;
    public static final int SINGLE_COMBO_SELECTION = 303;
    public static final int MULTIPLE_SELECTION = 301;
    public static final int ORDERED_MULTIPLE_SELECTION = 302;
    public static final int BROWSE_MODE = 400;
    public static final int SEARCH_MODE = 401;
    public static final int BROWSE_WITH_SEARCH_MODE = 402;
    public static final int BROWSE_AND_SEARCH_MODE = 403;
    public static final int PAGING_BROWSE_MODE = 600;
    public static final int STATIC_BROWSE_MODE = 601;
    protected String accessibleNamePrefix;
    private boolean contentsValid;
    private boolean ignoreEvents;
    private boolean comingFromSearch;
    private boolean ignoreEditorEvents;
    private ValueProviderTableSelector dualSelector;
    private ValueProviderDualSelectorAdapter valueProviderAdapter;
    private JButton binocularsButton;
    private JPanel searchPanel;
    private ValuePickerDialog dialog;
    private ViewQueryCacheInterface viewQueryCache;
    private ValuePickerRenderer renderer;
    private ValuePickerRendererHandler rendererHandler;
    private JPanel valuePanel;
    private EditorInterface editor;
    private JLabel valueLabel;
    private EditorListener editorListener;
    private String sourceLabel;
    private String targetLabel;
    private AutoSizingGridLayout layout;
    private int selectionMode;
    private int displayMode;
    private int maxValues;
    private int browseMode;
    private boolean editable;
    private boolean browse;
    private boolean search;
    private boolean addNullValueForSingleComboSelection;
    private boolean caseSensitiveSearch;
    private boolean isEditing;
    private boolean valueModified;
    private SupportedSpecialValues specialValues;
    private ValueProviderInterface valueProvider;
    private ChangeCursorCommand changeCursorCommand;
    private Object lastSelectedItem;
    private int pageSize;
    private DataTypeInterface setDataType;
    private DataTypeInterface unsetDataType;
    private MouseListener mouseDoubleClickListener;
    private GenericErrorHandlerInterface errorHandler;
    private EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, Locale locale) {
        this(valueProvider, displayMode, 302, locale);
    }

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, Locale locale) {
        this(valueProvider, displayMode, selectionMode, false, locale);
    }

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, boolean editable, Locale locale) {
        this(valueProvider, displayMode, selectionMode, editable, -1, locale);
    }

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, boolean editable, int pageSize, Locale locale) {
        this(valueProvider, displayMode, selectionMode, editable, null, pageSize, locale);
    }

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, boolean editable, GenericErrorHandlerInterface errorHandler, Locale locale) {
        this(valueProvider, displayMode, selectionMode, editable, errorHandler, -1, locale);
    }

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, boolean editable, GenericErrorHandlerInterface errorHandler, int pageSize, Locale locale) {
        this(valueProvider, displayMode, selectionMode, editable, errorHandler, null, pageSize, locale);
    }

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, boolean editable, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, Locale locale) {
        this(valueProvider, displayMode, selectionMode, editable, errorHandler, dataType, -1, locale);
    }

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, boolean editable, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, int pageSize, Locale locale) {
        this(valueProvider, displayMode, selectionMode, editable, errorHandler, dataType, pageSize, null, locale);
    }

    public ValuePicker(ValueProviderInterface valueProvider, int displayMode, int selectionMode, boolean editable, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, int pageSize, ViewQueryCacheInterface viewQueryCache, Locale locale) {
        this.valueProvider = valueProvider;
        this.selectionMode = selectionMode;
        this.displayMode = displayMode;
        this.editable = editable;
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            this.errorHandler = new JOptionPaneErrorHandler();
        }
        this.setDataType = dataType;
        this.pageSize = pageSize;
        this.viewQueryCache = viewQueryCache;
        this.setLocale(locale);
        this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        this.renderer = new ValuePickerRenderer();
        this.accessibleNamePrefix = "";
        this.browseMode = 600;
        this.ignoreEvents = false;
        this.contentsValid = false;
        this.comingFromSearch = false;
        this.isEditing = false;
        this.valueModified = false;
        this.maxValues = -1;
        this.setOpaque(false);
        this.layout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this.layout.setRemainderRow(1);
        this.layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(this.layout);
        FocusManager.getCurrentManager().addPropertyChangeListener("focusOwner", this);
        this.createUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Window currentWindow;
        Component comp;
        if ("focusOwner".equalsIgnoreCase(evt.getPropertyName()) && (comp = FocusManager.getCurrentManager().getFocusOwner()) != null && (currentWindow = SwingUtilities.windowForComponent(this)) != null) {
            boolean owner;
            boolean bl = owner = SwingUtilities.isDescendingFrom(comp, this) || this.dialog != null && SwingUtilities.isDescendingFrom(comp, this.dialog);
            if (owner) {
                if (!this.isEditing) {
                    this.isEditing = true;
                    this.fireEditingStarted();
                }
            } else if (this.isEditing && !(comp instanceof JRootPane) && currentWindow == SwingUtilities.getWindowAncestor(comp)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ValuePicker.this.isEditing = false;
                        ValuePicker.this.valueModified = false;
                        ValuePicker.this.fireEditingStopped();
                    }
                });
            }
        }
    }

    public void removeListeners() {
        FocusManager.getCurrentManager().removePropertyChangeListener("focusOwner", this);
        if (this.valueProviderAdapter != null && this.valueProviderAdapter.getBrowseComponent() instanceof EditorInterface) {
            EditorFactory.defaultInstance.cleanupEditor((EditorInterface)((Object)this.valueProviderAdapter.getBrowseComponent()));
        }
        if (this.editor != null) {
            EditorFactory.defaultInstance.cleanupEditor(this.editor);
            this.editor.removeEditorListener(this);
            this.editor.removeEditorListener(this.editorListener);
        }
        if (this.dualSelector != null) {
            ValueListEditor vle = (ValueListEditor)this.dualSelector.getTargetComponent();
            vle.removeListeners();
        }
    }

    protected void createUI() {
        this.removeAll();
        this.dualSelector = null;
        this.valueProviderAdapter = null;
        this.binocularsButton = null;
        this.editor = null;
        this.valueLabel = null;
        this.updateBrowseAndSearch();
        this.updateComponent();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dualSelector != null) {
            this.dualSelector.setEnabled(enabled);
        }
        if (this.valueProviderAdapter != null) {
            if (this.valueProviderAdapter.getContainerComponent() != null) {
                this.valueProviderAdapter.getContainerComponent().setEnabled(enabled);
            }
            if (this.valueProviderAdapter.getComponent() != null) {
                this.valueProviderAdapter.getComponent().setEnabled(enabled);
            }
            if (this.valueProviderAdapter.getBrowseAdapter() != null) {
                this.valueProviderAdapter.getBrowseAdapter().getContainerComponent().setEnabled(enabled);
                this.valueProviderAdapter.getBrowseAdapter().getComponent().setEnabled(enabled);
            }
            if (this.valueProviderAdapter.getSearchAdapter() != null) {
                this.valueProviderAdapter.getSearchAdapter().getContainerComponent().setEnabled(enabled);
                this.valueProviderAdapter.getSearchAdapter().getComponent().setEnabled(enabled);
            }
        }
        if (this.binocularsButton != null) {
            this.binocularsButton.setEnabled(enabled);
        }
        if (this.searchPanel != null) {
            this.searchPanel.setEnabled(enabled);
        }
        if (this.valuePanel != null) {
            this.valuePanel.setEnabled(enabled);
        }
        if (this.editor != null) {
            this.editor.getEditorComponent().setEnabled(enabled);
        }
        if (this.valueLabel != null) {
            this.valueLabel.setEnabled(enabled);
        }
    }

    public EditorInterface getEditor() {
        if (this.editable) {
            if (this.editor != null) {
                return this.editor;
            }
            if (this.dualSelector != null) {
                return ((ValueListEditor)this.dualSelector.getTargetComponent()).getEditor();
            }
            if (this.valueProviderAdapter != null && this.valueProviderAdapter.getBrowseAdapter().getComponent() instanceof EditorInterface) {
                return (EditorInterface)((Object)this.valueProviderAdapter.getBrowseAdapter().getComponent());
            }
        }
        return null;
    }

    public int getPageSize() {
        if (this.valueProviderAdapter != null) {
            return this.valueProviderAdapter.getPageSize();
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            int old = this.pageSize;
            this.pageSize = pageSize;
            if (this.valueProviderAdapter != null) {
                this.valueProviderAdapter.setPageSize(pageSize);
            }
            this.firePropertyChange("pageSize", old, this.pageSize);
        }
    }

    public void setAccessibleNamePrefix(String prefix) {
        this.accessibleNamePrefix = prefix;
        if (this.dualSelector != null) {
            ValueListEditor vle = (ValueListEditor)this.dualSelector.getTargetComponent();
            vle.setAccessibleNamePrefix(prefix);
        }
        this.setAccessibleNames();
    }

    protected void setAccessibleNames() {
        if (this.binocularsButton != null) {
            this.binocularsButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "searchButton");
        }
        if (this.editor != null && this.editor.getEditorComponent().getAccessibleContext() != null) {
            this.editor.getEditorComponent().getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "editorField");
        }
        if (this.dualSelector != null) {
            this.dualSelector.alternatingSingleButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "moveRightButton");
            this.dualSelector.alternatingMultipleButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "moveAllRightButton");
            if (this.dualSelector.addEditButton != null) {
                this.dualSelector.addEditButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "addEditButton");
            }
        }
        if (this.valueProviderAdapter != null) {
            if (this.valueProviderAdapter.getBrowsePanel() != null) {
                this.valueProviderAdapter.getBrowsePanel().getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "browsePanel");
                if (this.valueProviderAdapter.getBrowseAdapter().getComponent().getAccessibleContext() != null) {
                    this.valueProviderAdapter.getBrowseAdapter().getComponent().getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "availableList");
                }
            }
            if (this.valueProviderAdapter.getSearchPanel() != null) {
                this.valueProviderAdapter.getSearchPanel().getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "searchPanel");
                this.valueProviderAdapter.getSearchButton().getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "searchButton");
                this.valueProviderAdapter.getSearchField().getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "searchField");
                this.valueProviderAdapter.getSearchCombo().getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "searchComboBox");
                this.valueProviderAdapter.getSearchAdapter().getComponent().getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "searchList");
            }
        }
    }

    private void updateComponent() {
        this.removeAll();
        if (this.searchPanel != null) {
            this.searchPanel.removeAll();
        }
        this.searchPanel = null;
        this.binocularsButton = null;
        this.layout.setRemainderRow(1);
        this.layout.setColumns(1);
        this.layout.setRemainderColumn(1);
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            TableView tv;
            boolean reordering;
            boolean bl = reordering = this.selectionMode != 301;
            if (this.valueProviderAdapter == null) {
                this.dualSelector = new ValueProviderTableSelector(this.valueProvider, this.getBrowseOption(), this.search, this.editable, reordering, this.getGenericErrorHandler(), this.setDataType, this.pageSize, this.viewQueryCache, this.getLocale());
                this.dualSelector.setDragAndDropEnabled(true);
                this.dualSelector.setTargetMaximumCount(this.getMaxValues());
                ValueListEditor vle = (ValueListEditor)this.dualSelector.getTargetComponent();
                vle.setAccessibleNamePrefix(this.accessibleNamePrefix);
                vle.setMaxItems(this.getMaxValues());
                this.valueProviderAdapter = this.dualSelector.getSourceAdapter();
                this.valueProviderAdapter.setSupportedSpecialValues(this.getSupportedSpecialValues());
                this.valueProviderAdapter.setAddNullValueForSingleComboSelection(this.addNullValueForSingleComboSelection);
                ((ValueListEditor)this.dualSelector.getTargetComponent()).setGenericErrorHandler(this.getGenericErrorHandler());
            } else {
                if (this.valueProviderAdapter.getBrowseAdapter() != null) {
                    JComponent visualComp = this.valueProviderAdapter.getBrowseAdapter().getComponent();
                    if (visualComp instanceof TableView) {
                        tv = (TableView)visualComp;
                        tv.getRowModel().getSelectionModel().setSelectionMode(2);
                        tv.getRowModel().getSelectionModel().removeListSelectionListener(this);
                    } else if (visualComp instanceof JTree) {
                        JTree tree = (JTree)visualComp;
                        tree.getSelectionModel().removeTreeSelectionListener(this);
                        tree.getSelectionModel().setSelectionMode(4);
                        tree.getSelectionModel().clearSelection();
                    }
                }
                if (this.valueProviderAdapter.getSearchAdapter() != null) {
                    TableView tv2 = (TableView)this.valueProviderAdapter.getSearchAdapter().getComponent();
                    tv2.getRowModel().getSelectionModel().setSelectionMode(2);
                    tv2.getRowModel().getSelectionModel().removeListSelectionListener(this);
                }
                int bo = this.getBrowseOption();
                this.valueProviderAdapter.setBrowseMode(bo);
                this.dualSelector = new ValueProviderTableSelector(this.valueProviderAdapter, bo, this.search, this.editable, reordering, this.getGenericErrorHandler(), this.setDataType, this.getLocale());
                this.dualSelector.setDragAndDropEnabled(true);
                this.dualSelector.setTargetMaximumCount(this.getMaxValues());
                ValueListEditor vle = (ValueListEditor)this.dualSelector.getTargetComponent();
                vle.setAccessibleNamePrefix(this.accessibleNamePrefix);
                vle.setMaxItems(this.getMaxValues());
            }
            if (this.sourceLabel != null) {
                this.dualSelector.setSourceLabel(this.sourceLabel);
            }
            if (this.targetLabel != null) {
                this.dualSelector.setTargetLabel(this.targetLabel);
            }
            this.setButtonProperties(this.dualSelector.alternatingMultipleButton);
            this.setButtonProperties(this.dualSelector.alternatingSingleButton);
            this.add(this.dualSelector);
            this.updateBinoculars();
            JComponent visualComp = this.valueProviderAdapter.getBrowseAdapter().getComponent();
            if (visualComp instanceof TableView) {
                tv = (TableView)visualComp;
                tv.getRowModel().getSelectionModel().removeListSelectionListener(this);
                tv.getRowModel().getSelectionModel().addListSelectionListener(this);
                tv.getColumnHeader().setFocusable(false);
            }
            if (this.valueProviderAdapter.getSearchAdapter() != null) {
                tv = (TableView)this.valueProviderAdapter.getSearchAdapter().getComponent();
                tv.getColumnHeader().setFocusable(false);
            }
            this.dualSelector.removeEditorListener(this);
            this.dualSelector.addEditorListener(this);
        } else {
            if (this.valueProviderAdapter == null) {
                int bo = this.getBrowseOption();
                if (this.browse && this.getSelectionMode() == 303) {
                    bo = this.editable ? 50 : 40;
                }
                this.valueProviderAdapter = new ValueProviderDualSelectorAdapter(this.valueProvider, bo, this.search, null, this.getGenericErrorHandler(), this.setDataType, this.pageSize, this.viewQueryCache, this.getLocale());
                this.valueProviderAdapter.setSupportedSpecialValues(this.getSupportedSpecialValues());
                this.valueProviderAdapter.setAddNullValueForSingleComboSelection(this.addNullValueForSingleComboSelection);
            } else if (this.getSelectionMode() == 303 && !this.search) {
                if (this.editable) {
                    this.valueProviderAdapter.setBrowseMode(50);
                } else {
                    this.valueProviderAdapter.setBrowseMode(40);
                }
            } else {
                this.valueProviderAdapter.setBrowseMode(this.browseMode == 600 ? 20 : 30);
            }
            if (this.dualSelector != null) {
                this.dualSelector.setDragAndDropEnabled(false);
                this.dualSelector.removeEditorListener(this);
            }
            if (this.browse && this.valueProviderAdapter.getBrowseAdapter() != null) {
                JComponent visualComp = this.valueProviderAdapter.getBrowseAdapter().getComponent();
                if (visualComp instanceof TableView) {
                    TableView tv = (TableView)visualComp;
                    tv.setAutoResizeMode(0);
                    tv.getRowModel().getSelectionModel().setSelectionMode(0);
                    tv.getRowModel().getSelectionModel().removeListSelectionListener(this);
                    tv.getRowModel().getSelectionModel().addListSelectionListener(this);
                    tv.getColumnHeader().setFocusable(false);
                } else if (visualComp instanceof JTree) {
                    JTree tree = (JTree)visualComp;
                    tree.getSelectionModel().setSelectionMode(1);
                    tree.getSelectionModel().removeTreeSelectionListener(this);
                    tree.getSelectionModel().addTreeSelectionListener(this);
                    tree.clearSelection();
                } else if (visualComp instanceof JComboBox) {
                    JComboBox combo = (JComboBox)visualComp;
                    combo.removeActionListener(this);
                    combo.addActionListener(this);
                } else if (visualComp instanceof EditorInterface) {
                    if (this.editorListener == null) {
                        this.editorListener = new EditorEditorListener();
                    }
                    EditorInterface edit = (EditorInterface)((Object)visualComp);
                    edit.removeEditorListener(this.editorListener);
                    edit.addEditorListener(this.editorListener);
                }
            }
            if (this.search) {
                TableView tv = (TableView)this.valueProviderAdapter.getSearchAdapter().getComponent();
                tv.setAutoResizeMode(0);
                tv.getRowModel().getSelectionModel().setSelectionMode(0);
                tv.getRowModel().getSelectionModel().removeListSelectionListener(this);
                tv.getRowModel().getSelectionModel().addListSelectionListener(this);
                tv.getColumnHeader().setFocusable(false);
            }
            this.updateBinoculars();
            if (this.valueProviderAdapter.getContainerComponent() != null) {
                if (this.searchPanel != null) {
                    this.layout.setRemainderRow(1);
                    this.add((Component)this.valueProviderAdapter.getContainerComponent(), 0);
                } else {
                    this.add(this.valueProviderAdapter.getContainerComponent());
                }
            }
            this.addValueField();
            this.dualSelector = null;
            this.updateValueLabel();
        }
        this.updateMissingValueSupport();
        this.setAccessibleNames();
        this.setRenderer();
    }

    private void setRenderer() {
        this.setRendererOnValueProviderAdapter();
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            ((ValueListEditor)this.dualSelector.getTargetComponent()).setCellRenderer(-1, -1, this.renderer);
        }
    }

    private void setRendererOnValueProviderAdapter() {
        if (this.valueProviderAdapter.getBrowseAdapter() != null) {
            Component comp;
            JComponent visualComp = this.valueProviderAdapter.getBrowseAdapter().getComponent();
            if (visualComp instanceof TableView) {
                TableView tv = (TableView)visualComp;
                tv.setCellRenderer(-1, -1, this.renderer);
            } else if (visualComp instanceof JTree) {
                JTree tree = (JTree)visualComp;
                tree.setCellRenderer(this.renderer);
            } else if (visualComp instanceof JComboBox) {
                JComboBox combo = (JComboBox)visualComp;
                combo.setRenderer(this.renderer);
            } else if ((visualComp instanceof DatePicker || visualComp instanceof TextEditor) && (comp = visualComp.getComponent(0)) instanceof JComboBox) {
                JComboBox combo = (JComboBox)comp;
                combo.setRenderer(this.renderer);
            }
        }
        if (this.valueProviderAdapter.getSearchAdapter() != null) {
            TableView tv = (TableView)this.valueProviderAdapter.getSearchAdapter().getComponent();
            tv.setCellRenderer(-1, -1, this.renderer);
        }
    }

    private void updateBinoculars() {
        if (this.selectionMode == 300 || this.selectionMode == 303) {
            if (this.displayMode == 402 && this.isSearchable(this.valueProvider)) {
                if (this.searchPanel == null) {
                    this.binocularsButton = new SearchButton();
                    this.setButtonProperties(this.binocularsButton);
                    this.searchPanel = new JPanel();
                    this.searchPanel.setOpaque(false);
                    AutoSizingGridLayout searchLayout = new AutoSizingGridLayout(1, 0, 5, 5, true, false, false);
                    searchLayout.setRemainderColumn(1);
                    this.searchPanel.setLayout(searchLayout);
                    this.searchPanel.add(this.binocularsButton);
                    this.add(this.searchPanel);
                    this.layout.setRemainderRow(2);
                    this.layout.setColumns(2);
                    this.layout.setRemainderColumn(1);
                    this.binocularsButton.setVisible(true);
                    if (this.valueProviderAdapter != null) {
                        this.binocularsButton.setEnabled(!this.valueProviderAdapter.isInErrorMode());
                    }
                }
            } else if (this.searchPanel != null) {
                this.remove(this.searchPanel);
                this.searchPanel = null;
                this.binocularsButton = null;
                this.layout.setRemainderRow(1);
            }
        } else if (this.displayMode == 402 && this.isSearchable(this.valueProvider)) {
            if (this.binocularsButton == null) {
                this.binocularsButton = new SearchButton();
                this.setButtonProperties(this.binocularsButton);
                this.dualSelector.getSourceLabelComponent().setVisible(false);
                JPanel panel = this.dualSelector.getSourceTopActionButtonContainer();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel(this.dualSelector.getSourceLabel()));
                panel.add(this.binocularsButton);
                this.dualSelector.getTargetLabelComponent().setPreferredSize(panel.getPreferredSize());
                this.dualSelector.initializeSize();
                this.binocularsButton.setVisible(true);
                if (this.valueProviderAdapter != null) {
                    this.binocularsButton.setEnabled(!this.valueProviderAdapter.isInErrorMode());
                }
            }
        } else {
            this.dualSelector.getSourceLabelComponent().setVisible(this.browse);
            this.dualSelector.getSourceTopActionButtonContainer().removeAll();
            this.binocularsButton = null;
        }
    }

    private boolean updateBrowseAndSearch() {
        boolean newBrowse = false;
        boolean newSearch = false;
        if (this.displayMode == 400 || this.displayMode == 402 || this.displayMode == 403) {
            newBrowse = true;
        }
        if (this.displayMode == 401 || this.displayMode == 403) {
            newSearch = true;
        }
        if (this.browseMode == 601) {
            newBrowse = true;
        }
        if (newSearch && !this.isSearchable(this.valueProvider)) {
            newSearch = false;
        }
        if (!newBrowse && !newSearch) {
            newBrowse = true;
        }
        if (newBrowse != this.browse || newSearch != this.search) {
            this.browse = newBrowse;
            this.search = newSearch;
            return true;
        }
        return false;
    }

    public DataTypeInterface getDataType() {
        if (this.setDataType != null) {
            return this.setDataType;
        }
        return this.getUnsetDataType();
    }

    private DataTypeInterface getUnsetDataType() {
        if (this.unsetDataType == null && this.valueProvider != null) {
            try {
                this.unsetDataType = this.valueProvider.getDataType();
            }
            catch (ValueProviderException e) {
                LoggerRepository2.getLogger((String)ValuePicker.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.unsetDataType != null) {
            return this.unsetDataType;
        }
        return StringType.DEFAULT_INSTANCE;
    }

    private void addValueField() {
        if (this.getSelectionMode() == 300 || this.getSelectionMode() == 303) {
            this.valuePanel = new JPanel();
            this.valuePanel.setLayout(new AutoSizingGridLayout(2, 1, 5, 5, true, false, true));
            this.valuePanel.setOpaque(false);
            if (this.editable && this.getSelectionMode() == 300) {
                this.valuePanel.add(new JLabel(RB.getStringResource(RB_KEY, "valueLabel.txt", this.getLocale())));
                this.editor = EditorFactory.defaultInstance.getEditor(this.getDataType(), this.getLocale());
                if (this.editor instanceof DatePicker) {
                    ((DatePicker)this.editor).setShowRelativeDates(true);
                }
                this.valuePanel.add(this.editor.getEditorComponent());
                this.editor.addEditorListener(this);
                this.add(this.valuePanel);
            } else if (this.valueProviderAdapter.getContainerComponent() instanceof JTabbedPane) {
                this.valuePanel.add(new JLabel(RB.getStringResource(RB_KEY, "valueLabel.txt", this.getLocale())));
                this.valueLabel = new JLabel(" ");
                this.valuePanel.add(this.valueLabel);
                this.add(this.valuePanel);
            } else {
                this.valuePanel = null;
            }
        }
    }

    @Override
    public void requestFocus() {
        if (this.valueProviderAdapter != null) {
            this.valueProviderAdapter.getBrowseComponent().requestFocus();
        }
        super.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.valueProviderAdapter != null) {
            return this.valueProviderAdapter.getBrowseComponent().requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.valueProviderAdapter != null) {
            return this.valueProviderAdapter.getBrowseComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void reloadValues() {
        this.reloadValues(true);
    }

    public void reloadValues(boolean clearValue) {
        try {
            Window comp = SwingUtilities.getWindowAncestor(this);
            if (comp != null) {
                this.changeCursorCommand.apply(comp);
            }
            if (this.selectionMode == 301 || this.selectionMode == 302) {
                this.dualSelector.getSourceAdapter().clearSelections();
                this.dualSelector.reloadValues();
            } else {
                if (clearValue) {
                    this.valueProviderAdapter.clearSelections();
                }
                this.valueProviderAdapter.reloadValues();
            }
            this.updateBinoculars();
            this.setRendererOnValueProviderAdapter();
            if (this.isEditable()) {
                if (this.getSelectionMode() == 300 || this.getSelectionMode() == 303) {
                    if (this.valuePanel != null) {
                        this.remove(this.valuePanel);
                        this.valuePanel = null;
                        this.valueLabel = null;
                        this.editor = null;
                    }
                    this.addValueField();
                } else {
                    this.dualSelector.setEditable(this.editable);
                }
            }
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
    }

    private boolean isSearchable(ValueProviderInterface vp) {
        if (vp instanceof ListSearchInterface) {
            try {
                boolean searchable = ((ListSearchInterface)vp).isSearchable();
                return searchable;
            }
            catch (ValueProviderException valueProviderException) {
                // empty catch block
            }
        }
        return false;
    }

    private void setButtonProperties(AbstractButton button) {
        button.setMargin(new Insets(1, 1, 1, 1));
    }

    @Override
    public void onApply() {
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onClose() {
    }

    @Override
    public String getDialogTitle() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return null;
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public String getHelpID() {
        return null;
    }

    @Override
    public boolean isYesNo() {
        return false;
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (this.contentsValid != newValue) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
        if (!this.ignoreEvents && selectionModel != null && !e.getValueIsAdjusting()) {
            if (this.isMoreValuesSelected()) {
                try {
                    this.ignoreEvents = true;
                    JComponent browseComp = this.valueProviderAdapter.getBrowseAdapter().getComponent();
                    if (browseComp instanceof TableView) {
                        ((TableView)browseComp).changeSelection(((TableView)browseComp).getRowCount() - 1, -1, true, false);
                    }
                }
                finally {
                    this.ignoreEvents = false;
                }
                this.launchSearchWindow();
                return;
            }
            if (this.getSelectionMode() == 300) {
                boolean empty = selectionModel.isSelectionEmpty();
                if (!empty && this.browse && this.search) {
                    JComponent browseComp = this.valueProviderAdapter.getBrowseAdapter().getComponent();
                    if (browseComp instanceof TableView) {
                        if (((TableView)browseComp).getRowModel().getSelectionModel() == selectionModel) {
                            this.valueProviderAdapter.getSearchAdapter().clearSelections();
                        } else {
                            this.valueProviderAdapter.getBrowseAdapter().clearSelections();
                        }
                    } else {
                        this.valueProviderAdapter.getBrowseAdapter().clearSelections();
                    }
                }
                if (!this.valueModified) {
                    this.valueModified = true;
                    this.fireValueModified();
                }
                this.updateValueLabel();
                this.valueProviderAdapter.setAdditionalAvailableValues(null);
                this.fireValueChanged();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreeSelectionModel selectionModel = (TreeSelectionModel)e.getSource();
        if (!this.ignoreEvents && selectionModel != null) {
            boolean empty = selectionModel.isSelectionEmpty();
            if (!empty && this.browse && this.search) {
                this.valueProviderAdapter.getSearchAdapter().clearSelections();
            }
            if (!empty) {
                ((JTree)this.valueProviderAdapter.getBrowseAdapter().getComponent()).setSelectionPath(e.getPath());
            }
            if (!this.valueModified) {
                this.valueModified = true;
                this.fireValueModified();
            }
            this.updateValueLabel();
            this.valueProviderAdapter.setAdditionalAvailableValues(null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ValuePicker.this.fireValueChanged();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.ignoreEvents && e.getSource() == this.valueProviderAdapter.getBrowseAdapter().getComponent()) {
            JComboBox combo = (JComboBox)this.valueProviderAdapter.getBrowseAdapter().getComponent();
            if (this.isMoreValuesSelected()) {
                try {
                    this.ignoreEvents = true;
                    combo.setSelectedItem(this.lastSelectedItem);
                }
                finally {
                    this.ignoreEvents = false;
                }
                this.launchSearchWindow();
                return;
            }
            boolean empty = combo.getSelectedIndex() == -1;
            this.lastSelectedItem = combo.getSelectedItem();
            if (!empty && this.browse && this.search) {
                this.valueProviderAdapter.getSearchAdapter().clearSelections();
            }
            if (!this.valueModified) {
                this.valueModified = true;
                this.fireValueModified();
            }
            this.updateValueLabel();
            if (!this.comingFromSearch) {
                this.valueProviderAdapter.setAdditionalAvailableValues(null);
            }
            this.fireValueChanged();
        }
    }

    private boolean isMoreValuesSelected() {
        return this.valueProviderAdapter.isMoreValuesSelected();
    }

    @Override
    public void editingStarted(ChangeEvent e) {
        if (this.ignoreEditorEvents) {
            return;
        }
    }

    @Override
    public void valueModified(ChangeEvent e) {
        if (e.getSource() == this.dualSelector) {
            if (!this.valueModified) {
                this.valueModified = true;
                this.fireValueModified();
            }
        } else if (e.getSource() == this.editor) {
            if (this.ignoreEditorEvents) {
                return;
            }
            try {
                this.ignoreEvents = true;
                if (!this.valueModified) {
                    this.valueModified = true;
                    this.setContentsValid(true);
                    this.valueProviderAdapter.clearSelections();
                    this.fireValueModified();
                }
            }
            finally {
                this.ignoreEvents = false;
            }
        }
    }

    @Override
    public void valueChanged(ChangeEvent e) {
        if (e.getSource() == this.editor) {
            if (this.ignoreEditorEvents) {
                return;
            }
            try {
                this.ignoreEvents = true;
                JComponent comp = this.valueProviderAdapter.getSelectedAdapter().getComponent();
                if (comp instanceof TableView && ((TableView)comp).getRowModel().getSelectionModel().getValueIsAdjusting()) {
                    return;
                }
                this.valueProviderAdapter.clearSelections();
                if (this.editor.getValue() == null) {
                    this.setContentsValid(false);
                } else {
                    this.setContentsValid(true);
                }
                this.fireValueChanged();
            }
            finally {
                this.ignoreEvents = false;
            }
        } else if (e.getSource() == this.dualSelector) {
            this.updateValueLabel();
            this.fireValueChanged();
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (e.getSource() == this.editor && !this.ignoreEvents) {
            if (this.ignoreEditorEvents) {
                return;
            }
            try {
                JComponent comp = this.valueProviderAdapter.getSelectedAdapter().getComponent();
                if (comp instanceof TableView && ((TableView)comp).getRowModel().getSelectionModel().getValueIsAdjusting()) {
                    return;
                }
                this.ignoreEvents = true;
                this.valueProviderAdapter.clearSelections();
                this.fireValueChanged();
            }
            finally {
                this.ignoreEvents = false;
            }
        }
    }

    private void updateValueLabel() {
        if (this.selectionMode == 300 || this.selectionMode == 303) {
            List selectedItem = this.getSelectedItems();
            Object value = null;
            if (PromptUtil.isPromptValuesEqual(null, (Object)selectedItem)) {
                value = null;
                this.setContentsValid(false);
            } else {
                value = selectedItem.get(0);
                this.setContentsValid(true);
            }
            if (this.editable && this.editor != null) {
                try {
                    this.ignoreEditorEvents = true;
                    this.editor.setValue(value);
                }
                finally {
                    this.ignoreEditorEvents = false;
                }
            } else {
                String stringValue = null;
                if (value == null) {
                    stringValue = " ";
                } else if (value instanceof ValueItem) {
                    if (null != ((ValueItem)value).getLabel()) {
                        stringValue = ((ValueItem)value).getLabel().toString();
                    }
                } else {
                    stringValue = value.toString();
                }
                if (this.valueLabel != null) {
                    this.valueLabel.setText(stringValue);
                }
            }
        } else {
            this.setContentsValid(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedItems(List items) {
        try {
            this.ignoreEvents = true;
            if (items == null) {
                items = new ArrayList();
            }
            if (this.selectionMode == 301 || this.selectionMode == 302) {
                this.dualSelector.setSelectedItems(items);
                this.setContentsValid(!items.isEmpty());
            } else if (this.browse) {
                boolean found = false;
                ArrayList selectedItems = null;
                if (items != null) {
                    selectedItems = new ArrayList();
                    Iterator iter = items.iterator();
                    if (iter.hasNext()) {
                        Object element = iter.next();
                        if (element instanceof Vector) {
                            selectedItems.add(((Vector)element).get(0));
                        } else {
                            selectedItems.add(element);
                        }
                    }
                }
                if (this.valueProviderAdapter != null && this.valueProviderAdapter.getBrowseAdapter() != null) {
                    JComponent browseComp = this.valueProviderAdapter.getBrowseAdapter().getComponent();
                    if (browseComp instanceof TableView) {
                        TableView tv = (TableView)browseComp;
                        if (selectedItems == null) {
                            tv.getRowModel().getSelectionModel().clearSelection();
                        } else {
                            int rowCount = tv.getRowCount();
                            block3: for (Object element : selectedItems) {
                                DataTypeInterface dataType = this.getDataType();
                                Locale locale = this.getLocale();
                                int lc = this.getLabelColumn();
                                TableModel tm = tv.getModel();
                                for (int i = 0; i < rowCount; ++i) {
                                    Object rowValue = tm.getValueAt(i, lc);
                                    if (!ValuePicker.areValuesEqual(rowValue, element, dataType, locale)) continue;
                                    found = true;
                                    final int row = tv.convertRowIndexToView(i);
                                    final TableView table = tv;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (table.getRowCount() > row && row != -1) {
                                                table.setRowSelectionInterval(row, row);
                                                if (row != -1) {
                                                    table.scrollRectToVisible(table.getCellRect(row, 0, true));
                                                }
                                                ValuePicker.this.updateValueLabel();
                                            }
                                        }
                                    });
                                    continue block3;
                                }
                            }
                        }
                        if (!found && this.editor != null) {
                            found = true;
                            if (selectedItems == null || selectedItems.isEmpty()) {
                                this.editor.setValue(null);
                                this.setContentsValid(false);
                            } else {
                                this.editor.setValue(selectedItems.get(0));
                                this.setContentsValid(true);
                            }
                        }
                    } else if (browseComp instanceof JTree) {
                        JTree tree = (JTree)browseComp;
                        if (selectedItems == null) {
                            tree.getSelectionModel().clearSelection();
                            this.setContentsValid(false);
                        } else {
                            Iterator iter = selectedItems.iterator();
                            block5: while (iter.hasNext()) {
                                TreePath treePath;
                                Object element;
                                Object val = element = iter.next();
                                if (element instanceof ValueItem) {
                                    val = ((ValueItem)element).getValue();
                                }
                                if (val instanceof String && (treePath = TreeUtil.getTreePathByUniqueMemberName(tree.getModel(), (String)val)) != null) {
                                    found = true;
                                    tree.setSelectionPath(treePath);
                                    tree.scrollPathToVisible(treePath);
                                }
                                if (found) continue;
                                PreorderTreeModelIterator treeIter = new PreorderTreeModelIterator(tree.getModel());
                                while (treeIter.hasNext()) {
                                    Object userObject;
                                    Object node = treeIter.next();
                                    if (!(node instanceof DefaultMutableTreeNode) || !ValuePicker.areValuesEqual(userObject = ((DefaultMutableTreeNode)node).getUserObject(), val, this.getDataType(), this.getLocale())) continue;
                                    found = true;
                                    TreePath path = new TreePath(((DefaultMutableTreeNode)node).getPath());
                                    tree.setSelectionPath(path);
                                    tree.scrollPathToVisible(path);
                                    continue block5;
                                }
                            }
                            if (found) {
                                this.setContentsValid(true);
                            } else {
                                this.setContentsValid(false);
                            }
                        }
                    } else if (browseComp instanceof JComboBox) {
                        JComboBox combo = (JComboBox)browseComp;
                        if (selectedItems == null || selectedItems.isEmpty()) {
                            combo.setSelectedIndex(-1);
                            this.setContentsValid(false);
                        } else {
                            this.valueProviderAdapter.setAdditionalAvailableValues(null);
                            Object val = selectedItems.get(0);
                            int size = combo.getModel().getSize();
                            for (int i = 0; i < size; ++i) {
                                Object element = combo.getModel().getElementAt(i);
                                if (this.valueProviderAdapter.isMoreValue(element) || this.valueProviderAdapter.isSeperatorValue(element) || !ValuePicker.areValuesEqual(val, element, this.getDataType(), this.getLocale())) continue;
                                combo.setSelectedItem(element);
                                this.setContentsValid(true);
                                found = true;
                                break;
                            }
                            if (!found && combo.isEditable()) {
                                combo.setSelectedItem(val);
                                this.setContentsValid(true);
                            } else if (!found) {
                                found = true;
                                this.valueProviderAdapter.setAdditionalAvailableValues(selectedItems);
                                combo.setSelectedItem(val);
                                this.setContentsValid(true);
                            }
                            combo.repaint();
                        }
                    } else if (browseComp instanceof EditorInterface) {
                        found = true;
                        if (selectedItems == null || selectedItems.isEmpty()) {
                            ((EditorInterface)((Object)browseComp)).setValue(null);
                            this.setContentsValid(false);
                        } else {
                            ((EditorInterface)((Object)browseComp)).setValue(selectedItems.get(0));
                            this.setContentsValid(true);
                        }
                    }
                    if (!found) {
                        this.valueProviderAdapter.clearSelections();
                    }
                }
            }
            this.fireValueChanged();
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private int getLabelColumn() {
        if (this.valueProvider != null && this.valueProvider.isValueDisplayed()) {
            return 1;
        }
        return 0;
    }

    private static Object coerceValue(Object value, DataTypeInterface dataType, Locale locale) {
        Object returnValue = value;
        if (dataType != null) {
            try {
                returnValue = dataType.coerceValue(value, locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static boolean areValuesEqual(Object value1, Object value2, DataTypeInterface dataType, Locale locale) {
        if (com.sas.util.Util.equal((Object)value1, (Object)value2)) {
            return true;
        }
        if (dataType != null) {
            if (value1 instanceof ValueItem && com.sas.util.Util.equal((Object)ValuePicker.coerceValue(((ValueItem)value1).getValue(), dataType, locale), (Object)ValuePicker.coerceValue(value2, dataType, locale))) {
                return true;
            }
            if (value2 instanceof ValueItem && com.sas.util.Util.equal((Object)ValuePicker.coerceValue(value1, dataType, locale), (Object)ValuePicker.coerceValue(((ValueItem)value2).getValue(), dataType, locale))) {
                return true;
            }
            if (value2 instanceof ValueItem && value1 instanceof ValueItem && com.sas.util.Util.equal((Object)ValuePicker.coerceValue(((ValueItem)value1).getValue(), dataType, locale), (Object)ValuePicker.coerceValue(((ValueItem)value2).getValue(), dataType, locale))) {
                return true;
            }
        } else {
            if (value1 instanceof ValueItem && com.sas.util.Util.equal((Object)((ValueItem)value1).getValue(), (Object)value2)) {
                return true;
            }
            if (value2 instanceof ValueItem && com.sas.util.Util.equal((Object)value1, (Object)((ValueItem)value2).getValue())) {
                return true;
            }
            if (value2 instanceof ValueItem && value1 instanceof ValueItem && com.sas.util.Util.equal((Object)((ValueItem)value1).getValue(), (Object)((ValueItem)value2).getValue())) {
                return true;
            }
        }
        return false;
    }

    public List getSelectedItems() {
        List<Object> selectedItems = null;
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            selectedItems = this.dualSelector.getSelectedItems();
        } else {
            DualSelectorInterface adapter = this.valueProviderAdapter.getBrowseAdapter();
            if (adapter instanceof JTreeDualSelectorAdapter) {
                TreePath path = ((JTree)((JTreeDualSelectorAdapter)adapter).getComponent()).getSelectionPath();
                ArrayList<TreePath> items = new ArrayList<TreePath>();
                if (path != null) {
                    items.add(path);
                }
                selectedItems = this.valueProviderAdapter.prepareSelectedItems(adapter, items);
            } else if (adapter != null) {
                selectedItems = this.valueProviderAdapter.getSelectedItemsFor(adapter);
            }
            if ((adapter == null || selectedItems.isEmpty()) && (adapter = this.valueProviderAdapter.getSearchAdapter()) != null) {
                selectedItems = this.valueProviderAdapter.getSelectedItemsFor(adapter);
            }
        }
        if (this.selectionMode == 300 && this.editable && selectedItems.isEmpty()) {
            ArrayList<Object> newList = new ArrayList<Object>(1);
            newList.add(this.editor.getValue());
            selectedItems = newList;
        }
        return selectedItems;
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
        this.valueModified = false;
    }

    @Override
    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    public void selectBrowseTab() {
        if (this.valueProviderAdapter != null) {
            this.valueProviderAdapter.selectBrowseTab();
        }
    }

    public void selectSearchTab() {
        if (this.valueProviderAdapter != null) {
            this.valueProviderAdapter.selectSearchTab();
        }
    }

    @Override
    public Object getValue() {
        List items = this.getSelectedItems();
        return items;
    }

    @Override
    public void setValue(Object anObject) {
        if (!(anObject instanceof List)) {
            ArrayList newList = new ArrayList(1);
            if (anObject != null) {
                newList.add(anObject);
            }
            anObject = newList;
        }
        this.setSelectedItems(anObject);
    }

    public ValueProviderInterface getValueProvider() {
        return this.valueProvider;
    }

    public Object getBrowseModel() {
        if (this.browse && this.valueProviderAdapter.getBrowseAdapter() != null) {
            JComponent comp = this.valueProviderAdapter.getBrowseAdapter().getComponent();
            if (comp instanceof JTable) {
                return ((JTable)comp).getModel();
            }
            if (comp instanceof JComboBox) {
                return ((JComboBox)comp).getModel();
            }
            if (comp instanceof JTree) {
                return ((JTree)comp).getModel();
            }
        }
        return null;
    }

    public Object getSearchModel() {
        JComponent comp;
        if (this.search && this.valueProviderAdapter.getSearchAdapter() != null && (comp = this.valueProviderAdapter.getSearchAdapter().getComponent()) instanceof JTable) {
            return ((JTable)comp).getModel();
        }
        return null;
    }

    public Object getTargetModel() {
        if (this.getSelectionMode() == 301 || this.getSelectionMode() == 302) {
            return this.dualSelector.getTargetModel();
        }
        return null;
    }

    public Object getBrowseComponent() {
        if (this.browse && this.valueProviderAdapter.getBrowseAdapter() != null) {
            return this.valueProviderAdapter.getBrowseAdapter().getComponent();
        }
        return null;
    }

    public Object getSearchComponent() {
        if (this.search && this.valueProviderAdapter.getSearchAdapter() != null) {
            return this.valueProviderAdapter.getSearchAdapter().getComponent();
        }
        return null;
    }

    public void clearSearchResults() {
        if (this.valueProviderAdapter.getSearchAdapter() != null) {
            this.valueProviderAdapter.clearSearchResults();
        }
    }

    public Object getTargetComponent() {
        if (this.getSelectionMode() == 301 || this.getSelectionMode() == 302) {
            return this.dualSelector.getTargetComponent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueProvider(ValueProviderInterface valueProvider) {
        if (this.valueProvider != valueProvider) {
            ValueProviderInterface oldValue = this.valueProvider;
            this.valueProvider = valueProvider;
            this.unsetDataType = null;
            try {
                Window comp = SwingUtilities.getWindowAncestor(this);
                if (comp != null) {
                    this.changeCursorCommand.apply(comp);
                }
                this.createUI();
            }
            finally {
                this.changeCursorCommand.undoAll();
            }
            this.setEnabled(this.isEnabled());
            this.revalidate();
            this.fireValueChanged();
            this.firePropertyChange("valueProvider", oldValue, this.valueProvider);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            boolean oldValue = this.editable;
            this.editable = editable;
            if (this.selectionMode == 300) {
                if (this.valuePanel != null) {
                    this.remove(this.valuePanel);
                    this.valuePanel = null;
                    this.valueLabel = null;
                    this.editor = null;
                }
                this.addValueField();
                this.setAccessibleNames();
            } else if (this.selectionMode == 303) {
                this.updateComponent();
            } else {
                this.dualSelector.setEditable(editable);
                this.setAccessibleNames();
            }
            this.revalidate();
            this.firePropertyChange("editable", oldValue, this.editable);
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        if (this.displayMode != displayMode) {
            int oldValue = this.displayMode;
            this.displayMode = displayMode;
            if (this.updateBrowseAndSearch()) {
                int browseOpt = this.getBrowseOption();
                if (this.selectionMode == 300 || this.selectionMode == 303) {
                    this.removeAll();
                    if (this.browse && this.selectionMode == 303) {
                        browseOpt = this.editable ? 50 : 40;
                    }
                    this.valueProviderAdapter.setBrowseAndSearchVisible(browseOpt, this.search);
                    this.setRendererOnValueProviderAdapter();
                    this.updateBinoculars();
                    if (this.getSelectionMode() == 303 && this.searchPanel != null) {
                        this.layout.setColumns(2);
                        this.layout.setRemainderColumn(1);
                        this.add((Component)this.valueProviderAdapter.getContainerComponent(), 0);
                    } else {
                        this.add(this.valueProviderAdapter.getContainerComponent());
                    }
                } else {
                    this.dualSelector.setBrowseAndSearchVisible(browseOpt, this.search);
                    this.setRendererOnValueProviderAdapter();
                    this.updateBinoculars();
                }
                if (this.valuePanel != null) {
                    this.remove(this.valuePanel);
                    this.valuePanel = null;
                    this.valueLabel = null;
                    this.editor = null;
                }
                this.addValueField();
            } else {
                this.updateBinoculars();
            }
            this.setAccessibleNames();
            this.revalidate();
            this.firePropertyChange("displayMode", oldValue, this.displayMode);
        }
    }

    private int getBrowseOption() {
        return this.browse ? (this.browseMode == 600 ? 20 : 30) : 10;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int selectionMode) {
        if (this.selectionMode != selectionMode) {
            int oldValue = this.selectionMode;
            this.selectionMode = selectionMode;
            if (selectionMode == 300 || selectionMode == 303) {
                this.updateComponent();
            } else if (oldValue == 301 || oldValue == 302) {
                this.dualSelector.setReorderingAllowed(selectionMode == 302);
                this.setAccessibleNames();
            } else {
                this.updateComponent();
            }
            this.revalidate();
            this.firePropertyChange("selectionMode", oldValue, this.selectionMode);
        }
    }

    public String getSourceLabel() {
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            return this.dualSelector.getSourceLabel();
        }
        return null;
    }

    public void setSourceLabel(String sourceLabel) {
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            this.dualSelector.setSourceLabel(sourceLabel);
        }
        this.sourceLabel = sourceLabel;
    }

    public String getTargetLabel() {
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            return this.dualSelector.getTargetLabel();
        }
        return null;
    }

    public void setTargetLabel(String targetLabel) {
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            this.dualSelector.setTargetLabel(targetLabel);
        }
        this.targetLabel = targetLabel;
    }

    public boolean isCaseSensitiveSearch() {
        return this.caseSensitiveSearch;
    }

    public void setCaseSensitiveSearch(boolean caseSensitiveSearch) {
        if (this.caseSensitiveSearch != caseSensitiveSearch) {
            boolean oldValue = this.caseSensitiveSearch;
            this.caseSensitiveSearch = caseSensitiveSearch;
            this.valueProviderAdapter.setCaseSensitiveSearch(this.caseSensitiveSearch);
            this.firePropertyChange("caseSensitiveSearch", oldValue, this.caseSensitiveSearch);
        }
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValuesSupported) {
        if (this.specialValues != specialValuesSupported) {
            SupportedSpecialValues oldValue = this.specialValues;
            this.specialValues = specialValuesSupported;
            this.valueProviderAdapter.setSupportedSpecialValues(specialValuesSupported);
            this.updateMissingValueSupport();
            this.setRendererOnValueProviderAdapter();
            this.firePropertyChange("supportedSpecialValues", oldValue, this.specialValues);
        }
    }

    private void updateMissingValueSupport() {
        if (this.specialValues != null && this.specialValues.isMissingValuesSupported()) {
            SupportedSpecialValues sv = SupportedSpecialValues.newMissingValuesSupported();
            sv.setMissingValuesHiddenIfSupported(true);
            if (this.editor instanceof MutableSupportedSpecialValuesInterface) {
                ((MutableSupportedSpecialValuesInterface)this.editor).setSupportedSpecialValues(sv);
            } else if (this.dualSelector != null && ((ValueListEditor)this.dualSelector.getTargetComponent()).getEditor() instanceof MutableSupportedSpecialValuesInterface) {
                ((MutableSupportedSpecialValuesInterface)((ValueListEditor)this.dualSelector.getTargetComponent()).getEditor()).setSupportedSpecialValues(sv);
            } else if (this.valueProviderAdapter != null && this.valueProviderAdapter.getBrowseComponent() instanceof MutableSupportedSpecialValuesInterface) {
                ((MutableSupportedSpecialValuesInterface)this.valueProviderAdapter.getBrowseComponent()).setSupportedSpecialValues(sv);
            }
        } else {
            SupportedSpecialValues sv = new SupportedSpecialValues();
            if (this.editor instanceof MutableSupportedSpecialValuesInterface) {
                ((MutableSupportedSpecialValuesInterface)this.editor).setSupportedSpecialValues(sv);
            } else if (this.dualSelector != null && ((ValueListEditor)this.dualSelector.getTargetComponent()).getEditor() instanceof MutableSupportedSpecialValuesInterface) {
                ((MutableSupportedSpecialValuesInterface)((ValueListEditor)this.dualSelector.getTargetComponent()).getEditor()).setSupportedSpecialValues(sv);
            } else if (this.valueProviderAdapter != null && this.valueProviderAdapter.getBrowseComponent() instanceof MutableSupportedSpecialValuesInterface) {
                ((MutableSupportedSpecialValuesInterface)this.valueProviderAdapter.getBrowseComponent()).setSupportedSpecialValues(sv);
            }
        }
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }

    public ValuePickerRendererHandler getRendererHandler() {
        return this.rendererHandler;
    }

    public void setRendererHandler(ValuePickerRendererHandler rendererHandler) {
        if (this.rendererHandler != rendererHandler) {
            ValuePickerRendererHandler oldValue = this.rendererHandler;
            this.rendererHandler = rendererHandler;
            this.firePropertyChange("rendererHandler", oldValue, this.rendererHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchSearchWindow() {
        try {
            int selectMode;
            Window comp = SwingUtilities.getWindowAncestor(this);
            if (comp != null) {
                this.changeCursorCommand.apply(comp);
            }
            if ((selectMode = this.getSelectionMode()) == 303) {
                selectMode = 300;
            }
            Container owner = SwingUtilities.getAncestorOfClass(Dialog.class, this);
            String title = null;
            title = selectMode == 303 || selectMode == 300 ? RB.getStringResource(RB_KEY, "pickAValue.txt", this.getLocale()) : RB.getStringResource(RB_KEY, "selectValues.txt", this.getLocale());
            if (this.dialog == null) {
                this.dialog = owner != null ? new ValuePickerDialog((Dialog)owner, this.valueProvider, 403, selectMode, this.editable, this.getPageSize(), title, true, this.setDataType, this.viewQueryCache, this.getLocale()) : new ValuePickerDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), this.valueProvider, 403, selectMode, this.editable, this.getPageSize(), title, true, this.setDataType, this.viewQueryCache, this.getLocale());
            } else {
                this.dialog.getValuePicker().setPageSize(this.getPageSize());
                this.dialog.getValuePicker().clearSearchResults();
                this.dialog.getValuePicker().reloadValues();
            }
            this.dialog.getValuePicker().setRendererHandler(this.getRendererHandler());
            this.dialog.getValuePicker().setSupportedSpecialValues(this.getSupportedSpecialValues());
            this.dialog.getValuePicker().setSelectionMode(selectMode);
            this.dialog.getValuePicker().setEditable(this.isEditable());
            this.dialog.getValuePicker().setCaseSensitiveSearch(this.isCaseSensitiveSearch());
            this.dialog.getValuePicker().setMaxValues(this.getMaxValues());
            this.dialog.getValuePicker().setGenericErrorHandler(this.getGenericErrorHandler());
            this.dialog.getValuePicker().setSourceLabel(this.getSourceLabel());
            this.dialog.getValuePicker().setTargetLabel(this.getTargetLabel());
            this.dialog.getValuePicker().setValueProvider(this.valueProvider);
            this.dialog.getValuePicker().selectSearchTab();
            ArrayList obj = this.getValue();
            if (!(obj instanceof List)) {
                ArrayList list = new ArrayList();
                list.add(obj);
                obj = list;
            }
            this.dialog.getValuePicker().setSelectedItems(obj);
            if (selectMode == 300) {
                Object bc = this.dialog.getValuePicker().getBrowseComponent();
                Object sc = this.dialog.getValuePicker().getSearchComponent();
                this.addDoubleClickListenerTo(bc);
                this.addDoubleClickListenerTo(sc);
            }
            this.dialog.pack();
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
        Util.centerOver(this.dialog, this);
        try {
            this.dialog.setVisible(true);
        }
        finally {
            if (this.dialog.getValuePicker().getSelectionMode() == 300) {
                Object bc = this.dialog.getValuePicker().getBrowseComponent();
                Object sc = this.dialog.getValuePicker().getSearchComponent();
                this.removeDoubleClickListenerTo(bc);
                this.removeDoubleClickListenerTo(sc);
            }
        }
        if (!this.dialog.wasCancelled()) {
            List items = this.dialog.getValuePicker().getSelectedItems();
            if (this.selectionMode == 300 || this.selectionMode == 303) {
                if (items.isEmpty()) {
                    this.setValue(null);
                } else {
                    try {
                        this.comingFromSearch = true;
                        this.setValue(items.get(0));
                    }
                    finally {
                        this.comingFromSearch = false;
                    }
                }
            } else {
                try {
                    this.comingFromSearch = true;
                    this.setValue(items);
                }
                finally {
                    this.comingFromSearch = false;
                }
            }
        }
    }

    private void addDoubleClickListenerTo(Object comp) {
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            jc.addMouseListener(this.getDoubleClickMouseListener());
        }
    }

    private MouseListener getDoubleClickMouseListener() {
        if (this.mouseDoubleClickListener == null) {
            this.mouseDoubleClickListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && ValuePicker.this.dialog != null) {
                        ValuePicker.this.dialog.onOK();
                    }
                }
            };
        }
        return this.mouseDoubleClickListener;
    }

    private void removeDoubleClickListenerTo(Object comp) {
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            jc.removeMouseListener(this.getDoubleClickMouseListener());
        }
    }

    public void setAddNullValueForSingleComboSelection(boolean addNullValueForSingleComboSelection) {
        if (this.addNullValueForSingleComboSelection != addNullValueForSingleComboSelection) {
            this.addNullValueForSingleComboSelection = addNullValueForSingleComboSelection;
            if (this.valueProviderAdapter != null) {
                this.valueProviderAdapter.setAddNullValueForSingleComboSelection(addNullValueForSingleComboSelection);
            }
            this.setRendererOnValueProviderAdapter();
            this.firePropertyChange("addNullValueForSingleComboSelection", !addNullValueForSingleComboSelection, addNullValueForSingleComboSelection);
        }
    }

    public int getMaxValues() {
        return this.maxValues;
    }

    public void setMaxValues(int maxValues) {
        if (this.maxValues != maxValues) {
            int oldValue = this.maxValues;
            this.maxValues = maxValues;
            if (this.dualSelector != null) {
                this.dualSelector.setTargetMaximumCount(maxValues);
                ((ValueListEditor)this.dualSelector.getTargetComponent()).setMaxItems(maxValues);
            }
            this.firePropertyChange("maxValues", oldValue, this.maxValues);
        }
    }

    public int getBrowseMode() {
        return this.browseMode;
    }

    public void setBrowseMode(int browseMode) {
        if (browseMode != 600 && browseMode != 601) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidPagingMode.ex.txt", this.getLocale()));
        }
        if (this.browseMode != browseMode) {
            int oldValue = this.browseMode;
            this.browseMode = browseMode;
            if (this.getSelectionMode() != 303) {
                int bo = this.getBrowseOption();
                this.valueProviderAdapter.setBrowseMode(bo);
                this.setRendererOnValueProviderAdapter();
            }
            this.updateBinoculars();
            this.firePropertyChange("browseMode", oldValue, this.browseMode);
        }
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            if (this.valueProviderAdapter != null) {
                this.valueProviderAdapter.setGenericErrorHandler(this.getGenericErrorHandler());
            }
            if (this.dualSelector != null) {
                ((ValueListEditor)this.dualSelector.getTargetComponent()).setGenericErrorHandler(errorHandler);
            }
            this.firePropertyChange("genericErrorHandler", oldValue, this.errorHandler);
        }
    }

    @SASScope
    private class ValuePickerRenderer
    implements TableCellRenderer,
    ListCellRenderer,
    TreeCellRenderer {
        private TableCellRenderer tableRenderer = new DefaultTableCellRenderer();
        private ListCellRenderer listRenderer;
        private TreeCellRenderer treeRenderer;
        private JSeparator separator;
        private int seperatorHeight;

        public ValuePickerRenderer() {
            ObjectToStringTransform transform = new ObjectToStringTransform(){

                public Object transform(Object input) {
                    if (input instanceof Date) {
                        DateFormat formatter;
                        if (input instanceof Time) {
                            formatter = DateFormat.getTimeInstance(2, this.locale);
                            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                        } else if (input instanceof Timestamp) {
                            formatter = DateFormat.getDateTimeInstance(2, 2, this.locale);
                            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                        } else {
                            formatter = DateFormat.getDateInstance(2, this.locale);
                            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                        }
                        return formatter.format((Date)input);
                    }
                    return super.transform(input);
                }
            };
            transform.setNullString("");
            ((DefaultTableCellRenderer)this.tableRenderer).setTransform((TransformInterface)transform);
            this.listRenderer = new DefaultListCellRenderer();
            this.treeRenderer = new DefaultTreeCellRenderer();
            ((DefaultTreeCellRenderer)this.treeRenderer).setClosedIcon(null);
            ((DefaultTreeCellRenderer)this.treeRenderer).setOpenIcon(null);
            ((DefaultTreeCellRenderer)this.treeRenderer).setLeafIcon(null);
            this.separator = new JSeparator(0);
            this.seperatorHeight = this.separator.getPreferredSize().height;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (ValuePicker.this.valueProviderAdapter.isSeperatorValue(value) || value == ComboBox.SEPARATOR) {
                if (table.getRowHeight(row) != this.seperatorHeight) {
                    table.setRowHeight(row, this.seperatorHeight);
                }
                return this.separator;
            }
            Component comp = this.tableRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (ValuePicker.this.valueProviderAdapter.isInErrorMode() && !table.isEnabled()) {
                comp.setEnabled(false);
                comp.setBackground(((TableView)table).getScrollPane().getBackground());
            } else if (table.isEnabled()) {
                comp.setEnabled(true);
            } else {
                comp.setEnabled(false);
            }
            List cols = Collections.EMPTY_LIST;
            cols = ValuePicker.this.dualSelector != null ? (ValuePicker.this.dualSelector.getTargetModel() instanceof ValueItemsToTableModelAdapter ? ((ValueItemsToTableModelAdapter)ValuePicker.this.dualSelector.getTargetModel()).getColumns() : ValuePicker.this.valueProviderAdapter.getColumns()) : ValuePicker.this.valueProviderAdapter.getColumns();
            Object colObject = null;
            if (cols.size() > column) {
                colObject = cols.get(column);
            }
            this.configureLabel((JLabel)comp, value, table, isSelected, hasFocus, colObject);
            return comp;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (ValuePicker.this.valueProviderAdapter.isSeperatorValue(value) || value == ComboBox.SEPARATOR) {
                return this.separator;
            }
            if (value == null || value instanceof ValueItem && (((ValueItem)value).getLabel() == null || ((ValueItem)value).getLabel().length() == 0)) {
                value = " ";
            }
            Component comp = this.listRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (ValuePicker.this.valueProvider != null && ValuePicker.this.valueProvider.isValueDisplayed() && value instanceof ValueItem) {
                ValueItem vi = (ValueItem)value;
                if (vi.getAttribute("QUALIFIED_LABEL") != null) {
                    vi = new ValueItem(vi.getAttribute("QUALIFIED_LABEL"), vi.getValue());
                    ((JLabel)comp).setText(vi.getLabel());
                }
                this.configureLabel((JLabel)comp, vi, list, isSelected, cellHasFocus, "QUALIFIED_LABEL");
            } else {
                this.configureLabel((JLabel)comp, value, list, isSelected, cellHasFocus, "LABEL");
            }
            return comp;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = this.treeRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.configureLabel((JLabel)comp, value, tree, selected, hasFocus, "LABEL");
            return comp;
        }

        private void configureLabel(JLabel label, Object value, JComponent visual, boolean isSelected, boolean hasFocus, Object cellType) {
            if (ValuePicker.this.rendererHandler != null) {
                ValuePicker.this.rendererHandler.configureLabelFor(label, value, visual, isSelected, hasFocus, cellType);
            }
        }
    }

    @SASScope
    private class EditorEditorListener
    implements EditorListener {
        private Object oldValue = null;

        public EditorEditorListener() {
            this.oldValue = ValuePicker.this.getValue();
        }

        @Override
        public void editingStarted(ChangeEvent e) {
        }

        @Override
        public void editingStopped(ChangeEvent e) {
        }

        @Override
        public void valueChanged(ChangeEvent e) {
            if (ValuePicker.this.isMoreValuesSelected()) {
                try {
                    ValuePicker.this.ignoreEvents = true;
                    ValuePicker.this.setValue(this.oldValue);
                }
                finally {
                    ValuePicker.this.ignoreEvents = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ValuePicker.this.launchSearchWindow();
                    }
                });
                return;
            }
            this.oldValue = ValuePicker.this.getValue();
            ValuePicker.this.valueProviderAdapter.setAdditionalAvailableValues(null);
            ValuePicker.this.fireValueChanged();
        }

        @Override
        public void valueModified(ChangeEvent e) {
            try {
                ValuePicker.this.ignoreEvents = true;
                if (!ValuePicker.this.valueModified) {
                    ValuePicker.this.valueModified = true;
                    ValuePicker.this.setContentsValid(true);
                    ValuePicker.this.fireValueModified();
                }
            }
            finally {
                ValuePicker.this.ignoreEvents = false;
            }
        }
    }

    @SASScope
    private class SearchButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 6442232351054043631L;

        @Override
        protected void init(String text, Icon icon) {
            if (icon == null) {
                icon = Resources.getImageIcon((String)"Search.gif");
            }
            super.init(text, icon);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this) {
                ValuePicker.this.launchSearchWindow();
            }
        }
    }
}

