/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.models.itemlistmanager.InsertRowInterface;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.swing.models.CollectionToTableModelAdapter;
import com.sas.swing.visuals.EditorFactory;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.FullWidthTable;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.itemlistmanager.AbstractItemListManagerPanel;
import com.sas.swing.visuals.itemlistmanager.TableItemListManagerPanel;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.table.DeleteRowInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

@SASScope
public class ValueListEditor
extends TableItemListManagerPanel
implements TableModelListener,
ListSelectionListener,
EditorInterface,
SupportsGenericErrorHandlerInterface,
PropertyChangeListener {
    private static final long serialVersionUID = -3346257005083463303L;
    public static final Object BUTTON_EDIT = new Object();
    public static final Object BUTTON_REPLACE = new Object();
    private static final String RB_KEY = "ValueListEditor.";
    public static final int BUTTON_LOCATION_TOP_VERTICAL = 3;
    private EditorInterface editorComp;
    private AbstractButton editButton;
    private AbstractButton replaceButton;
    private EditorListener editorCompListener;
    private ArrayList buttonsTopRight;
    private JPanel buttonsTopRightPanel;
    private JPanel editorPanel;
    private AbstractAction addAction;
    private AbstractAction editAction;
    private AbstractAction replaceAction;
    private AbstractAction cancelAction;
    private boolean editingRow;
    private boolean isEditing;
    private boolean valueModified;
    private boolean containsSpecialValue;
    private boolean editorValueModified;
    private boolean allowDuplicates;
    private Color defaultSelectionColor;
    private Color editingSelectionColor;
    private boolean reorderingAllowed;
    private int maxEntries;
    private boolean ignoreTableEvent;
    private boolean ignoreEditEvent;
    private GenericErrorHandlerInterface errorHandler;
    private EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;

    public ValueListEditor(EditorInterface editorComp) {
        super(new DefaultTableModel(0, 1), new FullWidthTable());
        this.editorComp = editorComp;
        this.setOpaque(false);
        this.allowDuplicates = true;
        this.isEditing = false;
        this.valueModified = false;
        this.reorderingAllowed = true;
        this.maxEntries = -1;
        this.ignoreEditEvent = false;
        this.errorHandler = new JOptionPaneErrorHandler(this);
        if (editorComp != null) {
            JTextComponent textComp;
            this.editorPanel = new JPanel();
            this.editorPanel.setOpaque(false);
            AutoSizingGridLayout panelLayout = new AutoSizingGridLayout(1, 0, 5, 5, true, false, true);
            panelLayout.setRemainderColumn(1);
            panelLayout.setIgnoreSizeOfNonVisibleComponents(true);
            this.editorPanel.setLayout(panelLayout);
            JComponent editComp = (JComponent)this.editorComp.getEditorComponent();
            editComp.setPreferredSize(new Dimension(120, editComp.getPreferredSize().height));
            this.editorPanel.add(editComp);
            this.editorPanel.add(this.replaceButton);
            this.mainPanel.add((Component)this.editorPanel, 0);
            if (editorComp instanceof TextEditor && (textComp = ((TextEditor)editorComp).getTextComponent()) instanceof JTextField) {
                ((JTextField)textComp).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!ValueListEditor.this.ignoreEditEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ValueListEditor.this.isEditingRow()) {
                                        ValueListEditor.this.commitEdit();
                                    } else {
                                        ValueListEditor.this.addRow();
                                    }
                                }
                            });
                        }
                    }
                });
            }
            this.editorCompListener = new EditorListener(){

                @Override
                public void editingStarted(ChangeEvent e) {
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    if (ValueListEditor.this.editorComp.getValue() == null) {
                        ValueListEditor.this.editorValueModified = false;
                        ValueListEditor.this.addButton.setEnabled(false);
                    }
                }

                @Override
                public void valueChanged(ChangeEvent e) {
                    ValueListEditor.this.editorValueModified = true;
                    boolean enableAdding = ValueListEditor.this.enableAdding();
                    ValueListEditor.this.addButton.setEnabled(enableAdding);
                }

                @Override
                public void valueModified(ChangeEvent e) {
                    ValueListEditor.this.editorValueModified = true;
                    boolean enableAdding = ValueListEditor.this.enableAdding();
                    ValueListEditor.this.addButton.setEnabled(enableAdding);
                }
            };
            editorComp.addEditorListener(this.editorCompListener);
            this.mainPanel.add((Component)this.buttonsTopRightPanel, 1);
        } else {
            ((AutoSizingGridLayout)this.mainPanel.getLayout()).setRemainderRow(1);
        }
        this.defaultSelectionColor = this.getTable().getSelectionBackground();
        this.editingSelectionColor = this.defaultSelectionColor.darker();
        FocusManager.getCurrentManager().addPropertyChangeListener("focusOwner", this);
        this.setSensitivities();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Window currentWindow;
        Component comp;
        if ("focusOwner".equalsIgnoreCase(evt.getPropertyName()) && (comp = FocusManager.getCurrentManager().getFocusOwner()) != null && (currentWindow = SwingUtilities.windowForComponent(this)) != null) {
            if (SwingUtilities.isDescendingFrom(comp, this)) {
                if (!this.isEditing) {
                    this.isEditing = true;
                    this.fireEditingStarted();
                }
            } else if (this.isEditing && currentWindow == SwingUtilities.getWindowAncestor(comp)) {
                this.isEditing = false;
                this.valueModified = false;
                this.fireEditingStopped();
            }
        }
    }

    public void removeListeners() {
        FocusManager.getCurrentManager().removePropertyChangeListener("focusOwner", this);
        if (this.editorComp != null) {
            EditorFactory.defaultInstance.cleanupEditor(this.editorComp);
            if (this.editorCompListener != null) {
                this.editorComp.removeEditorListener(this.editorCompListener);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.buttonsTopRight = new ArrayList();
    }

    @Override
    public void setModel(TableModel tm) {
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        super.setModel(tm);
        this.containsSpecialValue = false;
        if (this.model != null) {
            if (this.model.getColumnCount() > 0) {
                int rc = this.model.getRowCount();
                for (int i = 0; i < rc; ++i) {
                    Object v = this.model.getValueAt(i, 0);
                    if (!this.isSpecialValue(v)) continue;
                    this.containsSpecialValue = true;
                    break;
                }
            }
            this.model.addTableModelListener(this);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tableScrollPane.setEnabled(enabled);
        this.tableView.setEnabled(enabled);
        if (this.editorComp != null) {
            this.editorComp.getEditorComponent().setEnabled(enabled);
        }
        if (this.editorPanel != null) {
            this.editorPanel.setEnabled(enabled);
        }
        this.buttonsBottomPanel.setEnabled(enabled);
        this.buttonsRightPanel.setEnabled(enabled);
        this.buttonsTopRightPanel.setEnabled(enabled);
        if (enabled) {
            this.setSensitivities();
        } else {
            this.setEnabledFor(this.buttonsBottom, enabled);
            this.setEnabledFor(this.buttonsRight, enabled);
            this.setEnabledFor(this.buttonsTopRight, enabled);
        }
    }

    private void setEnabledFor(List list, boolean enabled) {
        if (list != null) {
            for (Component comp : list) {
                comp.setEnabled(enabled);
            }
        }
    }

    @Override
    public Object getPredefinedButton(Object button, int location) {
        Object object = super.getPredefinedButton(button, location);
        if (object == null || object == button) {
            if (button == BUTTON_EDIT) {
                object = this.editButton;
            } else if (button == BUTTON_REPLACE) {
                object = this.replaceButton;
            }
        }
        if (object instanceof JPanel) {
            ((JPanel)object).setOpaque(false);
        }
        return object;
    }

    public TableView getTable() {
        return this.tableView;
    }

    @Override
    protected void addComponents() {
        super.addComponents();
        this.setLayout(new AutoSizingGridLayout(1, 1, 5, 5, true, true, true));
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(0, 2, 5, 5, true, true, true);
        mainLayout.setRemainderColumn(1);
        mainLayout.setRemainderRow(2);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.mainPanel.setLayout(mainLayout);
        this.mainPanel.setOpaque(false);
        this.buttonsBottomPanel.setOpaque(false);
        this.buttonsRightPanel.setOpaque(false);
        this.buttonsTopRightPanel = new JPanel();
        this.buttonsTopRightPanel.setOpaque(false);
        this.buttonsTopRightPanel.setName("ButtonsTopRight");
        this.buttonsTopRightPanel.setLayout(new AutoSizingGridLayout(0, 1, 0, 0, true, false, true));
        this.buttonsRightPanel.setLayout(new AutoSizingGridLayout(0, 1, 0, 5, true, false, true));
        this.editAction = new EditAction();
        this.addAction = new AddAction();
        this.replaceAction = new ReplaceAction();
        this.cancelAction = new CancelAction();
        this.editButton = new JButton();
        this.editButton.setAction(this.editAction);
        this.editButton.setText(null);
        this.editButton.setMargin(LayoutConstants.EMPTY_INSETS);
        this.replaceButton = new JButton();
        this.replaceButton.setAction(this.replaceAction);
        this.replaceButton.setText(null);
        this.replaceButton.setMargin(LayoutConstants.EMPTY_INSETS);
        this.replaceButton.setVisible(false);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.tableView.setRowAutoResizeMode(6);
        this.tableView.getEditController().setEditEnabled(false);
        this.tableView.getRowModel().getSelectionModel().addListSelectionListener(this);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setReplaceNewline(false);
        SpecialObjectToStringTransform transform = new SpecialObjectToStringTransform();
        renderer.setTransform((TransformInterface)transform);
        this.setCellRenderer(-1, -1, renderer);
        this.tableView.setVisibleRowCount(5);
        this.tableView.setColumnHeaderVisible(false);
        this.tableView.setShowGrid(false);
        this.tableView.setOpaque(false);
        this.tableScrollPane.getViewport().setOpaque(true);
        this.tableScrollPane.getViewport().setBackground(this.tableView.getBackground());
        this.addButton.setAction(this.addAction);
        this.addButton.setText(null);
        this.addButton.setMargin(LayoutConstants.EMPTY_INSETS);
        this.addButton.setEnabled(false);
        this.deleteButton.setText(null);
        this.deleteButton.setIcon(Resources.getImageIcon((String)"DeleteRed.gif", (int)16));
        this.deleteButton.setMargin(LayoutConstants.EMPTY_INSETS);
        this.tableView.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "deleteRow");
        this.tableView.getActionMap().put("deleteRow", this.deleteButton.getAction());
        this.moveUpButton.setPreferredSize(null);
        this.moveUpButton.setIcon(Resources.getImageIcon((String)"ArrowUp.gif", (int)16));
        this.moveUpButton.setText(null);
        this.moveUpButton.setMargin(LayoutConstants.EMPTY_INSETS);
        this.moveDownButton.setPreferredSize(null);
        this.moveDownButton.setIcon(Resources.getImageIcon((String)"ArrowDown.gif", (int)16));
        this.moveDownButton.setText(null);
        this.moveDownButton.setMargin(LayoutConstants.EMPTY_INSETS);
    }

    @Override
    protected void addDefaultButtons() {
        this.addButton(ItemListManagerViewerInterface.BUTTON_ADD, 3, 0);
        this.addButton(BUTTON_EDIT, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_DELETE, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_MOVE_UP, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN, 0, -1);
    }

    @Override
    public Object addButton(Object button, int location, int position) {
        if (location == 3) {
            Object actualButton = this.getPredefinedButton(button, location);
            if (actualButton == button && !(button instanceof Component)) {
                throw new IllegalArgumentException("Button object must be an instance of java.awt.Component.");
            }
            if (button == ItemListManagerViewerInterface.BUTTON_EXPANDING_SPACER && this.findExpandingSpacerIndex(this.buttonsTopRight) != -1) {
                throw new IllegalArgumentException("Only one expanding spacer may be specified for a given location.");
            }
            if (position == -1) {
                this.buttonsTopRight.add(actualButton);
            } else {
                this.buttonsTopRight.add(position, actualButton);
            }
            int expandingSpacerIndex = this.findExpandingSpacerIndex(this.buttonsTopRight);
            if (expandingSpacerIndex != -1) {
                AutoSizingGridLayout buttonsTopRightPanelLayout = (AutoSizingGridLayout)this.buttonsTopRightPanel.getLayout();
                buttonsTopRightPanelLayout.setUseRowRemainder(true);
                buttonsTopRightPanelLayout.setRemainderRow(expandingSpacerIndex + 1);
            }
            this.rebuildButtonsTopRight();
            return actualButton;
        }
        return super.addButton(button, location, position);
    }

    @Override
    public void removeButton(Object button) {
        super.removeButton(button);
        this.removeButton(button, 3);
    }

    @Override
    public void removeButton(Object button, int location) {
        if (location == 3) {
            Object realButton = this.getPredefinedButton(button, location);
            if (this.buttonsTopRight.remove(realButton)) {
                AutoSizingGridLayout buttonsTopRightPanelLayout = (AutoSizingGridLayout)this.buttonsTopRightPanel.getLayout();
                int expandingSpacerIndex = this.findExpandingSpacerIndex(this.buttonsTopRight);
                if (expandingSpacerIndex != -1) {
                    buttonsTopRightPanelLayout.setRemainderRow(expandingSpacerIndex + 1);
                } else {
                    buttonsTopRightPanelLayout.setUseRowRemainder(false);
                }
                this.rebuildButtonsTopRight();
            }
        } else {
            super.removeButton(button, location);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeButton(Object button, int location, int position) {
        if (location == 3) {
            if (position >= this.buttonsTopRight.size()) {
                throw new IllegalArgumentException("No button exists at specified position in this location.");
            }
            if (!this.buttonsTopRight.get(position).equals(button)) throw new IllegalArgumentException("Button at specified position doesn't exist at this location.");
            this.buttonsTopRight.remove(position);
            this.rebuildButtonsTopRight();
            return;
        } else {
            super.removeButton(button, location, position);
        }
    }

    @Override
    public void removeAllButtons(int location) {
        if (location == 3) {
            this.buttonsTopRight.clear();
            this.rebuildButtonsTopRight();
        } else {
            super.removeAllButtons(location);
        }
    }

    protected void rebuildButtonsTopRight() {
        this.buttonsTopRightPanel.removeAll();
        for (int i = 0; i < this.buttonsTopRight.size(); ++i) {
            Object button = this.getPredefinedButton(this.buttonsTopRight.get(i), 3);
            this.buttonsTopRightPanel.add((Component)button);
        }
        this.buttonsTopRightPanel.doLayout();
        this.repaint();
    }

    @Override
    protected boolean addRow() {
        Object newValue = this.editorComp.getValue();
        int row = this.addItem(newValue);
        return row >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addItem(Object newItem) {
        Object specialValue;
        boolean addingSpecial = false;
        boolean enableAdding = this.enableAdding();
        if (!enableAdding) {
            return -1;
        }
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
        if (this.isEditingRow()) {
            this.cancelEdit();
        }
        int rowIndex = this.tableView.getRowCount();
        if (this.isSpecialValue(newItem)) {
            if (rowIndex > 0) {
                int option = JOptionPane.showConfirmDialog(this, Message.format((String)RB.getStringResource(RB_KEY, "addSpecialValue.fmt.txt"), (Object)SpecialValues.toDisplayString((SpecialValues)this.getSpecialValue(newItem), (Locale)this.getLocale())), RB.getStringResource(RB_KEY, "addValueTitle.txt", this.getLocale()), 0, 3);
                if (option == 0) {
                    boolean alreadyIgnore = this.ignoreTableEvent;
                    try {
                        this.ignoreTableEvent = true;
                        this.deleteAllRows();
                    }
                    finally {
                        if (!alreadyIgnore) {
                            this.ignoreTableEvent = false;
                        }
                    }
                    return this.addItem(newItem);
                }
                return -1;
            }
            addingSpecial = true;
        } else if (this.containsSpecialValue && rowIndex > 0 && this.isSpecialValue(specialValue = this.tableView.getValueAt(0, 0))) {
            int option = JOptionPane.showConfirmDialog(this, Message.format((String)RB.getStringResource(RB_KEY, "removeSpecialValue.fmt.txt"), (Object)this.formatItem(newItem), (Object)SpecialValues.toDisplayString((SpecialValues)this.getSpecialValue(specialValue), (Locale)this.getLocale())), RB.getStringResource(RB_KEY, "addValueTitle.txt", this.getLocale()), 0, 3);
            if (option == 0) {
                boolean alreadyIgnore = this.ignoreTableEvent;
                try {
                    this.ignoreTableEvent = true;
                    this.deleteAllRows();
                }
                finally {
                    if (!alreadyIgnore) {
                        this.ignoreTableEvent = false;
                    }
                }
                return this.addItem(newItem);
            }
            return -1;
        }
        if (this.maxEntries > -1 && rowIndex >= this.maxEntries) {
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError(this, new Message(Strings.padSingleQuotesForMessage((String)RB.getStringResource(RB_KEY, "noMoreAllowed.ex.txt", this.getLocale()))), null);
            } else {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "noMoreAllowed.ex.txt", this.getLocale()));
            }
        }
        if (!this.allowDuplicates) {
            for (int i = 0; i < rowIndex; ++i) {
                if (!com.sas.util.Util.equal((Object)this.model.getValueAt(i, 0), (Object)newItem)) continue;
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError(this, new Message(RB.getStringResource(RB_KEY, "valueAlreadyExists.fmt.txt", this.getLocale()), (Object)this.formatItem(newItem)), null);
                }
                return -1;
            }
        }
        if (newItem != null) {
            if (this.model instanceof InsertRowInterface) {
                InsertRowInterface insertModel = (InsertRowInterface)((Object)this.model);
                if (insertModel.canInsertRow(rowIndex)) {
                    rowIndex = insertModel.insertRow(new Object[]{newItem}, rowIndex);
                    if (this.editorComp != null && this.editorComp.getEditorComponent().isShowing()) {
                        this.editorComp.setValue(null);
                        this.editorValueModified = false;
                        this.editorComp.getEditorComponent().requestFocus();
                    }
                    if (addingSpecial) {
                        this.containsSpecialValue = true;
                    }
                    return rowIndex;
                }
            } else {
                com.sas.table.InsertRowInterface insertModel;
                if (this.model instanceof DefaultTableModel) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)this.model;
                    defaultTableModel.insertRow(rowIndex, new Object[]{newItem});
                    if (this.editorComp != null && this.editorComp.getEditorComponent().isShowing()) {
                        this.editorComp.setValue(null);
                        this.editorValueModified = false;
                        this.editorComp.getEditorComponent().requestFocus();
                    }
                    if (addingSpecial) {
                        this.containsSpecialValue = true;
                    }
                    return rowIndex;
                }
                if (this.model instanceof com.sas.table.InsertRowInterface && (insertModel = (com.sas.table.InsertRowInterface)this.model).isRowInsertionAllowed()) {
                    boolean alreadyIgnoring = this.ignoreTableEvent;
                    try {
                        this.ignoreTableEvent = true;
                        if (insertModel.isTableExtendOnly()) {
                            insertModel.insertUncommittedRow(-1);
                        } else {
                            insertModel.insertUncommittedRow(rowIndex);
                        }
                    }
                    finally {
                        if (!alreadyIgnoring) {
                            this.ignoreTableEvent = false;
                        }
                    }
                    rowIndex = insertModel.getUncommittedRowNumber();
                    this.model.setValueAt(newItem, insertModel.getUncommittedRowNumber(), 0);
                    insertModel.commitUncommittedRow();
                    if (this.editorComp != null && this.editorComp.getEditorComponent().isShowing()) {
                        this.editorComp.setValue(null);
                        this.editorValueModified = false;
                        this.editorComp.getEditorComponent().requestFocus();
                    }
                    if (addingSpecial) {
                        this.containsSpecialValue = true;
                    }
                    return rowIndex;
                }
            }
        }
        return -1;
    }

    private boolean isSpecialValue(Object value) {
        return value instanceof SpecialValues || value instanceof ValueItem && ((ValueItem)value).getValue() instanceof SpecialValues;
    }

    private SpecialValues getSpecialValue(Object value) {
        if (value instanceof SpecialValues) {
            return (SpecialValues)value;
        }
        if (value instanceof ValueItem && ((ValueItem)value).getValue() instanceof SpecialValues) {
            return (SpecialValues)((ValueItem)value).getValue();
        }
        return null;
    }

    private String formatItem(Object item) {
        if (item instanceof MissingValues) {
            return MissingValues.toDisplayString((MissingValues)((MissingValues)item), (Locale)this.getLocale());
        }
        if (item instanceof ValueItem && ((ValueItem)item).getValue() instanceof MissingValues) {
            return MissingValues.toDisplayString((MissingValues)((MissingValues)((ValueItem)item).getValue()), (Locale)this.getLocale());
        }
        return (String)ObjectToStringTransform.defaultInstance.transform(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addItems(Collection newItems) {
        boolean successfulAdd = false;
        boolean fireEvent = false;
        try {
            this.ignoreTableEvent = true;
            if (newItems != null && !newItems.isEmpty()) {
                successfulAdd = true;
                int row = -1;
                Iterator iter = newItems.iterator();
                while (iter.hasNext()) {
                    int r = this.addItem(iter.next());
                    if (r < 0) {
                        successfulAdd = false;
                        continue;
                    }
                    if (row == -1) {
                        row = r;
                    }
                    fireEvent = true;
                }
                if (row != -1) {
                    this.tableView.changeSelection(row, 0, false, false);
                    this.tableView.requestFocus();
                }
            }
        }
        finally {
            this.ignoreTableEvent = false;
            if (fireEvent) {
                this.getTable().getColumnHeader().sizeColumnsToFit();
                this.fireValueChanged();
            }
        }
        return successfulAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean deleteSelectedRows() {
        if (this.tableView.getSelectedRowCount() == 0) {
            return false;
        }
        boolean tableFocus = this.tableView.hasFocus();
        if (this.tableView.getSelectedRowCount() == this.tableView.getRowCount()) {
            return this.deleteAllRows();
        }
        boolean fireEvent = false;
        try {
            this.ignoreTableEvent = true;
            fireEvent = super.deleteSelectedRows();
            if (tableFocus) {
                this.tableView.requestFocus();
            }
            boolean bl = fireEvent;
            return bl;
        }
        finally {
            this.ignoreTableEvent = false;
            if (fireEvent) {
                this.getTable().getColumnHeader().sizeColumnsToFit();
                this.fireValueChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAllRows() {
        if (this.model == null || this.model.getRowCount() <= 0) {
            return false;
        }
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
        boolean focusCycleRoot = this.isFocusCycleRoot();
        try {
            this.setFocusCycleRoot(true);
            if (this.model instanceof DefaultTableModel) {
                ((DefaultTableModel)this.model).setRowCount(0);
                if (this.editorComp != null && this.editorComp.getEditorComponent().isShowing()) {
                    this.editorComp.getEditorComponent().requestFocus();
                }
                boolean bl = true;
                return bl;
            }
            if (this.model instanceof CollectionToTableModelAdapter) {
                boolean ret = ((CollectionToTableModelAdapter)this.model).deleteAllRows();
                if (this.editorComp != null && this.editorComp.getEditorComponent().isShowing()) {
                    this.editorComp.getEditorComponent().requestFocus();
                }
                boolean bl = ret;
                return bl;
            }
            int rc = this.tableView.getRowCount();
            boolean fireEvent = false;
            boolean alreadingIgnore = this.ignoreTableEvent;
            try {
                this.ignoreTableEvent = true;
                for (int i = rc - 1; i >= 0; --i) {
                    if (!this.deleteRow(i)) {
                        boolean bl = false;
                        return bl;
                    }
                    fireEvent = true;
                }
                if (this.editorComp != null && this.editorComp.getEditorComponent().isShowing()) {
                    this.editorComp.getEditorComponent().requestFocus();
                }
            }
            finally {
                if (!alreadingIgnore) {
                    this.ignoreTableEvent = false;
                }
                if (fireEvent) {
                    this.getTable().getColumnHeader().sizeColumnsToFit();
                    if (!this.ignoreTableEvent) {
                        this.fireValueChanged();
                    }
                }
            }
        }
        finally {
            this.setFocusCycleRoot(focusCycleRoot);
        }
        return true;
    }

    @Override
    public boolean deleteRow(int rowIndex) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
        if (this.model instanceof DeleteRowInterface) {
            DeleteRowInterface deleteModel = (DeleteRowInterface)this.model;
            if (deleteModel.isRowDeletionAllowed()) {
                deleteModel.deleteRow(rowIndex);
                return true;
            }
            return false;
        }
        return super.deleteRow(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRows(int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        boolean rv = false;
        Arrays.sort(rows);
        try {
            this.ignoreTableEvent = true;
            int[] selectedRows = this.tableView.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i] < 0 || !this.deleteRow(rows[i])) continue;
                rv = true;
            }
            this.tableView.clearSelection();
            int firstSelectedRow = selectedRows[0];
            if (firstSelectedRow >= this.tableView.getRowCount()) {
                firstSelectedRow = this.tableView.getRowCount() - 1;
            }
            if (firstSelectedRow >= 0) {
                this.tableView.setRowSelectionInterval(firstSelectedRow, firstSelectedRow);
            }
        }
        finally {
            this.ignoreTableEvent = false;
            if (rv) {
                this.fireValueChanged();
            }
        }
        return rv;
    }

    protected void editRow(int row) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
        this.editorPanel.setEnabled(true);
        this.editorComp.getEditorComponent().setEnabled(true);
        this.editingRow = true;
        try {
            this.ignoreEditEvent = true;
            this.editorComp.setValue(this.tableView.getValueAt(row, 0));
        }
        finally {
            this.ignoreEditEvent = false;
        }
        this.editorComp.getEditorComponent().requestFocus();
        this.addButton.setAction(this.cancelAction);
        this.addButton.setText(null);
        this.replaceButton.setVisible(true);
        this.tableView.setSelectionBackground(this.editingSelectionColor);
    }

    protected void cancelEdit() {
        this.editorComp.setValue(null);
        this.editorValueModified = false;
        this.addButton.setAction(this.addAction);
        this.addButton.setText(null);
        this.replaceButton.setVisible(false);
        this.tableView.setSelectionBackground(this.defaultSelectionColor);
        this.editingRow = false;
        this.setSensitivities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitEdit() {
        Object specialValue;
        int row = this.tableView.getSelectedRow();
        int rowCount = this.tableView.getRowCount();
        Object newItem = this.editorComp.getValue();
        if (this.isSpecialValue(newItem)) {
            if (rowCount > 1) {
                int option = JOptionPane.showConfirmDialog(this, Message.format((String)RB.getStringResource(RB_KEY, "addSpecialValue.fmt.txt"), (Object)SpecialValues.toDisplayString((SpecialValues)this.getSpecialValue(newItem), (Locale)this.getLocale())), RB.getStringResource(RB_KEY, "addValueTitle.txt", this.getLocale()), 0, 3);
                if (option == 0) {
                    boolean alreadyIgnore = this.ignoreTableEvent;
                    try {
                        this.ignoreTableEvent = true;
                        this.deleteAllRows();
                    }
                    finally {
                        if (!alreadyIgnore) {
                            this.ignoreTableEvent = false;
                        }
                    }
                    this.addItem(newItem);
                    this.cancelEdit();
                    this.editorValueModified = false;
                    this.setSensitivities();
                }
                return;
            }
            this.containsSpecialValue = true;
        } else if (this.containsSpecialValue && rowCount > 1 && this.isSpecialValue(specialValue = this.tableView.getValueAt(0, 0))) {
            int option = JOptionPane.showConfirmDialog(this, Message.format((String)RB.getStringResource(RB_KEY, "removeSpecialValue.fmt.txt"), (Object)this.formatItem(newItem), (Object)SpecialValues.toDisplayString((SpecialValues)this.getSpecialValue(specialValue), (Locale)this.getLocale())), RB.getStringResource(RB_KEY, "addValueTitle.txt", this.getLocale()), 0, 3);
            if (option == 0) {
                boolean alreadyIgnore = this.ignoreTableEvent;
                try {
                    this.ignoreTableEvent = true;
                    this.deleteAllRows();
                }
                finally {
                    if (!alreadyIgnore) {
                        this.ignoreTableEvent = false;
                    }
                }
                this.addItem(newItem);
                this.cancelEdit();
                this.editorValueModified = false;
                this.setSensitivities();
            }
            return;
        }
        this.tableView.setValueAt(newItem, row, 0);
        this.cancelEdit();
        this.editorValueModified = false;
        this.setSensitivities();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.ignoreTableEvent) {
            return;
        }
        if (e.getType() == 1) {
            if (this.isEditingRow()) {
                this.cancelEdit();
            }
            final int row = e.getFirstRow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableView table = ValueListEditor.this.getTable();
                    if (table.getRowCount() > row) {
                        table.setRowSelectionInterval(row, row);
                        table.scrollRectToVisible(table.getCellRect(row, 0, true));
                    }
                }
            });
        }
        this.getTable().getColumnHeader().sizeColumnsToFit();
        this.fireValueChanged();
    }

    public boolean isEditingRow() {
        return this.editingRow;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.isEditingRow()) {
            this.cancelEdit();
        }
    }

    @Override
    protected int moveDownRows(int rowStart, int rowEnd) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
        if (this.isEditingRow()) {
            this.cancelEdit();
        }
        return super.moveDownRows(rowStart, rowEnd);
    }

    @Override
    protected boolean moveDownSelectedRows() {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
        if (this.isEditingRow()) {
            this.cancelEdit();
        }
        return super.moveDownSelectedRows();
    }

    @Override
    protected int moveUpRows(int rowStart, int rowEnd) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
        if (this.isEditingRow()) {
            this.cancelEdit();
        }
        return super.moveUpRows(rowStart, rowEnd);
    }

    @Override
    protected boolean moveUpSelectedRows() {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
        if (this.isEditingRow()) {
            this.cancelEdit();
        }
        return super.moveUpSelectedRows();
    }

    public boolean isReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setReorderingAllowed(boolean reorderingAllowed) {
        if (this.reorderingAllowed != reorderingAllowed) {
            boolean oldValue = this.reorderingAllowed;
            this.reorderingAllowed = reorderingAllowed;
            if (this.reorderingAllowed) {
                this.addButton(this.moveUpButton, 0, -1);
                this.addButton(this.moveDownButton, 0, -1);
            } else {
                this.removeButton(this.moveUpButton);
                this.removeButton(this.moveDownButton);
            }
            this.firePropertyChange("reorderingAllowed", oldValue, this.reorderingAllowed);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
        this.valueModified = false;
    }

    @Override
    public void setValue(Object anObject) {
        if (anObject == null) {
            this.deleteAllRows();
        } else if (anObject instanceof TableModel) {
            this.setModel((TableModel)anObject);
        } else if (anObject instanceof Collection) {
            boolean fireEvent = false;
            try {
                this.ignoreTableEvent = true;
                this.deleteAllRows();
                fireEvent = this.addItems((Collection)anObject);
            }
            finally {
                this.ignoreTableEvent = false;
                if (fireEvent) {
                    this.fireValueChanged();
                }
            }
        }
    }

    @Override
    public Object getValue() {
        TableModel model = this.getModel();
        int size = model.getRowCount();
        ArrayList<Object> values = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            values.add(model.getValueAt(i, 0));
        }
        return values;
    }

    @Override
    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    protected void setSensitivities() {
        super.setSensitivities();
        boolean enableEdit = !this.tableView.getRowModel().getSelectionModel().isSelectionEmpty();
        this.editButton.setEnabled(enableEdit);
        boolean enableAdding = this.enableAdding();
        this.updateAddButtonState();
        if (this.editorPanel != null) {
            this.editorPanel.setEnabled(enableAdding);
            this.editorComp.getEditorComponent().setEnabled(enableAdding);
        }
    }

    protected void updateAddButtonState() {
        boolean enableAdding = this.enableAdding();
        this.addButton.setEnabled(enableAdding && this.editorValueModified);
    }

    private boolean enableAdding() {
        return this.getMaxItems() < 0 || this.tableView.getRowCount() < this.getMaxItems();
    }

    public JPanel getEditorPanel() {
        return this.editorPanel;
    }

    public EditorInterface getEditor() {
        return this.editorComp;
    }

    public int getMaxItems() {
        return this.maxEntries;
    }

    public void setMaxItems(int maxItems) {
        if (this.maxEntries != maxItems) {
            int oldValue = this.maxEntries;
            this.maxEntries = maxItems;
            this.firePropertyChange("maxItems", oldValue, this.maxEntries);
        }
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        if (this.allowDuplicates != allowDuplicates) {
            boolean oldValue = this.allowDuplicates;
            this.allowDuplicates = allowDuplicates;
            this.firePropertyChange("allowDuplicates", oldValue, this.allowDuplicates);
        }
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("genericErrorHandler", oldValue, this.errorHandler);
        }
    }

    @SASScope
    protected class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 6920597593879578320L;

        public EditAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(ValueListEditor.RB_KEY, "edit.txt")));
            this.putValue("ShortDescription", RB.getStringResource(ValueListEditor.RB_KEY, "editToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(ValueListEditor.RB_KEY, "edit.txt"))));
            this.putValue("SmallIcon", Resources.getImageIcon((String)"Pencil.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ValueListEditor.this.tableView.getSelectedRow();
            ValueListEditor.this.editRow(row);
        }
    }

    @SASScope
    protected class AddAction
    extends AbstractItemListManagerPanel.AddAction {
        private static final long serialVersionUID = 6613829718512845479L;

        public AddAction() {
            super(ValueListEditor.this);
            this.putValue("SmallIcon", Resources.getImageIcon((String)"AddBlack.gif"));
        }
    }

    @SASScope
    protected class ReplaceAction
    extends AbstractAction {
        private static final long serialVersionUID = -6442298445500936895L;

        public ReplaceAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(ValueListEditor.RB_KEY, "replace.txt")));
            this.putValue("ShortDescription", RB.getStringResource(ValueListEditor.RB_KEY, "replaceToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(ValueListEditor.RB_KEY, "replace.txt"))));
            this.putValue("SmallIcon", Resources.getImageIcon((String)"ColorCheck1.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ValueListEditor.this.commitEdit();
        }
    }

    @SASScope
    protected class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 509214592342109920L;

        public CancelAction() {
            super(Util.getLabelWithoutMnemonic(RB.getStringResource(ValueListEditor.RB_KEY, "cancel.txt")));
            this.putValue("ShortDescription", RB.getStringResource(ValueListEditor.RB_KEY, "cancelToolTip.txt"));
            this.putValue("MnemonicKey", new Integer(Util.getDisplayedMnemonic(RB.getStringResource(ValueListEditor.RB_KEY, "cancel.txt"))));
            this.putValue("SmallIcon", Resources.getImageIcon((String)"Invalid.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ValueListEditor.this.cancelEdit();
        }
    }

    @SASScope
    private class SpecialObjectToStringTransform
    extends ObjectToStringTransform {
        private SpecialObjectToStringTransform() {
        }

        public Object transform(Object input) {
            System.out.println(" ValueListEditor.java-transform: input = " + input);
            if (ValueListEditor.this.isSpecialValue(input)) {
                return SpecialValues.toDisplayString((SpecialValues)ValueListEditor.this.getSpecialValue(input), (Locale)ValueListEditor.this.getLocale());
            }
            return ValueListEditor.this.formatItem(input);
        }
    }
}

