/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.LimitedPasswordField;
import com.sas.swing.visuals.LimitedTextArea;
import com.sas.swing.visuals.LimitedTextField;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.WideComboBox;
import com.sas.text.Message;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.text.JTextComponent;

@SASScope
public class TextEditor
extends JComponent
implements EditorInterface,
ActionListener,
DocumentListener,
MutableSupportedSpecialValuesInterface,
Accessible,
SupportsGenericErrorHandlerInterface {
    private static final long serialVersionUID = -4266846382290931710L;
    protected JTextComponent textComponent;
    protected JComboBox comboBox;
    private boolean multiLine;
    private int maximumLength;
    private boolean masked;
    private int maximumLines;
    private int displayedLines;
    protected FocusAdapter focusListener;
    protected boolean isEditing = false;
    protected boolean valueModified = false;
    protected boolean edited;
    private Object lastError;
    private Border oldBorder;
    private boolean ignoreRemoveEvent;
    private boolean handlingError;
    private SupportedSpecialValues specialValues;
    private List availableValues;
    private GenericErrorHandlerInterface errorHandler;
    private EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected static Insets editorBorderInsets = new Insets(2, 2, 2, 0);
    private static final Insets SAFE_EDITOR_BORDER_INSETS = new Insets(2, 2, 2, 0);

    public TextEditor() {
        this(false);
    }

    public TextEditor(boolean multiLine) {
        this(multiLine, false);
    }

    public TextEditor(boolean multiLine, boolean masked) {
        this(multiLine, masked, 0, 0);
    }

    public TextEditor(int maximumLength) {
        this(false, false, maximumLength, 0, 0);
    }

    public TextEditor(boolean multiLine, boolean masked, int maximumLines, int displayedLines) {
        this(multiLine, masked, -1, maximumLines, displayedLines);
    }

    public TextEditor(boolean multiLine, boolean masked, int maximumLength, int maximumLines, int displayedLines) {
        this.errorHandler = new JOptionPaneErrorHandler(this);
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                if (event.isTemporary()) {
                    return;
                }
                if (!TextEditor.this.valueModified) {
                    TextEditor.this.ignoreRemoveEvent = true;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextEditor.this.isEditing = false;
                        if (TextEditor.this.valueModified) {
                            TextEditor.this.ignoreRemoveEvent = false;
                            TextEditor.this.fireValueChanged();
                            TextEditor.this.valueModified = false;
                        }
                        TextEditor.this.fireEditingStopped();
                    }
                });
            }

            @Override
            public void focusGained(FocusEvent event) {
                TextEditor.this.isEditing = true;
                TextEditor.this.fireEditingStarted();
                try {
                    TextEditor.this.ignoreRemoveEvent = true;
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextEditor.this.ignoreRemoveEvent = false;
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        this.multiLine = multiLine;
        this.masked = masked;
        this.maximumLength = maximumLength;
        this.maximumLines = maximumLines;
        this.displayedLines = displayedLines;
        this.createUI();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.textComponent != null) {
            this.textComponent.setEnabled(enabled);
        }
        if (this.comboBox != null) {
            this.comboBox.setEnabled(enabled);
        }
    }

    public int getDisplayedLines() {
        if (this.isMultiLine()) {
            return this.displayedLines;
        }
        return 1;
    }

    public void setDisplayedLines(int displayedLines) {
        if (this.displayedLines != displayedLines) {
            int oldValue = this.displayedLines;
            this.displayedLines = displayedLines;
            this.configureUI();
            this.firePropertyChange("displayedLines", oldValue, this.displayedLines);
        }
    }

    public boolean isMasked() {
        return this.masked;
    }

    public void setMasked(boolean masked) {
        if (this.masked != masked) {
            boolean oldValue = this.masked;
            this.masked = masked;
            this.configureUI();
            this.firePropertyChange("masked", oldValue, this.masked);
        }
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int maximumLength) {
        if (this.maximumLength != maximumLength) {
            int oldValue = this.maximumLength;
            this.maximumLength = maximumLength;
            this.configureUI();
            this.firePropertyChange("maximumLength", oldValue, this.maximumLength);
        }
    }

    public int getMaximumLines() {
        if (this.isMultiLine()) {
            return this.maximumLines;
        }
        return 1;
    }

    public void setMaximumLines(int maximumLines) {
        if (this.maximumLines != maximumLines) {
            int oldValue = this.maximumLines;
            this.maximumLines = maximumLines;
            this.configureUI();
            this.firePropertyChange("maximumLines", oldValue, this.maximumLines);
        }
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        if (this.multiLine != multiLine) {
            boolean oldValue = this.multiLine;
            this.multiLine = multiLine;
            this.configureUI();
            this.firePropertyChange("multiLine", oldValue, this.multiLine);
        }
    }

    private void configureTextArea(LimitedTextArea textArea) {
        if (this.getDisplayedLines() <= 0) {
            textArea.setRows(3);
        } else {
            textArea.setRows(this.getDisplayedLines());
        }
        int maxLength = this.getMaximumLength();
        if (maxLength > 0) {
            textArea.setMaxCharacters(maxLength);
        } else {
            textArea.setMaxCharacters(Integer.MAX_VALUE);
        }
        int maxLines = this.getMaximumLines();
        if (maxLines > 0) {
            textArea.setMaxLines(maxLines);
        } else {
            textArea.setMaxLines(Integer.MAX_VALUE);
        }
        textArea.setFont(UIManager.getFont("TextField.font"));
    }

    private void configureTextField(JTextField textField) {
        int maxLength = this.getMaximumLength();
        if (maxLength > 0) {
            if (textField instanceof LimitedTextField) {
                ((LimitedTextField)textField).setMaxCharacters(maxLength);
            } else if (textField instanceof LimitedPasswordField) {
                ((LimitedPasswordField)textField).setMaxCharacters(maxLength);
            }
        } else if (textField instanceof LimitedTextField) {
            ((LimitedTextField)textField).setMaxCharacters(Integer.MAX_VALUE);
        } else if (textField instanceof LimitedPasswordField) {
            ((LimitedPasswordField)textField).setMaxCharacters(Integer.MAX_VALUE);
        }
    }

    protected void configureUI() {
        this.configureUI(false);
    }

    protected void configureUI(boolean numericEditor) {
        if (this.isMultiLine()) {
            LimitedTextArea textArea = null;
            if (this.textComponent instanceof LimitedTextArea) {
                textArea = (LimitedTextArea)this.textComponent;
                this.configureTextArea(textArea);
            } else {
                if (this.textComponent != null) {
                    this.textComponent.removeFocusListener(this.focusListener);
                    if (this.textComponent instanceof JTextField) {
                        ((JTextField)this.textComponent).removeActionListener(this);
                    }
                    this.textComponent.getDocument().removeDocumentListener(this);
                }
                textArea = (LimitedTextArea)this.createTextComponent();
                this.removeAll();
                JScrollPane scrollPane = new JScrollPane(textArea);
                this.textComponent = textArea;
                this.add((Component)scrollPane, "Center");
                this.textComponent.addFocusListener(this.focusListener);
                this.textComponent.getDocument().addDocumentListener(this);
            }
            if (this.comboBox != null) {
                this.comboBox.removeActionListener(this);
            }
            this.comboBox = null;
        } else if (this.isMasked()) {
            LimitedPasswordField textField = null;
            if (this.textComponent instanceof LimitedPasswordField) {
                textField = (LimitedPasswordField)this.textComponent;
                this.configureTextField(textField);
            } else {
                if (this.textComponent != null) {
                    this.textComponent.removeFocusListener(this.focusListener);
                    this.textComponent.getDocument().removeDocumentListener(this);
                }
                textField = (LimitedPasswordField)this.createTextComponent();
                this.removeAll();
                this.textComponent = textField;
                this.add((Component)textField, "Center");
                textField.addActionListener(this);
                this.textComponent.addFocusListener(this.focusListener);
                this.textComponent.getDocument().addDocumentListener(this);
            }
            if (this.comboBox != null) {
                this.comboBox.removeActionListener(this);
            }
            this.comboBox = null;
        } else {
            JTextField textField = null;
            if (this.textComponent instanceof LimitedTextField) {
                textField = (LimitedTextField)this.textComponent;
                this.configureTextField(textField);
            } else {
                if (this.textComponent != null) {
                    this.textComponent.removeFocusListener(this.focusListener);
                    this.textComponent.getDocument().removeDocumentListener(this);
                }
                textField = (JTextField)this.createTextComponent();
                this.removeAll();
                this.textComponent = textField;
                this.add((Component)textField, "Center");
                textField.addActionListener(this);
                this.textComponent.addFocusListener(this.focusListener);
                this.textComponent.getDocument().addDocumentListener(this);
            }
            if (this.availableValues != null && !this.availableValues.isEmpty() || this.specialValues != null && (this.specialValues.isAllSupported() || this.specialValues.isOtherSupported() || this.specialValues.isNoneSupported() || this.specialValues.isMissingValuesSupported() && !this.specialValues.isMissingValuesHiddenIfSupported())) {
                LookAndFeel lf;
                if (this.comboBox != null) {
                    this.comboBox.removeActionListener(this);
                }
                if (this.comboBox == null) {
                    this.comboBox = new WideComboBox();
                }
                DefaultComboBoxModel<Object> model = null;
                model = this.availableValues != null ? new DefaultComboBoxModel<Object>(this.availableValues.toArray()) : new DefaultComboBoxModel();
                if (this.specialValues != null) {
                    if (this.specialValues.isMissingValuesSupported() && !this.specialValues.isMissingValuesHiddenIfSupported()) {
                        ValueItem item = null;
                        item = numericEditor ? new ValueItem((Object)MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)this.getLocale()), (Object)MissingValues.Dot) : new ValueItem((Object)MissingValues.toDisplayString((MissingValues)MissingValues._BLANK_, (Locale)this.getLocale()), (Object)MissingValues._BLANK_);
                        model.insertElementAt(item, 0);
                    }
                    if (this.specialValues.isOtherSupported()) {
                        model.insertElementAt(new ValueItem((Object)SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.getLocale()), (Object)SpecialValues.OTHER), 0);
                    }
                    if (this.specialValues.isAllSupported()) {
                        model.insertElementAt(new ValueItem((Object)SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale()), (Object)SpecialValues.ALL), 0);
                    }
                }
                this.comboBox.setModel(model);
                this.comboBox.setSelectedIndex(-1);
                this.comboBox.setEditable(true);
                if (this.textComponent.getBorder() != null) {
                    if (!(this.textComponent.getBorder() instanceof EditorBorder)) {
                        this.oldBorder = this.textComponent.getBorder();
                    }
                    this.textComponent.setBorder(null);
                }
                if ((lf = UIManager.getLookAndFeel()) instanceof MetalLookAndFeel) {
                    this.textComponent.setBorder(new EditorBorder());
                }
                ComboBoxEditorAdapter comboBoxEditor = new ComboBoxEditorAdapter(this.textComponent);
                this.comboBox.setEditor(comboBoxEditor);
                textField.removeActionListener(this);
                this.comboBox.addActionListener(this);
                this.removeAll();
                this.add((Component)this.comboBox, "Center");
            } else if (this.comboBox != null) {
                this.removeAll();
                if (this.oldBorder != null) {
                    this.textComponent.setBorder(this.oldBorder);
                }
                this.add((Component)this.textComponent, "Center");
                if (this.comboBox != null) {
                    this.comboBox.removeActionListener(this);
                }
                this.comboBox = null;
            }
        }
    }

    public void removeListeners() {
        if (this.textComponent != null) {
            this.textComponent.removeFocusListener(this.focusListener);
            if (this.textComponent instanceof JTextField) {
                ((JTextField)this.textComponent).removeActionListener(this);
            }
            this.textComponent.getDocument().removeDocumentListener(this);
            this.textComponent.removeFocusListener(this.focusListener);
        }
        if (this.comboBox != null) {
            this.comboBox.removeActionListener(this);
        }
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.configureUI();
    }

    protected JTextComponent createTextComponent() {
        JTextComponent tc = null;
        if (this.isMultiLine()) {
            LimitedTextArea textArea = new LimitedTextArea(3, 20);
            textArea.setLineWrap(false);
            this.configureTextArea(textArea);
            tc = textArea;
        } else if (this.isMasked()) {
            LimitedPasswordField textField = new LimitedPasswordField(10){

                @Override
                public Dimension getPreferredSize() {
                    LookAndFeel lf;
                    Dimension pref = super.getPreferredSize();
                    if (TextEditor.this.comboBox != null && (lf = UIManager.getLookAndFeel()) instanceof MetalLookAndFeel) {
                        pref.height += 4;
                    }
                    return pref;
                }

                @Override
                public Dimension getMinimumSize() {
                    LookAndFeel lf;
                    Dimension min = super.getMinimumSize();
                    if (TextEditor.this.comboBox != null && (lf = UIManager.getLookAndFeel()) instanceof MetalLookAndFeel) {
                        min.height += 4;
                    }
                    return min;
                }
            };
            this.configureTextField(textField);
            tc = textField;
        } else {
            LimitedTextField textField = new LimitedTextField(10){

                @Override
                public Dimension getPreferredSize() {
                    Dimension pref = super.getPreferredSize();
                    pref.height += 4;
                    return pref;
                }

                @Override
                public Dimension getMinimumSize() {
                    Dimension min = super.getMinimumSize();
                    min.height += 4;
                    return min;
                }
            };
            this.configureTextField(textField);
            tc = textField;
        }
        return tc;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboBox && Strings.equal((String)e.getActionCommand(), (String)"comboBoxEdited", (boolean)false, (boolean)false)) {
            return;
        }
        this.valueModified = false;
        this.fireValueChanged();
    }

    public void selectAll() {
        this.textComponent.selectAll();
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getValue() {
        Object val;
        if (this.comboBox != null && (val = this.comboBox.getSelectedItem()) instanceof ValueItem) {
            return ((ValueItem)val).getValue();
        }
        String text = this.textComponent.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        return text;
    }

    @Override
    public void setValue(Object anObject) {
        if (!this.isValueAllowed(anObject)) {
            this.handleError(new IllegalArgumentException(Message.format((String)RB.getStringResource("notPermittedValue.fmt.txt", this.getLocale()), (Object)anObject)));
        } else if (this.comboBox != null) {
            ComboBoxModel dataModel = this.comboBox.getModel();
            boolean found = false;
            int size = dataModel.getSize();
            for (int i = 0; i < size; ++i) {
                if (!ValuePicker.areValuesEqual(anObject, dataModel.getElementAt(i), this.getDataType(), this.getLocale())) continue;
                this.comboBox.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found) {
                this.comboBox.setSelectedItem(anObject);
            }
        } else {
            if (anObject != null) {
                anObject = anObject.toString();
            }
            this.textComponent.setText((String)anObject);
            this.valueModified = false;
            this.fireValueChanged();
        }
    }

    protected boolean isValueAllowed(Object value) {
        return true;
    }

    protected DataTypeInterface getDataType() {
        return StringType.DEFAULT_INSTANCE;
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        this.edited = false;
        this.valueModified = false;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
    }

    @Override
    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public void requestFocus() {
        this.textComponent.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        return this.textComponent.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textComponent.requestFocusInWindow();
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("genericErrorHandler", oldValue, this.errorHandler);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.ignoreRemoveEvent) {
            this.edited = true;
            if (!this.valueModified) {
                this.valueModified = true;
                this.fireValueModified();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.ignoreRemoveEvent) {
            this.edited = true;
            if (!this.valueModified) {
                this.valueModified = true;
                this.fireValueModified();
            }
        }
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValues) {
        if (this.specialValues != specialValues) {
            SupportedSpecialValues oldValue = this.specialValues;
            this.specialValues = specialValues;
            Object value = this.getValue();
            this.configureUI();
            this.revalidate();
            this.setValue(value);
            this.firePropertyChange("specialValues", oldValue, this.specialValues);
        }
    }

    public void setAvailableValues(List values) {
        if (this.availableValues != values) {
            List oldValue = this.availableValues;
            this.availableValues = values;
            Object value = this.getValue();
            this.configureUI();
            this.revalidate();
            this.setValue(value);
            this.firePropertyChange("availableValues", oldValue, this.availableValues);
        }
    }

    public List getAvailableValues() {
        return this.availableValues;
    }

    protected void handleError(Exception e) {
        try {
            this.handlingError = true;
            if (this.getGenericErrorHandler() != null && this.lastError != e) {
                this.getGenericErrorHandler().handleError(this, new Message(Strings.padSingleQuotesForMessage((String)e.getMessage())), null);
            }
        }
        finally {
            this.lastError = e;
            this.handlingError = false;
        }
    }

    protected boolean isHandlingError() {
        return this.handlingError;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.getTextComponent().getAccessibleContext();
    }

    @SASScope
    class EditorBorder
    extends AbstractBorder {
        EditorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawRect(0, 0, w, h - 1);
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(1, 1, w - 2, h - 3);
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 0, 0, h - 2);
                g.drawLine(0, h - 2, w - 1, h - 2);
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, w - 1, 1);
                g.drawLine(1, 1, 1, h - 1);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.setColor(MetalLookAndFeel.getControl());
                g.drawLine(1, h - 2, 1, h - 2);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (System.getSecurityManager() != null) {
                return SAFE_EDITOR_BORDER_INSETS;
            }
            return editorBorderInsets;
        }
    }

    @SASScope
    private class ComboBoxEditorAdapter
    implements ComboBoxEditor {
        private JTextComponent component;
        private Object item;

        public ComboBoxEditorAdapter(JTextComponent comp) {
            this.component = comp;
        }

        @Override
        public void selectAll() {
            this.component.selectAll();
        }

        @Override
        public Component getEditorComponent() {
            return this.component;
        }

        @Override
        public void addActionListener(ActionListener l) {
            if (this.component instanceof JTextField) {
                ((JTextField)this.component).addActionListener(l);
            }
        }

        @Override
        public void removeActionListener(ActionListener l) {
            if (this.component instanceof JTextField) {
                ((JTextField)this.component).removeActionListener(l);
            }
        }

        @Override
        public Object getItem() {
            if (this.component instanceof JFormattedTextField) {
                if (!TextEditor.this.handlingError) {
                    try {
                        if (TextEditor.this.edited) {
                            ((JFormattedTextField)this.component).commitEdit();
                        }
                    }
                    catch (ParseException e) {
                        TextEditor.this.handleError(e);
                    }
                    finally {
                        TextEditor.this.edited = false;
                    }
                }
                Object value = ((JFormattedTextField)this.component).getValue();
                return value;
            }
            String newValue = this.component.getText();
            if (this.item != null && !(this.item instanceof String) && newValue.equals(this.item.toString())) {
                return this.item;
            }
            return newValue;
        }

        @Override
        public void setItem(Object anObject) {
            if (this.component instanceof JFormattedTextField) {
                try {
                    TextEditor.this.ignoreRemoveEvent = true;
                    ((JFormattedTextField)this.component).setValue(anObject);
                }
                finally {
                    TextEditor.this.ignoreRemoveEvent = false;
                }
                return;
            }
            this.item = anObject;
            if (anObject != null) {
                this.component.setText(anObject.toString());
            } else {
                this.component.setText("");
            }
        }
    }
}

