/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleType;
import com.sas.swing.visuals.IntegerEditor;
import com.sas.swing.visuals.RB;
import java.util.Locale;

@SASScope
public class DoubleEditor
extends IntegerEditor {
    private DataTypeInterface doubleType;

    public void setDisplayedDecimalDigits(int digits) {
        if (digits < 0) {
            throw new IllegalArgumentException(RB.getStringResource("DoubleEditor.setDisplayedDecimalDigits.txt"));
        }
        ((DoubleDigitsType)this.getDataType()).setDisplayedDecimalDigits(digits);
    }

    @Override
    protected DataTypeInterface getDataType() {
        if (this.doubleType == null) {
            this.doubleType = new DoubleDigitsType();
        }
        return this.doubleType;
    }

    @SASScope
    private class DoubleDigitsType
    extends DoubleType {
        private int digits;

        private DoubleDigitsType() {
        }

        public String getValueAsString(Object value, Locale locale) {
            return this.padDecimalsPlaces(value, locale, this.digits);
        }

        public void setDisplayedDecimalDigits(int digits) {
            this.digits = digits;
        }
    }
}

