/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.ValueInterface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.metal.MetalLookAndFeel;

@SASScope(value="ALL")
public class ComboBox
extends JComboBox
implements ValueInterface {
    protected HashMap displayNameMap;
    protected HashMap toolTipMap;
    public static String SEPARATOR = "SEPARATOR";
    protected Object previousSelection;

    public ComboBox() {
        this.init();
    }

    public ComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public ComboBox(Vector items) {
        super(items);
        this.init();
    }

    public ComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.init();
    }

    protected void init() {
        this.displayNameMap = new HashMap();
        this.toolTipMap = new HashMap();
        this.setRenderer(new ComboBoxRenderer());
        final ComboBox comboBox = this;
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    Object selectedItem = event.getItem();
                    if (selectedItem instanceof Window) {
                        comboBox.setSelectedItem(ComboBox.this.previousSelection);
                        ComboBox.this.alignAndShowWindow((Window)selectedItem);
                    }
                    ComboBox.this.previousSelection = selectedItem;
                }
            }
        });
        this.updateComboBoxEditor();
    }

    @Override
    @SASScope
    public void updateUI() {
        super.updateUI();
        this.updateComboBoxEditor();
    }

    private void updateComboBoxEditor() {
        LookAndFeel lnf = UIManager.getLookAndFeel();
        if (lnf instanceof MetalLookAndFeel) {
            this.setEditor(new MetalComboBoxEditor(this.displayNameMap));
        } else {
            this.setEditor(new ComboBoxEditor(this.displayNameMap));
        }
    }

    protected void alignAndShowWindow(Window window) {
        window.pack();
        Util.alignWindow(window, this, 4, -1);
        window.show();
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent event) {
        if (event.getID() == 401) {
            if (event.getKeyCode() == 32) {
                this.setPopupVisible(!this.isPopupVisible());
            }
            if (event.getKeyCode() == 40 && !this.isPopupVisible()) {
                this.setPopupVisible(true);
                return;
            }
            if (event.getKeyCode() == 38 && (event.getModifiers() & 8) > 0 && this.isPopupVisible()) {
                this.setPopupVisible(false);
                return;
            }
        }
        super.processComponentKeyEvent(event);
    }

    @SASScope
    public void addItem(Object item) {
        super.addItem(item);
    }

    public void addItem(Object item, String toolTip) {
        super.addItem(item);
        if (toolTip != null) {
            this.toolTipMap.put(item, toolTip);
        }
    }

    @SASScope
    public void addItem(Object item, String toolTip, String displayName) {
        super.addItem(item);
        if (toolTip != null) {
            this.toolTipMap.put(item, toolTip);
        }
        if (displayName != null) {
            this.displayNameMap.put(item, displayName);
        }
    }

    @SASScope
    public int getItemIndex(Object item) {
        int itemCount = this.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            if (!this.getItemAt(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @SASScope
    public Object getValue() {
        if (this.getEditor() != null) {
            return this.getEditor().getItem();
        }
        return this.getSelectedItem();
    }

    @Override
    @SASScope
    public void setValue(Object anObject) {
        this.setSelectedItem(anObject);
    }

    @Override
    @SASScope
    public void setSelectedIndex(int anIndex) {
        int dir;
        int lastSelectedIndex = this.getSelectedIndex();
        int n = dir = lastSelectedIndex > anIndex ? -1 : 1;
        while (anIndex >= 0 && SEPARATOR.equals(this.getItemAt(anIndex))) {
            if (anIndex < this.getItemCount() - 1) {
                anIndex += dir;
                continue;
            }
            if (anIndex != this.getItemCount() - 1) continue;
            anIndex = 0;
        }
        super.setSelectedIndex(anIndex);
    }

    @SASScope
    protected class ComboBoxRenderer
    extends BasicComboBoxRenderer {
        JSeparator separator = new JSeparator(0);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            String string = str = value == null ? "" : value.toString();
            if (SEPARATOR.equals(str)) {
                return this.separator;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    String toolTip = null;
                    if (!ComboBox.this.toolTipMap.isEmpty()) {
                        toolTip = (String)ComboBox.this.toolTipMap.get(value);
                    }
                    if (toolTip != null) {
                        list.setToolTipText(toolTip);
                    } else {
                        list.setToolTipText(null);
                    }
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            String name = null;
            if (!ComboBox.this.displayNameMap.isEmpty()) {
                name = (String)ComboBox.this.displayNameMap.get(value);
            }
            if (name != null) {
                this.setText(name);
            } else {
                this.setText(str);
            }
            return this;
        }
    }

    @SASScope
    protected class MetalComboBoxEditor
    extends javax.swing.plaf.metal.MetalComboBoxEditor {
        HashMap displayNameMap;

        public MetalComboBoxEditor(HashMap displayNameMap) {
            this.displayNameMap = displayNameMap;
        }

        @Override
        public void setItem(Object item) {
            String name = (String)this.displayNameMap.get(item);
            if (name != null) {
                super.setItem(name);
            } else {
                super.setItem(item);
            }
        }
    }

    @SASScope
    protected class ComboBoxEditor
    extends BasicComboBoxEditor {
        HashMap displayNameMap;

        public ComboBoxEditor(HashMap displayNameMap) {
            this.displayNameMap = displayNameMap;
        }

        @Override
        public void setItem(Object item) {
            String name = (String)this.displayNameMap.get(item);
            if (name != null) {
                super.setItem(name);
            } else {
                super.setItem(item);
            }
        }
    }
}

