/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.ColorType;
import com.sas.swing.visuals.ColorComboPopup;
import com.sas.swing.visuals.ColorIcon;
import com.sas.swing.visuals.ComponentComboBox;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.ComboPopup;

@SASScope
public class ColorPicker
extends ComponentComboBox
implements EditorInterface,
ItemListener {
    private static final long serialVersionUID = 649249816289344774L;
    private ComboPopup comboPopup;
    private FocusAdapter focusListener;
    private boolean isEditing;
    private EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent = null;

    public ColorPicker() {
        super(ColorPicker.createDefaultModel());
        this.setSelectedIndex(-1);
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                if (event.isTemporary()) {
                    return;
                }
                ColorPicker.this.isEditing = false;
                ColorPicker.this.fireEditingStopped();
            }

            @Override
            public void focusGained(FocusEvent event) {
                ColorPicker.this.isEditing = true;
                ColorPicker.this.fireEditingStarted();
            }
        };
        this.isEditing = false;
        this.setEditable(false);
        this.setRenderer(new ColorPickerRenderer());
        this.setMaximumRowCount(this.comboPopup.getList().getVisibleRowCount());
        this.addFocusListener(this.focusListener);
        this.addItemListener(this);
    }

    public void removeListeners() {
        this.removeFocusListener(this.focusListener);
        this.removeItemListener(this);
    }

    private static ComboBoxModel createDefaultModel() {
        DefaultComboBoxModel<Color> colors = new DefaultComboBoxModel<Color>();
        colors.addElement(ColorPicker.getColor("#000000"));
        colors.addElement(ColorPicker.getColor("#0000FF"));
        colors.addElement(ColorPicker.getColor("#A05000"));
        colors.addElement(ColorPicker.getColor("#4F4F4F"));
        colors.addElement(ColorPicker.getColor("#E8D898"));
        colors.addElement(ColorPicker.getColor("#00FFFF"));
        colors.addElement(ColorPicker.getColor("#FF00FF"));
        colors.addElement(ColorPicker.getColor("#FFAA00"));
        colors.addElement(ColorPicker.getColor("#808080"));
        colors.addElement(ColorPicker.getColor("#00FF00"));
        colors.addElement(ColorPicker.getColor("#E06090"));
        colors.addElement(ColorPicker.getColor("#C0FF81"));
        colors.addElement(ColorPicker.getColor("#700000"));
        colors.addElement(ColorPicker.getColor("#000080"));
        colors.addElement(ColorPicker.getColor("#2A8307"));
        colors.addElement(ColorPicker.getColor("#FF8000"));
        colors.addElement(ColorPicker.getColor("#FF0080"));
        colors.addElement(ColorPicker.getColor("#703070"));
        colors.addElement(ColorPicker.getColor("#FF0000"));
        colors.addElement(ColorPicker.getColor("#FF6060"));
        colors.addElement(ColorPicker.getColor("#FF0055"));
        colors.addElement(ColorPicker.getColor("#C0C0C0"));
        colors.addElement(ColorPicker.getColor("#3883A8"));
        colors.addElement(ColorPicker.getColor("#E0A860"));
        colors.addElement(ColorPicker.getColor("#008080"));
        colors.addElement(ColorPicker.getColor("#B090D0"));
        colors.addElement(ColorPicker.getColor("#FFFFFF"));
        colors.addElement(ColorPicker.getColor("#FFFF00"));
        colors.addElement(null);
        return colors;
    }

    private static Color getColor(String string) {
        return Color.decode(string);
    }

    @Override
    public ComboPopup createPopup() {
        if (this.comboPopup == null) {
            this.comboPopup = new ColorComboPopup((JComboBox)this);
        }
        return this.comboPopup;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getValue() {
        return this.getSelectedItem();
    }

    @Override
    public void setValue(Object anObject) {
        if (anObject instanceof Color && this.getModel() instanceof DefaultComboBoxModel && ((DefaultComboBoxModel)this.getModel()).getIndexOf(anObject) == -1) {
            ((DefaultComboBoxModel)this.getModel()).addElement(anObject);
        }
        this.setSelectedItem(anObject);
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
    }

    @Override
    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.fireValueChanged();
        } else if (e.getStateChange() == 2 && this.getSelectedItem() == null) {
            this.fireValueChanged();
        }
    }

    @SASScope
    class ColorPickerRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 8266507167140902L;
        private ColorIcon icon = new ColorIcon();
        private Border border = BorderFactory.createEmptyBorder(2, 2, 2, 3);
        private ColorType colorType = new ColorType();

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            comp.setText("");
            if (value instanceof Color) {
                Color c = (Color)value;
                this.icon.setColor(c);
                comp.setIcon(this.icon);
                comp.setToolTipText(this.colorType.getDisplayString((Object)c, this.getLocale()).toUpperCase());
            } else {
                comp.setToolTipText(null);
                comp.setIcon(null);
            }
            comp.setBorder(this.border);
            return comp;
        }
    }
}

