/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.swing.visuals.CheckBoxTreeCellRendererWrapper;
import com.sas.swing.visuals.CheckedStateNode;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.Resources;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

@SASScope(value="ALL")
@SubjectToChange
public class CheckBoxTree
extends JTree
implements TreeModelListener,
TreeExpansionListener,
TreeWillExpandListener,
TreeSelectionListener,
PropertyChangeListener,
LayoutConstants {
    protected JCheckBox checkBox;
    protected CheckBoxTreeCellRendererWrapper checkRenderer;
    protected TreeSelectionModel checkedTreeModel;
    private Icon checkBoxIcon;
    private Insets checkBoxInsets;
    private Map pathCache;
    protected boolean checkBoxOnLeafNodes;
    protected boolean checkBoxOnParentNodes;
    protected boolean checkBoxOnRootNode;
    protected boolean showSelectionIcon;
    protected boolean checkBoxShouldCheckChildren;
    protected boolean checkBoxShouldCheckParents;
    private Icon noneSelected;
    private Icon childrenSelected;
    private Icon nodeSelected;
    private Icon nodeChildrenSelected;
    private Icon nodeSomeChildrenSelected;
    private Icon someChildrenSelected;
    public static final int NOTHING_SELECTED = 1;
    public static final int NODE_SELECTED = 2;
    public static final int NODE_SOME_CHILDREN_SELECTED = 4;
    public static final int NODE_ALL_CHILDREN_SELECTED = 8;
    public static final int NODE_NO_CHILDREN_SELECTED = 16;
    public static final int SOME_CHILDREN_SELECTED = 32;
    public static final int ALL_CHILDREN_SELECTED = 64;
    public static final int NO_CHECKBOX = 128;
    public static final int PREORDER = 34;
    public static final int POSTORDER = 35;
    private ChangeCursorCommand changeCursorCommand;
    private Timer timer;
    private TimerTask changeCursorTask;
    private boolean timerActive;
    private boolean changeCursor;
    private int delayForCursorChange;
    private boolean mCheckedStateCacheDirty = true;
    private HashMap mCheckedStateCache = null;
    private boolean mInternalCheckOperation = false;
    private boolean newExpand;
    int mCheckedCachePutCount;
    private static final CheckedStateNode NOTHING_SELECTED_STATE = new CheckedStateNode(1);
    private static final CheckedStateNode NODE_SELECTED_STATE = new CheckedStateNode(2);
    private static final CheckedStateNode NODE_SOME_CHILDREN_SELECTED_STATE = new CheckedStateNode(4);
    private static final CheckedStateNode NODE_ALL_CHILDREN_SELECTED_STATE = new CheckedStateNode(8);
    private static final CheckedStateNode NODE_NO_CHILDREN_SELECTED_STATE = new CheckedStateNode(16);
    private static final CheckedStateNode SOME_CHILDREN_SELECTED_STATE = new CheckedStateNode(32);
    private static final CheckedStateNode ALL_CHILDREN_SELECTED_STATE = new CheckedStateNode(64);
    private static final CheckedStateNode NO_CHECKBOX_STATE = new CheckedStateNode(128);

    public CheckBoxTree() {
        this.initLocalVars();
    }

    public CheckBoxTree(TreeModel model) {
        super(model);
        this.initLocalVars();
    }

    private void initLocalVars() {
        this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        this.changeCursor = true;
        this.delayForCursorChange = 250;
        this.timerActive = false;
        this.checkBoxOnLeafNodes = true;
        this.checkBoxOnParentNodes = true;
        this.checkBoxOnRootNode = true;
        this.showSelectionIcon = true;
        this.checkBoxShouldCheckChildren = false;
        this.checkBoxShouldCheckParents = false;
        this.createDefaultIcons();
        this.setCheckedModel(this.createDefaultCheckedModel());
        this.checkRenderer = new CheckBoxTreeCellRendererWrapper(this);
        this.setCellRenderer(this.checkRenderer);
        this.checkBoxIcon = UIManager.getIcon("CheckBox.icon");
        this.checkBoxInsets = UIManager.getInsets("CheckBox.margin");
        NodeSelectionListener listener = new NodeSelectionListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addTreeExpansionListener(this);
        this.addTreeWillExpandListener(this);
        this.pathCache = new HashMap();
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "checkNode");
        inputMap.put(KeyStroke.getKeyStroke(32, 3), "toggleCheckedChildren");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("checkNode", new CheckNodeAction());
        actionMap.put("toggleCheckedChildren", new ToggleCheckedChildrenAction());
    }

    public boolean isChangeCursorWhenBusy() {
        return this.changeCursor;
    }

    public void setChangeCursorWhenBusy(boolean shouldChangeCursor) {
        if (this.changeCursor != shouldChangeCursor) {
            this.changeCursor = shouldChangeCursor;
            this.firePropertyChange("changeCursorWhenBusy", this.changeCursor ? Boolean.FALSE : Boolean.TRUE, this.changeCursor ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public int getDelayForCursorChange() {
        return this.delayForCursorChange;
    }

    public void setDelayForCursorChange(int delayToChangeCursor) {
        if (this.delayForCursorChange != delayToChangeCursor) {
            int old = this.delayForCursorChange;
            this.delayForCursorChange = delayToChangeCursor;
            this.firePropertyChange("delayForCursorChange", old, this.delayForCursorChange);
        }
    }

    public boolean isCheckBoxOnLeafNodes() {
        return this.checkBoxOnLeafNodes;
    }

    public void setCheckBoxOnLeafNodes(boolean checksOnLeaves) {
        if (checksOnLeaves != this.checkBoxOnLeafNodes) {
            this.checkBoxOnLeafNodes = checksOnLeaves;
            this.firePropertyChange("checkBoxOnLeafNodes", this.checkBoxOnLeafNodes ? Boolean.FALSE : Boolean.TRUE, this.checkBoxOnLeafNodes ? Boolean.TRUE : Boolean.FALSE);
            this.treeDidChange();
        }
    }

    public boolean isCheckBoxOnParentNodes() {
        return this.checkBoxOnParentNodes;
    }

    public void setCheckBoxOnParentNodes(boolean checksOnParents) {
        if (checksOnParents != this.checkBoxOnParentNodes) {
            this.checkBoxOnParentNodes = checksOnParents;
            this.firePropertyChange("checkBoxOnParentNodes", this.checkBoxOnParentNodes ? Boolean.FALSE : Boolean.TRUE, this.checkBoxOnParentNodes ? Boolean.TRUE : Boolean.FALSE);
            this.treeDidChange();
        }
    }

    public void createDefaultIcons() {
        this.setNoneSelectedIcon(Resources.getImageIcon((String)"treeviewEmpty.gif"));
        this.setAllChildrenSelectedIcon(Resources.getImageIcon((String)"treeviewChildren.gif"));
        this.setNodeSelectedIcon(Resources.getImageIcon((String)"treeviewNode.gif"));
        this.setNodeAndAllChildrenSelectedIcon(Resources.getImageIcon((String)"treeviewNodeChildren.gif"));
        this.setNodeAndSomeChildrenSelectedIcon(Resources.getImageIcon((String)"treeviewNodeSomeChildren.gif"));
        this.setSomeChildrenSelectedIcon(Resources.getImageIcon((String)"treeviewSomeChildren.gif"));
    }

    public void setNoneSelectedIcon(Icon newIcon) {
        if (this.noneSelected != newIcon) {
            Icon old = this.noneSelected;
            this.noneSelected = newIcon;
            this.firePropertyChange("noneSelectedIcon", old, newIcon);
        }
    }

    public Icon getNoneSelectedIcon() {
        return this.noneSelected;
    }

    public void setAllChildrenSelectedIcon(Icon newIcon) {
        if (this.childrenSelected != newIcon) {
            Icon old = this.childrenSelected;
            this.childrenSelected = newIcon;
            this.firePropertyChange("allChildrenSelectedIcon", old, newIcon);
        }
    }

    public Icon getAllChildrenSelectedIcon() {
        return this.childrenSelected;
    }

    public void setNodeSelectedIcon(Icon newIcon) {
        if (this.nodeSelected != newIcon) {
            Icon old = this.nodeSelected;
            this.nodeSelected = newIcon;
            this.firePropertyChange("nodeSelectedIcon", old, newIcon);
        }
    }

    public Icon getNodeSelectedIcon() {
        return this.nodeSelected;
    }

    public void setNodeAndAllChildrenSelectedIcon(Icon newIcon) {
        if (this.nodeChildrenSelected != newIcon) {
            Icon old = this.nodeChildrenSelected;
            this.nodeChildrenSelected = newIcon;
            this.firePropertyChange("nodeAndAllChildrenSelectedIcon", old, newIcon);
        }
    }

    public Icon getNodeAndAllChildrenSelectedIcon() {
        return this.nodeChildrenSelected;
    }

    public void setNodeAndSomeChildrenSelectedIcon(Icon newIcon) {
        if (this.nodeSomeChildrenSelected != newIcon) {
            Icon old = this.nodeSomeChildrenSelected;
            this.nodeSomeChildrenSelected = newIcon;
            this.firePropertyChange("nodeAndSomeChildrenSelectedIcon", old, newIcon);
        }
    }

    public Icon getNodeAndSomeChildrenSelectedIcon() {
        return this.nodeSomeChildrenSelected;
    }

    public void setSomeChildrenSelectedIcon(Icon newIcon) {
        if (this.someChildrenSelected != newIcon) {
            Icon old = this.someChildrenSelected;
            this.someChildrenSelected = newIcon;
            this.firePropertyChange("someChildrenSelectedIcon", old, newIcon);
        }
    }

    public Icon getSomeChildrenSelectedIcon() {
        return this.someChildrenSelected;
    }

    public boolean isCheckBoxVisibleForRow(int row) {
        if (row == 0) {
            return this.checkBoxOnRootNode;
        }
        if (this.checkBoxOnLeafNodes && this.checkBoxOnParentNodes) {
            return true;
        }
        if (!this.checkBoxOnLeafNodes && !this.checkBoxOnParentNodes) {
            return false;
        }
        return this.isCheckBoxVisibleForPath(this.getPathForRow(row));
    }

    public boolean isCheckBoxVisibleForPath(TreePath path) {
        if (path != null && path.getPathCount() == 1) {
            return this.checkBoxOnRootNode;
        }
        if (this.checkBoxOnLeafNodes && this.checkBoxOnParentNodes) {
            return true;
        }
        if (!this.checkBoxOnLeafNodes && !this.checkBoxOnParentNodes) {
            return false;
        }
        if (path != null) {
            Object child = path.getLastPathComponent();
            boolean leaf = this.getModel().isLeaf(child);
            if (leaf && this.checkBoxOnLeafNodes) {
                return true;
            }
            if (!leaf && this.checkBoxOnParentNodes) {
                return true;
            }
        }
        return false;
    }

    public boolean isIconVisibleForRow(int row) {
        if (!this.isShowSelectionIcon()) {
            return false;
        }
        return this.isIconVisibleForPath(this.getPathForRow(row));
    }

    public boolean isIconVisibleForPath(TreePath path) {
        if (!this.isShowSelectionIcon() || !this.checkBoxOnLeafNodes && !this.checkBoxOnParentNodes && !this.checkBoxOnRootNode) {
            return false;
        }
        if (path != null) {
            Object parent = path.getLastPathComponent();
            boolean leaf = this.getModel().isLeaf(parent);
            if (leaf) {
                return false;
            }
            if (this.checkBoxOnLeafNodes) {
                return true;
            }
            if (this.checkBoxOnParentNodes) {
                int cc = this.getModel().getChildCount(parent);
                for (int i = 0; i < cc; ++i) {
                    if (this.getModel().getChildCount(this.getModel().getChild(parent, i)) <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SASScope
    public boolean isCheckBoxEnabledForPath(TreePath path) {
        return true;
    }

    @SASScope
    public boolean isCheckBoxEnabledForRow(int row) {
        return this.isCheckBoxEnabledForPath(this.getPathForRow(row));
    }

    @Override
    public void updateUI() {
        if (this.checkRenderer != null && this.checkRenderer.isDefaultRenderer()) {
            this.setCellRenderer(null);
        }
        super.updateUI();
        if (this.checkRenderer == null) {
            this.checkRenderer = new CheckBoxTreeCellRendererWrapper(this);
        } else if (this.checkRenderer.isDefaultRenderer()) {
            this.checkRenderer.setCellRenderer(this.getCellRenderer());
            this.setCellRenderer(this.checkRenderer);
        }
        this.checkBoxIcon = UIManager.getIcon("CheckBox.icon");
        this.checkBoxInsets = UIManager.getInsets("CheckBox.margin");
        if (this.getCheckedModel() != null && this.getSelectionModel() != null) {
            this.getCheckedModel().setRowMapper(this.getSelectionModel().getRowMapper());
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        if (this.getModel() != null) {
            this.getModel().removeTreeModelListener(this);
        }
        this.mCheckedStateCacheDirty = true;
        super.setModel(newModel);
        if (this.getCheckedModel() != null) {
            this.getCheckedModel().clearSelection();
        }
        if (this.getSelectionModel().getRowMapper() instanceof AbstractLayoutCache) {
            ((AbstractLayoutCache)this.getSelectionModel().getRowMapper()).invalidateSizes();
        }
        if (newModel != null) {
            newModel.addTreeModelListener(this);
        }
    }

    public TreeSelectionModel createDefaultCheckedModel() {
        DefaultTreeSelectionModel tsm = new DefaultTreeSelectionModel();
        tsm.setRowMapper(this.getSelectionModel().getRowMapper());
        return tsm;
    }

    public TreeSelectionModel getCheckedModel() {
        return this.checkedTreeModel;
    }

    public void setCheckedModel(TreeSelectionModel newModel) {
        if (newModel != this.checkedTreeModel) {
            TreeSelectionModel old = this.checkedTreeModel;
            if (old != null) {
                old.removeTreeSelectionListener(this);
                old.removePropertyChangeListener(this);
            }
            this.checkedTreeModel = newModel;
            this.mCheckedStateCacheDirty = true;
            if (this.checkedTreeModel != null) {
                this.checkedTreeModel.addTreeSelectionListener(this);
                this.checkedTreeModel.addPropertyChangeListener(this);
            }
            this.firePropertyChange("checkedModel", old, newModel);
        }
    }

    public Object[] getCheckedObjects() {
        return this.getCheckedObjects(34);
    }

    public Object[] getCheckedObjects(int order) {
        if (this.getCheckedModel() != null) {
            Collection c = this.getOrderedCheckedCollection(order);
            int size = c.size();
            Object[] objs = new Object[size];
            Iterator iter = c.iterator();
            int i = 0;
            while (iter.hasNext()) {
                objs[i++] = ((TreePath)iter.next()).getLastPathComponent();
            }
            return objs;
        }
        return new Object[0];
    }

    private String createHashStringFromTreePath(TreePath path) {
        StringBuffer hashString = new StringBuffer();
        int pathSize = path.getPathCount();
        for (int i = 0; i < pathSize; ++i) {
            Object node = path.getPathComponent(i);
            hashString.append(node.hashCode() + ",");
        }
        return hashString.toString();
    }

    private String createHashStringFromTreePath(TreePath parentPath, Object node) {
        StringBuffer hashString = new StringBuffer();
        hashString.append(this.createHashStringFromTreePath(parentPath));
        hashString.append(node.hashCode() + ",");
        return hashString.toString();
    }

    private void updateCheckedCache(TreePath path) {
        if (this.mCheckedStateCacheDirty) {
            return;
        }
        for (TreePath pathWalker = path; pathWalker != null && pathWalker.getPathCount() > 0; pathWalker = pathWalker.getParentPath()) {
            this.updateCheckedStatusForNode(pathWalker);
        }
    }

    private void updateCheckedStatusForNode(TreePath path) {
        if (path == null) {
            return;
        }
        TreeModel treeModel = this.getModel();
        Object rootNode = path.getLastPathComponent();
        boolean nodeChecked = this.getCheckedModel().isPathSelected(path);
        int children = treeModel.getChildCount(rootNode);
        boolean allChecked = true;
        boolean someChecked = false;
        for (int i = 0; i < children; ++i) {
            Object child = treeModel.getChild(rootNode, i);
            TreePath childPath = path.pathByAddingChild(child);
            boolean checkBoxForChild = this.isCheckBoxVisibleForPath(childPath);
            String hashString = this.createHashStringFromTreePath(path, child);
            CheckedStateNode checkedStateNode = (CheckedStateNode)this.mCheckedStateCache.get(hashString);
            if (checkedStateNode == null) {
                checkedStateNode = NOTHING_SELECTED_STATE;
            }
            if (checkBoxForChild) {
                if (checkedStateNode.mState != 8 && (checkedStateNode.mState != 2 || treeModel.getChildCount(child) != 0)) {
                    allChecked = false;
                }
            } else if (checkedStateNode.mState != 64 && treeModel.getChildCount(child) != 0) {
                allChecked = false;
            }
            if (checkedStateNode.mState == 1) continue;
            someChecked = true;
        }
        String hashString = this.createHashStringFromTreePath(path);
        if (nodeChecked) {
            if (children > 0) {
                if (allChecked) {
                    this.mCheckedStateCache.put(hashString, NODE_ALL_CHILDREN_SELECTED_STATE);
                } else if (someChecked) {
                    this.mCheckedStateCache.put(hashString, NODE_SOME_CHILDREN_SELECTED_STATE);
                } else {
                    this.mCheckedStateCache.put(hashString, NODE_NO_CHILDREN_SELECTED_STATE);
                }
            } else {
                this.mCheckedStateCache.put(hashString, NODE_SELECTED_STATE);
            }
        } else if (children > 0) {
            if (allChecked) {
                this.mCheckedStateCache.put(hashString, ALL_CHILDREN_SELECTED_STATE);
            } else if (someChecked) {
                this.mCheckedStateCache.put(hashString, SOME_CHILDREN_SELECTED_STATE);
            } else {
                this.mCheckedStateCache.put(hashString, NOTHING_SELECTED_STATE);
            }
        } else {
            this.mCheckedStateCache.put(hashString, NOTHING_SELECTED_STATE);
        }
        ++this.mCheckedCachePutCount;
    }

    private void updateCheckedCache(TreePath path, boolean recursive) {
        if (this.mCheckedStateCacheDirty) {
            return;
        }
        this.mCheckedCachePutCount = 0;
        if (recursive) {
            this.buildCheckedStateHelper(path.getLastPathComponent(), path);
        } else {
            TreeModel treeModel = this.getModel();
            Object node = path.getLastPathComponent();
            int childCount = treeModel.getChildCount(node);
            for (int i = 0; i < childCount; ++i) {
                Object child = treeModel.getChild(node, i);
                TreePath childPath = path.pathByAddingChild(child);
                this.updateCheckedStatusForNode(childPath);
            }
            this.updateCheckedStatusForNode(path);
        }
        this.updateCheckedCache(path.getParentPath());
    }

    private void buildCheckedStateHelper(Object node, TreePath pathToNode) {
        TreeModel treeModel = this.getModel();
        int children = treeModel.getChildCount(node);
        for (int i = 0; i < children; ++i) {
            Object child = treeModel.getChild(node, i);
            TreePath pathToChild = pathToNode.pathByAddingChild(child);
            this.buildCheckedStateHelper(child, pathToChild);
        }
        this.updateCheckedStatusForNode(pathToNode);
    }

    private void buildCheckedStateHelperToRoot(TreePath pathToNode) {
        this.updateCheckedStatusForNode(pathToNode);
        TreePath parentPath = pathToNode.getParentPath();
        if (parentPath != null) {
            this.buildCheckedStateHelperToRoot(parentPath);
        }
    }

    private void buildCheckedStateCache() {
        this.mCheckedStateCache = new HashMap();
        TreeModel treeModel = this.getModel();
        this.mCheckedCachePutCount = 0;
        if (this.getCheckedModel() != null) {
            Collection c = this.getOrderedCheckedCollection(34);
            for (TreePath path : c) {
                String hashString = this.createHashStringFromTreePath(path);
                if (this.mCheckedStateCache.containsKey(hashString)) continue;
                Object node = path.getLastPathComponent();
                if (treeModel.getChildCount(node) > 0) {
                    this.mCheckedStateCache.put(hashString, NODE_NO_CHILDREN_SELECTED_STATE);
                } else {
                    this.mCheckedStateCache.put(hashString, NODE_SELECTED_STATE);
                }
                if ((path = path.getParentPath()) == null) continue;
                this.buildCheckedStateHelperToRoot(path);
            }
            this.mCheckedStateCacheDirty = false;
        }
    }

    public int getCheckedState(TreePath path) {
        if (path != null && this.getCheckedModel() != null) {
            String hashString;
            CheckedStateNode checkedStateNode;
            if (this.getCheckedModel().isSelectionEmpty()) {
                return 1;
            }
            if (this.mCheckedStateCacheDirty) {
                this.buildCheckedStateCache();
            }
            if ((checkedStateNode = (CheckedStateNode)this.mCheckedStateCache.get(hashString = this.createHashStringFromTreePath(path))) != null) {
                return checkedStateNode.mState;
            }
            return 1;
        }
        return 1;
    }

    public Icon getIconForCheckedState(int state) {
        switch (state) {
            case 1: {
                return this.getNoneSelectedIcon();
            }
            case 2: {
                return this.getNodeSelectedIcon();
            }
            case 4: {
                return this.getNodeAndSomeChildrenSelectedIcon();
            }
            case 8: {
                return this.getNodeAndAllChildrenSelectedIcon();
            }
            case 16: {
                return this.getNodeSelectedIcon();
            }
            case 32: {
                return this.getSomeChildrenSelectedIcon();
            }
            case 64: {
                return this.getAllChildrenSelectedIcon();
            }
        }
        return null;
    }

    public void checkPath(TreePath path, boolean setChecked, boolean makeVisible) {
        if (path != null) {
            this.mInternalCheckOperation = true;
            if (setChecked) {
                if (this.isCheckBoxShouldCheckChildren()) {
                    this.checkChildren(path, true, true);
                }
                if (this.isCheckBoxShouldCheckParents()) {
                    this.checkParents(path, true, true);
                }
                this.getCheckedModel().addSelectionPath(path);
            } else {
                if (this.isCheckBoxShouldCheckChildren()) {
                    this.checkChildren(path, false, true);
                }
                this.getCheckedModel().removeSelectionPath(path);
            }
            if (makeVisible) {
                TreePath parent = path.getParentPath();
                if (parent != null) {
                    this.expandPath(parent);
                }
                this.makeVisible(path);
            }
            this.updateCheckedCache(path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkChildrenHelper(TreePath path, boolean setChecked, boolean recursive, ArrayList newCheckList, ArrayList newUncheckList) {
        if (path == null || this.getCheckedModel() == null) return;
        Object child = path.getLastPathComponent();
        int childCount = this.getModel().getChildCount(child);
        if (childCount <= 0) return;
        for (int i = 0; i < childCount; ++i) {
            TreePath childPath = path.pathByAddingChild(this.getModel().getChild(child, i));
            if (this.isCheckBoxEnabledForPath(childPath)) {
                if (setChecked) {
                    if (this.isCheckBoxVisibleForPath(childPath)) {
                        newCheckList.add(childPath);
                    }
                } else {
                    newUncheckList.add(childPath);
                }
            }
            if (!recursive) continue;
            this.checkChildrenHelper(childPath, setChecked, recursive, newCheckList, newUncheckList);
        }
    }

    public void checkChildren(TreePath path, boolean setChecked, boolean recursive) {
        ArrayList newCheckList = new ArrayList();
        ArrayList newUncheckList = new ArrayList();
        this.checkChildrenHelper(path, setChecked, recursive, newCheckList, newUncheckList);
        this.mInternalCheckOperation = true;
        if (newCheckList.size() > 0) {
            this.getCheckedModel().addSelectionPaths(newCheckList.toArray(new TreePath[0]));
        }
        if (newUncheckList.size() > 0) {
            this.getCheckedModel().removeSelectionPaths(newUncheckList.toArray(new TreePath[0]));
        }
        this.updateCheckedCache(path, recursive);
    }

    private void checkParentHelper(TreePath path, boolean setChecked, boolean recursive, ArrayList newCheckList, ArrayList newUncheckList) {
        TreePath parent;
        if (path != null && this.getCheckedModel() != null && (parent = path.getParentPath()) != null) {
            if (this.isCheckBoxEnabledForPath(parent)) {
                if (setChecked) {
                    if (this.isCheckBoxVisibleForPath(parent)) {
                        newCheckList.add(parent);
                    }
                } else {
                    newUncheckList.add(parent);
                }
            }
            if (recursive) {
                this.checkParentHelper(parent, setChecked, recursive, newCheckList, newUncheckList);
            }
        }
    }

    public void checkParents(TreePath path, boolean setChecked, boolean recursive) {
        ArrayList newCheckList = new ArrayList();
        ArrayList newUncheckList = new ArrayList();
        this.checkParentHelper(path, setChecked, recursive, newCheckList, newUncheckList);
        this.mInternalCheckOperation = true;
        if (newCheckList.size() > 0) {
            this.getCheckedModel().addSelectionPaths(newCheckList.toArray(new TreePath[0]));
        }
        if (newUncheckList.size() > 0) {
            this.getCheckedModel().removeSelectionPaths(newUncheckList.toArray(new TreePath[0]));
        }
        this.updateCheckedCache(path.getParentPath());
    }

    private void cacheState(TreePath path) {
        List list;
        if (path != null && this.getCheckedModel() != null && (list = this.getCheckedChildrenPaths(path)) != null && list.size() > 0) {
            this.pathCache.put(path, list);
        }
    }

    private void restoreState(TreePath path) {
        if (path != null && this.getCheckedModel() != null && this.isPathCached(path)) {
            List paths = (List)this.pathCache.get(path);
            if (paths != null) {
                this.mInternalCheckOperation = true;
                this.getCheckedModel().addSelectionPaths(paths.toArray(new TreePath[0]));
                this.updateCheckedCache(path, true);
            }
            this.pathCache.remove(path);
        }
    }

    private boolean isPathCached(TreePath path) {
        return this.pathCache != null && this.pathCache.containsKey(path);
    }

    public List getCheckedChildrenPaths(TreePath path) {
        TreePath[] paths;
        ArrayList<TreePath> checkedChildrenPaths = new ArrayList<TreePath>();
        if (path != null && this.getCheckedModel() != null && (paths = this.getCheckedModel().getSelectionPaths()) != null) {
            for (int i = 0; i < paths.length; ++i) {
                if (!path.isDescendant(paths[i]) || path == paths[i]) continue;
                checkedChildrenPaths.add(paths[i]);
            }
        }
        return checkedChildrenPaths;
    }

    @Override
    public void setRootVisible(boolean visible) {
        super.setRootVisible(visible);
        if (this.getCheckedModel() != null) {
            this.getCheckedModel().resetRowSelection();
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.mCheckedStateCacheDirty = true;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        if (this.getCheckedModel() != null) {
            this.getCheckedModel().resetRowSelection();
        }
        this.mCheckedStateCacheDirty = true;
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        if (e == null) {
            return;
        }
        final TreePath parent = e.getTreePath();
        final Object[] children = e.getChildren();
        if (children == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeSelectionModel sm = CheckBoxTree.this.getCheckedModel();
                if (sm != null && parent != null && children != null && children.length > 0) {
                    for (int counter = children.length - 1; counter >= 0; --counter) {
                        CheckBoxTree.this.removeDescendantCheckedPaths(parent.pathByAddingChild(children[counter]), true);
                    }
                }
                if (sm != null) {
                    sm.resetRowSelection();
                }
                CheckBoxTree.this.mCheckedStateCacheDirty = true;
            }
        });
    }

    private boolean removeDescendantCheckedPaths(TreePath path, boolean includePath) {
        TreePath[] toRemove = this.getDescendantCheckedPaths(path, includePath);
        if (toRemove != null) {
            this.getCheckedModel().removeSelectionPaths(toRemove);
            return true;
        }
        return false;
    }

    private TreePath[] getDescendantCheckedPaths(TreePath path, boolean includePath) {
        TreePath[] selPaths;
        TreeSelectionModel sm = this.getCheckedModel();
        TreePath[] treePathArray = selPaths = sm != null ? sm.getSelectionPaths() : null;
        if (selPaths != null) {
            boolean shouldRemove = false;
            for (int counter = selPaths.length - 1; counter >= 0; --counter) {
                if (selPaths[counter] != null && path.isDescendant(selPaths[counter]) && (!path.equals(selPaths[counter]) || includePath)) {
                    shouldRemove = true;
                    continue;
                }
                selPaths[counter] = null;
            }
            if (!shouldRemove) {
                selPaths = null;
            }
            return selPaths;
        }
        return null;
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        if (e == null) {
            return;
        }
        final TreePath parent = e.getTreePath();
        if (parent == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CheckBoxTree.this.removeDescendantCheckedPaths(parent, false);
                if (CheckBoxTree.this.getCheckedModel() != null) {
                    CheckBoxTree.this.getCheckedModel().resetRowSelection();
                }
                CheckBoxTree.this.mCheckedStateCacheDirty = true;
            }
        });
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        if (this.getCheckedModel() != null) {
            this.getCheckedModel().resetRowSelection();
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        if (this.newExpand && this.getSelectionModel().getRowMapper() instanceof AbstractLayoutCache) {
            ((AbstractLayoutCache)this.getSelectionModel().getRowMapper()).invalidateSizes();
        }
        this.stopTiming();
        if (this.getCheckedModel() != null) {
            this.getCheckedModel().resetRowSelection();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        if (!this.hasBeenExpanded(event.getPath())) {
            this.startTiming();
            this.newExpand = true;
        } else {
            this.newExpand = false;
        }
    }

    private void startTiming() {
        this.createTimer();
        this.timer.schedule(this.changeCursorTask, this.delayForCursorChange);
    }

    private void stopTiming() {
        if (this.changeCursorTask != null) {
            this.changeCursorTask.cancel();
        }
        if (this.timerActive) {
            this.timerActive = false;
            this.changeCursorCommand.undoAll();
        }
    }

    private void createTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.changeCursorTask = new TimerTask(){

            @Override
            public void run() {
                CheckBoxTree.this.timerActive = true;
                CheckBoxTree.this.changeCursorCommand.apply(CheckBoxTree.this.getParent());
                this.cancel();
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("selectionMode")) {
            this.treeDidChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iconAction(TreePath path, Rectangle bounds) {
        try {
            this.startTiming();
            int state = this.getCheckedState(path);
            if (state == 8 || state == 64) {
                this.checkChildren(path, false, true);
            } else {
                if (this.isPathCached(path)) {
                    this.restoreState(path);
                } else {
                    this.cacheState(path);
                    this.checkChildren(path, true, true);
                }
                if (bounds == null) {
                    bounds = this.getPathBounds(path);
                }
                this.repaint(bounds);
            }
        }
        finally {
            this.stopTiming();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (this.getCheckedModel() != null) {
            if (!this.mInternalCheckOperation) {
                this.mCheckedStateCacheDirty = true;
            }
            this.mInternalCheckOperation = false;
            this.repaint();
        }
    }

    public void setWrapperCellRenderer(TreeCellRenderer newRenderer) {
        if (this.checkRenderer != null) {
            this.checkRenderer.setCellRenderer(newRenderer);
        }
    }

    public boolean isShowSelectionIcon() {
        return this.showSelectionIcon;
    }

    public void setShowSelectionIcon(boolean showSelectionIcon) {
        if (this.showSelectionIcon != showSelectionIcon) {
            this.showSelectionIcon = showSelectionIcon;
            this.firePropertyChange("showSelectionIcon", this.showSelectionIcon ? Boolean.FALSE : Boolean.TRUE, this.showSelectionIcon ? Boolean.TRUE : Boolean.FALSE);
            this.treeDidChange();
        }
    }

    public boolean isCheckBoxOnRootNode() {
        return this.checkBoxOnRootNode;
    }

    public void setCheckBoxOnRootNode(boolean checkBoxOnRootNode) {
        if (this.checkBoxOnRootNode != checkBoxOnRootNode) {
            this.checkBoxOnRootNode = checkBoxOnRootNode;
            this.firePropertyChange("checkBoxOnRootNode", this.checkBoxOnRootNode ? Boolean.FALSE : Boolean.TRUE, this.checkBoxOnRootNode ? Boolean.TRUE : Boolean.FALSE);
            this.treeDidChange();
        }
    }

    public boolean isCheckBoxShouldCheckChildren() {
        return this.checkBoxShouldCheckChildren;
    }

    public void setCheckBoxShouldCheckChildren(boolean checkBoxShouldCheckChildren) {
        this.checkBoxShouldCheckChildren = checkBoxShouldCheckChildren;
    }

    private Collection getOrderedCheckedCollection(int order) {
        TreePath[] paths;
        if (this.getCheckedModel() != null && (paths = this.getCheckedModel().getSelectionPaths()) != null) {
            TreeSet<TreePath> treeSet = null;
            if (order == 34) {
                PreOrderTreePathComparator comparator = new PreOrderTreePathComparator(this.getModel());
                treeSet = new TreeSet(comparator);
            } else if (order == 35) {
                PostOrderTreePathComparator comparator = new PostOrderTreePathComparator(this.getModel());
                treeSet = new TreeSet(comparator);
            } else {
                treeSet = new TreeSet<TreePath>();
            }
            treeSet.addAll(Arrays.asList(paths));
            return treeSet;
        }
        return new ArrayList();
    }

    public boolean isCheckBoxShouldCheckParents() {
        return this.checkBoxShouldCheckParents;
    }

    public void setCheckBoxShouldCheckParents(boolean checkBoxShouldCheckParents) {
        this.checkBoxShouldCheckParents = checkBoxShouldCheckParents;
    }

    @SASScope
    class NodeSelectionListener
    extends MouseInputAdapter {
        CheckBoxTree tree;

        NodeSelectionListener(CheckBoxTree tree) {
            this.tree = tree;
        }

        private boolean inCheckBox(int relX, int relY) {
            return CheckBoxTree.this.checkBoxIcon != null && CheckBoxTree.this.checkBoxInsets != null && ((CheckBoxTree)CheckBoxTree.this).checkBoxInsets.left <= relX && ((CheckBoxTree)CheckBoxTree.this).checkBoxInsets.left + CheckBoxTree.this.checkBoxIcon.getIconWidth() >= relX && ((CheckBoxTree)CheckBoxTree.this).checkBoxInsets.top <= relY && ((CheckBoxTree)CheckBoxTree.this).checkBoxInsets.top + CheckBoxTree.this.checkBoxIcon.getIconHeight() >= relY;
        }

        private boolean inIcon(int relX, int relY, TreePath path, Rectangle bounds) {
            Icon icon;
            if (CheckBoxTree.this.checkBoxIcon != null && CheckBoxTree.this.checkBoxInsets != null && (icon = this.tree.getIconForCheckedState(this.tree.getCheckedState(path))) != null) {
                int checkBoxSpace = 0;
                if (this.tree.isCheckBoxVisibleForPath(path)) {
                    checkBoxSpace = ((CheckBoxTree)CheckBoxTree.this).checkBoxInsets.left + CheckBoxTree.this.checkBoxIcon.getIconWidth() + ((CheckBoxTree)CheckBoxTree.this).checkBoxInsets.right + 5;
                }
                int iconStartY = (bounds.height - icon.getIconHeight()) / 2;
                if (checkBoxSpace <= relX && checkBoxSpace + icon.getIconWidth() >= relX && iconStartY <= relY && iconStartY + icon.getIconHeight() >= relY) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (CheckBoxTree.this.checkRenderer.getPressedRow() != -1) {
                CheckBoxTree.this.checkRenderer.setArmedRow(-1);
                this.tree.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (CheckBoxTree.this.checkRenderer.getPressedRow() != -1) {
                int y;
                int x = e.getX();
                int row = this.tree.getRowForLocation(x, y = e.getY());
                TreePath path = this.tree.getPathForRow(row);
                if (path != null) {
                    Rectangle bounds = this.tree.getPathBounds(path);
                    if (row != CheckBoxTree.this.checkRenderer.getPressedRow()) {
                        TreePath oldPath;
                        int oldArm = CheckBoxTree.this.checkRenderer.getArmedRow();
                        CheckBoxTree.this.checkRenderer.setArmedRow(-1);
                        if (oldArm != -1 && (oldPath = this.tree.getPathForRow(oldArm)) != null) {
                            this.tree.repaint(this.tree.getPathBounds(oldPath));
                        }
                    } else {
                        boolean ltr = this.tree.getComponentOrientation().isLeftToRight();
                        int relX = -1;
                        relX = ltr ? x - bounds.x : bounds.x + bounds.width - x;
                        int relY = y - bounds.y;
                        if (CheckBoxTree.this.isCheckBoxVisibleForRow(row) && CheckBoxTree.this.checkRenderer.getCheckBoxHasFocus() && CheckBoxTree.this.isCheckBoxEnabledForPath(path)) {
                            if (this.inCheckBox(relX, relY)) {
                                CheckBoxTree.this.checkRenderer.setArmedRow(row);
                            } else {
                                CheckBoxTree.this.checkRenderer.setArmedRow(-1);
                            }
                        }
                        if (CheckBoxTree.this.isIconVisibleForPath(path) && !CheckBoxTree.this.checkRenderer.getCheckBoxHasFocus()) {
                            if (this.inIcon(relX, relY, path, bounds)) {
                                CheckBoxTree.this.checkRenderer.setArmedRow(row);
                            } else {
                                CheckBoxTree.this.checkRenderer.setArmedRow(-1);
                            }
                        }
                    }
                    this.tree.repaint(bounds);
                } else if (CheckBoxTree.this.checkRenderer.getArmedRow() != -1) {
                    TreePath oldPath;
                    int oldArm = CheckBoxTree.this.checkRenderer.getArmedRow();
                    CheckBoxTree.this.checkRenderer.setArmedRow(-1);
                    if (oldArm != -1 && (oldPath = this.tree.getPathForRow(oldArm)) != null) {
                        this.tree.repaint(this.tree.getPathBounds(oldPath));
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = this.tree.getRowForLocation(x, y = e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path != null && CheckBoxTree.this.isCheckBoxVisibleForPath(path)) {
                int relY;
                Rectangle bounds = this.tree.getPathBounds(path);
                boolean ltr = this.tree.getComponentOrientation().isLeftToRight();
                int relX = -1;
                relX = ltr ? x - bounds.x : bounds.x + bounds.width - x;
                if (this.inCheckBox(relX, relY = y - bounds.y) && CheckBoxTree.this.isCheckBoxEnabledForPath(path)) {
                    CheckBoxTree.this.checkRenderer.setCheckBoxHasFocus(true);
                    CheckBoxTree.this.checkRenderer.setArmedRow(row);
                    CheckBoxTree.this.checkRenderer.setPressedRow(row);
                    this.tree.repaint(bounds);
                }
                if (CheckBoxTree.this.isIconVisibleForPath(path) && this.inIcon(relX, relY, path, bounds)) {
                    CheckBoxTree.this.checkRenderer.setCheckBoxHasFocus(false);
                    CheckBoxTree.this.checkRenderer.setArmedRow(row);
                    CheckBoxTree.this.checkRenderer.setPressedRow(row);
                    this.tree.repaint(bounds);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TreePath path;
            boolean hasFocus;
            int x = e.getX();
            int y = e.getY();
            int row = this.tree.getRowForLocation(x, y);
            int lsr = this.tree.getLeadSelectionRow();
            CheckBoxTree.this.checkRenderer.setPressedRow(-1);
            CheckBoxTree.this.checkRenderer.setArmedRow(-1);
            boolean bl = hasFocus = this.tree.isFocusOwner() && lsr == row;
            if (hasFocus && (path = this.tree.getPathForRow(row)) != null) {
                Rectangle bounds = this.tree.getPathBounds(path);
                boolean ltr = this.tree.getComponentOrientation().isLeftToRight();
                int relX = -1;
                relX = ltr ? x - bounds.x : bounds.x + bounds.width - x;
                int relY = y - bounds.y;
                if (CheckBoxTree.this.isCheckBoxVisibleForPath(path) && CheckBoxTree.this.isCheckBoxEnabledForPath(path)) {
                    boolean sel = this.tree.getCheckedModel().isRowSelected(row);
                    if (this.inCheckBox(relX, relY) && CheckBoxTree.this.checkRenderer.getCheckBoxHasFocus()) {
                        CheckBoxTree.this.mInternalCheckOperation = true;
                        if (sel) {
                            if (CheckBoxTree.this.isCheckBoxShouldCheckChildren()) {
                                this.tree.checkChildren(path, false, true);
                            }
                            this.tree.getCheckedModel().removeSelectionPath(path);
                        } else {
                            if (CheckBoxTree.this.isCheckBoxShouldCheckChildren()) {
                                this.tree.checkChildren(path, true, true);
                            }
                            if (CheckBoxTree.this.isCheckBoxShouldCheckParents()) {
                                this.tree.checkParents(path, true, true);
                            }
                            this.tree.getCheckedModel().addSelectionPath(path);
                        }
                        CheckBoxTree.this.updateCheckedCache(path);
                    }
                }
                if (CheckBoxTree.this.isIconVisibleForPath(path) && this.inIcon(relX, relY, path, bounds) && !CheckBoxTree.this.checkRenderer.getCheckBoxHasFocus()) {
                    CheckBoxTree.this.iconAction(path, bounds);
                }
            }
            CheckBoxTree.this.checkRenderer.setCheckBoxHasFocus(false);
        }
    }

    @SASScope
    public class CheckNodeAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath selPath = CheckBoxTree.this.getLeadSelectionPath();
            if (selPath != null && CheckBoxTree.this.isCheckBoxVisibleForPath(selPath) && CheckBoxTree.this.isCheckBoxEnabledForPath(selPath)) {
                CheckBoxTree.this.mInternalCheckOperation = true;
                boolean sel = CheckBoxTree.this.getCheckedModel().isPathSelected(selPath);
                if (sel) {
                    if (CheckBoxTree.this.isCheckBoxShouldCheckChildren()) {
                        CheckBoxTree.this.checkChildren(selPath, false, true);
                    }
                    CheckBoxTree.this.getCheckedModel().removeSelectionPath(selPath);
                } else {
                    if (CheckBoxTree.this.isCheckBoxShouldCheckChildren()) {
                        CheckBoxTree.this.checkChildren(selPath, true, true);
                    }
                    if (CheckBoxTree.this.isCheckBoxShouldCheckParents()) {
                        CheckBoxTree.this.checkParents(selPath, true, true);
                    }
                    CheckBoxTree.this.getCheckedModel().addSelectionPath(selPath);
                }
                CheckBoxTree.this.updateCheckedCache(selPath);
            }
        }
    }

    @SASScope
    public class ToggleCheckedChildrenAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath selPath = CheckBoxTree.this.getLeadSelectionPath();
            if (selPath != null && CheckBoxTree.this.isIconVisibleForPath(selPath)) {
                CheckBoxTree.this.iconAction(selPath, null);
            }
        }
    }

    @SASScope
    class PreOrderTreePathComparator
    implements Comparator {
        private TreeModel model;

        public PreOrderTreePathComparator(TreeModel model) {
            this.model = model;
        }

        public int compare(Object o1, Object o2) {
            TreePath path1 = (TreePath)o1;
            TreePath path2 = (TreePath)o2;
            Object[] paths1 = path1.getPath();
            Object[] paths2 = path2.getPath();
            for (int i = 1; i < Math.min(paths1.length, paths2.length); ++i) {
                int index2;
                int index1 = this.model.getIndexOfChild(paths1[i - 1], paths1[i]);
                if (index1 > (index2 = this.model.getIndexOfChild(paths2[i - 1], paths2[i]))) {
                    return 1;
                }
                if (index1 >= index2) continue;
                return -1;
            }
            if (paths1.length > paths2.length) {
                return 1;
            }
            if (paths1.length < paths2.length) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    @SASScope
    class PostOrderTreePathComparator
    implements Comparator {
        private TreeModel model;

        public PostOrderTreePathComparator(TreeModel model) {
            this.model = model;
        }

        public int compare(Object o1, Object o2) {
            TreePath path1 = (TreePath)o1;
            TreePath path2 = (TreePath)o2;
            Object[] paths1 = path1.getPath();
            Object[] paths2 = path2.getPath();
            for (int i = 1; i < Math.min(paths1.length, paths2.length); ++i) {
                int index2;
                int index1 = this.model.getIndexOfChild(paths1[i - 1], paths1[i]);
                if (index1 > (index2 = this.model.getIndexOfChild(paths2[i - 1], paths2[i]))) {
                    return -1;
                }
                if (index1 >= index2) continue;
                return 1;
            }
            if (paths1.length > paths2.length) {
                return 1;
            }
            if (paths1.length < paths2.length) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

