/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.CalendarDayButton;
import com.sas.swing.visuals.CalendarNavigationAction;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.text.NLFormats;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@SASScope(value="ALL")
public class CalendarPanel
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    public static final String RB_KEY = "CalendarPanel.";
    public static final String VALUE_CHANGED = "valueChanged";
    public static final String DATE_CHANGED = "dateChanged";
    public static final String TIME_CHANGED = "timeChanged";
    public static final String SIZE_CHANGED = "sizeChanged";
    protected String accessibleNamePrefix;
    protected GregorianCalendar todayDate;
    protected GregorianCalendar selectedDate;
    protected GregorianCalendar displayDate;
    protected GregorianCalendar maxDate;
    protected GregorianCalendar minDate;
    protected TimeZone timeZone;
    protected CalendarDayButton selectedDayButton;
    protected DateFormat todayDateFormat;
    protected Font weekdayHeaderFont;
    protected JPanel monthAndYearPanel;
    protected JPanel daysPanel;
    protected JPanel weeksPanel;
    protected JPanel mainPanel;
    protected JPanel buttonPanel;
    protected JPanel timePanel;
    private JPanel monthButtonPanel;
    protected JPanel daysUserContentPanel;
    protected Icon LEFT_ARROW = null;
    protected Icon RIGHT_ARROW = null;
    protected Icon DOUBLE_LEFT_ARROW = null;
    protected Icon DOUBLE_RIGHT_ARROW = null;
    protected Icon CALENDAR_CLOCK_ICON = null;
    protected String GO_TO_SELECTED_DATE_TEXT = null;
    protected String GO_TO_SELECTED_DATE_TOOLTIP = null;
    protected String GO_TO_TODAY_FMT = null;
    protected String GO_TO_TODAY_TOOLTIP = null;
    protected String TIME_PANEL_TEXT = null;
    protected JButton nextYearButton;
    protected JButton prevYearButton;
    protected JButton prevDisplayMonthButton;
    protected JButton nextDisplayMonthButton;
    protected JButton goToButton;
    protected JButton timeButton;
    protected JButton okButton;
    protected JLabel monthLabel;
    protected JLabel quarterLabel;
    protected JLabel yearLabel;
    protected ComboBox headingMonthComboBox;
    protected ComboBox headingQuarterComboBox;
    protected JSpinner headingYearSpinner;
    protected JLabel timeLabel;
    protected JSpinner timeSpinner;
    protected int goToMode;
    public static final int GO_TO_TODAY = 0;
    public static final int GO_TO_CURRENT_DATE = 0;
    public static final int GO_TO_SELECTED_DATE = 1;
    protected boolean enabled;
    protected int daysInMonth;
    protected boolean okClicked;
    protected boolean showWeekdayHeaders;
    protected Vector vectorDays;
    protected boolean timePanelVisible;
    protected boolean timeMode24Hour;
    protected boolean showSeconds;
    protected Color todayOutlineColor;
    private boolean ignoreEvents = false;
    public static final int DAY_SELECTION = 10;
    public static final int WEEK_SELECTION = 20;
    public static final int MONTH_SELECTION = 30;
    public static final int QUARTER_SELECTION = 40;
    public static final int TIME_SELECTION = 50;
    public static final int WEEKDAY_SELECTION = 60;
    protected int weekStartingDay;
    protected int minimalDaysInFirstWeek;
    protected boolean showWeekNumbers;
    protected boolean showCalendar;
    protected boolean showMonthQuarterYearLabels;
    protected int selectMode;
    protected Vector vectorWeeks;
    private AutoSizingGridLayout monthAndYearLayout;

    public CalendarPanel() {
        this(new GregorianCalendar());
    }

    public CalendarPanel(TimeZone timeZone) {
        this(new GregorianCalendar(timeZone));
    }

    public CalendarPanel(GregorianCalendar date) {
        this.setTimeZone(date.getTimeZone());
        this.todayDate = this.getNewCalendar();
        this.displayDate = this.getNewCalendar();
        try {
            this.LEFT_ARROW = Resources.getImageIcon((String)RB.getStringResource(RB_KEY, "leftArrow.image"));
            this.RIGHT_ARROW = Resources.getImageIcon((String)RB.getStringResource(RB_KEY, "rightArrow.image"));
            this.DOUBLE_LEFT_ARROW = Resources.getImageIcon((String)RB.getStringResource(RB_KEY, "doubleLeftArrow.image"));
            this.DOUBLE_RIGHT_ARROW = Resources.getImageIcon((String)RB.getStringResource(RB_KEY, "doubleRightArrow.image"));
            this.CALENDAR_CLOCK_ICON = Resources.getImageIcon((String)RB.getStringResource(RB_KEY, "calendarClock.image"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.GO_TO_TODAY_FMT = RB.getStringResource(RB_KEY, "today.txt");
        this.GO_TO_SELECTED_DATE_TEXT = RB.getStringResource(RB_KEY, "selectedDateTime.txt");
        this.GO_TO_SELECTED_DATE_TOOLTIP = RB.getStringResource(RB_KEY, "goToSelectedDate.toolTip.txt");
        this.GO_TO_TODAY_TOOLTIP = RB.getStringResource(RB_KEY, "goToToday.toolTip.txt");
        this.TIME_PANEL_TEXT = RB.getStringResource(RB_KEY, "hoursMinutes.txt");
        this.init();
        try {
            this.initializeUI();
            this.layoutUI();
            this.setAccessibleNames();
            this.setCurrentDate(date);
            this.showOKButton(false);
            this.showTimeButton(false);
            this.set24HourTime(false);
            this.setEnabled(true);
            this.setGoToButtonMode(0);
            this.setShowWeekdayHeaders(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addPropertyChangeListener(this);
    }

    protected void init() {
        ActionMap actionMap;
        InputMap inputMap;
        CalendarDayButton button;
        int i;
        this.accessibleNamePrefix = "";
        this.showWeekNumbers = false;
        this.showCalendar = true;
        this.selectMode = 10;
        this.okClicked = false;
        CalendarNavigationAction upAction = new CalendarNavigationAction(this, 111);
        CalendarNavigationAction downAction = new CalendarNavigationAction(this, 211);
        CalendarNavigationAction leftAction = new CalendarNavigationAction(this, 311);
        CalendarNavigationAction rightAction = new CalendarNavigationAction(this, 411);
        this.vectorDays = new Vector();
        for (i = 0; i < 42; ++i) {
            button = new CalendarDayButton();
            inputMap = button.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "selectDayInPreviousWeek");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "selectDayInNextWeek");
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "selectPreviousDay");
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "selectNextDay");
            actionMap = button.getActionMap();
            actionMap.put("selectDayInPreviousWeek", upAction);
            actionMap.put("selectDayInNextWeek", downAction);
            actionMap.put("selectPreviousDay", leftAction);
            actionMap.put("selectNextDay", rightAction);
            this.vectorDays.add(button);
            button.addPropertyChangeListener(this);
        }
        this.vectorWeeks = new Vector();
        for (i = 0; i < 6; ++i) {
            button = new CalendarDayButton();
            button.setDateFormat("ww");
            inputMap = button.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "selectPreviousWeek");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "selectNextWeek");
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "selectPreviousWeek");
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "selectNextWeek");
            actionMap = button.getActionMap();
            actionMap.put("selectPreviousWeek", upAction);
            actionMap.put("selectNextWeek", downAction);
            actionMap.put("selectPreviousWeek", leftAction);
            actionMap.put("selectNextWeek", rightAction);
            this.vectorWeeks.add(button);
            button.addPropertyChangeListener(this);
        }
        this.prevYearButton = new JButton(this.DOUBLE_LEFT_ARROW);
        if (this.DOUBLE_LEFT_ARROW == null) {
            this.prevYearButton.setText(">>");
        }
        this.prevDisplayMonthButton = new JButton(this.LEFT_ARROW);
        if (this.LEFT_ARROW == null) {
            this.prevDisplayMonthButton.setText("<");
        }
        this.nextDisplayMonthButton = new JButton(this.RIGHT_ARROW);
        if (this.RIGHT_ARROW == null) {
            this.nextDisplayMonthButton.setText(">");
        }
        this.nextYearButton = new JButton(this.DOUBLE_RIGHT_ARROW);
        if (this.DOUBLE_RIGHT_ARROW == null) {
            this.nextYearButton.setText(">>");
        }
        this.weekdayHeaderFont = new Font("Helvetica", 1, 12);
        this.todayDateFormat = DateFormat.getDateInstance();
    }

    public void setAccessibleNamePrefix(String prefix) {
        this.accessibleNamePrefix = prefix;
        this.setAccessibleNames();
    }

    protected void setAccessibleNames() {
        this.nextYearButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "nextYearButton");
        this.prevYearButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "prevYearButton");
        this.prevDisplayMonthButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "prevDisplayMonthButton");
        this.nextDisplayMonthButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "nextDisplayMonthButton");
        this.goToButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "goToButton");
        this.timeButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "timeButton");
        this.okButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "okButton");
        this.headingMonthComboBox.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "headingMonthComboBox");
        this.headingQuarterComboBox.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "headingQuarterComboBox");
        if (this.showWeekNumbers) {
            for (int i = 0; i < 5; ++i) {
                CalendarDayButton dayButton = this.getWeekButton(i);
                dayButton.getAccessibleContext().setAccessibleName(this.accessibleNamePrefix + "weekButton" + i);
            }
        }
    }

    public void setShowWeekdayHeaders(boolean show) {
        if (this.showWeekdayHeaders == show) {
            return;
        }
        this.showWeekdayHeaders = show;
        GridLayout gridLayout = (GridLayout)this.daysPanel.getLayout();
        gridLayout.setRows(show ? 7 : 6);
        this.updateDayComponents();
    }

    public boolean getShowWeekdayHeaders() {
        return this.showWeekdayHeaders;
    }

    protected void initializeUI() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(0, 1, 0, 5, true, false, true);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.mainPanel.setLayout(mainLayout);
        this.monthAndYearPanel = new JPanel();
        this.monthAndYearPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.monthAndYearLayout = new AutoSizingGridLayout(2, 0, 5, 5, true, false, true);
        this.monthAndYearLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.monthAndYearLayout.setRemainderColumn(3);
        this.monthAndYearPanel.setLayout(this.monthAndYearLayout);
        this.quarterLabel = new JLabel(RB.getStringResource(RB_KEY, "quarterLabel.txt"));
        this.quarterLabel.setVisible(false);
        this.monthLabel = new JLabel(RB.getStringResource(RB_KEY, "monthLabel.txt"));
        this.monthLabel.setVisible(false);
        this.yearLabel = new JLabel(RB.getStringResource(RB_KEY, "yearLabel.txt"));
        this.yearLabel.setVisible(false);
        this.headingMonthComboBox = new ComboBox();
        this.headingMonthComboBox.setMaximumRowCount(12);
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "january.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "february.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "march.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "april.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "may.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "june.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "july.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "august.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "september.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "october.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "november.txt"));
        this.headingMonthComboBox.addItem(RB.getStringResource(RB_KEY, "december.txt"));
        String longestValue = "";
        for (int i = 0; i < this.headingMonthComboBox.getItemCount(); ++i) {
            String item = (String)this.headingMonthComboBox.getItemAt(i);
            if (item.length() <= longestValue.length()) continue;
            longestValue = item;
        }
        this.headingMonthComboBox.setPrototypeDisplayValue(longestValue + " ");
        this.headingMonthComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.setDisplayMonth(CalendarPanel.this.headingMonthComboBox.getSelectedIndex());
                CalendarPanel.this.updateMonthComponents();
            }
        });
        this.headingQuarterComboBox = new ComboBox();
        this.headingQuarterComboBox.setMaximumRowCount(4);
        this.headingQuarterComboBox.addItem(RB.getStringResource(RB_KEY, "q1.txt"));
        this.headingQuarterComboBox.addItem(RB.getStringResource(RB_KEY, "q2.txt"));
        this.headingQuarterComboBox.addItem(RB.getStringResource(RB_KEY, "q3.txt"));
        this.headingQuarterComboBox.addItem(RB.getStringResource(RB_KEY, "q4.txt"));
        this.headingQuarterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.setDisplayQuarter(CalendarPanel.this.headingQuarterComboBox.getSelectedIndex());
            }
        });
        this.headingQuarterComboBox.setVisible(false);
        SpinnerDateModel dateModel = new SpinnerDateModel();
        this.headingYearSpinner = new JSpinner(dateModel);
        this.headingYearSpinner.setEditor(new JSpinner.DateEditor(this.headingYearSpinner, "yyyy"));
        this.headingYearSpinner.addChangeListener(this);
        this.headingYearSpinner.setFont(this.headingMonthComboBox.getFont());
        this.daysPanel = new JPanel(new GridLayout(7, 7));
        this.daysPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.daysPanel.setBackground(Color.white);
        this.weeksPanel = new JPanel(new GridLayout(7, 1));
        this.weeksPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.weeksPanel.setBackground(Color.white);
        this.weeksPanel.setVisible(false);
        this.daysUserContentPanel = new JPanel();
        this.daysUserContentPanel.setPreferredSize(new Dimension(0, 0));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.goToButton = new JButton();
        this.goToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.goToDate();
            }
        });
        this.prevYearButton.setToolTipText(RB.getStringResource(RB_KEY, "prevYear.toolTip.txt"));
        if (this.DOUBLE_LEFT_ARROW != null) {
            this.prevYearButton.setPreferredSize(new Dimension(24, 24));
        }
        this.prevYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.goPrevYear();
            }
        });
        this.prevDisplayMonthButton.setToolTipText(RB.getStringResource(RB_KEY, "prevMonth.toolTip.txt"));
        this.prevDisplayMonthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.goPrevDisplayMonth();
            }
        });
        this.nextDisplayMonthButton.setToolTipText(RB.getStringResource(RB_KEY, "nextMonth.toolTip.txt"));
        this.nextDisplayMonthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.goNextDisplayMonth();
            }
        });
        this.nextYearButton.setToolTipText(RB.getStringResource(RB_KEY, "nextYear.toolTip.txt"));
        if (this.DOUBLE_RIGHT_ARROW != null) {
            this.nextYearButton.setPreferredSize(new Dimension(24, 24));
        }
        this.nextYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.goNextYear();
            }
        });
        this.timeButton = new JButton(this.CALENDAR_CLOCK_ICON);
        this.timeButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 2));
        this.timeButton.setToolTipText(RB.getStringResource(RB_KEY, "expandTimePanel.toolTip.txt"));
        this.timeButton.setCursor(new Cursor(12));
        this.timeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.showTimePanel(!CalendarPanel.this.timePanelVisible);
            }
        });
        this.okButton = new JButton(RB.getStringResource(RB_KEY, "okButton.txt"));
        this.okButton.setToolTipText(RB.getStringResource(RB_KEY, "selectDate.toolTip.txt"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.dateSelected();
            }
        });
        this.timePanel = new JPanel();
        this.timeLabel = new JLabel(this.TIME_PANEL_TEXT);
        SpinnerDateModel timeModel = new SpinnerDateModel();
        this.timeSpinner = new JSpinner(timeModel);
        this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, NLFormats.getPattern((String)"NLTIMNAP", (Locale)this.getLocale())));
        ((JSpinner.DateEditor)this.timeSpinner.getEditor()).getFormat().setLenient(false);
        this.timeSpinner.addChangeListener(this);
        this.timeSpinner.setFont(this.headingMonthComboBox.getFont());
        this.showTimePanel(false);
    }

    protected void layoutUI() throws Exception {
        this.addComponents();
        this.updateDateComponents();
    }

    protected void addComponents() {
        this.mainPanel.add(this.monthAndYearPanel);
        JPanel dayPanelContainer = new JPanel();
        AutoSizingGridLayout dayPanelLayout = new AutoSizingGridLayout(1, -1, 0, 0, true, true, true);
        dayPanelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        dayPanelContainer.setLayout(dayPanelLayout);
        dayPanelContainer.add(this.weeksPanel);
        dayPanelContainer.add(this.daysPanel);
        this.mainPanel.add(dayPanelContainer);
        this.mainPanel.add(this.timePanel);
        this.mainPanel.add(this.daysUserContentPanel);
        this.mainPanel.add(this.buttonPanel);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setVisible(false);
        this.monthAndYearPanel.add(emptyPanel);
        this.monthAndYearPanel.add(this.quarterLabel);
        this.monthAndYearPanel.add(this.monthLabel);
        this.monthAndYearPanel.add(this.yearLabel);
        this.monthButtonPanel = new JPanel(new AutoSizingGridLayout(1, 2, 0, 0, true, false, false));
        this.monthButtonPanel.add(this.prevDisplayMonthButton);
        this.monthButtonPanel.add(this.nextDisplayMonthButton);
        this.monthAndYearPanel.add(this.monthButtonPanel);
        this.monthAndYearPanel.add(this.headingQuarterComboBox);
        this.monthAndYearPanel.add(this.headingMonthComboBox);
        this.monthAndYearPanel.add(this.headingYearSpinner);
        this.buttonPanel.add(this.goToButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.timeButton);
        this.buttonPanel.add(this.okButton);
        this.timePanel.add(this.timeLabel);
        this.timePanel.add(this.timeSpinner);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.mainPanel);
    }

    protected void updateDateComponents() {
        this.updateMonthQuarterYearComponents();
        this.updateGoToButton();
    }

    protected void updateMonthQuarterYearComponents() {
        try {
            this.ignoreEvents = true;
            this.updateMonthComponents();
            this.updateQuarterComponents();
            this.updateYearComponents();
        }
        finally {
            this.ignoreEvents = false;
            this.updateDayComponents();
        }
    }

    protected void updateMonthComponents() {
        this.headingMonthComboBox.setSelectedIndex(this.displayDate.get(2));
        int year = this.displayDate.get(1);
        int month = this.displayDate.get(2);
        if (this.enabled) {
            this.prevDisplayMonthButton.setEnabled(year > 1 || month > 0);
        }
    }

    protected void updateQuarterComponents() {
        this.headingQuarterComboBox.setSelectedIndex(this.displayDate.get(2) / 3);
    }

    protected void updateYearComponents() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(1, this.displayDate.get(1));
        this.headingYearSpinner.setValue(gc.getTime());
    }

    protected void updateDayComponents() {
        if (!this.ignoreEvents) {
            this.daysPanel.removeAll();
            this.weeksPanel.removeAll();
            if (this.showWeekdayHeaders) {
                if (this.showWeekNumbers) {
                    JLabel dayName = new JLabel(RB.getStringResource(RB_KEY, "weekNumberLabel.txt"));
                    dayName.setFont(this.weekdayHeaderFont);
                    dayName.setToolTipText(RB.getStringResource(RB_KEY, "weekNumberLabelToolTip.txt"));
                    dayName.setHorizontalAlignment(0);
                    dayName.setEnabled(this.enabled);
                    this.weeksPanel.add(dayName);
                }
                DateFormatSymbols symbols = new DateFormatSymbols();
                for (int nameOfDay = 1; nameOfDay <= 7; ++nameOfDay) {
                    int day = nameOfDay;
                    if (this.weekStartingDay != 0) {
                        day = (this.weekStartingDay + nameOfDay - 2) % 7 + 1;
                    }
                    String fullName = symbols.getWeekdays()[day];
                    String shortName = symbols.getShortWeekdays()[day];
                    JLabel dayName = new JLabel(shortName);
                    dayName.setFont(this.weekdayHeaderFont);
                    dayName.setToolTipText(fullName);
                    dayName.setHorizontalAlignment(0);
                    dayName.setEnabled(this.enabled);
                    this.daysPanel.add(dayName);
                }
            }
            GregorianCalendar prevDisplayMonth = this.getNewCalendar();
            prevDisplayMonth.setTime(this.displayDate.getTime());
            prevDisplayMonth.add(2, -1);
            GregorianCalendar nextDisplayMonth = this.getNewCalendar();
            nextDisplayMonth.setTime(this.displayDate.getTime());
            nextDisplayMonth.add(2, 1);
            int dayIx = 0;
            int startDay = this.getFirstDayOfWeek(this.displayDate) - 1;
            if (this.weekStartingDay != 0) {
                startDay = startDay - this.weekStartingDay + 1;
            }
            if (startDay < 0) {
                startDay += 7;
            }
            int lastDayInPrevDisplayMonth = prevDisplayMonth.getActualMaximum(5);
            GregorianCalendar dayCalendar = this.getNewCalendar();
            dayCalendar.setTime(prevDisplayMonth.getTime());
            for (int day = startDay; day > 0; --day) {
                CalendarDayButton dayNumber;
                if (this.showWeekNumbers && dayIx % 7 == 0) {
                    dayNumber = this.getWeekButton(dayIx / 7);
                    dayCalendar.set(5, lastDayInPrevDisplayMonth - day + 1);
                    if (this.selectMode == 20) {
                        dayNumber.setType(0);
                    } else {
                        dayNumber.setType(2);
                    }
                    dayNumber.setText(dayCalendar);
                    dayNumber.setSelected(false);
                    this.weeksPanel.add(dayNumber);
                }
                dayNumber = this.getDayButton(dayIx++);
                dayCalendar.set(5, lastDayInPrevDisplayMonth - day + 1);
                dayNumber.setType(2);
                dayNumber.setText(dayCalendar);
                dayNumber.setSelected(false);
                this.daysPanel.add(dayNumber);
            }
            int todayYear = this.todayDate.get(1);
            int todayMonth = this.todayDate.get(2);
            int todayDay = this.todayDate.get(5);
            int todayWeek = this.todayDate.get(3);
            int selectedYear = this.selectedDate == null ? -1 : this.selectedDate.get(1);
            int selectedMonth = this.selectedDate == null ? -1 : this.selectedDate.get(2);
            int selectedDay = this.selectedDate == null ? -1 : this.selectedDate.get(5);
            int selectedWeek = this.selectedDate == null ? -1 : this.selectedDate.get(3);
            this.selectedDayButton = null;
            dayCalendar.setTime(this.displayDate.getTime());
            for (int day = 1; day <= this.daysInMonth; ++day) {
                int month;
                int year;
                CalendarDayButton dayNumber;
                if (this.showWeekNumbers && dayIx % 7 == 0) {
                    dayNumber = this.getWeekButton(dayIx / 7);
                    dayCalendar.set(5, day);
                    if (this.selectMode == 20) {
                        dayNumber.setType(0);
                    } else {
                        dayNumber.setType(2);
                    }
                    dayNumber.setText(dayCalendar);
                    dayNumber.setSelected(false);
                    if (this.selectMode == 20) {
                        year = dayCalendar.get(1);
                        month = dayCalendar.get(2);
                        int aWeek = dayCalendar.get(3);
                        if (this.maxDate != null && dayCalendar.after(this.maxDate)) {
                            dayNumber.setType(2);
                        } else if (this.minDate != null && dayCalendar.before(this.minDate)) {
                            dayNumber.setType(2);
                        } else if (year == todayYear && month == todayMonth && aWeek == todayWeek) {
                            dayNumber.setType(1);
                        } else {
                            dayNumber.setType(0);
                        }
                        if (this.selectedDate != null && year == selectedYear && month == selectedMonth && aWeek == selectedWeek) {
                            dayNumber.setSelected(true);
                            this.selectedDayButton = dayNumber;
                        }
                    }
                    this.weeksPanel.add(dayNumber);
                }
                dayNumber = this.getDayButton(dayIx++);
                dayCalendar.set(5, day);
                if (this.selectMode == 10) {
                    dayNumber.setType(0);
                } else if (this.selectMode == 60) {
                    int dayOfWeek = dayCalendar.get(7);
                    if (dayOfWeek == 7 || dayOfWeek == 1) {
                        dayNumber.setType(2);
                    } else {
                        dayNumber.setType(0);
                    }
                } else {
                    dayNumber.setType(2);
                }
                dayNumber.setText(dayCalendar);
                dayNumber.setSelected(false);
                if (this.selectMode == 10 || this.selectMode == 60) {
                    year = dayCalendar.get(1);
                    month = dayCalendar.get(2);
                    int aday = dayCalendar.get(5);
                    int dayOfWeek = dayCalendar.get(7);
                    boolean weekday = true;
                    if (dayOfWeek == 7 || dayOfWeek == 1) {
                        weekday = false;
                    }
                    if (this.maxDate != null && dayCalendar.after(this.maxDate)) {
                        dayNumber.setType(2);
                    } else if (this.minDate != null && dayCalendar.before(this.minDate)) {
                        dayNumber.setType(2);
                    } else if (year == todayYear && month == todayMonth && aday == todayDay) {
                        if (this.selectMode == 10 || weekday) {
                            dayNumber.setType(1);
                        }
                    } else if (this.selectMode == 10 || weekday) {
                        dayNumber.setType(0);
                    }
                    if (this.selectedDate != null && year == selectedYear && month == selectedMonth && aday == selectedDay) {
                        dayNumber.setSelected(true);
                        this.selectedDayButton = dayNumber;
                    }
                }
                this.daysPanel.add(dayNumber);
            }
            int daysInNextDisplayMonth = 43 - (startDay + this.daysInMonth);
            dayCalendar.setTime(nextDisplayMonth.getTime());
            for (int day = 1; day < daysInNextDisplayMonth; ++day) {
                CalendarDayButton dayNumber;
                if (this.showWeekNumbers && dayIx % 7 == 0) {
                    dayNumber = this.getWeekButton(dayIx / 7);
                    dayCalendar.set(5, day);
                    if (this.selectMode == 20) {
                        dayNumber.setType(0);
                    } else {
                        dayNumber.setType(2);
                    }
                    dayNumber.setText(dayCalendar);
                    dayNumber.setSelected(false);
                    this.weeksPanel.add(dayNumber);
                }
                dayNumber = this.getDayButton(dayIx++);
                dayNumber.setType(2);
                dayCalendar.set(5, day);
                dayNumber.setText(dayCalendar);
                dayNumber.setSelected(false);
                this.daysPanel.add(dayNumber);
            }
            this.mainPanel.updateUI();
        }
    }

    protected CalendarDayButton getDayButton(int ix) {
        return (CalendarDayButton)this.vectorDays.elementAt(ix);
    }

    protected CalendarDayButton getWeekButton(int ix) {
        return (CalendarDayButton)this.vectorWeeks.elementAt(ix);
    }

    @SASScope
    public CalendarDayButton getButtonForDay(int day) {
        int fdow = this.getFirstDayOfWeek(this.displayDate);
        int dayIndex = fdow - 1 + day - 1;
        if (this.weekStartingDay != 0) {
            dayIndex = dayIndex - this.weekStartingDay + 1;
        }
        if (fdow < this.weekStartingDay) {
            dayIndex += 7;
        }
        if (dayIndex < 0 || dayIndex > 41) {
            return null;
        }
        return (CalendarDayButton)this.vectorDays.elementAt(dayIndex);
    }

    @SASScope
    public CalendarDayButton getButtonForWeek(int week) {
        for (CalendarDayButton button : this.vectorWeeks) {
            if (week != button.getDate().get(3)) continue;
            return button;
        }
        return null;
    }

    protected void updateGoToButton() {
        String text = "";
        String toolTip = "";
        switch (this.goToMode) {
            case 0: {
                text = MessageFormat.format(this.GO_TO_TODAY_FMT, this.todayDateFormat.format(this.todayDate.getTime()));
                toolTip = this.GO_TO_TODAY_TOOLTIP;
                break;
            }
            case 1: {
                text = this.GO_TO_SELECTED_DATE_TEXT;
                toolTip = this.GO_TO_SELECTED_DATE_TOOLTIP;
            }
        }
        this.goToButton.setText(text);
        this.goToButton.setToolTipText(toolTip);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    protected GregorianCalendar getCalendarWithTimeZone(GregorianCalendar calendar, TimeZone timeZone) {
        if (calendar == null) {
            return null;
        }
        GregorianCalendar newCalendar = timeZone != null ? new GregorianCalendar(timeZone) : new GregorianCalendar();
        newCalendar.set(1, calendar.get(1));
        newCalendar.set(6, calendar.get(6));
        newCalendar.set(10, calendar.get(10));
        newCalendar.set(11, calendar.get(11));
        newCalendar.set(12, calendar.get(12));
        newCalendar.set(13, calendar.get(13));
        return newCalendar;
    }

    public GregorianCalendar getSelectedDate() {
        if (this.getSelectionMode() == 10 || this.getSelectionMode() == 60 || this.getSelectionMode() == 20) {
            return this.getCalendarWithTimeZone(this.selectedDate, this.timeZone);
        }
        if (this.getSelectionMode() == 50) {
            if (this.selectedDate != null) {
                return this.getCalendarWithTimeZone(this.selectedDate, this.timeZone);
            }
            return this.getCurrentDate();
        }
        if (this.getSelectionMode() == 30 || this.getSelectionMode() == 40) {
            return this.getCurrentDate();
        }
        return null;
    }

    public void setSelectedDate(GregorianCalendar aDate) {
        this.setSelectedDate(aDate, true);
    }

    protected void setSelectedDate(GregorianCalendar aDate, boolean redraw) {
        if (this.selectedDate != null && this.selectedDayButton != null) {
            this.selectedDayButton.setSelected(false);
        }
        if (aDate != null) {
            this.selectedDate = this.getCalendarWithTimeZone(aDate, null);
            this.addSpinnerTimeToDate(this.selectedDate);
        } else {
            this.selectedDate = null;
            if (this.selectedDayButton != null) {
                this.selectedDayButton.setSelected(false);
            }
        }
        this.firePropertyChange(DATE_CHANGED, null, null);
        if (redraw) {
            this.updateDayComponents();
        }
    }

    @SASScope
    public GregorianCalendar getSelectedWeek() {
        if (this.getSelectionMode() == 20) {
            return this.getCalendarWithTimeZone(this.selectedDate, this.timeZone);
        }
        return null;
    }

    @SASScope
    public void setSelectedWeek(GregorianCalendar aDate) {
        this.setSelectedDate(aDate, true);
    }

    protected void setSelectedWeek(GregorianCalendar aDate, boolean redraw) {
        this.setSelectedDate(aDate, redraw);
    }

    public GregorianCalendar getCurrentDate() {
        return this.getCalendarWithTimeZone(this.displayDate, this.timeZone);
    }

    public void setCurrentDate(GregorianCalendar date) {
        this.displayDate = this.getCalendarWithTimeZone(date, null);
        SpinnerDateModel timeModel = (SpinnerDateModel)this.timeSpinner.getModel();
        Date d = new Date(this.displayDate.getTimeInMillis());
        d.setHours(this.displayDate.get(11));
        d.setMinutes(this.displayDate.get(12));
        timeModel.setValue(d);
        this.updateDateComponents();
    }

    public GregorianCalendar getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(GregorianCalendar aDate) {
        this.maxDate = this.getCalendarWithTimeZone(aDate, null);
        if (this.maxDate != null) {
            DatePeriod max = null;
            if (this.getSelectionMode() == 10 || this.getSelectionMode() == 60) {
                max = new DatePeriod(this.maxDate.getTime(), DateTypes.DATE, this.maxDate.getTimeZone(), this.getLocale());
            } else if (this.getSelectionMode() == 50) {
                max = new DatePeriod(this.maxDate.getTime(), DateTypes.TIME, this.maxDate.getTimeZone(), this.getLocale());
            } else if (this.getSelectionMode() == 30) {
                max = new DatePeriod(this.maxDate.getTime(), DateTypes.MONTH, this.maxDate.getTimeZone(), this.getLocale());
            } else if (this.getSelectionMode() == 40) {
                max = new DatePeriod(this.maxDate.getTime(), DateTypes.QUARTER, this.maxDate.getTimeZone(), this.getLocale());
            } else if (this.getSelectionMode() == 20) {
                max = new DatePeriod(this.maxDate.getTime(), DateTypes.WEEK, this.maxDate.getTimeZone(), this.getLocale());
            }
            GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance(this.maxDate.getTimeZone());
            cal.setTime(max.getEndOfPeriod());
            this.maxDate = cal;
        }
    }

    public GregorianCalendar getMinDate() {
        return this.minDate;
    }

    public void setMinDate(GregorianCalendar aDate) {
        this.minDate = this.getCalendarWithTimeZone(aDate, null);
        if (this.minDate != null) {
            DatePeriod min = null;
            if (this.getSelectionMode() == 10 || this.getSelectionMode() == 60) {
                min = new DatePeriod(this.minDate.getTime(), DateTypes.DATE, this.minDate.getTimeZone(), this.getLocale());
            } else if (this.getSelectionMode() == 50) {
                min = new DatePeriod(this.minDate.getTime(), DateTypes.TIME, this.minDate.getTimeZone(), this.getLocale());
            } else if (this.getSelectionMode() == 30) {
                min = new DatePeriod(this.minDate.getTime(), DateTypes.MONTH, this.minDate.getTimeZone(), this.getLocale());
            } else if (this.getSelectionMode() == 40) {
                min = new DatePeriod(this.minDate.getTime(), DateTypes.QUARTER, this.minDate.getTimeZone(), this.getLocale());
            } else if (this.getSelectionMode() == 20) {
                min = new DatePeriod(this.minDate.getTime(), DateTypes.WEEK, this.minDate.getTimeZone(), this.getLocale());
            }
            GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance(this.minDate.getTimeZone());
            cal.setTime(min.getStartOfPeriod());
            this.minDate = cal;
        }
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public void setTodayDisplayFormat(DateFormat format) {
        this.todayDateFormat = format;
        this.updateGoToButton();
    }

    protected void goToDate() {
        GregorianCalendar date = null;
        switch (this.goToMode) {
            case 0: {
                date = this.todayDate = this.getNewCalendar();
                break;
            }
            case 1: {
                if (this.selectedDate == null) break;
                date = this.selectedDate;
            }
        }
        if (date != null && (this.maxDate == null || date.before(this.maxDate))) {
            this.displayDate.setTime(date.getTime());
            this.addDateToSpinnerTime(date);
            if (this.goToMode == 0) {
                this.setSelectedDate(this.todayDate);
            }
            this.updateDateComponents();
        }
    }

    public void goToSelectedDate() {
        this.updateDateComponents();
    }

    protected void goPrevDisplayMonth() {
        GregorianCalendar c = this.getNewCalendar();
        c.setTime(this.displayDate.getTime());
        c.roll(2, false);
        if (c.get(2) == 11) {
            c.roll(1, false);
        }
        if (this.minDate == null || c.after(this.minDate)) {
            this.displayDate.setTime(c.getTime());
            this.updateDateComponents();
        }
    }

    protected void goNextDisplayMonth() {
        GregorianCalendar c = this.getNewCalendar();
        c.setTime(this.displayDate.getTime());
        c.roll(2, true);
        if (c.get(2) == 0) {
            c.roll(1, true);
        }
        if (this.maxDate == null || c.before(this.maxDate)) {
            this.displayDate.setTime(c.getTime());
            this.updateDateComponents();
        }
    }

    protected void goPrevYear() {
        GregorianCalendar c = this.getNewCalendar();
        c.setTime(this.displayDate.getTime());
        c.roll(1, false);
        if (this.minDate == null || c.after(this.minDate)) {
            this.displayDate.setTime(c.getTime());
            this.updateDateComponents();
        }
    }

    protected void goNextYear() {
        GregorianCalendar c = this.getNewCalendar();
        c.setTime(this.displayDate.getTime());
        c.roll(1, true);
        if (this.maxDate == null || c.before(this.maxDate)) {
            this.displayDate.setTime(c.getTime());
            this.updateDateComponents();
        }
    }

    protected void dateSelected() {
        this.okClicked = true;
        this.dispose();
    }

    protected int getFirstDayOfWeek(GregorianCalendar calendar) {
        GregorianCalendar c = this.getNewCalendar();
        c.setTime(calendar.getTime());
        c.set(5, 1);
        this.daysInMonth = c.getActualMaximum(5);
        return c.get(7);
    }

    public void dispose() {
        this.firePropertyChange(VALUE_CHANGED, null, this.getSelectedDate());
    }

    public void setPrevYearButtonIcon(Icon icon) {
        if (icon != null) {
            this.prevYearButton.setText("");
            this.prevYearButton.setIcon(icon);
        }
    }

    public void setNextYearButtonIcon(Icon icon) {
        if (icon != null) {
            this.nextYearButton.setText("");
            this.nextYearButton.setIcon(icon);
        }
    }

    public void setPrevMonthButtonIcon(Icon icon) {
        if (icon != null) {
            this.prevDisplayMonthButton.setText("");
            this.prevDisplayMonthButton.setIcon(icon);
        }
    }

    public void setNextMonthButtonIcon(Icon icon) {
        if (icon != null) {
            this.nextDisplayMonthButton.setText("");
            this.nextDisplayMonthButton.setIcon(icon);
        }
    }

    protected void setDisplayMonth(int monthIndex) {
        this.displayDate.set(5, 1);
        this.displayDate.set(2, monthIndex);
        this.updateDayComponents();
    }

    protected void setDisplayQuarter(int quarterIndex) {
        this.displayDate.set(5, 1);
        int currentQuarter = this.displayDate.get(2) / 3;
        if (currentQuarter != quarterIndex) {
            this.displayDate.set(2, quarterIndex * 3);
        }
        this.updateDayComponents();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.headingYearSpinner) {
            int month = this.displayDate.get(2);
            int day = this.displayDate.get(5);
            int hour = this.displayDate.get(11);
            int minute = this.displayDate.get(12);
            int second = this.displayDate.get(13);
            Date date = (Date)this.headingYearSpinner.getValue();
            this.displayDate.setTime(date);
            this.displayDate.set(5, day);
            this.displayDate.set(2, month);
            this.displayDate.set(11, hour);
            this.displayDate.set(12, minute);
            this.displayDate.set(13, second);
            this.updateMonthComponents();
            this.updateDayComponents();
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            this.headingYearSpinner.getAccessibleContext().setAccessibleName(String.valueOf(c.get(1)));
        } else if (e.getSource() == this.timeSpinner) {
            if (this.selectMode == 50 && this.selectedDate == null) {
                this.selectedDate = this.getNewCalendar();
                this.selectedDate.setTime(this.displayDate.getTime());
            }
            if (this.selectedDate != null) {
                this.addSpinnerTimeToDate(this.selectedDate);
            }
            this.firePropertyChange(TIME_CHANGED, null, null);
        }
    }

    protected void addSpinnerTimeToDate(GregorianCalendar date) {
        if (date == null) {
            return;
        }
        Date spinnerDate = (Date)this.timeSpinner.getValue();
        date.set(11, spinnerDate.getHours());
        date.set(12, spinnerDate.getMinutes());
        date.set(13, spinnerDate.getSeconds());
    }

    protected void addDateToSpinnerTime(GregorianCalendar date) {
        if (date == null) {
            return;
        }
        Date spinnerDate = (Date)this.timeSpinner.getValue();
        spinnerDate.setHours(date.get(11));
        spinnerDate.setMinutes(date.get(12));
        spinnerDate.setSeconds(date.get(13));
        this.timeSpinner.setValue(spinnerDate);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource().getClass() == CalendarDayButton.class) {
            if (e.getPropertyName().equals("selectedState")) {
                CalendarDayButton dayButton = (CalendarDayButton)e.getSource();
                this.setSelectedDate(dayButton.getDate(), false);
                this.selectedDayButton = dayButton;
            }
        } else if (e.getSource() == this) {
            if (UIManager.getLookAndFeel().getID().compareToIgnoreCase("Motif") == 0) {
                this.nextDisplayMonthButton.setPreferredSize(new Dimension(32, 30));
                this.prevDisplayMonthButton.setPreferredSize(new Dimension(32, 30));
                this.timeButton.setPreferredSize(new Dimension(40, 25));
            } else {
                this.nextDisplayMonthButton.setPreferredSize(new Dimension(24, 24));
                this.prevDisplayMonthButton.setPreferredSize(new Dimension(24, 24));
                this.timeButton.setPreferredSize(new Dimension(25, 25));
            }
        }
    }

    public JButton getOKButton() {
        return this.okButton;
    }

    public void showOKButton(boolean show) {
        this.okButton.setVisible(show);
    }

    public void showTimeButton(boolean show) {
        this.timeButton.setVisible(show);
        this.updateGoToButton();
    }

    @SASScope
    public void showNextPrevMonthButtons(boolean show) {
        this.monthButtonPanel.setVisible(show);
    }

    @SASScope
    public void showMonthQuarterYearLabels(boolean show) {
        if (show) {
            if (this.selectMode == 30 || this.selectMode == 10 || this.selectMode == 20 || this.selectMode == 60) {
                this.monthLabel.setVisible(show);
            } else {
                this.monthLabel.setVisible(false);
            }
            if (this.selectMode == 40) {
                this.quarterLabel.setVisible(show);
            } else {
                this.quarterLabel.setVisible(false);
            }
        } else {
            this.monthLabel.setVisible(show);
            this.quarterLabel.setVisible(show);
        }
        this.yearLabel.setVisible(show);
        this.showMonthQuarterYearLabels = show;
    }

    public void enableTimeButton(boolean enabled) {
        if (this.enabled) {
            this.timeButton.setEnabled(enabled);
        }
    }

    public void showTimePanel(boolean show) {
        boolean changed = show != this.timePanelVisible;
        this.timePanelVisible = show;
        this.timePanel.setVisible(show);
        if (changed) {
            this.firePropertyChange(SIZE_CHANGED, null, null);
        }
    }

    public boolean get24HourTime() {
        return this.timeMode24Hour;
    }

    public void set24HourTime(boolean mode) {
        if (this.timeMode24Hour == mode) {
            return;
        }
        this.timeMode24Hour = mode;
        this.updateTimeEditor();
    }

    @SASScope
    public boolean isShowSeconds() {
        return this.showSeconds;
    }

    @SASScope
    public void setShowSeconds(boolean showSeconds) {
        if (this.showSeconds == showSeconds) {
            return;
        }
        this.showSeconds = showSeconds;
        this.updateTimeEditor();
    }

    private void updateTimeEditor() {
        if (this.timeMode24Hour) {
            if (this.showSeconds) {
                this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, NLFormats.getPattern((String)"NLTIME", (Locale)this.getLocale())));
            } else {
                this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, NLFormats.getPattern((String)"NLTIMENS", (Locale)this.getLocale())));
            }
        } else if (this.showSeconds) {
            this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, NLFormats.getPattern((String)"NLTIMAP", (Locale)this.getLocale())));
        } else {
            this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, NLFormats.getPattern((String)"NLTIMNAP", (Locale)this.getLocale())));
        }
        ((JSpinner.DateEditor)this.timeSpinner.getEditor()).getFormat().setLenient(false);
    }

    public void setGoToButtonMode(int mode) {
        if (mode == this.goToMode) {
            return;
        }
        this.goToMode = mode;
        this.updateGoToButton();
    }

    public int getGoToButtonMode() {
        return this.goToMode;
    }

    public void setGoToButtonText(int mode, String text, String toolTip) {
        if (mode == 0) {
            this.GO_TO_TODAY_FMT = text;
            if (toolTip != null) {
                this.GO_TO_TODAY_TOOLTIP = toolTip;
            }
        } else if (mode == 1) {
            this.GO_TO_SELECTED_DATE_TEXT = text;
            if (toolTip != null) {
                this.GO_TO_SELECTED_DATE_TOOLTIP = toolTip;
            }
        }
        this.updateGoToButton();
    }

    public void setTimePanelText(String label) {
        this.timeLabel.setText(label);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Util.setEnabledOnContainer(this, enabled);
    }

    public void setTodayOutlineColor(Color color) {
        if (color == this.todayOutlineColor) {
            return;
        }
        this.todayOutlineColor = color;
        for (int i = 0; i < 42; ++i) {
            CalendarDayButton label = (CalendarDayButton)this.vectorDays.get(i);
            label.setOutlineColor(this.todayOutlineColor);
        }
        this.updateDayComponents();
    }

    public Color getTodayOutlineColor() {
        return this.todayOutlineColor;
    }

    protected GregorianCalendar getNewCalendar() {
        GregorianCalendar gc = new GregorianCalendar();
        if (this.weekStartingDay != 0) {
            gc.setFirstDayOfWeek(this.weekStartingDay);
        }
        if (this.minimalDaysInFirstWeek != 0) {
            gc.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
        }
        return gc;
    }

    public void redraw() {
        this.updateDateComponents();
        this.updateDayComponents();
    }

    @SASScope
    public boolean isDisplayWeekNumbers() {
        return this.showWeekNumbers;
    }

    @SASScope
    public void setDisplayWeekNumbers(boolean show) {
        if (this.showWeekNumbers == show) {
            return;
        }
        if (!show && this.selectMode == 20) {
            return;
        }
        this.showWeekNumbers = show;
        this.weeksPanel.setVisible(show);
        this.updateDayComponents();
    }

    @SASScope
    public void setDisplayCalendar(boolean show) {
        if (this.showCalendar == show) {
            return;
        }
        this.showCalendar = show;
        this.daysPanel.setVisible(show);
        this.weeksPanel.setVisible(show);
        if (show) {
            this.updateDayComponents();
        }
    }

    @SASScope
    public int getSelectionMode() {
        return this.selectMode;
    }

    @SASScope
    public void setSelectionMode(int mode) {
        if (this.selectMode == mode) {
            return;
        }
        if (mode != 10 && mode != 20 && mode != 30 && mode != 40 && mode != 50 && mode != 60) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidSelectionMode.ex.txt"));
        }
        this.selectMode = mode;
        if (mode == 20) {
            this.monthAndYearLayout.setRemainderColumn(3);
            this.showMonthQuarterYearLabels(false);
            this.headingQuarterComboBox.setVisible(false);
            this.headingMonthComboBox.setVisible(true);
            this.headingYearSpinner.setVisible(true);
            this.setDisplayCalendar(true);
            this.setDisplayWeekNumbers(true);
            this.goToButton.setVisible(true);
        } else if (mode == 50) {
            this.monthAndYearLayout.setRemainderColumn(3);
            this.showNextPrevMonthButtons(false);
            this.showMonthQuarterYearLabels(false);
            this.headingQuarterComboBox.setVisible(false);
            this.headingMonthComboBox.setVisible(false);
            this.headingYearSpinner.setVisible(false);
            this.setDisplayCalendar(false);
            this.goToButton.setVisible(false);
            this.showTimePanel(true);
        } else if (mode == 30) {
            this.monthAndYearLayout.setRemainderColumn(3);
            this.showNextPrevMonthButtons(false);
            this.showMonthQuarterYearLabels(true);
            this.headingQuarterComboBox.setVisible(false);
            this.headingMonthComboBox.setVisible(true);
            this.headingYearSpinner.setVisible(true);
            this.setDisplayCalendar(false);
            this.goToButton.setVisible(false);
        } else if (mode == 40) {
            this.monthAndYearLayout.setRemainderColumn(2);
            this.showNextPrevMonthButtons(false);
            this.showMonthQuarterYearLabels(true);
            this.headingQuarterComboBox.setVisible(true);
            this.headingMonthComboBox.setVisible(false);
            this.headingYearSpinner.setVisible(true);
            this.setDisplayCalendar(false);
            this.goToButton.setVisible(false);
        } else {
            this.monthAndYearLayout.setRemainderColumn(3);
            this.showMonthQuarterYearLabels(false);
            this.headingQuarterComboBox.setVisible(false);
            this.headingMonthComboBox.setVisible(true);
            this.headingYearSpinner.setVisible(true);
            this.goToButton.setVisible(true);
            this.setDisplayCalendar(true);
        }
        if (this.showMonthQuarterYearLabels) {
            this.showMonthQuarterYearLabels(true);
        }
    }

    @SASScope
    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    @SASScope
    public void setMinimalDaysInFirstWeek(int minimalDaysInFirstWeek) {
        if (this.minimalDaysInFirstWeek != minimalDaysInFirstWeek) {
            int oldValue = this.minimalDaysInFirstWeek;
            this.minimalDaysInFirstWeek = minimalDaysInFirstWeek;
            if (this.selectedDate != null) {
                this.selectedDate.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
            }
            if (this.todayDate != null) {
                this.todayDate.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
            }
            if (this.displayDate != null) {
                this.displayDate.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
            }
            if (this.todayDateFormat != null) {
                this.todayDateFormat.getCalendar().setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
            }
            this.firePropertyChange("minimalDaysInFirstWeek", oldValue, this.minimalDaysInFirstWeek);
        }
    }

    @SASScope
    public int getWeekStartingDay() {
        return this.weekStartingDay;
    }

    @SASScope
    public void setWeekStartingDay(int weekStartingDay) {
        if (this.weekStartingDay != weekStartingDay) {
            int oldValue = this.weekStartingDay;
            this.weekStartingDay = weekStartingDay;
            if (this.selectedDate != null) {
                this.selectedDate.setFirstDayOfWeek(weekStartingDay);
            }
            if (this.todayDate != null) {
                this.todayDate.setFirstDayOfWeek(weekStartingDay);
            }
            if (this.displayDate != null) {
                this.displayDate.setFirstDayOfWeek(weekStartingDay);
            }
            if (this.todayDateFormat != null) {
                this.todayDateFormat.getCalendar().setFirstDayOfWeek(weekStartingDay);
            }
            this.firePropertyChange("weekStartingDay", oldValue, this.weekStartingDay);
        }
    }

    @SASScope
    public JPanel getDaysUserContentPanel() {
        return this.daysUserContentPanel;
    }
}

