/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.CalendarDayButton;
import com.sas.swing.visuals.CalendarPanel;
import com.sas.swing.visuals.RB;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;

@SASScope
public class CalendarNavigationAction
extends AbstractAction {
    public static final String RB_KEY = "CalendarNavigationAction.";
    public static final int UP = 111;
    public static final int DOWN = 211;
    public static final int LEFT = 311;
    public static final int RIGHT = 411;
    private int direction;
    private CalendarPanel panel;

    public CalendarNavigationAction(CalendarPanel panel, int direction) {
        if (direction != 111 && direction != 211 && direction != 311 && direction != 411) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "badDirection.txt"));
        }
        this.direction = direction;
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GregorianCalendar date = null;
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        if (focusOwner instanceof CalendarDayButton) {
            date = ((CalendarDayButton)focusOwner).getDate();
        }
        if (date != null) {
            CalendarDayButton button = null;
            int change = 0;
            if (this.panel.getSelectionMode() == 10) {
                int day = date.get(5);
                switch (this.direction) {
                    case 111: {
                        change = -7;
                        break;
                    }
                    case 211: {
                        change = 7;
                        break;
                    }
                    case 311: {
                        change = -1;
                        break;
                    }
                    case 411: {
                        change = 1;
                    }
                }
                button = this.panel.getButtonForDay(day + change);
            } else {
                int week = date.get(3);
                switch (this.direction) {
                    case 111: 
                    case 311: {
                        change = -1;
                        break;
                    }
                    case 211: 
                    case 411: {
                        change = 1;
                    }
                }
                button = this.panel.getButtonForWeek(week + change);
            }
            if (button != null && button.isEnabled()) {
                button.requestFocus();
            } else {
                int dayOfYear;
                if (this.panel.getSelectionMode() == 10) {
                    dayOfYear = date.get(6);
                    date.set(6, dayOfYear += change);
                    int day = date.get(5);
                    this.panel.setCurrentDate(date);
                    button = this.panel.getButtonForDay(day);
                } else {
                    dayOfYear = date.get(6);
                    date.set(6, dayOfYear += change * 7);
                    int week = date.get(3);
                    this.panel.setCurrentDate(date);
                    button = this.panel.getButtonForWeek(week);
                }
                if (button != null && button.isEnabled()) {
                    button.requestFocus();
                }
            }
        }
    }
}

