/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.CalendarPanel;
import com.sas.swing.visuals.RB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.UIManager;

@SASScope(value="ALL")
public class CalendarDialog
extends JDialog
implements ActionListener {
    protected static final String RB_KEY = "CalendarDialog.";
    protected CalendarPanel calendarPanel;

    public CalendarDialog(Frame owner, String dialogTitle) {
        this(owner, dialogTitle, null);
    }

    public CalendarDialog(Frame owner, String dialogTitle, CalendarPanel panel) {
        super(owner);
        this.init(dialogTitle);
        this.setPanel(panel);
    }

    @SASScope
    public CalendarDialog(Dialog owner, String dialogTitle) {
        this(owner, dialogTitle, null);
    }

    @SASScope
    public CalendarDialog(Dialog owner, String dialogTitle, CalendarPanel panel) {
        super(owner);
        this.init(dialogTitle);
        this.setPanel(panel);
    }

    public CalendarPanel getPanel() {
        return this.calendarPanel;
    }

    public void setPanel(CalendarPanel panel) {
        JButton okButton;
        this.calendarPanel = panel;
        if (panel == null) {
            this.calendarPanel = new CalendarPanel();
            this.calendarPanel.showOKButton(true);
        }
        if ((okButton = this.calendarPanel.getOKButton()) != null) {
            okButton.addActionListener(this);
        }
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.add((Component)this.calendarPanel, "North");
        this.pack();
    }

    protected void init(String dialogTitle) {
        this.setTitle(dialogTitle);
        Container contentPane = this.getContentPane();
        BorderLayout mainLayout = new BorderLayout();
        contentPane.setLayout(mainLayout);
        this.setModal(true);
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CalendarDialog dialog = new CalendarDialog((Frame)null, RB.getStringResource(RB_KEY, "title.txt"));
        final CalendarPanel calendarPanel = dialog.getPanel();
        JButton okButton = calendarPanel.getOKButton();
        if (okButton != null) {
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GregorianCalendar selectedDate = calendarPanel.getSelectedDate();
                    if (selectedDate != null) {
                        System.out.println("Selected date: " + selectedDate.getTime());
                    }
                }
            });
        }
        dialog.setVisible(true);
        System.exit(0);
    }
}

