/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;

@SASScope(value="ALL")
public class CalendarDayButton
extends JButton {
    protected GregorianCalendar date;
    protected Color CALENDAR_FORECOLOR;
    protected boolean isSelected;
    protected boolean mouseOver;
    public static final int NORMAL = 0;
    public static final int OUTLINED = 1;
    public static final int DISABLED = 2;
    protected int type;
    protected boolean enabled;
    protected Color outlineColor;
    protected Color backgroundHoover;
    protected Color foregroundNormal;
    protected Color backgroundNormal;
    protected Font fontNormal;
    protected Color foregroundToday;
    protected Color backgroundToday;
    protected Font fontToday;
    protected Color foregroundDisabled;
    protected Color backgroundDisabled;
    protected Font fontDisabled;
    protected String dateFormat;

    public CalendarDayButton() {
        this.init();
        try {
            this.initializeUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CalendarDayButton(GregorianCalendar aDate) {
        super(new SimpleDateFormat("dd").format(aDate != null ? aDate.getTime() : GregorianCalendar.getInstance().getTime()));
        if (aDate == null) {
            aDate = new GregorianCalendar();
        }
        this.init();
        this.setText(aDate);
        try {
            this.initializeUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void init() {
        this.setSelected(false);
        this.setOpaque(true);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.enabled = true;
        this.mouseOver = false;
        this.dateFormat = "dd";
        this.date = new GregorianCalendar();
        this.type = 0;
        this.foregroundNormal = this.CALENDAR_FORECOLOR = new Color(0, 0, 0);
        this.backgroundNormal = Color.white;
        this.fontNormal = new Font("Helvetica", 0, 12);
        this.foregroundToday = this.CALENDAR_FORECOLOR;
        this.backgroundToday = Color.white;
        this.fontToday = new Font("Helvetica", 0, 12);
        this.foregroundDisabled = Color.lightGray;
        this.backgroundDisabled = Color.white;
        this.fontDisabled = new Font("Helvetica", 0, 12);
        this.outlineColor = Color.BLUE;
        this.backgroundHoover = Color.lightGray;
    }

    protected void initializeUI() throws Exception {
        this.addListeners();
    }

    public void setType(int type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("Specified type must be one of NORMAL, OUTLINED or DISABLED.");
        }
        this.setHorizontalAlignment(0);
        this.type = type;
        int effectiveType = type;
        if (!this.enabled) {
            effectiveType = 2;
        }
        switch (effectiveType) {
            case 0: {
                this.setForeground(this.isSelected ? this.backgroundNormal : this.foregroundNormal);
                this.setBackground(this.isSelected ? this.foregroundNormal : this.backgroundNormal);
                this.setFont(this.fontNormal);
                this.setFocusable(true);
                super.setEnabled(true);
                break;
            }
            case 1: {
                this.setForeground(this.isSelected ? this.backgroundToday : this.foregroundToday);
                this.setBackground(this.isSelected ? this.foregroundToday : this.backgroundToday);
                this.setFont(this.fontToday);
                this.setFocusable(true);
                super.setEnabled(true);
                break;
            }
            case 2: {
                this.setBackground(this.isSelected ? this.foregroundDisabled : this.backgroundDisabled);
                this.setFont(this.fontDisabled);
                this.setFocusable(false);
                super.setEnabled(false);
            }
        }
        this.setBorder();
    }

    protected void setBorder() {
        switch (this.type) {
            case 0: {
                this.setBorder(BorderFactory.createEtchedBorder(Color.white, this.hasFocus() ? Color.lightGray : Color.white));
                break;
            }
            case 1: {
                this.setBorder(BorderFactory.createEtchedBorder(this.hasFocus() ? Color.gray : Color.white, this.isEffectivelyEnabled() ? this.outlineColor : Color.lightGray));
                break;
            }
            case 2: {
                this.setBorder(BorderFactory.createEtchedBorder(Color.white, Color.white));
            }
        }
    }

    protected void setBackground() {
        switch (this.type) {
            case 0: {
                if (!this.mouseOver) {
                    this.setBackground(this.isSelected ? this.foregroundNormal : this.backgroundNormal);
                }
            }
            case 1: {
                if (!this.mouseOver) {
                    this.setBackground(this.isSelected ? this.foregroundToday : this.backgroundToday);
                    break;
                }
                if (this.isSelected) break;
                this.setBackground(this.backgroundHoover);
                break;
            }
            case 2: {
                if (this.mouseOver) break;
                this.setBackground(this.isSelected ? this.foregroundDisabled : this.backgroundDisabled);
            }
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this.setSelected(selected, false);
    }

    public void setSelected(boolean selected, boolean fireChangeEvent) {
        boolean prevState = this.isSelected;
        this.isSelected = selected;
        this.setType(this.type);
        if (fireChangeEvent) {
            this.firePropertyChange("selectedState", this.isSelected, prevState);
        }
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    public void setCanSelect(boolean selectable) {
    }

    public boolean canSelect() {
        return true;
    }

    @Override
    public void setText(String ddMMyyyy) {
        if (ddMMyyyy == null) {
            return;
        }
        try {
            Date parsedDate = new SimpleDateFormat("ddMMyyyy").parse(ddMMyyyy);
            this.date = new GregorianCalendar();
            this.date.setTime(parsedDate);
            this.setText(this.date);
        }
        catch (ParseException pe) {
            super.setText("");
        }
    }

    public void setText(GregorianCalendar aDate) {
        if (aDate == null) {
            return;
        }
        this.date.setTime(aDate.getTime());
        this.date.setTimeZone(aDate.getTimeZone());
        this.date.setMinimalDaysInFirstWeek(aDate.getMinimalDaysInFirstWeek());
        this.date.setFirstDayOfWeek(aDate.getFirstDayOfWeek());
        SimpleDateFormat dayFormat = new SimpleDateFormat(this.getDateFormat());
        dayFormat.setTimeZone(aDate.getTimeZone());
        dayFormat.setCalendar(aDate);
        super.setText(dayFormat.format(this.date.getTime()));
        DateFormat dateFormat = DateFormat.getDateInstance();
        dateFormat.setTimeZone(aDate.getTimeZone());
        dateFormat.setCalendar(aDate);
        super.setToolTipText(dateFormat.format(this.date.getTime()));
    }

    public GregorianCalendar getDate() {
        return this.date;
    }

    @Override
    public String toString() {
        return this.date.toString();
    }

    protected void addListeners() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (CalendarDayButton.this.isEffectivelyEnabled()) {
                    CalendarDayButton.this.setBorder();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (CalendarDayButton.this.isEffectivelyEnabled()) {
                    CalendarDayButton.this.setBorder();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CalendarDayButton.this.isEffectivelyEnabled()) {
                    CalendarDayButton.this.requestFocus();
                    CalendarDayButton.this.setSelected(true, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (CalendarDayButton.this.isEffectivelyEnabled()) {
                    CalendarDayButton.this.mouseOver = true;
                    CalendarDayButton.this.setBackground();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (CalendarDayButton.this.isEffectivelyEnabled()) {
                    CalendarDayButton.this.mouseOver = false;
                    CalendarDayButton.this.setBackground();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keycode = e.getKeyCode();
                switch (keycode) {
                    case 32: {
                        CalendarDayButton.this.setSelected(true, true);
                    }
                }
            }
        });
    }

    public void setForeColor(Color color) {
        this.foregroundNormal = this.CALENDAR_FORECOLOR = color;
        this.foregroundToday = this.CALENDAR_FORECOLOR;
        this.foregroundDisabled = this.CALENDAR_FORECOLOR;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    @Override
    public void setEnabled(boolean mode) {
        this.enabled = mode;
        this.setType(this.type);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isSelected || this.mouseOver) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
        super.paintComponent(g);
    }

    protected boolean isEffectivelyEnabled() {
        return this.enabled && this.type != 2;
    }

    @SASScope
    public String getDateFormat() {
        return this.dateFormat;
    }

    @SASScope
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

