/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.swing.visuals.BasicCheckBoxListUI;
import com.sas.swing.visuals.TriStateCheckBoxList;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;

public class BasicTriStateCheckBoxListUI
extends BasicCheckBoxListUI {
    @Override
    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("selectCurrentRow", new IncrementLeadSelectionAction("selectCurrentRow", 0, 0));
        map.put("selectPreviousRow", new IncrementLeadSelectionAction("selectPreviousRow", 1, -1));
        map.put("selectNextRow", new IncrementLeadSelectionAction("selectNextRow", 1, 1));
        map.put("selectFirstRow", new HomeAction("selectFirstRow", 1));
        map.put("selectLastRow", new EndAction("selctLastRow", 1));
        map.put("scrollUp", new PageUpAction("scrollUp", 1));
        map.put("scrollDown", new PageDownAction("scrollDown", 1));
        map.put("selectAll", new BasicCheckBoxListUI.SelectAllAction("selectAll"));
        map.put("clearSelection", new BasicCheckBoxListUI.ClearSelectionAction("clearSelection"));
        return map;
    }

    public static ComponentUI createUI(JComponent list) {
        return new BasicTriStateCheckBoxListUI();
    }

    public static class IncrementLeadSelectionAction
    extends BasicCheckBoxListUI.IncrementLeadSelectionAction {
        public IncrementLeadSelectionAction(String name, int type) {
            this(name, type, -1);
        }

        public IncrementLeadSelectionAction(String name, int type, int amount) {
            super(name, type, amount);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList list = (JList)e.getSource();
            int index = this.getNextIndex(list);
            if (index >= 0 && index < list.getModel().getSize()) {
                ListSelectionModel lsm = list.getSelectionModel();
                if (this.selectionType == 0) {
                    if (list instanceof TriStateCheckBoxList) {
                        ((TriStateCheckBoxList)list).setUpdateEnabled(true);
                    }
                    list.setSelectedIndex(index);
                } else if (this.selectionType == 1) {
                    if (list instanceof TriStateCheckBoxList) {
                        int value = ((TriStateCheckBoxList)list).getSelectedIndexValue(index);
                        if (((TriStateCheckBoxList)list).isUpdateEnabled()) {
                            if (list instanceof TriStateCheckBoxList) {
                                ((TriStateCheckBoxList)list).setUpdateEnabled(false);
                            }
                            list.setSelectedIndex(index);
                            if (list instanceof TriStateCheckBoxList) {
                                ((TriStateCheckBoxList)list).setUpdateEnabled(true);
                            }
                        } else {
                            list.setSelectedIndex(index);
                        }
                        value = ((TriStateCheckBoxList)list).getSelectedIndexValue(index);
                        ((TriStateCheckBoxList)list).setSelectedIndexValue(index, value);
                        value = ((TriStateCheckBoxList)list).getSelectedIndexValue(index);
                    } else if (list.isSelectedIndex(index)) {
                        list.addSelectionInterval(index, index);
                    } else {
                        list.removeSelectionInterval(index, index);
                    }
                }
                this.ensureIndexIsVisible(list, index);
            }
        }
    }

    public static class HomeAction
    extends IncrementLeadSelectionAction {
        public HomeAction(String name, int type) {
            super(name, type);
        }

        @Override
        protected int getNextIndex(JList list) {
            return 0;
        }
    }

    public static class EndAction
    extends IncrementLeadSelectionAction {
        public EndAction(String name, int type) {
            super(name, type);
        }

        @Override
        protected int getNextIndex(JList list) {
            return list.getModel().getSize() - 1;
        }
    }

    public static class PageUpAction
    extends IncrementLeadSelectionAction {
        public PageUpAction(String name, int type) {
            super(name, type);
        }

        @Override
        protected int getNextIndex(JList list) {
            int index = list.getFirstVisibleIndex();
            ListSelectionModel lsm = list.getSelectionModel();
            if (lsm.getLeadSelectionIndex() == index) {
                Rectangle visRect = list.getVisibleRect();
                visRect.y = Math.max(0, visRect.y - visRect.height);
                index = list.locationToIndex(visRect.getLocation());
            }
            return index;
        }

        @Override
        protected void ensureIndexIsVisible(JList list, int index) {
            Rectangle visRect = list.getVisibleRect();
            Rectangle cellBounds = list.getCellBounds(index, index);
            cellBounds.height = visRect.height;
            list.scrollRectToVisible(cellBounds);
        }
    }

    public static class PageDownAction
    extends IncrementLeadSelectionAction {
        public PageDownAction(String name, int type) {
            super(name, type);
        }

        @Override
        protected int getNextIndex(JList list) {
            int index = list.getLastVisibleIndex();
            ListSelectionModel lsm = list.getSelectionModel();
            if (index == -1) {
                index = list.getModel().getSize() - 1;
            }
            if (lsm.getLeadSelectionIndex() == index) {
                Rectangle visRect = list.getVisibleRect();
                visRect.y += visRect.height + visRect.height - 1;
                index = list.locationToIndex(visRect.getLocation());
                if (index == -1) {
                    index = list.getModel().getSize() - 1;
                }
            }
            return index;
        }

        @Override
        protected void ensureIndexIsVisible(JList list, int index) {
            Rectangle visRect = list.getVisibleRect();
            Rectangle cellBounds = list.getCellBounds(index, index);
            cellBounds.y = Math.max(0, cellBounds.y + cellBounds.height - visRect.height);
            cellBounds.height = visRect.height;
            list.scrollRectToVisible(cellBounds);
        }
    }
}

