/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.swing.visuals.TriStateCheckBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.plaf.metal.MetalCheckBoxIcon;

public class BasicTriStateCheckBoxIcon
extends MetalCheckBoxIcon {
    @Override
    protected int getControlSize() {
        return 12;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        TriStateCheckBox checkBox = (TriStateCheckBox)c;
        TriStateCheckBox.TriStateCheckBoxModel model = (TriStateCheckBox.TriStateCheckBoxModel)checkBox.getModel();
        int controlSize = this.getControlSize();
        boolean drawCheck = model.isSelected();
        if (model.getSelectedValue() == 1 || !model.isEnabled()) {
            if (checkBox.isBorderPaintedFlat() || !model.isEnabled()) {
                g2d.setColor(SystemColor.controlShadow);
                g2d.drawRect(x + 1, y + 1, controlSize - 2, controlSize - 2);
            } else {
                this.drawBox(g2d, x, y, controlSize, controlSize);
            }
            if (model.isEnabled()) {
                BufferedImage bi = new BufferedImage(2, 2, 1);
                Graphics2D big2d = bi.createGraphics();
                big2d.setColor(SystemColor.control);
                big2d.drawLine(0, 0, 1, 1);
                big2d.setColor(SystemColor.controlLtHighlight);
                big2d.drawLine(0, 1, 1, 0);
                Rectangle r = new Rectangle(0, 0, 2, 2);
                TexturePaint tp = new TexturePaint(bi, r);
                g2d.setPaint(tp);
                g2d.fillRect(x + 2, y + 2, controlSize - 3, controlSize - 3);
            } else {
                g2d.setColor(SystemColor.control);
            }
        } else {
            if (checkBox.isBorderPaintedFlat()) {
                g2d.setColor(SystemColor.controlShadow);
                g2d.drawRect(x + 1, y + 1, controlSize - 2, controlSize - 2);
            } else if (!checkBox.isBorderPaintedFlat()) {
                this.drawBox(g2d, x, y, controlSize, controlSize);
            }
            g2d.setColor(Color.white);
            g2d.fillRect(x + 2, y + 2, controlSize - 3, controlSize - 3);
        }
        if (model.isPressed() && model.isArmed()) {
            g2d.setColor(SystemColor.control);
            g2d.fillRect(x + 2, y + 2, controlSize - 3, controlSize - 3);
        }
        if (drawCheck) {
            if (model.getSelectedValue() == 1) {
                g2d.setColor(SystemColor.controlShadow);
            } else {
                g2d.setColor(SystemColor.controlDkShadow);
            }
            this.drawCheck(c, g2d, x, y);
        }
    }

    @Override
    protected void drawCheck(Component c, Graphics g, int x, int y) {
        g.drawLine(x + 3, y + 5, x + 5, y + 7);
        g.drawLine(x + 3, y + 6, x + 5, y + 8);
        g.drawLine(x + 3, y + 7, x + 5, y + 9);
        g.drawLine(x + 6, y + 6, x + 9, y + 3);
        g.drawLine(x + 6, y + 7, x + 9, y + 4);
        g.drawLine(x + 6, y + 8, x + 9, y + 5);
    }

    protected void drawBox(Graphics g, int x, int y, int width, int height) {
        g.setColor(SystemColor.controlShadow);
        g.drawLine(x, y, x + width - 1, y);
        g.drawLine(x, y, x, y + height);
        g.setColor(Color.darkGray);
        g.drawLine(x + 1, y + 1, x + width - 2, y + 1);
        g.drawLine(x + 1, y + 1, x + 1, y + height - 1);
        g.setColor(SystemColor.control);
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + height - 1, x + 2, y + height - 1);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(x + width, y, x + width, y + height);
        g.drawLine(x + width, y + height, x + 1, y + height);
    }
}

