/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class BasicCheckBoxListUI
extends BasicListUI {
    protected static final int CHANGE_SELECTION = 0;
    protected static final int MOVE_TO_SELECTION = 1;

    @Override
    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(' '), "selectCurrentRow");
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        ActionMap map = this.getActionMap();
        if (map != null) {
            SwingUtilities.replaceUIActionMap(this.list, map);
        }
    }

    protected InputMap getInputMap(int condition) {
        if (condition == 0) {
            return (InputMap)UIManager.get("List.focusInputMap");
        }
        return null;
    }

    protected ActionMap getActionMap() {
        ActionMap map = this.createActionMap();
        if (map != null) {
            UIManager.put("CheckBoxList.actionMap", map);
        }
        return map;
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("selectCurrentRow", new IncrementLeadSelectionAction("selectCurrentRow", 0, 0));
        map.put("selectPreviousRow", new IncrementLeadSelectionAction("selectPreviousRow", 1, -1));
        map.put("selectNextRow", new IncrementLeadSelectionAction("selectNextRow", 1, 1));
        map.put("selectFirstRow", new HomeAction("selectFirstRow", 1));
        map.put("selectLastRow", new EndAction("selctLastRow", 1));
        map.put("scrollUp", new PageUpAction("scrollUp", 1));
        map.put("scrollDown", new PageDownAction("scrollDown", 1));
        map.put("selectAll", new SelectAllAction("selectAll"));
        map.put("clearSelection", new ClearSelectionAction("clearSelection"));
        return map;
    }

    public static ComponentUI createUI(JComponent list) {
        return new BasicCheckBoxListUI();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new CheckBoxListMouseInputHandler();
    }

    public static class IncrementLeadSelectionAction
    extends AbstractAction {
        protected int amount;
        protected int selectionType;

        public IncrementLeadSelectionAction(String name, int type) {
            this(name, type, -1);
        }

        public IncrementLeadSelectionAction(String name, int type, int amount) {
            super(name);
            this.amount = amount;
            this.selectionType = type;
        }

        protected int getNextIndex(JList list) {
            int index = list.getLeadSelectionIndex();
            int size = list.getModel().getSize();
            if (index == -1) {
                if (size > 0) {
                    index = this.amount > 0 ? 0 : size - 1;
                }
            } else {
                index += this.amount;
            }
            return index;
        }

        protected void ensureIndexIsVisible(JList list, int index) {
            list.ensureIndexIsVisible(index);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList list = (JList)e.getSource();
            int index = this.getNextIndex(list);
            if (index >= 0 && index < list.getModel().getSize()) {
                ListSelectionModel lsm = list.getSelectionModel();
                if (this.selectionType == 0) {
                    list.setSelectedIndex(index);
                } else if (this.selectionType == 1) {
                    if (list.isSelectedIndex(index)) {
                        list.addSelectionInterval(index, index);
                    } else {
                        list.removeSelectionInterval(index, index);
                    }
                }
                this.ensureIndexIsVisible(list, index);
            }
        }
    }

    public static class HomeAction
    extends IncrementLeadSelectionAction {
        public HomeAction(String name, int type) {
            super(name, type);
        }

        @Override
        protected int getNextIndex(JList list) {
            return 0;
        }
    }

    public static class EndAction
    extends IncrementLeadSelectionAction {
        public EndAction(String name, int type) {
            super(name, type);
        }

        @Override
        protected int getNextIndex(JList list) {
            return list.getModel().getSize() - 1;
        }
    }

    public static class PageUpAction
    extends IncrementLeadSelectionAction {
        public PageUpAction(String name, int type) {
            super(name, type);
        }

        @Override
        protected int getNextIndex(JList list) {
            int index = list.getFirstVisibleIndex();
            ListSelectionModel lsm = list.getSelectionModel();
            if (lsm.getLeadSelectionIndex() == index) {
                Rectangle visRect = list.getVisibleRect();
                visRect.y = Math.max(0, visRect.y - visRect.height);
                index = list.locationToIndex(visRect.getLocation());
            }
            return index;
        }

        @Override
        protected void ensureIndexIsVisible(JList list, int index) {
            Rectangle visRect = list.getVisibleRect();
            Rectangle cellBounds = list.getCellBounds(index, index);
            cellBounds.height = visRect.height;
            list.scrollRectToVisible(cellBounds);
        }
    }

    public static class PageDownAction
    extends IncrementLeadSelectionAction {
        public PageDownAction(String name, int type) {
            super(name, type);
        }

        @Override
        protected int getNextIndex(JList list) {
            int index = list.getLastVisibleIndex();
            ListSelectionModel lsm = list.getSelectionModel();
            if (index == -1) {
                index = list.getModel().getSize() - 1;
            }
            if (lsm.getLeadSelectionIndex() == index) {
                Rectangle visRect = list.getVisibleRect();
                visRect.y += visRect.height + visRect.height - 1;
                index = list.locationToIndex(visRect.getLocation());
                if (index == -1) {
                    index = list.getModel().getSize() - 1;
                }
            }
            return index;
        }

        @Override
        protected void ensureIndexIsVisible(JList list, int index) {
            Rectangle visRect = list.getVisibleRect();
            Rectangle cellBounds = list.getCellBounds(index, index);
            cellBounds.y = Math.max(0, cellBounds.y + cellBounds.height - visRect.height);
            cellBounds.height = visRect.height;
            list.scrollRectToVisible(cellBounds);
        }
    }

    public static class SelectAllAction
    extends AbstractAction {
        public SelectAllAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList list = (JList)e.getSource();
            list.addSelectionInterval(0, list.getModel().getSize() - 1);
        }
    }

    public static class ClearSelectionAction
    extends AbstractAction {
        public ClearSelectionAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList list = (JList)e.getSource();
            list.clearSelection();
        }
    }

    public class CheckBoxListMouseInputHandler
    extends BasicListUI.MouseInputHandler {
        public CheckBoxListMouseInputHandler() {
            super(BasicCheckBoxListUI.this);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            BasicCheckBoxListUI.this.list.setValueIsAdjusting(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row;
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!BasicCheckBoxListUI.this.list.isEnabled()) {
                return;
            }
            if (!BasicCheckBoxListUI.this.list.hasFocus()) {
                BasicCheckBoxListUI.this.list.requestFocus();
            }
            if ((row = BasicCheckBoxListUI.this.convertYToRow(e.getY())) != -1) {
                BasicCheckBoxListUI.this.list.setValueIsAdjusting(true);
                int anchorIndex = BasicCheckBoxListUI.this.list.getAnchorSelectionIndex();
                BasicCheckBoxListUI.this.list.setSelectionInterval(row, row);
            }
        }
    }
}

