/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.awt.RefreshCommand;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeCommandAdaptor;
import com.sas.lang.StringDataInterface;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.event.SwingPropertyChangeSupport;

public class BaseBorder
extends AbstractBorder
implements StringDataInterface {
    static final long serialVersionUID = -5931736587553705325L;
    public static final String RB_KEY = "BaseBorder.";
    Color backgroundColor;
    Color foregroundColor;
    Color highlightColor;
    Color shadowColor;
    Font font;
    Component component;
    String text;
    int textGap;
    int textHeight;
    int alignment;
    int margin;
    int sidesPainted;
    int version;
    int borderWidth;
    protected Color baseColorJ;
    protected int lightSource = 5;
    protected int style = 0;
    public static final int CENTER = 256;
    public static final int RIGHT = 2;
    public static final int LEFT = 1;
    public static final int ALL_SIDES = 15;
    public static final int BEZEL = 1;
    public static final int SIMPLE = 2;
    public static final int EMBOSS = 3;
    public static final int BUTTON = 4;
    public static final int NONE = 0;
    public static final int DEFAULT = 1;
    public static final int RAISED = 5;
    public static final int LOWERED = 10;
    public static final int TOP_LEFT = 5;
    public static final int TOP_RIGHT = 6;
    public static final int BOTTOM_RIGHT = 10;
    public static final int BOTTOM_LEFT = 9;
    private SwingPropertyChangeSupport changeSupport;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "backgroundColor"}, {"Description", RB.getStringResource(RB_KEY, "backgroundColor.pd.txt")}}, {{"Name", "baseColor"}, {"Description", RB.getStringResource(RB_KEY, "baseColor.pd.txt")}}, {{"Name", "borderWidth"}, {"Description", RB.getStringResource(RB_KEY, "borderWidth.pd.txt")}}, {{"Name", "component"}, {"Hidden", "true"}}, {{"Name", "font"}, {"Description", RB.getStringResource(RB_KEY, "font.pd.txt")}}, {{"Name", "foregroundColor"}, {"Description", RB.getStringResource(RB_KEY, "foregroundColor.pd.txt")}}, {{"Name", "highlightColor"}, {"Description", RB.getStringResource(RB_KEY, "highlightColor.pd.txt")}}, {{"Name", "shadowColor"}, {"Description", RB.getStringResource(RB_KEY, "shadowColor.pd.txt")}}, {{"Name", "text"}, {"Description", RB.getStringResource(RB_KEY, "text.pd.txt")}}, {{"Name", "textAlignment"}, {"Description", RB.getStringResource(RB_KEY, "textAlignment.pd.txt")}}, {{"Name", "textMargin"}, {"Description", RB.getStringResource(RB_KEY, "textMargin.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public BaseBorder() {
        this(1, 5, 2);
    }

    public BaseBorder(int style) {
        this(style, 5, 2);
    }

    public BaseBorder(int style, int ltSrc) {
        this(style, ltSrc, 2);
    }

    public BaseBorder(int style, int ltSrc, int width) {
        this(style, ltSrc, width, SystemColor.windowBorder, SystemColor.controlHighlight, SystemColor.controlShadow);
    }

    public BaseBorder(int style, int ltSrc, int width, Color base) {
        this(style, ltSrc, width, base, base.brighter(), base.darker());
    }

    public BaseBorder(int style, int ltSrc, int width, Color base, Color highlight, Color shadow) {
        this(style, ltSrc, width, base, highlight, shadow, null, 1, 10, Util.getDialogFont());
    }

    public BaseBorder(int style, int ltSrc, int width, Color base, Color highlight, Color shadow, String txt, int align, int margin, Font f) {
        this.setBaseColor(base);
        this.highlightColor = highlight;
        this.shadowColor = shadow;
        this.backgroundColor = null;
        this.foregroundColor = null;
        this.font = f;
        this.borderWidth = width;
        this.text = txt;
        this.textHeight = 0;
        this.textGap = 3;
        this.alignment = align;
        this.margin = margin;
        this.setStyle(style);
        this.setLightSource(ltSrc);
        this.version = 2;
        this.sidesPainted = 15;
        this.changeSupport = new SwingPropertyChangeSupport(this);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport != null && oldValue != newValue) {
            this.changeSupport.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
        }
    }

    public int getSidesPainted() {
        return this.sidesPainted;
    }

    public void setSidesPainted(int sides) {
        if (sides != this.sidesPainted) {
            int oldSides = this.sidesPainted;
            this.sidesPainted = sides;
            this.firePropertyChange("sidesPainted", oldSides, this.sidesPainted);
        }
    }

    public static void drawBezel(Graphics g, int x, int y, int width, int height, Color topLeft, Color bottomRight, int borderWidth) {
        int allSides = 15;
        BaseBorder.drawBezel(g, x, y, width, height, topLeft, topLeft, bottomRight, bottomRight, borderWidth, allSides);
    }

    public static void drawBezel(Graphics g, int x, int y, int width, int height, Color top, Color left, Color bottom, Color right, int borderWidth, int sides) {
        if (g == null) {
            return;
        }
        boolean paintRight = true;
        boolean paintLeft = true;
        boolean paintTop = true;
        boolean paintBottom = true;
        boolean hack = false;
        if ((sides & 4) != 4) {
            paintTop = false;
        }
        if ((sides & 8) != 8) {
            paintBottom = false;
        }
        if ((sides & 1) != 1) {
            paintLeft = false;
        }
        if ((sides & 2) != 2) {
            paintRight = false;
        }
        Polygon poly = null;
        int indent = borderWidth;
        if (paintLeft) {
            poly = new Polygon();
            poly.addPoint(x, y);
            if (!paintTop) {
                indent = 0;
            }
            poly.addPoint(x + borderWidth, y + indent);
            indent = borderWidth;
            if (!paintBottom) {
                indent = 0;
            }
            poly.addPoint(x + borderWidth, y + height - indent);
            poly.addPoint(x, y + height);
            g.setColor(left);
            g.fillPolygon(poly);
        }
        indent = borderWidth;
        if (paintTop) {
            poly = new Polygon();
            poly.addPoint(x, y);
            if (!paintLeft) {
                indent = 0;
            }
            poly.addPoint(x + indent, y + borderWidth);
            indent = borderWidth;
            if (!paintRight) {
                indent = 0;
            }
            poly.addPoint(x + width - indent, y + borderWidth);
            poly.addPoint(x + width, y);
            g.setColor(top);
            g.fillPolygon(poly);
        }
        indent = borderWidth;
        if (paintRight) {
            poly = new Polygon();
            poly.addPoint(x + width, y);
            if (!paintTop) {
                indent = 0;
            }
            poly.addPoint(x + width - borderWidth, y + indent);
            indent = borderWidth;
            if (!paintBottom) {
                indent = 0;
            }
            poly.addPoint(x + width - borderWidth, y + height - indent);
            poly.addPoint(x + width, y + height);
            g.setColor(right);
            g.fillPolygon(poly);
        }
        indent = borderWidth;
        if (paintBottom) {
            poly = new Polygon();
            poly.addPoint(x, y + height);
            if (!paintLeft) {
                indent = 0;
            }
            poly.addPoint(x + indent, y + height - borderWidth);
            indent = borderWidth;
            if (!paintRight) {
                indent = 0;
            }
            poly.addPoint(x + width - indent, y + height - borderWidth);
            poly.addPoint(x + width, y + height);
            g.setColor(bottom);
            g.fillPolygon(poly);
        }
    }

    public static void drawEmboss(Graphics g, int x, int y, int width, int height, Color top, Color bottom, int borderWidth) {
        int allSides = 15;
        BaseBorder.drawEmboss(g, x, y, width, height, top, bottom, borderWidth, allSides);
    }

    public static void drawEmboss(Graphics g, int x, int y, int width, int height, Color top, Color bottom, int borderWidth, int sides) {
        if (g == null) {
            return;
        }
        int half = borderWidth / 2;
        int tmpWidth = width - half;
        int tmpHeight = height - half;
        g.setColor(bottom);
        if ((sides & 4) == 4) {
            g.fillRect(x, y, width, borderWidth);
        }
        if ((sides & 8) == 8) {
            g.fillRect(x, y + height - borderWidth, width, borderWidth);
        } else {
            tmpHeight = height;
        }
        if ((sides & 1) == 1) {
            g.fillRect(x, y, borderWidth, height);
        }
        if ((sides & 2) == 2) {
            g.fillRect(x + width - borderWidth, y, borderWidth, height);
        } else {
            tmpWidth = width;
        }
        g.setColor(top);
        if ((sides & 4) == 4) {
            g.fillRect(x, y, tmpWidth, half);
        }
        if ((sides & 8) == 8) {
            g.fillRect(x, y + height - borderWidth, tmpWidth, half);
        }
        if ((sides & 1) == 1) {
            g.fillRect(x, y, half, tmpHeight);
        }
        if ((sides & 2) == 2) {
            g.fillRect(x + width - borderWidth, y, half, tmpHeight);
        }
    }

    public void drawInRect(Graphics g, Rectangle rect) {
        this.drawInRect(null, g, rect.x, rect.y, rect.width, rect.height);
    }

    public void drawInRect(Graphics g, Rectangle rect, int lSource) {
        int oldLightSource = this.lightSource;
        this.lightSource = lSource;
        this.drawInRect(g, rect);
        this.lightSource = oldLightSource;
    }

    public void drawInRect(Graphics g, int x, int y, int width, int height) {
        this.drawInRect(null, g, x, y, width, height);
    }

    public void drawInRect(Component comp, Graphics g, int x, int y, int width, int height) {
        Rectangle oldClip;
        this.setComponent(comp);
        if (g == null || this.borderWidth == 0) {
            return;
        }
        Color currentColor = g.getColor();
        Font currentFont = null;
        if (comp != null) {
            currentFont = comp.getFont();
        }
        if (currentFont == null) {
            currentFont = g.getFont();
        }
        int initialY = y;
        this.textHeight = 0;
        int textWidth = 0;
        Point textStart = new Point(0, 0);
        boolean borderText = false;
        if (this.text != null && this.text.length() != 0 && (this.sidesPainted & 4) == 4) {
            Font textFont = this.font;
            if (this.font == null && currentFont != null) {
                textFont = new Font(currentFont.getFamily(), currentFont.getStyle(), currentFont.getSize());
            }
            g.setFont(textFont);
            FontMetrics fontMetrics = g.getFontMetrics();
            this.textHeight = fontMetrics.getHeight();
            textWidth = fontMetrics.stringWidth(this.text) + 2 * this.textGap;
            textStart.x = x;
            textStart.y = y + this.textHeight - fontMetrics.getDescent();
            y += this.textHeight / 2;
            height -= this.textHeight / 2;
            borderText = true;
            textStart.x = this.alignment == 256 ? (textStart.x += (width - textWidth) / 2) : (this.alignment == 2 ? (textStart.x += width - textWidth - this.margin) : (textStart.x += this.margin));
        }
        if ((oldClip = g.getClipBounds()) != null && borderText) {
            Rectangle textRect = new Rectangle(textStart.x - 1, 0, textWidth, this.textHeight);
            Rectangle textI = null;
            if (oldClip.intersects(textRect)) {
                textI = oldClip.intersection(textRect);
            }
            if (textI != null) {
                Point pt1 = new Point(textI.x, textI.y);
                Point pt2 = new Point(textI.x + textI.width, textI.y);
                Point pt3 = new Point(textI.x + textI.width, textI.y + textI.height);
                Point pt4 = new Point(textI.x, textI.y + textI.height);
                Point cpt1 = new Point(oldClip.x, oldClip.y);
                Point cpt2 = new Point(oldClip.x + oldClip.width, oldClip.y);
                Point cpt3 = new Point(oldClip.x + oldClip.width, oldClip.y + oldClip.height);
                Point cpt4 = new Point(oldClip.x, oldClip.y + oldClip.height);
                Point[] pts = null;
                if (pt1.equals(cpt1)) {
                    pts = new Point[]{pt4, pt3, pt2, cpt2, cpt3, cpt4};
                } else if (pt2.equals(cpt2)) {
                    pts = new Point[]{cpt1, pt1, pt4, pt3, cpt3, cpt4};
                } else if (pt3.equals(cpt3)) {
                    pts = new Point[]{cpt1, cpt2, pt2, pt1, pt4, cpt4};
                } else if (pt4.equals(cpt4)) {
                    pts = new Point[]{cpt1, cpt2, cpt3, pt3, pt2, pt1};
                } else if (pt1.y == cpt1.y) {
                    pts = new Point[]{cpt1, pt1, pt4, pt3, pt2, cpt2, cpt3, cpt4};
                } else if (pt1.x == cpt1.x) {
                    pts = new Point[]{cpt1, cpt2, cpt3, cpt4, pt4, pt3, pt2, pt1};
                } else if (pt3.y == cpt3.y) {
                    pts = new Point[]{cpt1, cpt2, cpt3, pt3, pt2, pt1, pt4, cpt4};
                } else if (pt3.x == cpt3.x) {
                    pts = new Point[]{cpt1, cpt2, pt2, pt1, pt4, pt3, cpt3, cpt4};
                }
                if (pts != null) {
                    Polygon clipPoly = new Polygon();
                    for (int i = 0; i < pts.length; ++i) {
                        clipPoly.addPoint(pts[i].x, pts[i].y);
                    }
                    g.setClip(clipPoly);
                }
            }
        }
        if (this.getStyle() == 1) {
            if (this.getLightSource() == 5) {
                BaseBorder.drawBezel(g, x, y, width, height, this.highlightColor, this.highlightColor, this.shadowColor, this.shadowColor, this.borderWidth, this.sidesPainted);
            } else {
                BaseBorder.drawBezel(g, x, y, width, height, this.shadowColor, this.shadowColor, this.highlightColor, this.highlightColor, this.borderWidth, this.sidesPainted);
            }
        } else if (this.getStyle() == 2) {
            Color bColor = this.getBaseColor();
            BaseBorder.drawBezel(g, x, y, width, height, bColor, bColor, bColor, bColor, this.borderWidth, this.sidesPainted);
        } else if (this.getStyle() == 3) {
            if (this.getLightSource() == 5) {
                BaseBorder.drawEmboss(g, x, y, width, height, this.highlightColor, this.shadowColor, this.borderWidth, this.sidesPainted);
            } else {
                BaseBorder.drawEmboss(g, x, y, width, height, this.shadowColor, this.highlightColor, this.borderWidth, this.sidesPainted);
            }
        } else if (this.getStyle() == 4) {
            if (this.getLightSource() == 5) {
                BaseBorder.drawBezel(g, x, y, width, height, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, SystemColor.controlDkShadow, SystemColor.controlDkShadow, 1, this.sidesPainted);
                BaseBorder.drawBezel(g, x + 1, y + 1, width - 2, height - 2, SystemColor.controlHighlight, SystemColor.controlHighlight, SystemColor.controlShadow, SystemColor.controlShadow, 1, this.sidesPainted);
            } else {
                BaseBorder.drawBezel(g, x, y, width, height, SystemColor.controlDkShadow, SystemColor.controlDkShadow, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, 1, this.sidesPainted);
                BaseBorder.drawBezel(g, x + 1, y + 1, width - 2, height - 2, SystemColor.controlShadow, SystemColor.controlShadow, SystemColor.controlHighlight, SystemColor.controlHighlight, 1, this.sidesPainted);
            }
        }
        if (borderText && oldClip != null) {
            g.setClip(oldClip);
        }
        if (this.text != null && this.text.length() != 0 && (this.sidesPainted & 4) == 4) {
            Color foreColor;
            Color backColor = this.backgroundColor;
            if (backColor == null && comp != null) {
                backColor = comp.getBackground();
            }
            if (backColor == null && this.component != null) {
                backColor = this.component.getBackground();
            }
            if (backColor == null) {
                backColor = Color.white;
            }
            if (this.component instanceof JComponent) {
                if (((JComponent)this.component).isOpaque()) {
                    g.setColor(backColor);
                    g.fillRect(textStart.x - 1, initialY, textWidth + 2, initialY + this.textHeight);
                }
            } else {
                g.setColor(backColor);
                g.fillRect(textStart.x - 1, initialY, textWidth + 2, initialY + this.textHeight);
            }
            if ((foreColor = this.foregroundColor) == null && comp != null) {
                foreColor = comp.getForeground();
            }
            if (foreColor == null && this.component != null) {
                foreColor = this.component.getForeground();
            }
            if (foreColor == null) {
                foreColor = Color.black;
            }
            g.setColor(foreColor);
            g.drawString(this.text, textStart.x + this.textGap, textStart.y);
        }
        if (currentFont != null) {
            g.setFont(currentFont);
        }
        g.setColor(currentColor);
    }

    public int getBorderWidth() {
        if (this.getStyle() == 4) {
            return 2;
        }
        return this.borderWidth;
    }

    public Color getBaseColor() {
        return this.baseColorJ;
    }

    public int getLightSource() {
        return this.lightSource;
    }

    public int getStyle() {
        return this.style;
    }

    public Insets getInsets() {
        return this.getBorderInsets(null);
    }

    public Component getComponent() {
        return this.component;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        Insets insets;
        if (this.text != null && this.text.length() != 0) {
            Component compUsed = comp;
            if (comp == null && this.component != null) {
                compUsed = this.component;
            }
            this.textHeight = 0;
            if (this.font == null) {
                if (compUsed != null && compUsed.getFont() != null) {
                    Font currentFont = compUsed.getFont();
                    FontMetrics fontMetrics = compUsed.getFontMetrics(currentFont);
                    this.textHeight = fontMetrics.getHeight();
                }
            } else if (compUsed != null) {
                FontMetrics fontMetrics = compUsed.getFontMetrics(this.font);
                this.textHeight = fontMetrics.getHeight();
            }
            int bWidth = this.getBorderWidth();
            if (this.getStyle() == 4) {
                bWidth = 2;
            } else if (this.getStyle() == 0) {
                bWidth = 0;
            }
            int top = bWidth + this.textHeight / 2;
            if (this.textHeight > top) {
                top = this.textHeight;
            }
            insets = new Insets(top, bWidth, bWidth, bWidth);
        } else {
            int bWidth = this.getBorderWidth();
            if (this.getStyle() == 0) {
                bWidth = 0;
            } else if (this.getStyle() == 4) {
                bWidth = 2;
            }
            insets = new Insets(bWidth, bWidth, bWidth, bWidth);
        }
        if ((this.sidesPainted & 4) != 4) {
            insets.top = 0;
        }
        if ((this.sidesPainted & 8) != 8) {
            insets.bottom = 0;
        }
        if ((this.sidesPainted & 1) != 1) {
            insets.left = 0;
        }
        if ((this.sidesPainted & 2) != 2) {
            insets.right = 0;
        }
        return insets;
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.alignment;
    }

    public int getTextGap() {
        return this.textGap;
    }

    public int getTextMargin() {
        return this.margin;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.drawInRect(c, g, x, y, width, height);
    }

    public static void paintBorder(Graphics g, int x, int y, int width, int height, Color highlight, Color shadow, int style, int bWidth, int lSource, int sides) {
        if (style == 1) {
            if (lSource == 5) {
                BaseBorder.drawBezel(g, x, y, width, height, highlight, highlight, shadow, shadow, bWidth, sides);
            } else {
                BaseBorder.drawBezel(g, x, y, width, height, shadow, shadow, highlight, highlight, bWidth, sides);
            }
        } else if (style == 2) {
            BaseBorder.drawBezel(g, x, y, width, height, highlight, highlight, highlight, highlight, bWidth, sides);
        } else if (style == 3) {
            if (lSource == 5) {
                BaseBorder.drawEmboss(g, x, y, width, height, highlight, shadow, bWidth, sides);
            } else {
                BaseBorder.drawEmboss(g, x, y, width, height, shadow, highlight, bWidth, sides);
            }
        } else if (style == 4) {
            if (lSource == 5) {
                BaseBorder.drawBezel(g, x, y, width, height, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, SystemColor.controlDkShadow, SystemColor.controlDkShadow, 1, sides);
                BaseBorder.drawBezel(g, x + 1, y + 1, width - 2, height - 2, SystemColor.controlHighlight, SystemColor.controlHighlight, SystemColor.controlShadow, SystemColor.controlShadow, 1, sides);
            } else {
                BaseBorder.drawBezel(g, x, y, width, height, SystemColor.controlDkShadow, SystemColor.controlDkShadow, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, 1, sides);
                BaseBorder.drawBezel(g, x + 1, y + 1, width - 2, height - 2, SystemColor.controlShadow, SystemColor.controlShadow, SystemColor.controlHighlight, SystemColor.controlHighlight, 1, sides);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.alignment == 0) {
            this.alignment = 256;
        }
        if (this.version == 0) {
            if (this.alignment == 1) {
                this.alignment = 2;
            }
            if (this.alignment == 2) {
                this.alignment = 1;
            }
            this.version = 1;
        }
        if (this.version == 1) {
            this.sidesPainted = 15;
            this.version = 2;
        }
    }

    public void setBorderWidth(int width) {
        if (this.borderWidth != width) {
            int oldWidth = this.getBorderWidth();
            this.borderWidth = width;
            this.firePropertyChange("borderWidth", new Integer(oldWidth), new Integer(this.borderWidth));
        }
    }

    public void setStyle(int s) {
        if (this.style != s) {
            int oldStyle = this.getStyle();
            this.style = s;
            this.firePropertyChange("style", new Integer(oldStyle), new Integer(s));
        }
    }

    public void setLightSource(int ltSrc) {
        if (this.lightSource != ltSrc) {
            int oldType = this.getLightSource();
            this.lightSource = ltSrc;
            this.firePropertyChange("lightSource", new Integer(oldType), new Integer(ltSrc));
        }
    }

    public void setComponent(Component comp) {
        if (this.component != comp) {
            this.component = comp;
            this.changeSupport.addPropertyChangeListener(new PropertyChangeCommandAdaptor(new RefreshCommand(this.component)));
            if (this.font == null && this.component.getFont() != null) {
                this.font = this.component.getFont();
                FontMetrics fontInfo = this.component.getFontMetrics(this.font);
                this.textHeight = fontInfo.getHeight();
            }
        }
    }

    public void setFont(Font f) {
        if (!com.sas.util.Util.equal((Object)this.font, (Object)f)) {
            Font oldFont = this.font;
            this.font = f;
            this.firePropertyChange("font", oldFont, this.font);
        }
    }

    public void setText(String txt) {
        if (this.text == null && txt == null) {
            return;
        }
        if (!com.sas.util.Util.equal((Object)this.text, (Object)txt)) {
            String oldText = this.text;
            this.text = txt;
            this.firePropertyChange("text", oldText, this.text);
        }
    }

    public void setTextAlignment(int a) {
        if (this.alignment != a) {
            int oldAlign = this.alignment;
            this.alignment = a;
            this.firePropertyChange("alignment", new Integer(oldAlign), new Integer(this.alignment));
        }
    }

    public void setTextGap(int g) {
        if (this.textGap != g) {
            int oldTextGap = this.textGap;
            this.textGap = g;
            this.firePropertyChange("textGap", new Integer(oldTextGap), new Integer(this.textGap));
        }
    }

    public void setTextMargin(int m) {
        if (this.margin != m) {
            int oldMargin = this.margin;
            this.margin = m;
            this.firePropertyChange("margin", new Integer(oldMargin), new Integer(this.margin));
        }
    }

    public void setBackgroundColor(Color c) {
        Color oldColor = this.backgroundColor;
        if (!com.sas.util.Util.equal((Object)c, (Object)this.backgroundColor)) {
            this.backgroundColor = c;
            this.firePropertyChange("backgroundColor", oldColor, this.backgroundColor);
        }
    }

    public void setForegroundColor(Color c) {
        Color oldColor = this.foregroundColor;
        if (!com.sas.util.Util.equal((Object)c, (Object)this.foregroundColor)) {
            this.foregroundColor = c;
            this.firePropertyChange("foregroundColor", oldColor, this.foregroundColor);
        }
    }

    public void setBaseColor(Color c) {
        if (c != null && !com.sas.util.Util.equal((Object)c, (Object)this.getBaseColor())) {
            this.baseColorJ = c;
            this.setHighlightColor(this.getBaseColor().brighter());
            this.setShadowColor(this.getBaseColor().darker());
        }
    }

    public void setHighlightColor(Color c) {
        if (!com.sas.util.Util.equal((Object)c, (Object)this.highlightColor)) {
            Color oldColor = this.highlightColor;
            this.highlightColor = c;
            this.firePropertyChange("highlightColor", oldColor, this.highlightColor);
        }
    }

    public void setShadowColor(Color c) {
        if (!com.sas.util.Util.equal((Object)c, (Object)this.shadowColor)) {
            Color oldColor = this.shadowColor;
            this.shadowColor = c;
            this.firePropertyChange("shadowColor", oldColor, this.shadowColor);
        }
    }

    protected String paramString() {
        String styleString = "NONE";
        switch (this.getStyle()) {
            case 1: {
                styleString = "BEZEL";
                break;
            }
            case 4: {
                styleString = "BUTTON";
                break;
            }
            case 3: {
                styleString = "EMBOSS";
                break;
            }
            case 2: {
                styleString = "SIMPLE";
            }
        }
        String borderStruct = "Insets=" + this.getInsets() + ",Style=" + styleString + ",Shadow=" + this.shadowColor + ",Highlight=" + this.highlightColor + ",Base=" + this.getBaseColor() + ",Foreground=" + this.foregroundColor + ",Background=" + this.backgroundColor + ",Font=" + this.font + ",Text=" + this.text + ",TextMargin=" + this.margin;
        switch (this.getTextAlignment()) {
            case 256: {
                borderStruct = borderStruct + ",TextAlignment=CENTER";
                break;
            }
            case 1: {
                borderStruct = borderStruct + ",TextAlignment=LEFT";
                break;
            }
            case 2: {
                borderStruct = borderStruct + ",TextAlignment=RIGHT";
            }
        }
        return borderStruct;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public int hashCode() {
        int code = super.hashCode();
        if (this.getShadowColor() != null) {
            code += this.getShadowColor().hashCode();
        }
        if (this.getHighlightColor() != null) {
            code += this.getHighlightColor().hashCode();
        }
        if (this.getBackgroundColor() != null) {
            code += this.getBackgroundColor().hashCode();
        }
        if (this.getForegroundColor() != null) {
            code += this.getForegroundColor().hashCode();
        }
        if (this.getFont() != null) {
            code += this.getFont().hashCode();
        }
        if (this.getText() != null) {
            code += this.getText().hashCode();
        }
        code += this.getTextGap();
        code += this.getTextAlignment();
        code += this.getTextMargin();
        return code += this.getSidesPainted();
    }

    public boolean equals(Object item) {
        BaseBorder baseBorder;
        return item instanceof BaseBorder && (baseBorder = (BaseBorder)item) != null && com.sas.util.Util.equal((Object)baseBorder.getShadowColor(), (Object)this.getShadowColor()) && com.sas.util.Util.equal((Object)baseBorder.getHighlightColor(), (Object)this.getHighlightColor()) && com.sas.util.Util.equal((Object)baseBorder.getBackgroundColor(), (Object)this.getBackgroundColor()) && com.sas.util.Util.equal((Object)baseBorder.getForegroundColor(), (Object)this.getForegroundColor()) && com.sas.util.Util.equal((Object)baseBorder.getFont(), (Object)this.getFont()) && com.sas.util.Util.equal((Object)baseBorder.getText(), (Object)this.getText()) && baseBorder.getTextGap() == this.getTextGap() && baseBorder.getTextAlignment() == this.getTextAlignment() && baseBorder.getTextMargin() == this.getTextMargin() && baseBorder.getSidesPainted() == this.getSidesPainted() && this.getLightSource() == baseBorder.getLightSource() && this.getStyle() == baseBorder.getStyle() && this.getBorderWidth() == baseBorder.getBorderWidth() && com.sas.util.Util.equal((Object)this.getBaseColor(), (Object)baseBorder.getBaseColor());
    }
}

