/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.util;

import com.sas.codepolicy.SASScope;
import com.sas.swing.util.RB;
import com.sas.text.Message;
import com.sas.util.setinit.LeasableProduct;
import com.sas.util.setinit.ProductLease;
import com.sas.util.setinit.ProductSetinitException;
import com.sas.util.setinit.SetinitVerifierInterface;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JOptionPane;

@SASScope
public class SetinitUtil {
    public static final String RB_KEY = "SetinitUtil.";

    public static ProductLease[] leaseProducts(Component parent, SetinitVerifierInterface verifier, LeasableProduct[] products, long duration) throws ProductSetinitException {
        if (verifier.isExpired()) {
            String error = RB.getStringResource(RB_KEY, "sasSystemExpired.txt");
            JOptionPane.showMessageDialog(parent, error);
            throw new ProductSetinitException(error);
        }
        Locale loc = null;
        if (parent != null) {
            loc = parent.getLocale();
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        try {
            ProductLease[] leases = verifier.leaseProducts(products, duration);
            int warningPeriod = verifier.getWarningPeriod();
            for (int i = 0; i < leases.length; ++i) {
                long daysTilExpiration = leases[i].getLeaseExpirationDuration();
                if ((long)warningPeriod <= daysTilExpiration) continue;
                Date expire = verifier.getProductExpirationDate(products[i]);
                DateFormat formatter = DateFormat.getDateInstance(2, loc);
                String warn = Message.format((String)RB.getStringResource(RB_KEY, "inWarningPeriod.txt"), (Object)formatter.format(expire), (Object)new Long(daysTilExpiration));
                JOptionPane.showMessageDialog(parent, warn, null, 2);
            }
            return leases;
        }
        catch (ProductSetinitException pse) {
            JOptionPane.showMessageDialog(parent, RB.getStringResource(RB_KEY, "sasNotLicensed.txt"));
            throw pse;
        }
    }
}

