/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.beans.PropertyChangeSource;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.SequentialCache;
import com.sas.models.StaticCacheInterface;
import com.sas.models.ThresholdInterface;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.prompts.ViewQueryCacheInterface;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.swing.models.CollectionToComboBoxModelAdapter;
import com.sas.swing.models.RB;
import com.sas.swing.visuals.ComboBox;
import com.sas.table.MutableTableColumnsInterface;
import com.sas.table.TrueRowCountCalculatedInterface;
import com.sas.util.ListFactory;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerRepository2;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeModel;

@SASScope
public class ValueProviderModelAdapter
implements PropertyChangeSource,
MutableSupportedSpecialValuesInterface,
MutableTableColumnsInterface {
    public static final String RB_KEY = "ValueProviderModelAdapter.";
    public static final String LABEL_COLUMN = "LABEL";
    public static final String VALUE_COLUMN = "VALUE";
    private static String QUALIFIED_LABEL = "QUALIFIED_LABEL";
    public static final int PAGING_MODE = 600;
    public static final int STATIC_MODE = 601;
    public static final int COMBO_MODE = 602;
    public static final int SEARCH_MODE = 603;
    private SupportedSpecialValues specialValues;
    private List additionalValues;
    private ValueProviderInterface valueProvider;
    private DataTypeInterface setDataType;
    private Locale locale;
    private List columnOrder;
    private Map columnNames;
    private int mode;
    private Object initValues;
    private Object model;
    private boolean addNullValueForSingleComboSelection;
    private boolean addBrowseSearchOption;
    private boolean loadingValues;
    protected SwingPropertyChangeSupport spcs;
    private ValueItem allValue;
    private ValueItem otherValue;
    private ValueItem missingValue;
    public static ValueItem MORE_VALUES = new ValueItem((Object)RB.getStringResource("ValueProviderModelAdapter.", "moreValues.txt"), (Object)"-MORE_VALUES-");
    public static ValueItem SEPARATOR = new ValueItem((Object)" ", (Object)"-SEPARATOR-");
    private static ValueItem NULL_VALUE_ITEM = new ValueItem((Object)"", null);
    public static ValueItem NO_RESULTS_FOUND = new ValueItem((Object)"", (Object)" ");
    private int pageSize;
    private SequentialCache primaryCache;
    private SecondaryValueItemCache secondaryValueItemCache;
    private ViewQueryCacheInterface viewQueryCache;
    private int threshold;

    public ValueProviderModelAdapter(ValueProviderInterface valueProvider, int mode, Locale locale) {
        this(valueProvider, mode, null, locale);
    }

    public ValueProviderModelAdapter(ValueProviderInterface valueProvider, DataTypeInterface dataType, int mode, Locale locale) {
        this(valueProvider, dataType, mode, null, locale);
    }

    public ValueProviderModelAdapter(ValueProviderInterface valueProvider, DataTypeInterface dataType, int mode, int pageSize, Locale locale) {
        this(valueProvider, dataType, mode, null, pageSize, locale);
    }

    public ValueProviderModelAdapter(ValueProviderInterface valueProvider, int mode, SupportedSpecialValues specialValues, Locale locale) {
        this(valueProvider, null, mode, specialValues, locale);
    }

    public ValueProviderModelAdapter(ValueProviderInterface valueProvider, int mode, SupportedSpecialValues specialValues, int pageSize, Locale locale) {
        this(valueProvider, null, mode, specialValues, pageSize, locale);
    }

    public ValueProviderModelAdapter(ValueProviderInterface valueProvider, DataTypeInterface dataType, int mode, SupportedSpecialValues specialValues, Locale locale) {
        this(valueProvider, dataType, mode, specialValues, -1, locale);
    }

    public ValueProviderModelAdapter(ValueProviderInterface valueProvider, DataTypeInterface dataType, int mode, SupportedSpecialValues specialValues, int pageSize, Locale locale) {
        this.valueProvider = valueProvider;
        this.locale = locale;
        this.mode = mode;
        this.setDataType = dataType;
        this.init();
        this.setPageSize(pageSize);
        this.specialValues = specialValues;
        this.setSupportedSpecialValues(specialValues);
        this.getNoResultsFoundValue().setLabel(RB.getStringResource(RB_KEY, "noResultsFound.txt", locale));
        this.getMoreOptionsValue().setLabel(RB.getStringResource(RB_KEY, "moreValues.txt", locale));
    }

    protected void calculateThreshold() {
        Map thresholdMap;
        int userThreshold = ViewQueryCacheInterface.DEFAULT_RELATIONAL_THRESHOLD;
        ViewQueryCacheInterface dp = this.getViewQueryCache();
        if (dp != null && (thresholdMap = dp.getThresholdMap()) != null && thresholdMap.containsKey("RELATIONAL_LIST_THRESHOLD")) {
            userThreshold = (Integer)thresholdMap.get("RELATIONAL_LIST_THRESHOLD");
        }
        if (this.valueProvider != null && this.valueProvider instanceof ThresholdInterface) {
            userThreshold = ((ThresholdInterface)this.valueProvider).getThreshold();
        }
        this.threshold = userThreshold;
        if (userThreshold < 0) {
            userThreshold = ViewQueryCacheInterface.DEFAULT_RELATIONAL_THRESHOLD;
        }
        int maxCacheSize = userThreshold;
        int bufferLookAhead = userThreshold;
        if (this.primaryCache != null) {
            try {
                this.primaryCache.configureCache(maxCacheSize, bufferLookAhead, -1, -1, -1);
            }
            catch (CacheException ce) {
                ce.printStackTrace();
            }
        }
    }

    public void resetCache() {
        if (this.primaryCache != null) {
            SecondaryValueItemCache sc = (SecondaryValueItemCache)this.primaryCache.getSecondaryCache();
            sc.reset();
            this.primaryCache.invalidateCache();
        }
    }

    public ViewQueryCacheInterface getViewQueryCache() {
        return this.viewQueryCache;
    }

    public void setViewQueryCache(ViewQueryCacheInterface viewQueryCache) {
        if (this.viewQueryCache != viewQueryCache) {
            this.viewQueryCache = viewQueryCache;
            this.calculateThreshold();
            if (viewQueryCache != null && this.primaryCache != null) {
                viewQueryCache.addViewCache((Object)this, this.primaryCache);
            }
        }
    }

    public ValueItem getMoreOptionsValue() {
        return MORE_VALUES;
    }

    public ValueItem getSeperatorValue() {
        return SEPARATOR;
    }

    public ValueItem getNoResultsFoundValue() {
        return NO_RESULTS_FOUND;
    }

    private void init() {
        this.spcs = new SwingPropertyChangeSupport(this);
        this.pageSize = 100;
        this.addNullValueForSingleComboSelection = true;
        this.addBrowseSearchOption = false;
        this.loadingValues = false;
        if (this.columnOrder == null) {
            this.columnOrder = new ArrayList();
            this.columnOrder.add(LABEL_COLUMN);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            int oldSize = this.pageSize;
            this.pageSize = pageSize;
            this.initValues = null;
            this.model = null;
        }
    }

    public void search(SearchCriteria searchCriteria) throws ValueProviderException {
        this.initCacheIfNeeded();
        if (this.mode == 603) {
            if (!(this.model instanceof ValueProviderToTableModelAdapter)) {
                this.model = new ValueProviderToTableModelAdapter();
            }
            ((ValueProviderToTableModelAdapter)this.model).search(searchCriteria);
        }
    }

    public void clearSearchResults() {
        if (this.mode == 603 && this.model instanceof ValueProviderToTableModelAdapter) {
            ((ValueProviderToTableModelAdapter)this.model).clearSearchResults();
        }
    }

    public ValueItem getAllValue() {
        if (this.allValue == null) {
            this.allValue = new ValueItem((Object)SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.locale), (Object)SpecialValues.ALL);
        }
        return this.allValue;
    }

    public ValueItem getOtherValue() {
        if (this.otherValue == null) {
            this.otherValue = new ValueItem((Object)SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.locale), (Object)SpecialValues.OTHER);
        }
        return this.otherValue;
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        if (this.setDataType != null) {
            return this.setDataType;
        }
        DataTypeInterface dataType = null;
        if (this.valueProvider != null) {
            dataType = this.valueProvider.getDataType();
        }
        return dataType;
    }

    public void setDataType(DataTypeInterface newDataType) {
        DataTypeInterface oldDT = this.setDataType;
        if (oldDT != newDataType) {
            this.setDataType = newDataType;
            this.initValues = null;
            this.model = null;
            this.missingValue = null;
            this.spcs.firePropertyChange("dataType", oldDT, newDataType);
        }
    }

    public ValueItem getMissingValue() {
        if (this.missingValue == null) {
            DataTypeInterface dataType = null;
            try {
                dataType = this.getDataType();
            }
            catch (ValueProviderException valueProviderException) {
                // empty catch block
            }
            this.missingValue = dataType instanceof StringType ? new ValueItem((Object)MissingValues.toDisplayString((MissingValues)MissingValues._BLANK_, (Locale)this.locale), (Object)MissingValues._BLANK_) : new ValueItem((Object)MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)this.locale), (Object)MissingValues.Dot);
        }
        return this.missingValue;
    }

    public void setAddNullValueForSingleComboSelection(boolean addNullValueForSingleComboSelection) {
        if (this.addNullValueForSingleComboSelection != addNullValueForSingleComboSelection) {
            this.addNullValueForSingleComboSelection = addNullValueForSingleComboSelection;
            if (this.model instanceof ComboBoxModelWrapper) {
                ComboBoxModelWrapper adapter = (ComboBoxModelWrapper)this.model;
                if (this.addNullValueForSingleComboSelection) {
                    adapter.fireIntervalAdded(adapter, 0, 0);
                } else {
                    adapter.fireIntervalRemoved(adapter, 0, 0);
                }
            }
        }
    }

    public Object getModel() throws ValueProviderException {
        this.initCacheIfNeeded();
        if (this.model == null) {
            this.getValues();
        }
        return this.model;
    }

    private void initCacheIfNeeded() {
        if (this.primaryCache == null) {
            this.secondaryValueItemCache = new SecondaryValueItemCache(this.locale, ValueType.TREETHENLIST);
            this.primaryCache = new SequentialCache((StaticCacheInterface)this.secondaryValueItemCache);
            this.calculateThreshold();
            if (this.viewQueryCache != null) {
                this.viewQueryCache.addViewCache((Object)this, this.primaryCache);
            }
        }
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValues) {
        int oldSize = -1;
        if (this.specialValues != null) {
            if (this.specialValues.isAllSupported()) {
                ++oldSize;
            }
            if (this.specialValues.isMissingValuesSupported() && !this.specialValues.isMissingValuesHiddenIfSupported()) {
                ++oldSize;
            }
            if (this.specialValues.isOtherSupported()) {
                ++oldSize;
            }
        }
        this.specialValues = specialValues;
        int newSize = -1;
        if (this.specialValues != null) {
            if (this.specialValues.isAllSupported()) {
                ++newSize;
            }
            if (this.specialValues.isMissingValuesSupported() && !this.specialValues.isMissingValuesHiddenIfSupported()) {
                ++newSize;
            }
            if (this.specialValues.isOtherSupported()) {
                ++newSize;
            }
        }
        if (oldSize >= 0 || newSize >= 0) {
            if (this.model instanceof ValueProviderToTableModelAdapter) {
                ValueProviderToTableModelAdapter adapter = (ValueProviderToTableModelAdapter)this.model;
                if (oldSize == newSize) {
                    adapter.fireTableRowsUpdated(0, oldSize);
                } else if (oldSize > newSize) {
                    if (newSize >= 0) {
                        adapter.fireTableRowsUpdated(0, newSize);
                    }
                    int rowsDeleted = oldSize + 1 - (newSize + 1);
                    if (newSize == -1 && (adapter.trueRowCount > 0 || adapter.currentRowCount > 0)) {
                        ++rowsDeleted;
                    }
                    adapter.fireTableRowsDeleted(newSize + 1, newSize + rowsDeleted);
                } else if (newSize > oldSize) {
                    if (oldSize >= 0) {
                        adapter.fireTableRowsUpdated(0, oldSize);
                    } else if (adapter.trueRowCount > 0 || adapter.currentRowCount > 0) {
                        ++newSize;
                    }
                    adapter.fireTableRowsInserted(oldSize + 1, newSize);
                }
            } else if (this.model instanceof ComboBoxModelWrapper) {
                ComboBoxModelWrapper adapter = (ComboBoxModelWrapper)this.model;
                if (oldSize == newSize) {
                    adapter.fireContentsChanged(adapter, 0, oldSize);
                } else if (oldSize > newSize) {
                    if (newSize >= 0) {
                        adapter.fireContentsChanged(adapter, 0, newSize);
                    }
                    int rowsDeleted = oldSize + 1 - (newSize + 1);
                    if (newSize == -1 && adapter.model.getSize() > 0) {
                        ++rowsDeleted;
                    }
                    adapter.fireIntervalRemoved(adapter, newSize + 1, newSize + rowsDeleted);
                } else if (newSize > oldSize) {
                    if (oldSize >= 0) {
                        adapter.fireContentsChanged(adapter, 0, oldSize);
                    } else if (adapter.model.getSize() > 0) {
                        ++newSize;
                    }
                    adapter.fireIntervalAdded(adapter, oldSize + 1, newSize);
                }
            }
        }
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }

    public boolean isSeparatorIndex(int index) {
        boolean isSeparatorIndex = false;
        if (this.model instanceof ValueProviderToTableModelAdapter) {
            List separatorIndices = ((ValueProviderToTableModelAdapter)this.model).getSeparatorRowIndices();
            for (Integer separatorIndex : separatorIndices) {
                if (separatorIndex != index) continue;
                return true;
            }
        } else if (this.model instanceof ComboBoxModelWrapper) {
            // empty if block
        }
        return isSeparatorIndex;
    }

    public int getColumnCount() {
        if (this.columnOrder == null) {
            this.columnOrder = new ArrayList();
            this.columnOrder.add(LABEL_COLUMN);
        }
        return this.columnOrder.size();
    }

    public List getColumns() {
        return ListFactory.newList((Collection)this.columnOrder);
    }

    public void setColumns(List columns) {
        if (columns != null && !Util.equal((Object)columns, (Object)this.columnOrder)) {
            this.columnOrder = columns;
        }
    }

    private void getValues() throws ValueProviderException {
        try {
            Object v = null;
            if (this.valueProvider != null) {
                if (this.initValues == null) {
                    v = this.getInitValues();
                    if (v == null) {
                        v = Collections.EMPTY_LIST;
                    }
                    if (v instanceof List) {
                        this.initValues = ListFactory.newList((Collection)((List)v));
                    }
                } else {
                    v = this.initValues;
                }
            }
            if (v instanceof TreeModel) {
                this.model = v;
            } else {
                if (this.mode != 603 && this.initValues != null) {
                    List oo;
                    if (this.getReadAheadAmount() < 0) {
                        this.addBrowseSearchOption = false;
                    }
                    this.addBrowseSearchOption = this.mode != 600 && ((Collection)this.initValues).size() == this.getReadAheadAmount() ? (oo = this.queryValues(null, this.getPageSize(), 1)) instanceof List && oo.size() == 1 : false;
                }
                this.model = this.mode == 602 ? new ComboBoxModelWrapper(new CollectionToComboBoxModelAdapter((Collection)this.initValues), this.getDataType()) : new ValueProviderToTableModelAdapter();
            }
        }
        finally {
            if (this.initValues == null) {
                this.initValues = ListFactory.newList((Collection)Collections.EMPTY_LIST);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInitValues() throws ValueProviderException {
        try {
            Object o;
            this.setLoadingValues(true);
            List l = Collections.EMPTY_LIST;
            if (this.mode != 603 && (l = this.queryValues(null, 0, this.getPageSize())).size() == 1 && (o = l.get(0)) != null && o instanceof TreeModel) {
                Object e = o;
                return e;
            }
            List list = l;
            return list;
        }
        finally {
            this.setLoadingValues(false);
        }
    }

    private List queryValues(SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        try {
            int startKey = index;
            int endKey = index + count - 1;
            Object[] values = null;
            if (this.primaryCache.cacheContainsKey((long)startKey) && this.primaryCache.cacheContainsKey((long)endKey)) {
                values = this.primaryCache.getFromCache((long)startKey, (long)endKey, true);
            } else {
                this.secondaryValueItemCache.setSearchCriteria(searchCriteria);
                values = this.primaryCache.getFromCache((long)startKey, (long)endKey, false);
                if (values.length < count && this.primaryCache.cacheContainsKey((long)startKey)) {
                    int endIndex = this.primaryCache.count() - 1;
                    values = this.primaryCache.getFromCache((long)startKey, (long)endIndex, true);
                } else if (this.primaryCache.cacheContainsKey((long)startKey) && this.primaryCache.cacheContainsKey((long)endKey)) {
                    values = this.primaryCache.getFromCache((long)startKey, (long)endKey, true);
                }
            }
            return values != null ? Arrays.asList(values) : Collections.EMPTY_LIST;
        }
        catch (CacheException ce) {
            throw new ValueProviderException((Throwable)ce, ce.getMessage());
        }
    }

    public void setModel(ValueProviderInterface valueProvider) {
        ValueProviderInterface oldModel = this.valueProvider;
        if (oldModel != valueProvider) {
            this.valueProvider = valueProvider;
            this.initValues = null;
            this.model = null;
            this.missingValue = null;
            this.calculateThreshold();
            this.spcs.firePropertyChange("model", oldModel, valueProvider);
        }
    }

    public void refresh() {
        this.initValues = null;
        this.model = null;
        this.resetCache();
        this.calculateThreshold();
    }

    public void setColumnName(String columnName, int columnIndex) {
        if (this.columnNames == null) {
            this.columnNames = new HashMap();
        }
        Integer key = new Integer(columnIndex);
        String oldName = this.getColumnName(columnIndex);
        if (!Util.equal((Object)oldName, (Object)columnName)) {
            this.columnNames.put(key, columnName);
        }
    }

    public String getColumnName(int columnIndex) {
        if (this.columnNames != null) {
            return (String)this.columnNames.get(new Integer(columnIndex));
        }
        return "";
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public int getMode() {
        return this.mode;
    }

    public ValueProviderInterface getValueProvider() {
        return this.valueProvider;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setAdditionalAvailableValues(List additionalValues) {
        int oldSize = 0;
        if (this.additionalValues != null) {
            oldSize = this.additionalValues.size();
        }
        int oldStartRow = 0;
        if (this.model instanceof ValueProviderToTableModelAdapter) {
            oldStartRow = ((ValueProviderToTableModelAdapter)this.model).getStartRowOfAddtitionalValues();
        } else if (this.model instanceof ComboBoxModelWrapper) {
            oldStartRow = ((ComboBoxModelWrapper)this.model).getStartRowOfAddtitionalValues();
        }
        this.additionalValues = additionalValues;
        int newSize = 0;
        if (this.additionalValues != null) {
            newSize = this.additionalValues.size();
        }
        if (oldSize > 0 || newSize > 0) {
            if (this.model instanceof ValueProviderToTableModelAdapter) {
                ValueProviderToTableModelAdapter adapter = (ValueProviderToTableModelAdapter)this.model;
                if (oldSize == newSize) {
                    adapter.fireTableRowsUpdated(oldStartRow, oldStartRow + oldSize);
                } else if (oldSize > newSize) {
                    if (newSize > 0) {
                        adapter.fireTableRowsUpdated(oldStartRow, oldStartRow + newSize);
                    }
                    adapter.fireTableRowsDeleted(oldStartRow + newSize, oldStartRow + oldSize);
                } else if (newSize > oldSize) {
                    if (oldSize > 0) {
                        adapter.fireTableRowsUpdated(oldStartRow, oldStartRow + oldSize);
                    }
                    adapter.fireTableRowsInserted(oldStartRow + oldSize, oldStartRow + newSize);
                }
            } else if (this.model instanceof ComboBoxModelWrapper) {
                ComboBoxModelWrapper adapter = (ComboBoxModelWrapper)this.model;
                if (oldSize == newSize) {
                    adapter.fireContentsChanged(adapter, oldStartRow, oldStartRow + oldSize);
                } else if (oldSize > newSize) {
                    if (newSize > 0) {
                        adapter.fireContentsChanged(adapter, oldStartRow, oldStartRow + newSize);
                    }
                    adapter.fireIntervalRemoved(adapter, oldStartRow + newSize, oldStartRow + oldSize);
                } else if (newSize > oldSize) {
                    if (oldSize > 0) {
                        adapter.fireContentsChanged(adapter, oldStartRow, oldStartRow + oldSize);
                    }
                    adapter.fireIntervalAdded(adapter, oldStartRow + oldSize, oldStartRow + newSize);
                }
            }
        }
    }

    public boolean isLoadingValues() {
        return this.loadingValues;
    }

    public void setLoadingValues(boolean loadingValues) {
        if (this.loadingValues != loadingValues) {
            boolean oldValue = this.loadingValues;
            this.loadingValues = loadingValues;
            this.spcs.firePropertyChange("loadingValues", oldValue, this.loadingValues);
        }
    }

    private boolean readUntilEnd(int size) {
        if (this.getPageSize() > 0 && size < this.getPageSize()) {
            return true;
        }
        return this.getPageSize() <= 0 && (!(this.valueProvider instanceof ThresholdInterface) || ((ThresholdInterface)this.valueProvider).getThreshold() <= -1 || size < ((ThresholdInterface)this.valueProvider).getThreshold());
    }

    private int getReadAheadAmount() {
        if (this.getPageSize() > 0) {
            return this.getPageSize();
        }
        if (!(this.getPageSize() > 0 || this.valueProvider instanceof ThresholdInterface && ((ThresholdInterface)this.valueProvider).getThreshold() > -1)) {
            return -1;
        }
        return ((ThresholdInterface)this.valueProvider).getThreshold();
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            Locale oldValue = this.locale;
            this.locale = locale;
            this.missingValue = null;
            this.allValue = null;
            this.otherValue = null;
            this.getNoResultsFoundValue().setLabel(RB.getStringResource(RB_KEY, "noResultsFound.txt", locale));
            this.getMoreOptionsValue().setLabel(RB.getStringResource(RB_KEY, "moreValues.txt", locale));
            this.spcs.firePropertyChange("locale", oldValue, this.locale);
        }
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            int oldMode = this.mode;
            this.mode = mode;
            this.model = null;
            this.spcs.firePropertyChange("mode", oldMode, this.mode);
        }
    }

    @SASScope
    class SecondaryValueItemCache
    implements StaticCacheInterface {
        SearchCriteria searchCriteria;
        Locale locale;
        ValueType returnType;
        List allValues;

        public SecondaryValueItemCache(Locale locale, ValueType returnType) {
            this.locale = locale;
            this.returnType = returnType;
        }

        public void setSearchCriteria(SearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
        }

        public void setReturnType(ValueType returnType) {
            this.returnType = returnType;
        }

        public void reset() {
            this.searchCriteria = null;
            this.allValues = null;
        }

        public Object[] getFromCache(long startKey, long endKey, boolean readFully) throws CacheException {
            try {
                int startIndex = 0;
                int count = (int)endKey + 1;
                Object vpValues = null;
                List<TreeModel> values = Collections.EMPTY_LIST;
                if (ValueProviderModelAdapter.this.threshold < 0) {
                    if (this.allValues != null) {
                        values = this.allValues;
                        int endIndex = Math.min((int)endKey + 1, values.size());
                        List subList = values.subList((int)startKey, endIndex);
                        return subList.toArray();
                    }
                } else {
                    vpValues = ValueProviderModelAdapter.this.valueProvider instanceof ListSearchInterface && this.searchCriteria != null ? ((ListSearchInterface)ValueProviderModelAdapter.this.valueProvider).getValues(this.locale, this.searchCriteria, startIndex, count) : ValueProviderModelAdapter.this.valueProvider.getValues(this.locale, this.returnType, startIndex, count);
                    if (vpValues instanceof List) {
                        int size;
                        values = (List)vpValues;
                        int newCacheSize = size = values.size();
                        if (size > ValueProviderModelAdapter.this.primaryCache.getCacheCapacity() || size < count) {
                            ValueProviderModelAdapter.this.primaryCache.configureCache(newCacheSize, -1, -1, -1, -1);
                        }
                        if (startKey > 0L) {
                            int endIndex = Math.min((int)endKey + 1, size);
                            List<TreeModel> subList = values.subList((int)startKey, endIndex);
                            return subList.toArray();
                        }
                    } else if (vpValues instanceof TreeModel) {
                        values = Collections.singletonList((TreeModel)vpValues);
                    }
                }
                return values.toArray();
            }
            catch (ValueProviderException me) {
                throw new CacheException((Exception)((Object)me));
            }
        }

        public Object getFromCache(long key) throws CacheException {
            Object[] vi = this.getFromCache(key, key, true);
            return vi != null && vi.length > 0 ? vi[0] : null;
        }

        public Object[] getFromCache(long[] keys, boolean readFully) throws CacheException {
            return this.getFromCache(keys[0], keys[keys.length - 1], readFully);
        }

        public long[] computeCacheKeyRange(long startKey, long endKey, int size) throws CacheException {
            if (ValueProviderModelAdapter.this.threshold < 0) {
                List l = this.getAllValuesFromServer();
                int allValuesSize = l.size();
                if (allValuesSize == 0) {
                    ++allValuesSize;
                }
                long[] keys = SequentialCache.computeSequentialKeyRange((long)startKey, (long)endKey, (int)(allValuesSize - (int)startKey));
                return keys;
            }
            return SequentialCache.computeSequentialKeyRange((long)startKey, (long)endKey, (int)size);
        }

        public boolean cacheContainsKey(long key) throws CacheException {
            return false;
        }

        public void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int thresholdValue, int accessType) throws CacheException {
        }

        public int getCacheKeyUse() {
            return 0;
        }

        public long[] getCacheKeys() throws CacheException {
            return new long[0];
        }

        public StaticCacheInterface getSecondaryCache() {
            return null;
        }

        public int count() {
            return 0;
        }

        public void useBufferHints(BufferHints hints) {
        }

        private List getAllValuesFromServer() throws CacheException {
            if (this.allValues == null) {
                this.allValues = Collections.EMPTY_LIST;
                try {
                    Object vpValues = null;
                    vpValues = ValueProviderModelAdapter.this.valueProvider instanceof ListSearchInterface && this.searchCriteria != null ? ((ListSearchInterface)ValueProviderModelAdapter.this.valueProvider).getValues(this.locale, this.searchCriteria, 0, -1) : ValueProviderModelAdapter.this.valueProvider.getValues(this.locale, ValueType.TREETHENLIST, 0, -1);
                    if (vpValues instanceof List) {
                        this.allValues = (List)vpValues;
                        int newCacheSize = this.allValues.size();
                        ValueProviderModelAdapter.this.primaryCache.configureCache(newCacheSize, -1, -1, -1, -1);
                    } else if (vpValues instanceof TreeModel) {
                        this.allValues = Collections.singletonList((TreeModel)vpValues);
                    }
                }
                catch (ValueProviderException ve) {
                    CacheException ce = new CacheException(ve.getMessage());
                    ce.initCause((Throwable)ve);
                    throw ce;
                }
            }
            return this.allValues;
        }
    }

    @SASScope
    public class ValueProviderToTableModelAdapter
    extends AbstractTableModel
    implements MutableTableColumnsInterface,
    TrueRowCountCalculatedInterface {
        private int trueRowCount;
        private int currentRowCount;
        private SearchCriteria searchCriteria;

        public ValueProviderToTableModelAdapter() {
            this.init();
        }

        private void init() {
            this.trueRowCount = -1;
            this.currentRowCount = -1;
            if (ValueProviderModelAdapter.this.initValues != null && ValueProviderModelAdapter.this.initValues instanceof Collection) {
                int size;
                this.currentRowCount = size = ((Collection)ValueProviderModelAdapter.this.initValues).size();
                if (ValueProviderModelAdapter.this.readUntilEnd(size)) {
                    this.trueRowCount = size;
                }
            }
        }

        @Override
        public int getColumnCount() {
            return ValueProviderModelAdapter.this.getColumnCount();
        }

        private void getValues() throws ValueProviderException {
            Object v = null;
            if (ValueProviderModelAdapter.this.getValueProvider() != null) {
                v = ValueProviderModelAdapter.this.getInitValues();
            }
            if (v instanceof List) {
                int size;
                this.currentRowCount = size = ((List)v).size();
                if (ValueProviderModelAdapter.this.readUntilEnd(size)) {
                    this.trueRowCount = size;
                }
            } else {
                this.currentRowCount = 0;
                this.trueRowCount = 0;
            }
        }

        public List getSeparatorRowIndices() {
            ArrayList<Integer> separatorIndices = new ArrayList<Integer>();
            if (ValueProviderModelAdapter.this.getMode() != 603) {
                int rowCount = this.getRowCount();
                if (ValueProviderModelAdapter.this.addBrowseSearchOption) {
                    separatorIndices.add(new Integer(rowCount - 1));
                }
                int sizeIncrease = 0;
                if (ValueProviderModelAdapter.this.specialValues != null) {
                    int preSpecialValuesSize = sizeIncrease++;
                    if (ValueProviderModelAdapter.this.specialValues.isAllSupported()) {
                        // empty if block
                    }
                    if (ValueProviderModelAdapter.this.specialValues.isMissingValuesSupported() && !ValueProviderModelAdapter.this.specialValues.isMissingValuesHiddenIfSupported()) {
                        ++sizeIncrease;
                    }
                    if (ValueProviderModelAdapter.this.specialValues.isOtherSupported()) {
                        ++sizeIncrease;
                    }
                    if ((this.trueRowCount > 0 || this.currentRowCount > 0) && sizeIncrease > preSpecialValuesSize) {
                        separatorIndices.add(new Integer(++sizeIncrease - 1));
                    }
                }
            }
            return separatorIndices;
        }

        @Override
        public int getRowCount() {
            try {
                if (this.currentRowCount == -1) {
                    this.getValues();
                }
            }
            catch (ValueProviderException e) {
                LoggerRepository2.getLogger((String)ValueProviderModelAdapter.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
            int sizeIncrease = 0;
            if (ValueProviderModelAdapter.this.getMode() != 603) {
                if (ValueProviderModelAdapter.this.addBrowseSearchOption) {
                    sizeIncrease = 2;
                }
                if (ValueProviderModelAdapter.this.specialValues != null) {
                    int preSpecialValuesSize = sizeIncrease++;
                    if (ValueProviderModelAdapter.this.specialValues.isAllSupported()) {
                        // empty if block
                    }
                    if (ValueProviderModelAdapter.this.specialValues.isMissingValuesSupported() && !ValueProviderModelAdapter.this.specialValues.isMissingValuesHiddenIfSupported()) {
                        ++sizeIncrease;
                    }
                    if (ValueProviderModelAdapter.this.specialValues.isOtherSupported()) {
                        ++sizeIncrease;
                    }
                    if ((this.trueRowCount > 0 || this.currentRowCount > 0) && sizeIncrease > preSpecialValuesSize) {
                        ++sizeIncrease;
                    }
                }
                if (ValueProviderModelAdapter.this.additionalValues != null && !ValueProviderModelAdapter.this.additionalValues.isEmpty()) {
                    sizeIncrease += ValueProviderModelAdapter.this.additionalValues.size();
                }
            }
            if (this.trueRowCount >= 0) {
                return this.trueRowCount + sizeIncrease;
            }
            return this.currentRowCount + sizeIncrease;
        }

        public int getStartRowOfAddtitionalValues() {
            int index = -1;
            int increase = 0;
            if (ValueProviderModelAdapter.this.getMode() != 603 && ValueProviderModelAdapter.this.specialValues != null) {
                if (ValueProviderModelAdapter.this.specialValues.isAllSupported()) {
                    ++increase;
                }
                if (ValueProviderModelAdapter.this.specialValues.isMissingValuesSupported() && !ValueProviderModelAdapter.this.specialValues.isMissingValuesHiddenIfSupported()) {
                    ++increase;
                }
                if (ValueProviderModelAdapter.this.specialValues.isOtherSupported()) {
                    ++increase;
                }
            }
            if (increase > 0) {
                index = increase;
            }
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void search(SearchCriteria searchCriteria) throws ValueProviderException {
            int rowCount = this.getRowCount();
            if (rowCount > 0) {
                this.fireTableRowsDeleted(0, rowCount - 1);
            }
            this.searchCriteria = searchCriteria;
            ValueProviderModelAdapter.this.resetCache();
            this.trueRowCount = -1;
            this.currentRowCount = 0;
            List v = null;
            if (searchCriteria != null && ValueProviderModelAdapter.this.valueProvider instanceof ListSearchInterface) {
                try {
                    ValueProviderModelAdapter.this.setLoadingValues(true);
                    v = ValueProviderModelAdapter.this.queryValues(searchCriteria, 0, ValueProviderModelAdapter.this.getPageSize());
                }
                finally {
                    ValueProviderModelAdapter.this.setLoadingValues(false);
                }
            }
            if (v instanceof Collection && !((Collection)v).isEmpty()) {
                int newSize = ((Collection)v).size();
                if (ValueProviderModelAdapter.this.readUntilEnd(newSize)) {
                    this.trueRowCount = newSize;
                }
                if (this.currentRowCount == -1) {
                    this.currentRowCount = 0;
                }
                this.currentRowCount += ((Collection)v).size();
                this.fireTableRowsInserted(0, newSize - 1);
            }
            if (this.currentRowCount == 0) {
                this.trueRowCount = 1;
                this.fireTableRowsInserted(0, 0);
            }
        }

        public void clearSearchResults() {
            int rowCount = this.getRowCount();
            if (rowCount > 0) {
                this.getRowCount();
                this.fireTableRowsDeleted(0, rowCount - 1);
            }
            this.trueRowCount = -1;
            this.currentRowCount = -1;
            ValueProviderModelAdapter.this.resetCache();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getValueAt(rowIndex, columnIndex, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int rowIndex, int columnIndex, boolean pageIfNeeded) {
            int rowCount;
            if (this.currentRowCount < 0) {
                try {
                    this.getValues();
                }
                catch (ValueProviderException e1) {
                    LoggerRepository2.getLogger((String)ValueProviderModelAdapter.class.getName(), null).error(e1.getMessage(), (Throwable)e1);
                }
            }
            if ((rowCount = this.getRowCount()) > rowIndex) {
                Object obj;
                block60: {
                    int minSize = 0;
                    if (ValueProviderModelAdapter.this.getMode() != 603) {
                        if (ValueProviderModelAdapter.this.specialValues != null) {
                            int preSpecialValuesSize = minSize++;
                            if (ValueProviderModelAdapter.this.specialValues.isAllSupported()) {
                                // empty if block
                            }
                            if (ValueProviderModelAdapter.this.specialValues.isMissingValuesSupported() && !ValueProviderModelAdapter.this.specialValues.isMissingValuesHiddenIfSupported()) {
                                ++minSize;
                            }
                            if (ValueProviderModelAdapter.this.specialValues.isOtherSupported()) {
                                ++minSize;
                            }
                            if (rowCount > 0 && minSize > preSpecialValuesSize) {
                                ++minSize;
                            }
                        }
                        if (ValueProviderModelAdapter.this.additionalValues != null && !ValueProviderModelAdapter.this.additionalValues.isEmpty()) {
                            minSize += ValueProviderModelAdapter.this.additionalValues.size();
                        }
                    }
                    if (pageIfNeeded && (ValueProviderModelAdapter.this.getMode() == 600 || ValueProviderModelAdapter.this.getMode() == 603) && this.trueRowCount < 0) {
                        int readAheadAmt;
                        int sizeIncrease = 0;
                        if (ValueProviderModelAdapter.this.getMode() != 603 && ValueProviderModelAdapter.this.addBrowseSearchOption) {
                            sizeIncrease = 2;
                        }
                        if ((readAheadAmt = ValueProviderModelAdapter.this.getReadAheadAmount()) > 0 && rowIndex + readAheadAmt >= rowCount - (sizeIncrease += minSize)) {
                            List v = null;
                            try {
                                try {
                                    ValueProviderModelAdapter.this.setLoadingValues(true);
                                    if (ValueProviderModelAdapter.this.getMode() != 603) {
                                        v = ValueProviderModelAdapter.this.queryValues(null, rowCount - sizeIncrease, readAheadAmt);
                                    } else if (ValueProviderModelAdapter.this.valueProvider instanceof ListSearchInterface) {
                                        v = this.searchCriteria != null ? ValueProviderModelAdapter.this.queryValues(this.searchCriteria, rowCount - sizeIncrease, readAheadAmt) : Collections.EMPTY_LIST;
                                    }
                                }
                                finally {
                                    ValueProviderModelAdapter.this.setLoadingValues(false);
                                }
                                if (v instanceof Collection) {
                                    int newSize = ((Collection)v).size();
                                    if (newSize < readAheadAmt) {
                                        this.trueRowCount = rowCount - sizeIncrease + newSize;
                                    }
                                    if (this.currentRowCount == -1) {
                                        this.currentRowCount = 0;
                                    }
                                    this.currentRowCount += newSize;
                                    if (newSize > 0) {
                                        this.fireTableRowsInserted(rowCount - sizeIncrease + minSize, rowCount - sizeIncrease + minSize + newSize);
                                    }
                                } else {
                                    this.trueRowCount = rowCount - sizeIncrease;
                                }
                            }
                            catch (ValueProviderException e) {
                                IllegalStateException ex = new IllegalStateException(e.getMessage());
                                ex.initCause(e);
                                throw ex;
                            }
                        }
                    }
                    obj = null;
                    int size = this.currentRowCount;
                    if (rowIndex < minSize) {
                        int cnt = 0;
                        if (ValueProviderModelAdapter.this.specialValues != null) {
                            int startIndex = rowIndex;
                            if (ValueProviderModelAdapter.this.specialValues.isAllSupported()) {
                                if (rowIndex == cnt) {
                                    obj = ValueProviderModelAdapter.this.getAllValue();
                                }
                                ++cnt;
                            }
                            if (ValueProviderModelAdapter.this.specialValues.isOtherSupported()) {
                                if (rowIndex == cnt) {
                                    obj = ValueProviderModelAdapter.this.getOtherValue();
                                }
                                ++cnt;
                            }
                            if (ValueProviderModelAdapter.this.specialValues.isMissingValuesSupported() && !ValueProviderModelAdapter.this.specialValues.isMissingValuesHiddenIfSupported()) {
                                if (rowIndex == cnt) {
                                    obj = ValueProviderModelAdapter.this.getMissingValue();
                                }
                                ++cnt;
                            }
                            if (cnt >= startIndex && (this.trueRowCount > 0 || this.currentRowCount > 0)) {
                                if (rowIndex == cnt) {
                                    obj = SEPARATOR;
                                }
                                ++cnt;
                            }
                        }
                        if (obj == null && ValueProviderModelAdapter.this.additionalValues != null) {
                            obj = ValueProviderModelAdapter.this.additionalValues.get(rowIndex - cnt);
                        }
                    } else if (size > rowIndex - minSize) {
                        try {
                            List lv = null;
                            if (ValueProviderModelAdapter.this.getMode() != 603) {
                                Object o;
                                List l = ValueProviderModelAdapter.this.queryValues(null, rowIndex - minSize, 1);
                                if (l.size() == 1 && (o = l.get(0)) instanceof TreeModel) {
                                    return o;
                                }
                                lv = l;
                            } else {
                                lv = ValueProviderModelAdapter.this.queryValues(this.searchCriteria, rowIndex - minSize, 1);
                            }
                            if (lv != null && lv.size() > 0) {
                                obj = lv.get(0);
                                break block60;
                            }
                            --this.currentRowCount;
                            this.fireTableRowsDeleted(rowIndex, rowIndex);
                        }
                        catch (ValueProviderException lv) {}
                    } else {
                        obj = ValueProviderModelAdapter.this.getMode() == 603 && this.trueRowCount == 1 && this.currentRowCount == 0 && rowIndex == 0 ? ValueProviderModelAdapter.this.getNoResultsFoundValue() : (size + minSize == rowIndex ? SEPARATOR : MORE_VALUES);
                    }
                }
                List columnOrder = ValueProviderModelAdapter.this.getColumns();
                String type = ValueProviderModelAdapter.LABEL_COLUMN;
                if (columnIndex < columnOrder.size()) {
                    type = (String)columnOrder.get(columnIndex);
                }
                if (obj == NO_RESULTS_FOUND) {
                    if (columnIndex == 0) {
                        return obj;
                    }
                    return NO_RESULTS_FOUND.getValue();
                }
                if (obj == MORE_VALUES) {
                    if (columnIndex == 0) {
                        return obj;
                    }
                    return " ";
                }
                if (ValueProviderModelAdapter.LABEL_COLUMN.equals(type)) {
                    return obj;
                }
                if (obj instanceof ValueItem) {
                    if (ValueProviderModelAdapter.VALUE_COLUMN.equals(type)) {
                        Object valueObj = obj.getValue();
                        if (valueObj instanceof DataSourceColumnInterface) {
                            return this.getNameForLocation(((DataSourceColumnInterface)valueObj).getDataSource().getDataSourceLocation());
                        }
                        return valueObj;
                    }
                    Object att = obj.getAttribute(type);
                    if (att instanceof Collection) {
                        Collection path = (Collection)att;
                        StringBuffer returnString = new StringBuffer();
                        if (path != null) {
                            Iterator iter = path.iterator();
                            while (iter.hasNext()) {
                                Object element = iter.next();
                                returnString.append("[");
                                returnString.append(element);
                                returnString.append("]");
                                if (!iter.hasNext()) continue;
                                returnString.append(".");
                            }
                        }
                        return returnString.toString();
                    }
                    return att;
                }
                return obj;
            }
            return null;
        }

        private String getNameForLocation(String location) {
            int index = location.lastIndexOf(47);
            if (index != -1 && (index = (location = location.substring(index + 1)).lastIndexOf(40)) != -1) {
                location = location.substring(0, index);
            }
            return location;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return ValueProviderModelAdapter.this.getColumnName(columnIndex);
        }

        public void setColumns(List columns) {
            ValueProviderModelAdapter.this.setColumns(columns);
            this.fireTableStructureChanged();
        }

        public void setColumnName(String columnName, int columnIndex) {
            ValueProviderModelAdapter.this.setColumnName(columnName, columnIndex);
            this.fireTableStructureChanged();
        }

        public boolean isTrueRowCountCalculated() {
            return this.trueRowCount >= 0;
        }

        public void setTrueRowCountCalculated(boolean calculate) {
        }

        public boolean isAccurateRowCountAvailable() {
            return this.trueRowCount >= 0;
        }
    }

    @SASScope
    private class ComboBoxModelWrapper
    implements ComboBoxModel {
        private ComboBoxModel model;
        private Object selectedObject;
        private DataTypeInterface dataType;
        protected EventListenerList listenerList = new EventListenerList();

        public ComboBoxModelWrapper(ComboBoxModel model, DataTypeInterface dataType) {
            this.model = model;
            this.selectedObject = model.getSelectedItem();
            this.dataType = dataType;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == ComboBox.SEPARATOR) {
                return;
            }
            this.selectedObject = anItem;
            if (ValueProviderModelAdapter.this.addNullValueForSingleComboSelection) {
                if (anItem != NULL_VALUE_ITEM) {
                    this.model.setSelectedItem(anItem);
                }
            } else if (anItem != SpecialValues.ALL && anItem != SpecialValues.OTHER && anItem != MissingValues.Dot && anItem != MissingValues._BLANK_) {
                if (ValueProviderModelAdapter.this.addBrowseSearchOption) {
                    if (anItem != MORE_VALUES) {
                        this.model.setSelectedItem(anItem);
                    }
                } else if (ValueProviderModelAdapter.this.additionalValues == null || !ValueProviderModelAdapter.this.additionalValues.contains(anItem)) {
                    this.model.setSelectedItem(anItem);
                }
            }
        }

        @Override
        public int getSize() {
            int modelValuesSize;
            int size = modelValuesSize = this.model.getSize();
            if (ValueProviderModelAdapter.this.addNullValueForSingleComboSelection) {
                ++size;
            }
            if (ValueProviderModelAdapter.this.addBrowseSearchOption) {
                size += 2;
            }
            if (ValueProviderModelAdapter.this.additionalValues != null && !ValueProviderModelAdapter.this.additionalValues.isEmpty()) {
                size += ValueProviderModelAdapter.this.additionalValues.size();
            }
            if (ValueProviderModelAdapter.this.specialValues != null) {
                int preSpecialValuesSize = size++;
                if (ValueProviderModelAdapter.this.specialValues.isAllSupported()) {
                    // empty if block
                }
                if (ValueProviderModelAdapter.this.specialValues.isMissingValuesSupported() && !ValueProviderModelAdapter.this.specialValues.isMissingValuesHiddenIfSupported()) {
                    ++size;
                }
                if (ValueProviderModelAdapter.this.specialValues.isOtherSupported()) {
                    ++size;
                }
                if (modelValuesSize > 0 && size > preSpecialValuesSize) {
                    ++size;
                }
            }
            return size;
        }

        public int getStartRowOfAddtitionalValues() {
            int index = 0;
            int increase = 0;
            if (ValueProviderModelAdapter.this.addNullValueForSingleComboSelection) {
                ++increase;
            }
            if (ValueProviderModelAdapter.this.getMode() != 603 && ValueProviderModelAdapter.this.specialValues != null) {
                if (ValueProviderModelAdapter.this.specialValues.isAllSupported()) {
                    ++increase;
                }
                if (ValueProviderModelAdapter.this.specialValues.isMissingValuesSupported() && !ValueProviderModelAdapter.this.specialValues.isMissingValuesHiddenIfSupported()) {
                    ++increase;
                }
                if (ValueProviderModelAdapter.this.specialValues.isOtherSupported()) {
                    ++increase;
                }
            }
            if (increase > 0) {
                index = increase;
            }
            return index;
        }

        @Override
        public Object getElementAt(int index) {
            if (ValueProviderModelAdapter.this.addNullValueForSingleComboSelection) {
                if (index == 0) {
                    return NULL_VALUE_ITEM;
                }
                --index;
            }
            if (ValueProviderModelAdapter.this.specialValues != null) {
                int startIndex = index;
                if (ValueProviderModelAdapter.this.specialValues.isAllSupported()) {
                    if (index == 0) {
                        return ValueProviderModelAdapter.this.getAllValue();
                    }
                    --index;
                }
                if (ValueProviderModelAdapter.this.specialValues.isOtherSupported()) {
                    if (index == 0) {
                        return ValueProviderModelAdapter.this.getOtherValue();
                    }
                    --index;
                }
                if (ValueProviderModelAdapter.this.specialValues.isMissingValuesSupported() && !ValueProviderModelAdapter.this.specialValues.isMissingValuesHiddenIfSupported()) {
                    if (index == 0) {
                        return ValueProviderModelAdapter.this.getMissingValue();
                    }
                    --index;
                }
                if (index < startIndex && this.model.getSize() > 0) {
                    if (index == 0) {
                        return SEPARATOR;
                    }
                    --index;
                }
            }
            if (ValueProviderModelAdapter.this.additionalValues != null && !ValueProviderModelAdapter.this.additionalValues.isEmpty()) {
                if (index < ValueProviderModelAdapter.this.additionalValues.size()) {
                    Object obj = ValueProviderModelAdapter.this.additionalValues.get(index);
                    if (obj instanceof ValueItem && ValueProviderModelAdapter.this.valueProvider.isValueDisplayed()) {
                        ValueItem vi = (ValueItem)obj;
                        StringBuffer sb = new StringBuffer();
                        sb.append(vi.getLabel(ValueProviderModelAdapter.this.locale));
                        StringBuffer labelForValue = new StringBuffer();
                        if (vi.getValue() instanceof MissingValues) {
                            labelForValue.append(" [");
                            labelForValue.append(MissingValues.toQueryString((MissingValues)((MissingValues)vi.getValue())));
                            labelForValue.append("]");
                        } else {
                            Object valueToConvert = vi.getValue();
                            try {
                                valueToConvert = this.dataType.coerceValue(vi.getValue(), ValueProviderModelAdapter.this.locale);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            if (valueToConvert instanceof DataSourceColumnInterface) {
                                labelForValue.append(" [").append(((DataSourceColumnInterface)valueToConvert).getColumnName()).append("]");
                                labelForValue.append("[").append(this.getLocationWithoutType(((DataSourceColumnInterface)valueToConvert).getDataSource().getDataSourceLocation())).append("]");
                            } else {
                                labelForValue.append(" [").append(this.dataType.getDisplayString(valueToConvert, ValueProviderModelAdapter.this.locale)).append("]");
                            }
                        }
                        if (!sb.toString().endsWith(labelForValue.toString())) {
                            sb.append(labelForValue);
                        }
                        if (labelForValue != null && !labelForValue.equals(vi.getLabel(ValueProviderModelAdapter.this.locale))) {
                            vi.setAttribute(QUALIFIED_LABEL, (Object)sb.toString());
                        }
                    }
                    return obj;
                }
                index -= ValueProviderModelAdapter.this.additionalValues.size();
            }
            if (ValueProviderModelAdapter.this.addBrowseSearchOption) {
                int size = this.model.getSize();
                if (index == size) {
                    return SEPARATOR;
                }
                if (index > size) {
                    return MORE_VALUES;
                }
            }
            Object value = this.model.getElementAt(index);
            if (ValueProviderModelAdapter.this.valueProvider.isValueDisplayed() && value instanceof ValueItem) {
                ValueItem vi = (ValueItem)value;
                StringBuffer sb = new StringBuffer();
                sb.append(vi.getLabel(ValueProviderModelAdapter.this.locale));
                StringBuffer labelForValue = new StringBuffer();
                if (vi.getValue() instanceof MissingValues) {
                    labelForValue.append(" [");
                    labelForValue.append(MissingValues.toQueryString((MissingValues)((MissingValues)vi.getValue())));
                    labelForValue.append("]");
                } else {
                    Object valueToConvert = vi.getValue();
                    try {
                        valueToConvert = this.dataType.coerceValue(vi.getValue(), ValueProviderModelAdapter.this.locale);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (valueToConvert instanceof DataSourceColumnInterface) {
                        labelForValue.append(" [").append(((DataSourceColumnInterface)valueToConvert).getColumnName()).append("]");
                        labelForValue.append("[").append(this.getLocationWithoutType(((DataSourceColumnInterface)valueToConvert).getDataSource().getDataSourceLocation())).append("]");
                    } else {
                        labelForValue.append(" [").append(this.dataType.getDisplayString(valueToConvert, ValueProviderModelAdapter.this.locale)).append("]");
                    }
                }
                if (!sb.toString().endsWith(labelForValue.toString())) {
                    sb.append(labelForValue);
                }
                vi.setAttribute(QUALIFIED_LABEL, (Object)sb.toString());
            }
            return value;
        }

        private String getLocationWithoutType(String location) {
            int index = location.lastIndexOf(40);
            if (index != -1) {
                location = location.substring(0, index);
            }
            return location;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.model.addListDataListener(l);
            this.listenerList.add(ListDataListener.class, l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.model.removeListDataListener(l);
            this.listenerList.remove(ListDataListener.class, l);
        }

        protected void fireContentsChanged(Object source, int index0, int index1) {
            Object[] listeners = this.listenerList.getListenerList();
            ListDataEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 0, index0, index1);
                }
                ((ListDataListener)listeners[i + 1]).contentsChanged(e);
            }
        }

        protected void fireIntervalAdded(Object source, int index0, int index1) {
            Object[] listeners = this.listenerList.getListenerList();
            ListDataEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 1, index0, index1);
                }
                ((ListDataListener)listeners[i + 1]).intervalAdded(e);
            }
        }

        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            Object[] listeners = this.listenerList.getListenerList();
            ListDataEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 2, index0, index1);
                }
                ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
            }
        }
    }
}

