/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.codepolicy.SASScope;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

@SASScope
public class SortableListModelAdapter
extends AbstractListModel {
    private static final long serialVersionUID = 1L;
    private List sortedModel;
    private ListModel unsortedModel;
    private Comparator comparator;

    public SortableListModelAdapter(ListModel model) {
        this(model, null);
    }

    public SortableListModelAdapter(ListModel model, Comparator comp) {
        this.unsortedModel = model;
        this.unsortedModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                SortableListModelAdapter.this.unsortedIntervalAdded(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SortableListModelAdapter.this.unsortedIntervalRemoved(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                SortableListModelAdapter.this.unsortedContentsChanged(e);
            }
        });
        this.setComparator(comp);
        int size = model.getSize();
        this.sortedModel = new ArrayList(size);
        for (int x = 0; x < size; ++x) {
            SortedListEntry entry = new SortedListEntry(x);
            int insertionPoint = this.findInsertionPoint(entry);
            this.sortedModel.add(insertionPoint, entry);
        }
    }

    @Override
    public int getSize() {
        int size = this.sortedModel.size();
        return size;
    }

    @Override
    public Object getElementAt(int index) {
        int modelIndex = this.toUnsortedModelIndex(index);
        Object element = this.unsortedModel.getElementAt(modelIndex);
        return element;
    }

    void unsortedIntervalAdded(ListDataEvent e) {
        int begin = e.getIndex0();
        int end = e.getIndex1();
        int nElementsAdded = end - begin + 1;
        for (SortedListEntry entry : this.sortedModel) {
            int index = entry.getIndex();
            if (index < begin) continue;
            entry.setIndex(index + nElementsAdded);
        }
        for (int x = begin; x <= end; ++x) {
            SortedListEntry newEntry = new SortedListEntry(x);
            int insertionPoint = this.findInsertionPoint(newEntry);
            this.sortedModel.add(insertionPoint, newEntry);
            this.fireIntervalAdded(this.unsortedModel, 1, insertionPoint);
        }
    }

    void unsortedIntervalRemoved(ListDataEvent e) {
        int x;
        int begin = e.getIndex0();
        int end = e.getIndex1();
        int nElementsRemoved = end - begin + 1;
        int sortedSize = this.sortedModel.size();
        boolean[] bElementRemoved = new boolean[sortedSize];
        for (x = sortedSize - 1; x >= 0; --x) {
            SortedListEntry entry = (SortedListEntry)this.sortedModel.get(x);
            int index = entry.getIndex();
            if (index > end) {
                entry.setIndex(index - nElementsRemoved);
                continue;
            }
            if (index < begin) continue;
            this.sortedModel.remove(x);
            bElementRemoved[x] = true;
        }
        for (x = bElementRemoved.length - 1; x >= 0; --x) {
            if (!bElementRemoved[x]) continue;
            this.fireIntervalRemoved(this.unsortedModel, 2, x);
        }
    }

    void unsortedContentsChanged(ListDataEvent e) {
        Collections.sort(this.sortedModel);
        this.fireContentsChanged(this.unsortedModel, 0, 0);
    }

    private int findInsertionPoint(SortedListEntry entry) {
        int insertionPoint = this.sortedModel.size();
        insertionPoint = Collections.binarySearch(this.sortedModel, entry);
        if (insertionPoint < 0) {
            insertionPoint = -(insertionPoint + 1);
        }
        return insertionPoint;
    }

    public int toUnsortedModelIndex(int index) throws IndexOutOfBoundsException {
        int modelIndex = -1;
        SortedListEntry entry = (SortedListEntry)this.sortedModel.get(index);
        modelIndex = entry.getIndex();
        return modelIndex;
    }

    private void setComparator(Comparator comp) {
        this.comparator = comp != null ? comp : SASCollatorFactory.createCollator();
    }

    @SASScope
    class SortedListEntry
    implements Comparable {
        private int index;

        public SortedListEntry(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int compareTo(Object o) {
            Object thisElement = SortableListModelAdapter.this.unsortedModel.getElementAt(this.index);
            SortedListEntry thatEntry = (SortedListEntry)o;
            Object thatElement = SortableListModelAdapter.this.unsortedModel.getElementAt(thatEntry.getIndex());
            if (SortableListModelAdapter.this.comparator instanceof SASStringComparator) {
                thisElement = thisElement.toString();
                thatElement = thatElement.toString();
            }
            int comparison = SortableListModelAdapter.this.comparator.compare(thisElement, thatElement);
            return comparison;
        }
    }
}

