/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.OLAPDataSet;
import com.sas.swing.models.ViewDefaultModel;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@SASScope(value="ALL")
@SubjectToChange
public class OLAPDataSetInterfaceToTreeModelAdapter
implements TreeModel,
ViewDefaultModel {
    protected EventListenerList listenerList;
    protected boolean defaultModelAttached;
    protected OLAPDataSetInterface model;
    protected Object root;
    private int[] axesShown = new int[]{0, 1, -1};
    private boolean axesVisible = false;

    public OLAPDataSetInterfaceToTreeModelAdapter() {
        this(null);
    }

    public OLAPDataSetInterfaceToTreeModelAdapter(OLAPDataSetInterface model) {
        this.setModel(model);
    }

    public void setAxesUsed(int[] axes) {
        int[] oldAxes = this.axesShown;
        this.axesShown = axes;
        if (oldAxes != null && this.axesShown != null && Arrays.equals(oldAxes, this.axesShown)) {
            return;
        }
        this.fireTreeStructureChanged(this, new Object[]{this.getPathToRoot(this.getRoot())}, null, null);
    }

    public int[] getAxesUsed() {
        return this.axesShown;
    }

    public boolean isAxesVisible() {
        return this.axesVisible;
    }

    public void setAxesVisible(boolean areAxesVisible) {
        if (this.axesVisible != areAxesVisible) {
            this.axesVisible = areAxesVisible;
            this.fireTreeStructureChanged(this, new Object[]{this.getPathToRoot(this.getRoot())}, null, null);
        }
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public void setModel(OLAPDataSetInterface newModel) {
        boolean defaultModelUsed = false;
        if (newModel == null) {
            defaultModelUsed = true;
            newModel = this.newDefaultModel();
        }
        if (this.model != newModel) {
            OLAPDataSetInterface oldModel = this.model;
            this.model = newModel;
            try {
                String cubeName = newModel.getCubeName();
                if (cubeName != null) {
                    this.setRoot(newModel.getCubeName());
                } else {
                    this.setRoot(newModel);
                }
            }
            catch (OLAPException ex) {
                this.setRoot(newModel);
            }
            if (!defaultModelUsed) {
                this.setDefaultModelAttached(false);
            }
        }
    }

    protected OLAPDataSetInterface newDefaultModel() {
        this.setDefaultModelAttached(true);
        try {
            return new OLAPDataSet();
        }
        catch (OLAPException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isDefaultModelAttached() {
        return this.defaultModelAttached;
    }

    protected void setDefaultModelAttached(boolean defaultModelUsed) {
        if (defaultModelUsed != this.defaultModelAttached) {
            this.defaultModelAttached = defaultModelUsed;
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    @Override
    public int getChildCount(Object parent) {
        int childCount = 0;
        try {
            if (parent instanceof TupleElementInterface) {
                TupleElementInterface element = (TupleElementInterface)parent;
                int min = element.getMinimumCoordinate();
                int max = element.getMaximumCoordinate();
                TupleInterface[] tuples = element.getTuple().getAxis().getTuples(min, max - min + 1);
                TupleElementInterface[] elements = element.getTuple().getElements(0, element.getTupleElementIndex() + 1);
                int level = 0;
                for (int i = 0; i < elements.length; ++i) {
                    level += elements[i].getSpan();
                }
                elements = this.getTupleElementsForLevel(level, tuples, false, -1);
                childCount = elements.length;
            } else if (parent instanceof AxisInterface) {
                AxisInterface axis = (AxisInterface)parent;
                if (axis.getTupleCount() > 0) {
                    TupleInterface[] tuples = axis.getTuples(0, -1);
                    TupleElementInterface[] elements = this.getTupleElementsForLevel(0, tuples, false, -1);
                    childCount = elements.length;
                }
            } else if (parent == this.getRoot()) {
                AxisInterface[] axes = this.model.getResultSetMetadata().getAxes(0, -1);
                if (this.isAxesVisible()) {
                    for (int i = 0; i < axes.length; ++i) {
                        if (!this.usingAxis(axes[i].getAxisNumber())) continue;
                        ++childCount;
                    }
                } else {
                    int count = 0;
                    for (int i = 0; i < axes.length; ++i) {
                        if (!this.usingAxis(axes[i].getAxisNumber()) || axes[i].getTupleCount() <= 0) continue;
                        TupleInterface[] tuples = axes[i].getTuples(0, -1);
                        TupleElementInterface[] elements = this.getTupleElementsForLevel(0, tuples, false, -1);
                        count += elements.length;
                    }
                    childCount = count;
                }
            }
        }
        catch (OLAPException ex) {
            ex.printStackTrace();
        }
        return childCount;
    }

    @Override
    public Object getChild(Object parent, int index) {
        TupleElementInterface ret = null;
        try {
            if (parent instanceof TupleElementInterface) {
                TupleElementInterface element = (TupleElementInterface)parent;
                int min = element.getMinimumCoordinate();
                int max = element.getMaximumCoordinate();
                TupleInterface[] tuples = element.getTuple().getAxis().getTuples(min, max - min + 1);
                TupleElementInterface[] elements = element.getTuple().getElements(0, element.getTupleElementIndex() + 1);
                int level = 0;
                for (int i = 0; i < elements.length; ++i) {
                    level += elements[i].getSpan();
                }
                elements = this.getTupleElementsForLevel(level, tuples, false, -1);
                ret = elements[index];
            } else if (parent instanceof AxisInterface) {
                TupleInterface[] tuples;
                TupleElementInterface[] elements;
                AxisInterface axis = (AxisInterface)parent;
                if (axis.getTupleCount() > 0 && (elements = this.getTupleElementsForLevel(0, tuples = axis.getTuples(0, -1), false, -1)).length > index) {
                    ret = elements[index];
                }
            } else if (parent == this.getRoot()) {
                AxisInterface[] axes = this.model.getResultSetMetadata().getAxes(0, -1);
                if (this.isAxesVisible()) {
                    int count = 0;
                    for (int i = 0; i < this.axesShown.length; ++i) {
                        for (int j = 0; j < axes.length; ++j) {
                            if (this.axesShown[i] != axes[j].getAxisNumber()) continue;
                            if (index == count) {
                                return axes[j];
                            }
                            ++count;
                        }
                    }
                } else {
                    int count = 0;
                    for (int i = 0; i < this.axesShown.length; ++i) {
                        for (int j = 0; j < axes.length; ++j) {
                            if (this.axesShown[i] != axes[j].getAxisNumber() || axes[j].getTupleCount() <= 0) continue;
                            TupleInterface[] tuples = axes[j].getTuples(0, -1);
                            TupleElementInterface[] elements = this.getTupleElementsForLevel(0, tuples, false, -1);
                            if (index < elements.length + count) {
                                return elements[index - count];
                            }
                            count += elements.length;
                        }
                    }
                }
            }
        }
        catch (OLAPException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        if (child instanceof TupleElementInterface) {
            try {
                if (parent instanceof TupleElementInterface) {
                    int i;
                    TupleElementInterface pElement = (TupleElementInterface)parent;
                    TupleElementInterface cElement = (TupleElementInterface)child;
                    int min = pElement.getMinimumCoordinate();
                    int max = pElement.getMaximumCoordinate();
                    TupleInterface[] tuples = pElement.getTuple().getAxis().getTuples(min, max - min + 1);
                    TupleElementInterface[] elements = pElement.getTuple().getElements(0, pElement.getTupleElementIndex() + 1);
                    int level = 0;
                    for (i = 0; i < elements.length; ++i) {
                        level += elements[i].getSpan();
                    }
                    elements = this.getTupleElementsForLevel(level, tuples, false, -1);
                    for (i = 0; i < elements.length; ++i) {
                        if (elements[i] != cElement) continue;
                        return i;
                    }
                } else if (parent == this.getRoot()) {
                    AxisInterface[] axes = this.model.getResultSetMetadata().getAxes(0, -1);
                    int count = 0;
                    for (int i = 0; i < this.axesShown.length; ++i) {
                        for (int j = 0; j < axes.length; ++j) {
                            if (this.axesShown[i] != axes[j].getAxisNumber() || axes[j].getTupleCount() <= 0) continue;
                            TupleInterface[] tuples = axes[j].getTuples(0, -1);
                            TupleElementInterface[] elements = this.getTupleElementsForLevel(0, tuples, false, -1);
                            for (int k = 0; k < elements.length; ++k) {
                                if (elements[k] != child) continue;
                                return count + k;
                            }
                            count += elements.length;
                        }
                    }
                }
            }
            catch (OLAPException ex) {
                ex.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object object) {
        try {
            if (object instanceof TupleElementInterface) {
                TupleElementInterface element = (TupleElementInterface)object;
                if (element.getTupleElementIndex() + 1 == element.getTuple().getTupleDepth()) {
                    return true;
                }
            } else if (object instanceof AxisInterface) {
                if (((AxisInterface)object).getTupleCount() == 0) {
                    return true;
                }
            } else if (object == this.getRoot()) {
                AxisInterface[] axes = this.model.getResultSetMetadata().getAxes(0, -1);
                int count = 0;
                if (this.isAxesVisible()) {
                    block2: for (int i = 0; i < this.axesShown.length; ++i) {
                        for (int j = 0; j < axes.length; ++j) {
                            if (this.axesShown[i] != axes[j].getAxisNumber()) continue;
                            ++count;
                            continue block2;
                        }
                    }
                    if (count == 0) {
                        return true;
                    }
                } else {
                    block4: for (int i = 0; i < this.axesShown.length; ++i) {
                        for (int j = 0; j < axes.length; ++j) {
                            if (this.axesShown[i] != axes[j].getAxisNumber() || axes[j].getTupleCount() <= 0) continue;
                            ++count;
                            continue block4;
                        }
                    }
                    if (count == 0) {
                        return true;
                    }
                }
            }
        }
        catch (OLAPException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(TreeModelListener.class, listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(TreeModelListener.class, listener);
        }
    }

    private boolean usingAxis(int axis) {
        if (this.axesShown != null) {
            for (int i = 0; i < this.axesShown.length; ++i) {
                if (this.axesShown[i] != axis) continue;
                return true;
            }
        }
        return false;
    }

    public TreePath getPathToRoot(Object node) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(node);
        while ((node = this.getParent(node)) != null) {
            list.add(0, node);
        }
        return new TreePath(list.toArray());
    }

    public Object getParent(Object child) {
        if (this.getRoot() == child) {
            return null;
        }
        if (child instanceof TupleElementInterface) {
            try {
                TupleElementInterface element = (TupleElementInterface)child;
                int elementIndex = element.getTupleElementIndex();
                if (elementIndex == 0) {
                    return this.getRoot();
                }
                TupleInterface tuple = element.getTuple();
                return tuple.getElements(elementIndex - 1, 1)[0];
            }
            catch (OLAPException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(event);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(event);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(event);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(event);
        }
    }

    private TupleElementInterface[] getTupleElementsForLevel(int level, TupleInterface[] tuples, boolean includeDuplicates, int count) throws OLAPException {
        int nTuples = tuples.length;
        ArrayList<TupleElementInterface> elements = new ArrayList<TupleElementInterface>(nTuples);
        TupleElementInterface[] tupleElements = new TupleElementInterface[nTuples];
        ArrayList<String> elemNames = new ArrayList<String>(nTuples);
        if (level == 0) {
            if (count != -1 && count < nTuples) {
                nTuples = count;
            }
            for (int i = 0; i < nTuples; ++i) {
                TupleElementInterface tElement = tuples[i].getElements(0, 1)[0];
                if (!includeDuplicates && (includeDuplicates || elemNames.contains(tElement.getName()))) continue;
                elements.add(tElement);
                elemNames.add(tElement.getName());
            }
            tupleElements = new TupleElementInterface[elements.size()];
            System.arraycopy(elements.toArray(), 0, tupleElements, 0, elements.size());
            return tupleElements;
        }
        int currentCount = count == -1 ? nTuples * -1 : 0;
        block1: for (int i = 0; i < nTuples; ++i) {
            tupleElements = tuples[i].getElements(0, -1);
            int nElements = tupleElements.length;
            int relativeIndex = 0;
            for (int index = 0; index < nElements - 1 && currentCount <= count; ++index) {
                if ((relativeIndex += tupleElements[index].getSpan()) == level) {
                    Object tupleElement = null;
                    if (includeDuplicates || !includeDuplicates && !elemNames.contains(tupleElements[index + 1].getName())) {
                        elements.add(tupleElements[index + 1]);
                        elemNames.add(tupleElements[index + 1].getName());
                    }
                    ++currentCount;
                    continue block1;
                }
                if (relativeIndex > level) continue block1;
            }
        }
        tupleElements = new TupleElementInterface[elements.size()];
        System.arraycopy(elements.toArray(new TupleElementInterface[0]), 0, tupleElements, 0, elements.size());
        return tupleElements;
    }
}

