/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.swing.models.NodeIconsInterface;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class NodeIconCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        Icon icon = null;
        if (value instanceof NodeIconsInterface) {
            NodeIconsInterface nodeIcons = (NodeIconsInterface)value;
            icon = expanded ? (sel ? nodeIcons.getExpandedSelectedIcon() : nodeIcons.getExpandedIcon()) : (sel ? nodeIcons.getSelectedIcon() : nodeIcons.getIcon());
        }
        if (icon == null) {
            icon = leaf ? this.getLeafIcon() : (expanded ? this.getOpenIcon() : this.getClosedIcon());
        }
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            this.setDisabledIcon(icon);
        } else {
            this.setEnabled(true);
            this.setIcon(icon);
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }
}

