/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.event.SwingPropertyChangeSupport;

public class CollectionToListModelAdapter
extends AbstractListModel
implements PropertyChangeSource {
    protected List delegate;
    protected Collection model;
    protected SwingPropertyChangeSupport spcs;

    public CollectionToListModelAdapter() {
        this.delegate = new ArrayList();
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    public CollectionToListModelAdapter(int size) {
        this.delegate = new ArrayList(size);
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    public CollectionToListModelAdapter(Collection c) {
        this.model = c;
        this.createDelegate();
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public Object getElementAt(int i) {
        return this.delegate.get(i);
    }

    public void setModel(Collection model) {
        Collection oldModel = this.model;
        if (oldModel != model) {
            this.model = model;
            this.refresh();
            this.spcs.firePropertyChange("model", oldModel, model);
        }
    }

    public Collection getModel() {
        return this.model;
    }

    protected void createDelegate() {
        this.delegate = this.model instanceof List ? (List)this.model : (this.model != null ? new ArrayList(this.model) : new ArrayList());
    }

    public void refresh() {
        this.createDelegate();
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }
}

