/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.adapters;

import com.sas.codepolicy.SASScope;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTable;
import javax.swing.table.TableModel;

@SASScope
public class RowSelectKeyAdapter
extends KeyAdapter {
    protected JTable table;
    protected int col;

    public RowSelectKeyAdapter(JTable table, int colIndex) {
        this.col = colIndex;
        this.table = table;
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        char keyTyped = evt.getKeyChar();
        if (keyTyped != '\uffff') {
            this.selectRow(evt.getKeyChar());
        }
    }

    protected void selectRow(char keyTyped) {
        int row = this.findRowStartingWithKey(keyTyped);
        int viewCol = this.table.convertColumnIndexToView(this.col);
        if (row != -1 && this.table != null) {
            this.table.changeSelection(row, viewCol, false, false);
        }
    }

    protected int findRowStartingWithKey(char keyTyped) {
        if (this.table == null) {
            return -1;
        }
        int selectedRow = this.table.getSelectedRow();
        String keyTypedStr = String.valueOf(keyTyped);
        TableModel tableModel = this.table.getModel();
        int i = selectedRow + 1;
        int j = 0;
        while (j < tableModel.getRowCount()) {
            String cellStrValue;
            Object cellValue;
            if (i >= tableModel.getRowCount()) {
                i = 0;
            }
            if ((cellValue = tableModel.getValueAt(i, this.col)) != null && (cellStrValue = cellValue.toString()) != null && cellStrValue.startsWith(keyTypedStr)) {
                return i;
            }
            ++j;
            ++i;
        }
        return -1;
    }
}

