/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.adapters;

import com.sas.codepolicy.SASScope;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope
public class EditCellSelectionAdapter
implements ListSelectionListener {
    protected JTable table;
    protected int editColumn;
    protected int[] selectedColumns;

    public EditCellSelectionAdapter(JTable table, int editColumn, int[] selectedColumns) {
        this.table = table;
        this.editColumn = editColumn;
        this.selectedColumns = selectedColumns;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.editCell(this.table.getSelectedRow(), this.table.getSelectedColumn());
        }
    }

    protected void editCell(int row, int col) {
        boolean columnFound = false;
        for (int i = 0; i < this.selectedColumns.length; ++i) {
            int selCol = this.table.convertColumnIndexToView(this.selectedColumns[i]);
            if (selCol != col) continue;
            columnFound = true;
            break;
        }
        int editCol = this.table.convertColumnIndexToView(this.editColumn);
        if (columnFound && this.table.isCellEditable(row, editCol)) {
            Component editorComp;
            this.table.changeSelection(row, editCol, false, false);
            if (this.table.editCellAt(row, editCol) && (editorComp = this.table.getEditorComponent()) != null) {
                editorComp.requestFocus();
            }
        }
    }
}

