/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security;

import com.sas.GlobalInfoTable;
import com.sas.security.BaseSecuritySupport;
import com.sas.util.Strings;
import com.sas.visuals.image.ImageException;
import com.sas.visuals.image.ImageProvider;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class SecuritySupport
extends BaseSecuritySupport {
    private static final boolean DEBUG = false;
    public static SecuritySupport securitySupport = null;
    private static final String delimiterDefault = ",";
    private static final String[][] SecurityClassDefaults = new String[][]{{"Sun Microsystems Inc.", "1.4*", "com.sas.security.JDK_1_2_SecuritySupport"}, {"Sun Microsystems Inc.", "1.3*", "com.sas.security.JDK_1_2_SecuritySupport"}, {"Sun Microsystems Inc.", "1.2*", "com.sas.security.JDK_1_2_SecuritySupport"}};

    static SecuritySupport newSecuritySupport() {
        if (securitySupport != null) {
            return securitySupport;
        }
        String vendor = null;
        String version = null;
        try {
            vendor = System.getProperty("java.vendor");
        }
        catch (SecurityException e) {
            version = "unknown";
        }
        try {
            version = System.getProperty("java.version");
        }
        catch (SecurityException e) {
            version = "unknown";
        }
        Vector classes = SecuritySupport.parseSelections();
        securitySupport = SecuritySupport.newSecuritySupport(classes, vendor, version);
        if (securitySupport == null) {
            securitySupport = new SecuritySupport();
        }
        return securitySupport;
    }

    private static Vector parseSelections() {
        Vector<String> list = new Vector<String>();
        Properties classes = new Properties();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("com.sas.security.SecurityClasses");
            int count = Integer.parseInt(bundle.getString("count"));
            String delimiter = bundle.getString("delimiter");
            list.addElement(delimiter);
            for (int i = 0; i < count; ++i) {
                String key = Integer.toString(i);
                String spec = null;
                try {
                    spec = bundle.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (spec == null) continue;
                list.addElement(spec);
            }
        }
        catch (MissingResourceException bundle) {
            // empty catch block
        }
        if (list.size() <= 1) {
            list.removeAllElements();
            list.addElement(delimiterDefault);
            for (int i = 0; i < SecurityClassDefaults.length; ++i) {
                String item = SecurityClassDefaults[i][0] + delimiterDefault + SecurityClassDefaults[i][1] + delimiterDefault + SecurityClassDefaults[i][2];
                System.out.println("default: " + item);
                list.addElement(item);
            }
        }
        return list;
    }

    private static SecuritySupport newSecuritySupport(Vector classes, String vendor, String version) {
        String vers = version;
        SecuritySupport securitySupport = null;
        String delimiter = (String)classes.elementAt(0);
        classes.removeElementAt(0);
        for (int i = 0; i < classes.size(); ++i) {
            String className;
            Class secClass;
            String spec = (String)classes.elementAt(i);
            int pos = spec.lastIndexOf(delimiter);
            String pattern = spec.substring(0, pos);
            String config = vendor + delimiter + vers;
            if (!Strings.match((String)config, (String)pattern, (boolean)true) || (secClass = GlobalInfoTable._loadClass((String)(className = spec.substring(pos + delimiter.length(), spec.length())), (ClassLoader)SecuritySupport.class.getClassLoader())) == null) continue;
            try {
                securitySupport = (SecuritySupport)((Object)secClass.newInstance());
                return securitySupport;
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return new SecuritySupport();
    }

    public Image getImage(Object src) throws IOException, ImageException {
        ImageProvider imgProvider = null;
        if (src instanceof URL) {
            imgProvider = new ImageProvider((URL)src);
        } else if (src instanceof InputStream) {
            imgProvider = new ImageProvider((InputStream)src);
        } else if (src instanceof String) {
            imgProvider = new ImageProvider((String)src);
        }
        if (imgProvider != null) {
            return imgProvider.getImage();
        }
        return null;
    }

    static {
        securitySupport = SecuritySupport.newSecuritySupport();
    }
}

