/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models.itemlistmanager.tree;

import com.sas.dataselectors.filters.Util;
import com.sas.models.itemlistmanager.tree.ILMTreeInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class TreeUtil {
    public static List getAllLeafNodes(TreeNode treeRoot) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (treeRoot != null) {
            if (treeRoot.isLeaf()) {
                nodes.add(treeRoot);
            } else {
                Enumeration<? extends TreeNode> e = treeRoot.children();
                while (e.hasMoreElements()) {
                    nodes.addAll(TreeUtil.getAllLeafNodes(e.nextElement()));
                }
            }
        }
        return nodes;
    }

    public static TreeNode getIndexedLeaf(TreeNode treeRoot, int index) {
        List nodes = TreeUtil.getAllLeafNodes(treeRoot);
        if (index < nodes.size()) {
            return (TreeNode)nodes.get(index);
        }
        return null;
    }

    public static int getIndexOfLeaf(TreeNode treeRoot, TreeNode leaf) {
        List nodes = TreeUtil.getAllLeafNodes(treeRoot);
        return Util.indexOfInstance(nodes, leaf);
    }

    public static Object getLogicalCondition(TreeNode node) {
        Object lc = null;
        if (node != null && node.isLeaf() && node.getParent() instanceof ILMTreeNode) {
            ILMTreeNode parent = (ILMTreeNode)node.getParent();
            if (parent.getIndex(node) > 0) {
                lc = parent.getUserObject();
            } else {
                TreeNode[] nodes = TreeUtil.getCommonParentPlusLeftSibling(node);
                if (nodes != null && nodes[1] instanceof ILMTreeNode) {
                    lc = ((ILMTreeNode)nodes[1]).getUserObject();
                }
            }
        }
        return lc;
    }

    public static Object getLogicalCondition(TreeNode treeRoot, int index) {
        Object lc = null;
        TreeNode node = TreeUtil.getIndexedLeaf(treeRoot, index);
        lc = TreeUtil.getLogicalCondition(node);
        return lc;
    }

    public static int getLeftParenCount(TreeNode treeRoot, int index) {
        return TreeUtil.getLeftParenCount(TreeUtil.getIndexedLeaf(treeRoot, index));
    }

    public static int getLeftParenCount(TreeNode node) {
        int count = 0;
        if (node != null && node.isLeaf()) {
            for (TreeNode parent = node.getParent(); parent != null && parent.getParent() != null && parent.getIndex(node) == 0; parent = parent.getParent()) {
                if (parent instanceof ILMTreeNode && ((ILMTreeNode)parent).isExplicitlyCreated()) {
                    ++count;
                }
                node = parent;
            }
        }
        return count;
    }

    public static int getRightParenCount(TreeNode treeRoot, int index) {
        return TreeUtil.getRightParenCount(TreeUtil.getIndexedLeaf(treeRoot, index));
    }

    public static int getRightParenCount(TreeNode node) {
        int count = 0;
        if (node != null && node.isLeaf()) {
            for (TreeNode parent = node.getParent(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
                if (parent instanceof ILMTreeNode && ((ILMTreeNode)parent).isExplicitlyCreated() && parent.getIndex(node) == parent.getChildCount() - 1) {
                    ++count;
                }
                node = parent;
            }
        }
        return count;
    }

    public static TreeNode[] getGroupsStartingWith(TreeNode node) {
        ArrayList<TreeNode> groupList = null;
        if (node != null && node.isLeaf()) {
            for (TreeNode parent = node.getParent(); parent != null && parent.getIndex(node) == 0; parent = parent.getParent()) {
                if (parent instanceof ILMTreeNode && ((ILMTreeNode)parent).isExplicitlyCreated()) {
                    if (groupList == null) {
                        groupList = new ArrayList<TreeNode>(3);
                    }
                    groupList.add(0, parent);
                }
                node = parent;
            }
        }
        TreeNode[] groups = null;
        if (groupList != null) {
            groups = groupList.toArray(new ILMTreeNode[groupList.size()]);
        }
        return groups;
    }

    public static TreeNode[] getGroupsEndingWith(TreeNode node) {
        ArrayList<TreeNode> groupList = null;
        if (node != null && node.isLeaf()) {
            int cc;
            TreeNode parent = node.getParent();
            int n = cc = parent == null ? 0 : parent.getChildCount();
            while (parent != null && parent.getIndex(node) == cc - 1) {
                if (parent instanceof ILMTreeNode && ((ILMTreeNode)parent).isExplicitlyCreated()) {
                    if (groupList == null) {
                        groupList = new ArrayList<TreeNode>(3);
                    }
                    groupList.add(parent);
                }
                node = parent;
                cc = (parent = parent.getParent()) == null ? 0 : parent.getChildCount();
            }
        }
        TreeNode[] groups = null;
        if (groupList != null) {
            groups = groupList.toArray(new ILMTreeNode[groupList.size()]);
        }
        return groups;
    }

    public static void printTree(ILMTreeInterface tree) {
        if (tree != null) {
            TreeUtil.printTree(tree.getRootNode(), "", "ROOT-", new HashMap());
        }
    }

    public static void printTree(ILMTreeNode root) {
        TreeUtil.printTree(root, "", "ROOT-", new HashMap());
    }

    private static void printTree(ILMTreeNode root, String spacer, String prefix, Map visited) {
        System.out.println("_DEBUG_:" + spacer + prefix + TreeUtil.toDebugNodeString(root));
        if (root != null) {
            int count = root.getChildCount();
            if (!root.isLeaf() || count > 0) {
                if (root.isLeaf()) {
                    System.out.println("_DEBUG_:" + spacer + "WARNING - Parent node is not flagged as COMPOUND!");
                }
                if (visited.get(root) != null) {
                    System.out.println("_DEBUG_:" + spacer + "  RECURSIVE NODE LINK <stopping here>");
                } else {
                    visited.put(root, Boolean.TRUE);
                    for (int i = 0; i < count; ++i) {
                        TreeUtil.printTree((ILMTreeNode)root.getChildAt(i), spacer + "  ", i + "-", visited);
                    }
                }
            }
        }
    }

    private static String toDebugNodeString(ILMTreeNode node) {
        String negation;
        if (node == null) {
            return "NODE: <EMPTY>  [null]";
        }
        String prefix = node.isLeaf() ? "LEAF" : "NODE";
        String string = negation = node.isNegated ? "NOT " : "";
        if (node.isLeaf()) {
            return prefix + ": " + negation + node + " (id=" + node.hashCode() + ")";
        }
        String explicit = node.isExplicitlyCreated() ? "GROUP " : "<implicit>";
        return prefix + ": " + negation + explicit + node + " (id=" + node.hashCode() + ")";
    }

    public static TreeNode getCommonParent(TreeNode first, TreeNode last) {
        TreeNode common = null;
        if (null != first && null != last) {
            ArrayList<TreeNode> parents = new ArrayList<TreeNode>();
            while (first != null) {
                parents.add(first);
                first = first.getParent();
            }
            while (last != null) {
                if (Util.containsInstance(parents, last)) {
                    common = last;
                    break;
                }
                last = last.getParent();
            }
        }
        return common;
    }

    public static TreeNode getSharedAncestor(TreeNode one, TreeNode two) {
        TreeNode node2;
        TreeNode node1;
        int diff;
        if (one == two) {
            return two;
        }
        if (one == null) {
            return null;
        }
        int level1 = TreeUtil.getLevel(two);
        int level2 = TreeUtil.getLevel(one);
        if (level2 > level1) {
            diff = level2 - level1;
            node1 = one;
            node2 = two;
        } else {
            diff = level1 - level2;
            node1 = two;
            node2 = one;
        }
        while (diff > 0) {
            node1 = node1.getParent();
            --diff;
        }
        do {
            if (node1 == node2) {
                return node1;
            }
            node1 = node1.getParent();
            node2 = node2.getParent();
        } while (node1 != null);
        if (node1 != null || node2 != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    public static int getLevel(TreeNode node) {
        int levels = 0;
        TreeNode ancestor = node;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    public static TreeNode getCommonParent(List nodes) {
        TreeNode common = null;
        if (null != nodes && nodes.size() > 0) {
            ArrayList<TreeNode> parents = new ArrayList<TreeNode>();
            for (TreeNode first = (TreeNode)nodes.get(0); first != null; first = first.getParent()) {
                parents.add(first);
            }
            Iterator i = nodes.subList(1, nodes.size()).iterator();
            block1: while (i.hasNext()) {
                for (TreeNode node = (TreeNode)i.next(); node != null; node = node.getParent()) {
                    if (!Util.containsInstance(parents, node)) continue;
                    common = node;
                    int index = Util.indexOfInstance(parents, node);
                    if (index <= 0) continue block1;
                    parents.subList(0, index - 1).clear();
                    continue block1;
                }
            }
        }
        return common;
    }

    public static TreeNode[] getCommonParentPlus(TreeNode first, TreeNode last) {
        TreeNode[] nodes = null;
        if (null != first && null != last) {
            TreeNode walk;
            ArrayList<TreeNode> parents = new ArrayList<TreeNode>();
            for (walk = first; walk != null; walk = walk.getParent()) {
                parents.add(walk);
            }
            walk = last;
            while (last != null) {
                int index = Util.indexOfInstance(parents, last);
                if (index >= 0) {
                    nodes = new TreeNode[]{last, index > 0 ? (TreeNode)parents.get(index - 1) : first, walk};
                    break;
                }
                walk = last;
                last = last.getParent();
            }
        }
        return nodes;
    }

    public static TreeNode[] getCommonParentPlusLeftSibling(TreeNode right) {
        TreeNode[] nodes = null;
        if (null != right) {
            TreeNode left;
            TreeNode common;
            int index = 0;
            for (common = right.getParent(); common != null && (index = common.getIndex(right)) <= 0; common = common.getParent()) {
                right = common;
            }
            if (common != null && (left = common.getChildAt(index - 1)) != null) {
                nodes = new TreeNode[]{left, common, right};
            }
        }
        return nodes;
    }

    public static TreeNode getLeftMostChild(TreeNode node) {
        if (node != null && !node.isLeaf()) {
            return TreeUtil.getLeftMostChild(node.getChildAt(0));
        }
        return node;
    }

    public static TreeNode getRightMostChild(TreeNode node) {
        if (node != null && !node.isLeaf()) {
            return TreeUtil.getRightMostChild(node.getChildAt(node.getChildCount() - 1));
        }
        return node;
    }

    public static TreeNode findStartingNodeOnPath(TreeNode start, TreeNode stop) {
        TreeNode node = start;
        while (node != stop) {
            TreeNode parent = node.getParent();
            if (parent instanceof ILMTreeNode && ((ILMTreeNode)parent).isExplicitlyCreated()) {
                start = parent;
            }
            node = parent;
        }
        return start;
    }

    public static boolean substitute(DefaultTreeModel tree, ILMTreeNode currentChild, ILMTreeNode newChild) {
        boolean changed = false;
        if (currentChild != null && newChild != null) {
            ILMTreeNode parent = (ILMTreeNode)currentChild.getParent();
            if (parent != null) {
                int index = parent.getIndex(currentChild);
                tree.removeNodeFromParent(currentChild);
                tree.insertNodeInto(newChild, parent, index);
                changed = true;
            } else {
                if (newChild.getParent() != null) {
                    tree.removeNodeFromParent(newChild);
                }
                tree.setRoot(newChild);
                changed = true;
            }
        }
        return changed;
    }

    public static TreeNode removeNodeFromTree(DefaultTreeModel tree, MutableTreeNode node) {
        MutableTreeNode removed = null;
        if (tree != null && node != null) {
            removed = node;
            TreeNode parent = node.getParent();
            if (tree.getRoot() == node) {
                tree.setRoot(null);
            } else if (parent != null) {
                tree.removeNodeFromParent(node);
            }
        }
        return removed;
    }

    public static int getIndexOfChildInstance(TreeNode parent, TreeNode child) {
        int index = -1;
        int i = 0;
        Enumeration<? extends TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            TreeNode el = e.nextElement();
            if (child == el) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static boolean swap(DefaultTreeModel tree, ILMTreeNode one, ILMTreeNode two) {
        if (one != null && two != null) {
            ILMTreeNode parent1 = (ILMTreeNode)one.getParent();
            ILMTreeNode parent2 = (ILMTreeNode)two.getParent();
            if (parent1 != null || parent2 != null) {
                int index2;
                int index1 = parent1 == null ? -1 : parent1.getIndex(one);
                int n = index2 = parent2 == null ? -1 : parent2.getIndex(two);
                if (parent1 != null && parent2 != null) {
                    tree.removeNodeFromParent(one);
                    tree.removeNodeFromParent(two);
                    if (index1 < index2) {
                        tree.insertNodeInto(two, parent1, index1);
                        tree.insertNodeInto(one, parent2, index2);
                    } else {
                        tree.insertNodeInto(one, parent2, index2);
                        tree.insertNodeInto(two, parent1, index1);
                    }
                } else if (parent1 != null) {
                    tree.removeNodeFromParent(one);
                    tree.insertNodeInto(two, parent1, index1);
                } else if (parent2 != null) {
                    tree.removeNodeFromParent(two);
                    tree.insertNodeInto(one, parent2, index2);
                }
                return true;
            }
        }
        return false;
    }

    public static TreeNode getLeftSibling(TreeNode node) {
        TreeNode sibling = null;
        if (node != null) {
            int index;
            TreeNode parent = node.getParent();
            while ((index = parent.getIndex(node)) <= 0 && (parent = (node = parent).getParent()) != null) {
            }
            if (parent != null) {
                node = parent.getChildAt(index - 1);
                sibling = TreeUtil.getRightMostChild(node);
            }
        }
        return sibling;
    }

    public static TreeNode getRightSibling(TreeNode node) {
        TreeNode sibling = null;
        if (node != null) {
            TreeNode parent = node.getParent();
            int index = -1;
            while (parent != null) {
                int last = parent.getChildCount() - 1;
                index = parent.getIndex(node);
                if (index < last) break;
                node = parent;
                parent = node.getParent();
            }
            if (parent != null) {
                node = parent.getChildAt(index + 1);
                sibling = TreeUtil.getLeftMostChild(node);
            }
        }
        return sibling;
    }
}

