/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.sort;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.sort.SortSelectorAdapter;
import com.sas.dataselectors.sort.SortSelectorInterface;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.table.SortableInterface;
import com.sas.util.SortDirectionInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class SortSelectorModelFactory
implements SortDirectionInterface {
    public static SortSelectorInterface getAdapter(TableModel model) {
        SortSelectorAdapter adapter = new SortSelectorAdapter();
        if (model instanceof SortableInterface) {
            SortableInterface sortableModel = (SortableInterface)model;
            if (sortableModel.isSortAllowed()) {
                int colCount = model.getColumnCount();
                ArrayList<SortedItem> columns = new ArrayList<SortedItem>();
                List<String> sortedColumns = Arrays.asList(sortableModel.getSortedColumns());
                Object[] sortedArray = new Object[sortedColumns.size()];
                int sortCount = 0;
                int[] directions = sortableModel.getSortedDirections();
                ArrayList<String> displayedNames = new ArrayList<String>();
                for (int i = 0; i < colCount; ++i) {
                    String displayName = model.getColumnName(i);
                    if (!displayedNames.contains(displayName)) {
                        displayedNames.add(displayName);
                    } else {
                        int count = 2;
                        String clone = null;
                        do {
                            clone = displayName;
                            clone = clone + count;
                            ++count;
                        } while (displayedNames.contains(clone));
                        displayName = clone;
                        displayedNames.add(displayName);
                    }
                    String name = TableViewUtil.getColumnName(model, i);
                    if (!sortableModel.isColumnSortable(name)) continue;
                    if (!sortedColumns.contains(name)) {
                        columns.add(new SortedItem(displayName, 0, name));
                        continue;
                    }
                    int index = sortedColumns.indexOf(name);
                    sortedArray[index] = new SortedItem(displayName, directions[index], name);
                    ++sortCount;
                }
                Object[] avail = new SortedItem[columns.size()];
                columns.toArray(avail);
                adapter.setAvailableItems(avail);
                adapter.setSortedItems(sortedArray);
                adapter.setSortedDirections(directions);
            } else {
                adapter.setAvailableItems(new Object[0]);
                adapter.setSortedItems(new Object[0]);
                adapter.setSortedDirections(new int[0]);
            }
        }
        return adapter;
    }
}

