/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTreeInterface;
import com.sas.dataselectors.filters.tree.LogicalConditionNodeInterface;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class TreeUtil {
    private TreeUtil() {
    }

    public static void printTree(FilterLogicTreeInterface tree) {
        if (tree != null) {
            TreeUtil.printTree((FilterLogicBaseNodeInterface)tree.getRoot(), "", "ROOT-", new HashMap());
        }
    }

    public static void printTree(FilterLogicBaseNodeInterface root) {
        TreeUtil.printTree(root, "", "ROOT-", new HashMap());
    }

    private static void printTree(FilterLogicBaseNodeInterface root, String spacer, String prefix, Map visited) {
        System.out.println("_DEBUG_:" + spacer + prefix + TreeUtil.toDebugNodeString(root));
        if (root != null) {
            int count = root.getChildCount();
            if (!root.isLeaf() || count > 0) {
                if (root.isLeaf()) {
                    System.out.println("_DEBUG_:" + spacer + "WARNING - Parent node is not flagged as COMPOUND!");
                }
                if (visited.get(root) != null) {
                    System.out.println("_DEBUG_:" + spacer + "  RECURSIVE NODE LINK <stopping here>");
                } else {
                    visited.put(root, Boolean.TRUE);
                    for (int i = 0; i < count; ++i) {
                        TreeUtil.printTree(root.getChildLogicNodeAt(i), spacer + "  ", i + "-", visited);
                    }
                }
            }
        }
    }

    private static String toDebugNodeString(FilterLogicBaseNodeInterface node) {
        String prefix;
        if (node == null) {
            return "NODE: <EMPTY>  [" + node + "]";
        }
        String string = prefix = node.isLeaf() ? "LEAF" : "NODE";
        if (node instanceof LogicalConditionNodeInterface) {
            LogicalConditionNodeInterface lcn = (LogicalConditionNodeInterface)node;
            String condition = lcn.getLogicalCondition().toString();
            String explicit = lcn.isExplicitlyCreated() ? "GROUP " : "<implicit>";
            return prefix + ": " + explicit + node + " (id=" + node.hashCode() + ")";
        }
        return prefix + ": " + node + " (id=" + node.hashCode() + ")";
    }
}

