/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.AbstractFilterLogicBaseNode;
import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.DefaultFilterLogicTree;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTreeInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicInterface;
import com.sas.dataselectors.filters.tree.LogicalConditionNodeInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class SimpleFilterLogicTree
extends DefaultFilterLogicTree
implements SimpleFilterLogicInterface {
    static final long serialVersionUID = 7025592302701363842L;
    protected List testNodes = new ArrayList();
    protected String label;
    protected String description;

    public SimpleFilterLogicTree() {
        this((FilterLogicBaseNodeInterface)null);
    }

    public SimpleFilterLogicTree(FilterLogicBaseNodeInterface root) {
        this(root, true);
    }

    public SimpleFilterLogicTree(FilterLogicBaseNodeInterface root, boolean standardize) {
        super(root, true, standardize);
        this.modifiable = true;
        this.label = null;
        this.description = null;
    }

    public SimpleFilterLogicTree(FilterLogicTreeInterface otherTree) {
        this((FilterLogicBaseNodeInterface)null);
        Object otherRoot;
        if (otherTree instanceof DefaultFilterLogicTree) {
            this.markGroups = ((DefaultFilterLogicTree)otherTree).getQueryStandardization();
        }
        if (otherTree instanceof SimpleFilterLogicTree) {
            this.label = ((SimpleFilterLogicTree)otherTree).getFilterListLabel();
            this.description = ((SimpleFilterLogicTree)otherTree).getFilterListDescription();
        }
        if ((otherRoot = otherTree.getRoot()) instanceof FilterLogicBaseNodeInterface) {
            this.setRoot((FilterLogicBaseNodeInterface)otherRoot);
            this.refreshFilterList();
        }
    }

    public String toString() {
        if (this.label != null) {
            return this.label;
        }
        return super.toString();
    }

    @Override
    public String getFilterListLabel() {
        return this.label;
    }

    public void setFilterListLabel(String value) {
        this.label = value;
    }

    @Override
    public String getFilterListDescription() {
        return this.description;
    }

    public void setFilterListDescription(String value) {
        this.description = value;
    }

    public FilterLogicBaseNodeInterface getNodeByIndex(int index) {
        FilterLogicBaseNodeInterface node = null;
        if (index >= 0 && index < this.testNodes.size()) {
            node = (FilterLogicBaseNodeInterface)this.testNodes.get(index);
        }
        return node;
    }

    @Override
    public boolean isLeafGrouped(int index) {
        FilterLogicBaseNodeInterface node = this.getNodeByIndex(index);
        if (node == null) {
            throw new IllegalArgumentException();
        }
        return this.isGrouped(node);
    }

    @Override
    public FilterLogicTestNodeInterface removeLeaf(int index) {
        FilterLogicBaseNodeInterface node = this.getNodeByIndex(index);
        if (node == null) {
            return null;
        }
        FilterLogicBaseNodeInterface removed = this.removeNode(node);
        this.refreshFilterList();
        if (removed instanceof FilterLogicTestNodeInterface) {
            return (FilterLogicTestNodeInterface)removed;
        }
        return null;
    }

    @Override
    public void setConditionalRelationType(int index, ConditionalRelationType value) {
        FilterLogicBaseNodeInterface one = this.getNodeByIndex(index);
        FilterLogicBaseNodeInterface two = this.getNodeByIndex(index + 1);
        if (one != null && two != null) {
            if (ConditionalRelationType.AND == value) {
                this.applyAnd(one, two);
            } else if (ConditionalRelationType.OR == value) {
                this.applyOr(one, two);
            }
        }
    }

    @Override
    public ConditionalRelationType getConditionalRelationType(int index) {
        ConditionalRelationType type = null;
        FilterLogicBaseNodeInterface one = this.getNodeByIndex(index);
        FilterLogicBaseNodeInterface two = this.getNodeByIndex(index + 1);
        if (one != null && two != null) {
            type = this.getConditionalRelationType(one, two);
        }
        return type;
    }

    @Override
    public void refreshFilterList() {
        this.testNodes = this.getAllTestNodes((FilterLogicBaseNodeInterface)this.root);
    }

    @Override
    public List getFilterList() {
        return Collections.unmodifiableList(this.testNodes);
    }

    private List getAllTestNodes(FilterLogicBaseNodeInterface treeRoot) {
        ArrayList<FilterLogicBaseNodeInterface> nodes = new ArrayList<FilterLogicBaseNodeInterface>();
        if (treeRoot != null) {
            if (treeRoot instanceof FilterLogicTestNodeInterface) {
                nodes.add(treeRoot);
            } else {
                Enumeration<? extends TreeNode> e = treeRoot.children();
                while (e.hasMoreElements()) {
                    nodes.addAll(this.getAllTestNodes((FilterLogicBaseNodeInterface)e.nextElement()));
                }
            }
        }
        return nodes;
    }

    @Override
    public void setLeafNegated(int index, boolean value) {
        FilterLogicBaseNodeInterface groupRoot;
        boolean isNegated;
        FilterLogicBaseNodeInterface node = this.getNodeByIndex(index);
        if (node != null && value != (isNegated = this.isNegated(groupRoot = this.getGroupRoot(node)))) {
            this.applyNot(groupRoot);
        }
    }

    @Override
    public boolean isLeafNegated(int index) {
        FilterLogicBaseNodeInterface node = this.getNodeByIndex(index);
        if (node == null) {
            throw new IndexOutOfBoundsException();
        }
        FilterLogicBaseNodeInterface groupRoot = this.getGroupRoot(node);
        boolean isNegated = this.isNegated(groupRoot);
        return isNegated;
    }

    private FilterLogicBaseNodeInterface getGroupRoot(FilterLogicBaseNodeInterface node) {
        if (this.isGrouped(node)) {
            LogicalConditionNodeInterface groupRoot = null;
            while (node != null) {
                if (node instanceof LogicalConditionNodeInterface && ((LogicalConditionNodeInterface)node).isExplicitlyCreated()) {
                    groupRoot = (LogicalConditionNodeInterface)node;
                }
                node = node.getParentLogicNode();
            }
            node = groupRoot;
        }
        return node;
    }

    @Override
    public boolean canGroupLeaves(int startIndex, int endIndex) {
        FilterLogicBaseNodeInterface lastNode;
        FilterLogicBaseNodeInterface firstNode = this.getNodeByIndex(startIndex);
        if (firstNode != (lastNode = this.getNodeByIndex(endIndex))) {
            return this.canGroup(firstNode, lastNode);
        }
        return false;
    }

    @Override
    public boolean groupLeaves(int startIndex, int endIndex) {
        FilterLogicBaseNodeInterface lastNode;
        FilterLogicBaseNodeInterface firstNode = this.getNodeByIndex(startIndex);
        if (firstNode != (lastNode = this.getNodeByIndex(endIndex))) {
            return this.applyGroup(firstNode, lastNode, true);
        }
        return false;
    }

    @Override
    public boolean splitOnMember(int indexOfMember) {
        FilterLogicBaseNodeInterface memberNode = this.getNodeByIndex(indexOfMember);
        if (memberNode != null) {
            return this.applySplit(memberNode);
        }
        return false;
    }

    @Override
    public boolean moveLeafUp(int index) {
        boolean success = false;
        FilterLogicBaseNodeInterface memberNode = this.getNodeByIndex(index);
        if (memberNode != null) {
            success = this.moveUp(memberNode);
            this.refreshFilterList();
        }
        return success;
    }

    @Override
    public boolean moveLeafDown(int index) {
        boolean success = false;
        FilterLogicBaseNodeInterface memberNode = this.getNodeByIndex(index);
        if (memberNode != null) {
            success = this.moveDown(memberNode);
            this.refreshFilterList();
        }
        return success;
    }

    @Override
    public FilterLogicTestNodeInterface setLeaf(int index, FilterLogicTestNodeInterface testNode) {
        FilterLogicTestNodeInterface oldTestNode = null;
        if (index >= 0 && index < this.testNodes.size() && testNode != null) {
            oldTestNode = (FilterLogicTestNodeInterface)this.testNodes.get(index);
            this.replaceNode(oldTestNode, testNode);
            this.testNodes.set(index, testNode);
        }
        return oldTestNode;
    }

    @Override
    public boolean addLeaf(int index, FilterLogicTestNodeInterface testNode) {
        int treeSize = this.testNodes.size();
        if (index == -1) {
            index = treeSize;
        }
        boolean success = false;
        if (index == treeSize) {
            success = this.applyAdd(testNode);
        }
        if (success) {
            this.testNodes.add(index, testNode);
        }
        return success;
    }

    @Override
    public int getLeafCount() {
        return this.testNodes.size();
    }

    @Override
    public FilterLogicTestNodeInterface getLeaf(int i) {
        return (FilterLogicTestNodeInterface)this.testNodes.get(i);
    }

    @Override
    public boolean setFilterObject(Object filterObject) {
        boolean modified = false;
        if (filterObject == null) {
            if (this.getRoot() != null) {
                this.clear();
                modified = true;
            }
        } else {
            TreeNode newRoot = null;
            if (newRoot != null) {
                this.setRoot(newRoot);
                modified = true;
            }
        }
        this.refreshFilterList();
        return modified;
    }

    @Override
    public FilterLogicTreeInterface copy() {
        AbstractFilterLogicBaseNode newRoot;
        SimpleFilterLogicTree copy = new SimpleFilterLogicTree(this);
        AbstractFilterLogicBaseNode myRoot = (AbstractFilterLogicBaseNode)this.getRoot();
        if (myRoot == null) {
            newRoot = null;
        } else {
            newRoot = (AbstractFilterLogicBaseNode)myRoot.clone();
            this.copyChildren(newRoot);
        }
        copy.setRoot(newRoot);
        copy.refreshFilterList();
        return copy;
    }
}

