/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.timebased.RB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@SASScope
public class TimePeriodType
implements Serializable {
    private final String name;
    private final String key;
    private final String singularDescriptionKey;
    private final String pluralDescriptionKey;
    private static List types = new ArrayList(2);
    public static final TimePeriodType YEARS = new TimePeriodType("YEARS", "PeriodType.Years.txt", "PeriodType.Years.singular.description.txt", "PeriodType.Years.description.txt");
    public static final TimePeriodType QUARTERS = new TimePeriodType("QUARTERS", "PeriodType.Quarters.txt", "PeriodType.Quarters.singular.description.txt", "PeriodType.Quarters.description.txt");
    public static final TimePeriodType MONTHS = new TimePeriodType("MONTHS", "PeriodType.Months.txt", "PeriodType.Months.singular.description.txt", "PeriodType.Months.description.txt");
    public static final TimePeriodType WEEKS = new TimePeriodType("WEEKS", "PeriodType.Weeks.txt", "PeriodType.Weeks.singular.description.txt", "PeriodType.Weeks.description.txt");
    public static final TimePeriodType DAYS = new TimePeriodType("DAYS", "PeriodType.Days.txt", "PeriodType.Days.singular.description.txt", "PeriodType.Days.description.txt");
    public static final TimePeriodType HOURS = new TimePeriodType("HOURS", "PeriodType.Hours.txt", "PeriodType.Hours.singular.description.txt", "PeriodType.Hours.description.txt");
    public static final TimePeriodType MINUTES = new TimePeriodType("MINUTES", "PeriodType.Minutes.txt", "PeriodType.Minutes.singular.description.txt", "PeriodType.Minutes.description.txt");
    public static final TimePeriodType SECONDS = new TimePeriodType("SECONDS", "PeriodType.Seconds.txt", "PeriodType.Seconds.singular.description.txt", "PeriodType.Seconds.description.txt");

    private TimePeriodType(String name, String key, String singularDescriptionKey, String pluralDescriptionKey) {
        this.name = name;
        this.key = key;
        this.singularDescriptionKey = singularDescriptionKey;
        this.pluralDescriptionKey = pluralDescriptionKey;
        types.add(this);
    }

    public String toString() {
        return this.name;
    }

    public String getLabel() {
        return RB.getStringResource(this.key);
    }

    public String getLabel(Locale locale) {
        return RB.getStringResource(this.key, locale);
    }

    public String getSingularDescription() {
        return RB.getStringResource(this.singularDescriptionKey);
    }

    public String getSingularDescription(Locale locale) {
        return RB.getStringResource(this.singularDescriptionKey, locale);
    }

    public String getPluralDescription() {
        return RB.getStringResource(this.pluralDescriptionKey);
    }

    public String getPluralDescription(Locale locale) {
        return RB.getStringResource(this.pluralDescriptionKey, locale);
    }

    public static TimePeriodType findType(String name) {
        TimePeriodType type = null;
        if (name != null) {
            for (TimePeriodType t : types) {
                if (!name.equals(t.toString())) continue;
                type = t;
                break;
            }
        }
        return type;
    }

    public static TimePeriodType findByLabel(String label) {
        if (label != null) {
            for (TimePeriodType t : types) {
                if (!label.equals(t.getLabel())) continue;
                return t;
            }
        }
        return null;
    }

    public static List getAvailableTypes() {
        return Collections.unmodifiableList(types);
    }
}

