/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterData;
import com.sas.dataselectors.filters.timebased.TimePeriod;
import com.sas.dataselectors.filters.timebased.TimePeriodType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@SASScope
public class TimeCondition
implements Serializable {
    private final String name;
    private final List values;
    private static List types = new ArrayList(2);
    public static final TimeCondition CONDITION_YEAR_TO_DATE = new TimeCondition("year2date", new RelativeTimeFilterData[]{new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_YEAR, 1), new RelativeTimeFilterData(TimePeriod.PERIOD_TODAY)});
    public static final TimeCondition CONDITION_MONTH_TO_DATE = new TimeCondition("month2date", new RelativeTimeFilterData[]{new RelativeTimeFilterData(TimePeriod.PERIOD_CURRENT_MONTH, 1), new RelativeTimeFilterData(TimePeriod.PERIOD_TODAY)});
    public static final TimeCondition CONDITION_RANGE = new TimeCondition("range", new RelativeTimeFilterData[]{new RelativeTimeFilterData(TimePeriod.PERIOD_TODAY), new RelativeTimeFilterData(TimePeriod.PERIOD_TODAY)});
    public static final TimeCondition CONDITION_LAST_N_PERIODS = new TimeCondition("lastN", new RelativeTimeFilterData[]{new RelativeTimeFilterData(TimePeriod.PERIOD_N_PERIODS_AGO, 1, TimePeriodType.YEARS, 1), new RelativeTimeFilterData(TimePeriod.PERIOD_TODAY)});
    public static final TimeCondition CONDITION_NEXT_N_PERIODS = new TimeCondition("nextN", new RelativeTimeFilterData[]{new RelativeTimeFilterData(TimePeriod.PERIOD_TODAY), new RelativeTimeFilterData(TimePeriod.PERIOD_N_PERIODS_FROM_NOW, 2, TimePeriodType.YEARS, 1)});

    private TimeCondition(String name, RelativeTimeFilterData[] defaultValues) {
        this(name, Arrays.asList(defaultValues));
    }

    private TimeCondition(String name, List defaultValues) {
        this.name = name;
        this.values = Collections.unmodifiableList(defaultValues);
        types.add(this);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return obj.toString().equalsIgnoreCase(this.name);
        }
        return super.equals(obj);
    }

    public List getDefaultValueData() {
        return this.values;
    }

    public static TimeCondition findType(String name) {
        TimeCondition type = null;
        if (name != null) {
            for (TimeCondition t : types) {
                if (!name.equals(t.toString())) continue;
                type = t;
                break;
            }
        }
        return type;
    }

    public static List getAvailableTypes() {
        return Collections.unmodifiableList(types);
    }
}

