/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.AbstractFilterLogicBaseNode;
import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTreeInterface;
import com.sas.dataselectors.filters.Util;
import com.sas.dataselectors.filters.tree.LogicalConditionNode;
import com.sas.dataselectors.filters.tree.LogicalConditionNodeInterface;
import com.sas.dataselectors.filters.tree.NotNode;
import com.sas.dataselectors.filters.tree.NotNodeInterface;
import com.sas.dataselectors.filters.tree.TreeUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class DefaultFilterLogicTree
extends DefaultTreeModel
implements FilterLogicTreeInterface,
Serializable {
    static final long serialVersionUID = -2603417921367492064L;
    public static final boolean DEBUG = false;
    protected boolean modifiable;
    protected boolean modified;
    protected boolean markGroups;

    public DefaultFilterLogicTree() {
        this(null, true);
    }

    public DefaultFilterLogicTree(FilterLogicBaseNodeInterface root) {
        this(root, true);
    }

    public DefaultFilterLogicTree(FilterLogicBaseNodeInterface root, boolean modifiable) {
        this(root, true, true);
    }

    public DefaultFilterLogicTree(FilterLogicBaseNodeInterface root, boolean modifiable, boolean standardize) {
        this(root, modifiable, standardize, false);
    }

    @SASScope
    public DefaultFilterLogicTree(FilterLogicBaseNodeInterface root, boolean modifiable, boolean standardize, boolean compoundFilterFlag) {
        super(root);
        this.modifiable = modifiable;
        this.markGroups = standardize;
        if (modifiable) {
            this.root = this.simplify(this.root);
            if (this.markGroups) {
                this.markGroupsUsingBooleanLogic(this.root, compoundFilterFlag);
            }
        }
    }

    @Override
    public boolean canSplit(TreeNode node) {
        if (node != null) {
            boolean canSplit = true;
            while (!(node == null || node instanceof LogicalConditionNodeInterface && ((LogicalConditionNodeInterface)node).isExplicitlyCreated())) {
                node = node.getParent();
            }
            return node instanceof LogicalConditionNodeInterface && ((LogicalConditionNodeInterface)node).isExplicitlyCreated();
        }
        boolean canSplit = false;
        return canSplit;
    }

    @Override
    public boolean canMoveUp(TreeNode node) {
        return this.canMoveUp(node, true);
    }

    public boolean canMoveUp(TreeNode node, boolean includingParents) {
        TreeNode parent;
        if (null != node && null != (parent = node.getParent())) {
            int index = parent.getIndex(node);
            if (index > 0) {
                return true;
            }
            if (includingParents) {
                return this.canMoveUp(parent, includingParents);
            }
        }
        return false;
    }

    @Override
    public boolean canMoveDown(TreeNode node) {
        return this.canMoveDown(node, true);
    }

    public boolean canMoveDown(TreeNode node, boolean includingParents) {
        TreeNode parent;
        if (null != node && null != (parent = node.getParent())) {
            int count = parent.getChildCount();
            int index = parent.getIndex(node);
            if (count > 1 && index < count - 1) {
                return true;
            }
            if (includingParents) {
                return this.canMoveDown(parent, includingParents);
            }
        }
        return false;
    }

    protected boolean isGrouped(TreeNode node) {
        boolean grouped = false;
        while (node != null) {
            if (node instanceof LogicalConditionNodeInterface && ((LogicalConditionNodeInterface)node).isExplicitlyCreated()) {
                grouped = true;
                break;
            }
            node = node.getParent();
        }
        return grouped;
    }

    protected TreeNode getOuterMostGroupRoot(TreeNode node) {
        TreeNode groupRoot = node;
        if (this.isGrouped(node)) {
            while (node != null) {
                if (node instanceof LogicalConditionNodeInterface && ((LogicalConditionNodeInterface)node).isExplicitlyCreated()) {
                    groupRoot = node;
                }
                node = node.getParent();
            }
        }
        return groupRoot;
    }

    @Override
    public boolean group(TreeNode first, TreeNode last) {
        if (first != last) {
            return this.applyGroup(first, last, true);
        }
        return false;
    }

    @Override
    public boolean split(TreeNode node) {
        if (node != null) {
            if (!(node instanceof LogicalConditionNodeInterface)) {
                throw new IllegalArgumentException("Node must be an AND or OR node!");
            }
            return this.applySplit(node);
        }
        return false;
    }

    @Override
    public boolean moveUp(TreeNode node) {
        if (node != null) {
            return this.applyMoveUp(node);
        }
        return false;
    }

    @Override
    public boolean moveDown(TreeNode node) {
        if (node != null) {
            return this.applyMoveDown(node);
        }
        return false;
    }

    public boolean negate(TreeNode node) {
        if (node != null) {
            return this.applyNot(node);
        }
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void clear() {
        this.setRoot(null);
    }

    @Override
    public boolean add(TreeNode node) {
        if (this.markGroups) {
            this.markGroupsUsingBooleanLogic(node);
        }
        return this.applyAdd(node);
    }

    @Override
    public boolean setNegated(TreeNode node, boolean value) {
        boolean isNegated;
        if (node != null && value != (isNegated = this.isNegated(node))) {
            return this.applyNot(node);
        }
        return false;
    }

    @Override
    public boolean isNegated(TreeNode node) {
        TreeNode parent = node.getParent();
        return parent instanceof NotNodeInterface;
    }

    @Override
    public void setRoot(TreeNode root) {
        if (this.validateNodeTypes(root)) {
            super.setRoot(root);
        }
    }

    @Override
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        if (this.validateNodeTypes(newChild)) {
            super.insertNodeInto(newChild, parent, index);
        }
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    private boolean validateNodeTypes(TreeNode node) {
        if (node != null) {
            if (node instanceof FilterLogicTestNodeInterface) {
                FilterLogicTestNodeInterface test = (FilterLogicTestNodeInterface)node;
                if (test.getAllowsChildren()) {
                    return false;
                }
                if (test.getChildCount() > 0) {
                    return false;
                }
                if (test.getMaxChildren() > 0) {
                    return false;
                }
                if (!test.isLeaf()) {
                    return false;
                }
            } else if (node instanceof NotNodeInterface) {
                NotNodeInterface test = (NotNodeInterface)node;
                if (!test.getAllowsChildren()) {
                    return false;
                }
                if (test.getChildCount() != 1) {
                    return false;
                }
                if (test.getMaxChildren() > 1) {
                    return false;
                }
                if (test.isLeaf()) {
                    return false;
                }
                TreeNode child = test.getChildAt(0);
                if (!this.validateNodeTypes(child)) {
                    return false;
                }
            } else if (node instanceof LogicalConditionNodeInterface) {
                LogicalConditionNodeInterface test = (LogicalConditionNodeInterface)node;
                if (!test.getAllowsChildren()) {
                    return false;
                }
                if (test.getChildCount() == 0) {
                    return false;
                }
                if (test.getMaxChildren() == 0) {
                    return false;
                }
                if (test.isLeaf()) {
                    return false;
                }
                for (int i = 0; i < test.getChildCount(); ++i) {
                    if (this.validateNodeTypes(test.getChildAt(i))) continue;
                    return false;
                }
            } else {
                throw new IllegalArgumentException("TreeNode must be a TestNodeInterface, NotNodeInterface, or LogicalConditionNodeInterface");
            }
        }
        return true;
    }

    protected MutableTreeNode getMutableTreeNode(TreeNode node) {
        MutableTreeNode newNode = null;
        if (null != node) {
            if (node instanceof MutableTreeNode) {
                newNode = (MutableTreeNode)node;
            } else {
                newNode = null;
                if (node instanceof NotNodeInterface) {
                    newNode = new NotNode((NotNodeInterface)node);
                } else if (node instanceof LogicalConditionNodeInterface) {
                    newNode = new LogicalConditionNode((LogicalConditionNodeInterface)node);
                } else if (node instanceof FilterLogicTestNodeInterface) {
                    newNode = new DefaultFilterLogicTestNode((FilterLogicTestNodeInterface)node);
                }
            }
        }
        if (newNode != node) {
            TreeNode parent = node.getParent();
            if (parent == null) {
                if (this.root == node) {
                    this.root = newNode;
                }
            } else {
                int n = parent.getIndex(node);
            }
        }
        return newNode;
    }

    protected void destroy(TreeNode node) {
        if (node instanceof MutableTreeNode) {
            MutableTreeNode victim = (MutableTreeNode)node;
            int count = victim.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                victim.remove(i);
            }
            if (node instanceof FilterLogicBaseNodeInterface) {
                ((FilterLogicBaseNodeInterface)node).dispose();
            }
        }
    }

    public static NotNodeInterface newNotNode() {
        return new NotNode();
    }

    public static LogicalConditionNodeInterface newLogicalConditionNode(ConditionalRelationType lc) {
        return DefaultFilterLogicTree.newLogicalConditionNode(lc, true);
    }

    public static LogicalConditionNodeInterface newLogicalConditionNode(ConditionalRelationType lc, boolean explicitlyCreated) {
        return new LogicalConditionNode(lc, explicitlyCreated);
    }

    protected boolean applyNot(TreeNode node) {
        MutableTreeNode parent = this.getMutableTreeNode(node.getParent());
        if (parent instanceof NotNodeInterface) {
            MutableTreeNode child = this.getMutableTreeNode(node);
            MutableTreeNode newParent = this.getMutableTreeNode(parent.getParent());
            if (null != newParent) {
                int childIndex = newParent.getIndex(node.getParent());
                if (childIndex > -1) {
                    this.removeNodeFromParent(parent);
                    this.insertNodeInto(child, newParent, childIndex);
                }
            } else {
                this.setRoot(child);
            }
            this.destroy(parent);
        } else {
            MutableTreeNode oldParent = parent;
            parent = this.getMutableTreeNode(DefaultFilterLogicTree.newNotNode());
            if (null != oldParent) {
                MutableTreeNode child = this.getMutableTreeNode(node);
                int childIndex = oldParent.getIndex(child);
                if (childIndex > -1) {
                    this.insertNodeInto(child, parent, 0);
                    this.insertNodeInto(parent, oldParent, childIndex);
                }
            } else {
                MutableTreeNode child = this.getMutableTreeNode(node);
                this.insertNodeInto(child, parent, 0);
                this.setRoot(parent);
            }
        }
        return true;
    }

    protected boolean applySplit(TreeNode member) {
        LogicalConditionNodeInterface lcnParent;
        boolean canSplit = this.canSplit(member);
        if (!canSplit) {
            return false;
        }
        TreeNode splitRoot = this.getOuterMostGroupRoot(member);
        if (splitRoot == null) {
            return false;
        }
        MutableTreeNode newParent = null;
        MutableTreeNode parent = this.getMutableTreeNode(splitRoot.getParent());
        if (parent instanceof NotNodeInterface) {
            newParent = this.getMutableTreeNode(parent.getParent());
            this.substitute(parent, this.getMutableTreeNode(splitRoot));
            parent = newParent;
        } else {
            newParent = parent;
        }
        if (splitRoot instanceof LogicalConditionNode) {
            ((LogicalConditionNode)splitRoot).setExplicitlyCreated(false);
        }
        if (splitRoot instanceof LogicalConditionNodeInterface && ((LogicalConditionNodeInterface)splitRoot).getLogicalCondition() == ConditionalRelationType.OR && newParent instanceof LogicalConditionNodeInterface && (lcnParent = (LogicalConditionNodeInterface)((Object)newParent)).getLogicalCondition() == ConditionalRelationType.AND && !lcnParent.isExplicitlyCreated()) {
            int index = newParent.getIndex(splitRoot);
            MutableTreeNode theOR = this.getMutableTreeNode(splitRoot);
            MutableTreeNode leftAND = null;
            MutableTreeNode rightAND = null;
            MutableTreeNode grandparent = this.getMutableTreeNode(newParent.getParent());
            if (index == 0) {
                rightAND = this.getMutableTreeNode(newParent);
            } else if (index == newParent.getChildCount() - 1) {
                leftAND = this.getMutableTreeNode(newParent);
            } else {
                leftAND = this.getMutableTreeNode(newParent);
                rightAND = this.getMutableTreeNode(DefaultFilterLogicTree.newLogicalConditionNode(ConditionalRelationType.AND, false));
                for (int i = newParent.getChildCount() - 1; i > index; --i) {
                    MutableTreeNode child = this.getMutableTreeNode(newParent.getChildAt(i));
                    this.insertNodeInto(child, rightAND, 0);
                }
            }
            this.removeNodeFromParent(theOR);
            if (grandparent != null) {
                this.substitute(newParent, theOR);
            }
            splitRoot = theOR;
            newParent = grandparent;
            if (leftAND != null) {
                MutableTreeNode leftChild = this.getMutableTreeNode(theOR.getChildAt(0));
                this.substitute(leftChild, leftAND);
                this.insertNodeInto(leftChild, leftAND, leftAND.getChildCount());
            }
            if (rightAND != null) {
                MutableTreeNode rightChild = this.getMutableTreeNode(theOR.getChildAt(theOR.getChildCount() - 1));
                this.substitute(rightChild, rightAND);
                this.insertNodeInto(rightChild, rightAND, 0);
            }
        }
        if (newParent == null) {
            this.root = splitRoot;
            this.simplify(this.root);
        } else {
            if (newParent != splitRoot.getParent()) {
                this.substitute(newParent, this.getMutableTreeNode(splitRoot));
            }
            this.simplify(newParent);
        }
        return true;
    }

    private TreeNode simplify(TreeNode node) {
        if (node instanceof LogicalConditionNodeInterface) {
            LogicalConditionNodeInterface lcn = (LogicalConditionNodeInterface)node;
            for (int i = 0; i < node.getChildCount(); ++i) {
                LogicalConditionNodeInterface lcnChild;
                TreeNode child = node.getChildAt(i);
                if (!((child = this.simplify(child)) instanceof LogicalConditionNodeInterface) || (lcnChild = (LogicalConditionNodeInterface)child).isExplicitlyCreated() || lcnChild.getLogicalCondition() != lcn.getLogicalCondition()) continue;
                MutableTreeNode mParent = this.getMutableTreeNode(lcn);
                MutableTreeNode mChild = this.getMutableTreeNode(child);
                int index = mParent.getIndex(mChild);
                this.removeNodeFromParent(mChild);
                for (int c = mChild.getChildCount() - 1; c >= 0; --c) {
                    this.insertNodeInto(this.getMutableTreeNode(mChild.getChildAt(c)), mParent, index);
                }
            }
        }
        return node;
    }

    private boolean substitute(MutableTreeNode currentChild, MutableTreeNode newChild) {
        boolean changed = false;
        if (currentChild != null && newChild != null) {
            MutableTreeNode parent = this.getMutableTreeNode(currentChild.getParent());
            if (parent != null) {
                int index = parent.getIndex(currentChild);
                this.removeNodeFromParent(currentChild);
                this.insertNodeInto(newChild, parent, index);
                changed = true;
            } else {
                this.removeNodeFromParent(newChild);
                this.root = newChild;
                changed = true;
            }
        }
        return changed;
    }

    private boolean swap(MutableTreeNode one, MutableTreeNode two) {
        if (one != null && two != null) {
            MutableTreeNode parent1 = this.getMutableTreeNode(one.getParent());
            MutableTreeNode parent2 = this.getMutableTreeNode(two.getParent());
            if (parent1 != null || parent2 != null) {
                if (parent1 != null && parent2 != null) {
                    int index1 = parent1 == null ? -1 : parent1.getIndex(one);
                    this.removeNodeFromParent(one);
                    int index2 = parent2 == null ? -1 : parent2.getIndex(two);
                    this.removeNodeFromParent(two);
                    if (index1 < index2) {
                        this.insertNodeInto(two, parent1, index1);
                        this.insertNodeInto(one, parent2, index2);
                    } else {
                        this.insertNodeInto(one, parent2, index2);
                        this.insertNodeInto(two, parent1, index1);
                    }
                } else if (parent1 != null) {
                    int index1 = parent1 == null ? -1 : parent1.getIndex(one);
                    this.removeNodeFromParent(one);
                    this.insertNodeInto(two, parent1, index1);
                } else if (parent2 != null) {
                    int index2 = parent2 == null ? -1 : parent2.getIndex(two);
                    this.removeNodeFromParent(two);
                    this.insertNodeInto(one, parent2, index2);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean applyMoveUp(TreeNode node) {
        if (null != node) {
            TreeNode parent;
            TreeNode newStart = node;
            TreeNode last = node;
            for (node = node.getParent(); node != null; node = node.getParent()) {
                if (node instanceof NotNodeInterface) {
                    newStart = node;
                } else if (node instanceof LogicalConditionNodeInterface) {
                    LogicalConditionNodeInterface lcnParent = (LogicalConditionNodeInterface)node;
                    int index = node.getIndex(last);
                    if (index > 0) break;
                    if (lcnParent.isExplicitlyCreated()) {
                        newStart = node;
                    }
                }
                last = node;
            }
            if ((parent = (node = newStart).getParent()) instanceof NotNodeInterface) {
                return this.applyMoveUp(parent);
            }
            if (parent instanceof LogicalConditionNodeInterface) {
                LogicalConditionNodeInterface lcnParent = (LogicalConditionNodeInterface)parent;
                int index = parent.getIndex(node);
                if (index == 0 && lcnParent.isExplicitlyCreated()) {
                    return this.applyMoveUp(parent);
                }
                TreeNode sibling = null;
                if (index > 0) {
                    sibling = parent.getChildAt(index - 1);
                } else {
                    TreeNode[] path = this.getPathToLCNParent(parent);
                    if (path != null && path.length > 1) {
                        parent = path[path.length - 1];
                        sibling = parent.getChildAt(parent.getIndex(path[path.length - 2]) - 1);
                    }
                }
                while (sibling instanceof LogicalConditionNodeInterface && !((LogicalConditionNodeInterface)sibling).isExplicitlyCreated()) {
                    sibling = sibling.getChildAt(sibling.getChildCount() - 1);
                }
                if (sibling != null) {
                    return this.swap(this.getMutableTreeNode(node), this.getMutableTreeNode(sibling));
                }
            }
        }
        return false;
    }

    private TreeNode[] getPathToLCNParent(TreeNode parent) {
        TreeNode[] path = null;
        if (parent != null) {
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            nodes.add(parent);
            while ((parent = parent.getParent()) != null) {
                nodes.add(parent);
                if (!(parent instanceof LogicalConditionNodeInterface)) continue;
            }
            if (parent instanceof LogicalConditionNodeInterface) {
                path = new TreeNode[nodes.size()];
                nodes.toArray(path);
            }
        }
        return path;
    }

    protected boolean applyMoveDown(TreeNode node) {
        if (null != node) {
            TreeNode parent;
            TreeNode newStart = node;
            TreeNode last = node;
            for (node = node.getParent(); node != null; node = node.getParent()) {
                if (node instanceof NotNodeInterface) {
                    newStart = node;
                } else if (node instanceof LogicalConditionNodeInterface) {
                    LogicalConditionNodeInterface lcnParent = (LogicalConditionNodeInterface)node;
                    int index = node.getIndex(last);
                    if (index < lcnParent.getChildCount() - 1) break;
                    if (lcnParent.isExplicitlyCreated()) {
                        newStart = node;
                    }
                }
                last = node;
            }
            if ((parent = (node = newStart).getParent()) instanceof NotNodeInterface) {
                return this.applyMoveDown(parent);
            }
            if (parent instanceof LogicalConditionNodeInterface) {
                LogicalConditionNodeInterface lcnParent = (LogicalConditionNodeInterface)parent;
                int index = parent.getIndex(node);
                if (index == parent.getChildCount() - 1 && lcnParent.isExplicitlyCreated()) {
                    return this.applyMoveDown(parent);
                }
                TreeNode sibling = null;
                if (index < parent.getChildCount() - 1) {
                    sibling = parent.getChildAt(index + 1);
                } else {
                    TreeNode[] path = this.getPathToLCNParent(parent);
                    if (path != null && path.length > 1 && (index = (parent = path[path.length - 1]).getIndex(path[path.length - 2])) < parent.getChildCount() - 1) {
                        sibling = parent.getChildAt(parent.getIndex(path[path.length - 2]) + 1);
                    }
                }
                while (sibling instanceof LogicalConditionNodeInterface && !((LogicalConditionNodeInterface)sibling).isExplicitlyCreated()) {
                    sibling = sibling.getChildAt(0);
                }
                if (sibling != null) {
                    return this.swap(this.getMutableTreeNode(node), this.getMutableTreeNode(sibling));
                }
            }
        }
        return false;
    }

    protected boolean applyDelete(TreeNode node) {
        if (null != node) {
            if (null != node.getParent()) {
                MutableTreeNode child = this.getMutableTreeNode(node);
                this.removeNodeFromParent(child);
            } else {
                this.setRoot(null);
            }
            this.destroy(node);
            return true;
        }
        return false;
    }

    protected boolean applyAdd(TreeNode node) {
        if (null != node) {
            if (null == this.root) {
                this.setRoot(node);
            } else {
                MutableTreeNode mutableRoot;
                MutableTreeNode groupRoot = mutableRoot = this.getMutableTreeNode(this.root);
                LogicalConditionNodeInterface lcnRoot = null;
                if (this.root instanceof LogicalConditionNodeInterface) {
                    lcnRoot = (LogicalConditionNodeInterface)this.root;
                }
                if (lcnRoot == null || lcnRoot.isExplicitlyCreated()) {
                    groupRoot = this.getMutableTreeNode(DefaultFilterLogicTree.newLogicalConditionNode(ConditionalRelationType.AND, false));
                    this.insertNodeInto(mutableRoot, groupRoot, 0);
                    this.setRoot(groupRoot);
                } else if (lcnRoot != null && lcnRoot.getLogicalCondition() == ConditionalRelationType.OR) {
                    int last = lcnRoot.getChildCount() - 1;
                    FilterLogicBaseNodeInterface lastChild = lcnRoot.getChildLogicNodeAt(last);
                    if (lastChild instanceof LogicalConditionNodeInterface && !((LogicalConditionNodeInterface)lastChild).isExplicitlyCreated()) {
                        groupRoot = this.getMutableTreeNode(lastChild);
                    } else {
                        groupRoot = this.getMutableTreeNode(DefaultFilterLogicTree.newLogicalConditionNode(ConditionalRelationType.AND, false));
                        this.insertNodeInto(this.getMutableTreeNode(lastChild), groupRoot, 0);
                        this.insertNodeInto(groupRoot, mutableRoot, last);
                    }
                }
                MutableTreeNode child = this.getMutableTreeNode(node);
                int childCount = groupRoot.getChildCount();
                this.insertNodeInto(child, groupRoot, childCount);
            }
            return true;
        }
        return false;
    }

    protected boolean applyGroup(TreeNode first, TreeNode last, boolean explicitlyCreated) {
        TreeNode[] nodes;
        boolean changed = false;
        if (first != last && (nodes = this.getCommonParentPlus(first, last)) != null && nodes.length == 3) {
            MutableTreeNode newChild;
            int mCommonIndex;
            MutableTreeNode mcParent;
            MutableTreeNode mChild;
            MutableTreeNode mParent;
            MutableTreeNode mCommon;
            TreeNode tempNode;
            int index;
            TreeNode parent;
            TreeNode common = nodes[0];
            TreeNode leftChild = nodes[1];
            TreeNode rightChild = nodes[2];
            TreeNode leftStart = first;
            TreeNode rightStart = last;
            int lIndex = common.getIndex(leftChild);
            int rIndex = common.getIndex(rightChild);
            if (lIndex > 0 || rIndex < common.getChildCount() - 1) {
                LogicalConditionNodeInterface groupRoot = DefaultFilterLogicTree.newLogicalConditionNode(((LogicalConditionNodeInterface)common).getLogicalCondition(), false);
                MutableTreeNode mParent2 = this.getMutableTreeNode(groupRoot);
                for (int i = rIndex; i >= lIndex; --i) {
                    MutableTreeNode newChild2 = this.getMutableTreeNode(common.getChildAt(i));
                    this.insertNodeInto(newChild2, mParent2, 0);
                }
                this.insertNodeInto(mParent2, this.getMutableTreeNode(common), lIndex);
                changed = true;
                common = mParent2;
            }
            boolean isInnerGroup = false;
            LogicalConditionNodeInterface commonLCN = (LogicalConditionNodeInterface)common;
            if (commonLCN instanceof LogicalConditionNode) {
                if (commonLCN.isExplicitlyCreated()) {
                    isInnerGroup = true;
                }
                ((LogicalConditionNode)commonLCN).setExplicitlyCreated(explicitlyCreated);
            }
            leftStart = this.findStartingNodeOnPath(leftStart, leftChild);
            rightStart = this.findStartingNodeOnPath(rightStart, rightChild);
            TreeNode node = leftStart;
            while (node != leftChild) {
                parent = node.getParent();
                index = parent.getIndex(node);
                if (index > 0 && parent instanceof LogicalConditionNodeInterface && !((LogicalConditionNodeInterface)parent).isExplicitlyCreated()) {
                    MutableTreeNode newLeftChild;
                    LogicalConditionNodeInterface lcn = (LogicalConditionNodeInterface)parent;
                    if (lcn.getLogicalCondition() != ConditionalRelationType.AND) {
                        throw new AssertionError(lcn.getLogicalCondition());
                    }
                    tempNode = lcn.getParent();
                    if (tempNode == null) {
                        throw new AssertionError(tempNode);
                    }
                    if (!(tempNode instanceof LogicalConditionNodeInterface)) {
                        throw new AssertionError(tempNode);
                    }
                    if (tempNode != common) {
                        throw new AssertionError(tempNode);
                    }
                    if (commonLCN.getLogicalCondition() != ConditionalRelationType.OR) {
                        throw new AssertionError(commonLCN.getLogicalCondition());
                    }
                    mCommon = this.getMutableTreeNode(common);
                    mParent = this.getMutableTreeNode(parent);
                    mChild = this.getMutableTreeNode(node);
                    mcParent = this.getMutableTreeNode(mCommon.getParent());
                    int n = mCommonIndex = mcParent == null ? -1 : mcParent.getIndex(mCommon);
                    if (index == parent.getChildCount() - 1) {
                        newLeftChild = mChild;
                    } else {
                        newLeftChild = this.getMutableTreeNode(DefaultFilterLogicTree.newLogicalConditionNode(lcn.getLogicalCondition(), false));
                        for (int i = parent.getChildCount() - 1; i >= index; --i) {
                            newChild = this.getMutableTreeNode(parent.getChildAt(i));
                            this.insertNodeInto(newChild, newLeftChild, 0);
                        }
                    }
                    this.removeNodeFromParent(mParent);
                    this.insertNodeInto(newLeftChild, mCommon, 0);
                    this.insertNodeInto(mCommon, mParent, index);
                    if (mcParent == null) {
                        this.root = mParent;
                    } else {
                        this.insertNodeInto(mParent, mcParent, mCommonIndex);
                    }
                }
                node = parent;
            }
            node = rightStart;
            while (node != rightChild) {
                int count;
                parent = node.getParent();
                index = parent.getIndex(node);
                if (index < (count = parent.getChildCount()) - 1 && parent instanceof LogicalConditionNodeInterface && !((LogicalConditionNodeInterface)parent).isExplicitlyCreated()) {
                    MutableTreeNode newRightChild;
                    LogicalConditionNodeInterface lcn = (LogicalConditionNodeInterface)parent;
                    if (lcn.getLogicalCondition() != ConditionalRelationType.AND) {
                        throw new AssertionError(lcn.getLogicalCondition());
                    }
                    tempNode = lcn.getParent();
                    if (tempNode == null) {
                        throw new AssertionError(tempNode);
                    }
                    if (!(tempNode instanceof LogicalConditionNodeInterface)) {
                        throw new AssertionError(tempNode);
                    }
                    if (tempNode != common) {
                        throw new AssertionError(tempNode);
                    }
                    if (commonLCN.getLogicalCondition() != ConditionalRelationType.OR) {
                        throw new AssertionError(commonLCN.getLogicalCondition());
                    }
                    mCommon = this.getMutableTreeNode(common);
                    mParent = this.getMutableTreeNode(parent);
                    mChild = this.getMutableTreeNode(node);
                    mcParent = this.getMutableTreeNode(mCommon.getParent());
                    int n = mCommonIndex = mcParent == null ? -1 : mcParent.getIndex(mCommon);
                    if (index == 0) {
                        newRightChild = mChild;
                    } else {
                        newRightChild = this.getMutableTreeNode(DefaultFilterLogicTree.newLogicalConditionNode(lcn.getLogicalCondition(), false));
                        for (int i = index; i >= 0; --i) {
                            newChild = this.getMutableTreeNode(parent.getChildAt(i));
                            this.insertNodeInto(newChild, newRightChild, 0);
                        }
                    }
                    this.removeNodeFromParent(mParent);
                    this.insertNodeInto(newRightChild, mCommon, mCommon.getChildCount());
                    if (mcParent == null) {
                        this.root = mParent;
                        this.insertNodeInto(mCommon, mParent, 0);
                        if (isInnerGroup && mParent instanceof LogicalConditionNode) {
                            ((LogicalConditionNode)mParent).setExplicitlyCreated(explicitlyCreated);
                        }
                    } else if (mcParent instanceof LogicalConditionNodeInterface && ((LogicalConditionNodeInterface)((Object)mcParent)).getLogicalCondition() == lcn.getLogicalCondition()) {
                        while (mParent.getChildCount() > 0) {
                            TreeNode c = mParent.getChildAt(0);
                            this.insertNodeInto(this.getMutableTreeNode(c), mcParent, mcParent.getChildCount());
                        }
                        mParent = null;
                        if (isInnerGroup && mcParent instanceof LogicalConditionNode) {
                            ((LogicalConditionNode)mcParent).setExplicitlyCreated(explicitlyCreated);
                        }
                    } else {
                        this.insertNodeInto(mParent, mcParent, mCommonIndex);
                        this.insertNodeInto(mCommon, mParent, 0);
                    }
                }
                node = parent;
            }
        }
        return changed;
    }

    private TreeNode findStartingNodeOnPath(TreeNode start, TreeNode stop) {
        TreeNode node = start;
        while (node != stop) {
            TreeNode parent = node.getParent();
            if (parent instanceof LogicalConditionNodeInterface && ((LogicalConditionNodeInterface)parent).isExplicitlyCreated()) {
                start = parent;
            } else if (parent instanceof NotNodeInterface) {
                start = parent;
            }
            node = parent;
        }
        return start;
    }

    @Override
    public boolean canGroup(TreeNode first, TreeNode last) {
        TreeNode[] nodes;
        if (first != last && (nodes = this.getCommonParentPlus(first, last)) != null && nodes.length == 3) {
            TreeNode common = nodes[0];
            TreeNode leftChild = nodes[1];
            TreeNode rightChild = nodes[2];
            int lIndex = common.getIndex(leftChild);
            int rIndex = common.getIndex(rightChild);
            if (lIndex > 0 || rIndex < common.getChildCount()) {
                return true;
            }
        }
        return false;
    }

    private TreeNode getCommonParent(TreeNode first, TreeNode last) {
        TreeNode common = null;
        if (null != first && null != last) {
            ArrayList<TreeNode> parents = new ArrayList<TreeNode>();
            while (first != null) {
                parents.add(first);
                first = first.getParent();
            }
            while (last != null) {
                if (Util.containsInstance(parents, last)) {
                    common = last;
                    break;
                }
                last = last.getParent();
            }
        }
        return common;
    }

    private TreeNode[] getCommonParentPlus(TreeNode first, TreeNode last) {
        TreeNode[] nodes = null;
        if (null != first && null != last) {
            TreeNode walk;
            ArrayList<TreeNode> parents = new ArrayList<TreeNode>();
            for (walk = first; walk != null; walk = walk.getParent()) {
                parents.add(walk);
            }
            walk = last;
            while (last != null) {
                int index = Util.indexOfInstance(parents, last);
                if (index >= 0) {
                    nodes = new TreeNode[]{last, index > 0 ? (TreeNode)parents.get(index - 1) : first, walk};
                    break;
                }
                walk = last;
                last = last.getParent();
            }
        }
        return nodes;
    }

    protected boolean applyAnd(TreeNode node, TreeNode sibling) {
        TreeNode[] nodes;
        if (node != null && sibling != null && (nodes = this.getCommonParentPlus(node, sibling)) != null && nodes.length == 3) {
            TreeNode common = nodes[0];
            TreeNode leftChild = nodes[1];
            TreeNode rightChild = nodes[2];
            if (null == common || !(common instanceof LogicalConditionNodeInterface)) {
                return false;
            }
            LogicalConditionNodeInterface lcn_common = (LogicalConditionNodeInterface)common;
            int lIndex = common.getIndex(leftChild);
            int rIndex = common.getIndex(rightChild);
            ConditionalRelationType oldType = lcn_common.getLogicalCondition();
            boolean consolidate = false;
            if (lIndex == 0 && rIndex == common.getChildCount() - 1) {
                lcn_common.setLogicalCondition(ConditionalRelationType.AND);
                consolidate = true;
            } else {
                MutableTreeNode mLeftChild;
                LogicalConditionNodeInterface lcnLeft = (LogicalConditionNodeInterface)(leftChild instanceof LogicalConditionNodeInterface ? leftChild : null);
                LogicalConditionNodeInterface lcnRight = (LogicalConditionNodeInterface)(rightChild instanceof LogicalConditionNodeInterface ? rightChild : null);
                if (lcnLeft != null && lcnRight != null && !lcnLeft.isExplicitlyCreated() && lcnLeft.getLogicalCondition() == ConditionalRelationType.AND && !lcnRight.isExplicitlyCreated() && lcnRight.getLogicalCondition() == ConditionalRelationType.AND) {
                    mLeftChild = this.getMutableTreeNode(leftChild);
                    this.removeNodeFromParent(this.getMutableTreeNode(rightChild));
                    int size = rightChild.getChildCount();
                    for (int i = 0; i < size; ++i) {
                        MutableTreeNode child = this.getMutableTreeNode(rightChild.getChildAt(0));
                        this.insertNodeInto(child, mLeftChild, mLeftChild.getChildCount());
                    }
                    rightChild = null;
                } else if (lcnLeft != null && lcnRight == null && !lcnLeft.isExplicitlyCreated() && lcnLeft.getLogicalCondition() == ConditionalRelationType.AND) {
                    mLeftChild = this.getMutableTreeNode(leftChild);
                    MutableTreeNode mRightChild = this.getMutableTreeNode(rightChild);
                    this.removeNodeFromParent(mRightChild);
                    this.insertNodeInto(mRightChild, mLeftChild, mLeftChild.getChildCount());
                } else if (lcnRight != null && lcnLeft == null && !lcnRight.isExplicitlyCreated() && lcnRight.getLogicalCondition() == ConditionalRelationType.AND) {
                    mLeftChild = this.getMutableTreeNode(leftChild);
                    MutableTreeNode mRightChild = this.getMutableTreeNode(rightChild);
                    this.removeNodeFromParent(mLeftChild);
                    this.insertNodeInto(mLeftChild, mRightChild, 0);
                } else {
                    LogicalConditionNodeInterface groupRoot = DefaultFilterLogicTree.newLogicalConditionNode(ConditionalRelationType.AND, false);
                    MutableTreeNode mut_group = this.getMutableTreeNode(groupRoot);
                    this.insertNodeInto(this.getMutableTreeNode(leftChild), mut_group, 0);
                    this.insertNodeInto(this.getMutableTreeNode(rightChild), mut_group, 1);
                    this.insertNodeInto(mut_group, this.getMutableTreeNode(common), lIndex);
                }
            }
            if (consolidate && oldType == ConditionalRelationType.OR) {
                for (int i = common.getChildCount() - 1; i >= 0; --i) {
                    LogicalConditionNodeInterface lcnChild;
                    TreeNode child = common.getChildAt(i);
                    if (!(child instanceof LogicalConditionNodeInterface) || (lcnChild = (LogicalConditionNodeInterface)child).isExplicitlyCreated() || lcnChild.getLogicalCondition() != ConditionalRelationType.AND) continue;
                    MutableTreeNode mCommon = this.getMutableTreeNode(common);
                    this.removeNodeFromParent(this.getMutableTreeNode(lcnChild));
                    for (int j = lcnChild.getChildCount() - 1; j >= 0; --j) {
                        MutableTreeNode childToMove = this.getMutableTreeNode(lcnChild.getChildAt(j));
                        this.insertNodeInto(childToMove, mCommon, i);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean applyOr(TreeNode node, TreeNode sibling) {
        TreeNode[] nodes;
        if (node != null && sibling != null && (nodes = this.getCommonParentPlus(node, sibling)) != null && nodes.length == 3) {
            TreeNode parent;
            LogicalConditionNodeInterface lcn_parent;
            int count;
            int rIndex;
            TreeNode common = nodes[0];
            TreeNode leftChild = nodes[1];
            TreeNode rightChild = nodes[2];
            if (null == common || !(common instanceof LogicalConditionNodeInterface)) {
                return false;
            }
            LogicalConditionNodeInterface lcn_common = (LogicalConditionNodeInterface)common;
            int lIndex = Util.getIndexOfChildInstance(common, leftChild);
            if (lIndex > 0) {
                LogicalConditionNode newGroup = new LogicalConditionNode(ConditionalRelationType.AND, false);
                for (int i = lIndex; i >= 0; --i) {
                    this.insertNodeInto(this.getMutableTreeNode(common.getChildAt(i)), newGroup, 0);
                }
                this.insertNodeInto(newGroup, this.getMutableTreeNode(common), 0);
                leftChild = newGroup;
            }
            if ((rIndex = Util.getIndexOfChildInstance(common, rightChild)) < (count = common.getChildCount()) - 1) {
                LogicalConditionNode newGroup = new LogicalConditionNode(ConditionalRelationType.AND, false);
                for (int i = count; i > rIndex; --i) {
                    this.insertNodeInto(this.getMutableTreeNode(common.getChildAt(i - 1)), newGroup, 0);
                }
                this.insertNodeInto(newGroup, this.getMutableTreeNode(common), rIndex);
                rightChild = newGroup;
            }
            LogicalConditionNodeInterface logicalConditionNodeInterface = lcn_parent = (parent = common.getParent()) instanceof LogicalConditionNodeInterface ? (LogicalConditionNodeInterface)parent : null;
            if (!lcn_common.isExplicitlyCreated() && lcn_parent != null && lcn_parent.getLogicalCondition() == ConditionalRelationType.OR) {
                int index = Util.getIndexOfChildInstance(parent, common);
                this.removeNodeFromParent(this.getMutableTreeNode(common));
                MutableTreeNode mut_parent = this.getMutableTreeNode(parent);
                for (int i = common.getChildCount(); i > 0; --i) {
                    MutableTreeNode child = this.getMutableTreeNode(common.getChildAt(i - 1));
                    this.insertNodeInto(child, mut_parent, index);
                }
                this.destroy(common);
            } else {
                lcn_common.setLogicalCondition(ConditionalRelationType.OR);
            }
            return true;
        }
        return false;
    }

    public void printTree() {
        TreeUtil.printTree((FilterLogicBaseNodeInterface)this.root);
    }

    protected void replaceNode(TreeNode oldNode, TreeNode node) {
        TreeNode parent = oldNode.getParent();
        if (parent == null) {
            this.setRoot(node);
            this.destroy(oldNode);
        } else {
            int i = parent.getIndex(oldNode);
            this.removeNodeFromParent(this.getMutableTreeNode(oldNode));
            this.insertNodeInto(this.getMutableTreeNode(node), this.getMutableTreeNode(parent), i);
        }
    }

    protected FilterLogicBaseNodeInterface removeNode(FilterLogicBaseNodeInterface node) {
        if (node != null) {
            LogicalConditionNodeInterface lcnParent;
            TreeNode groupRoot = this.getOuterMostGroupRoot(node);
            if (!(groupRoot instanceof FilterLogicBaseNodeInterface)) {
                return null;
            }
            node = (FilterLogicBaseNodeInterface)groupRoot;
            FilterLogicBaseNodeInterface parent = this.removeNodeFromTree(node);
            if (parent instanceof NotNodeInterface) {
                parent = this.removeNodeFromTree(parent);
            }
            if (parent instanceof LogicalConditionNodeInterface && (lcnParent = (LogicalConditionNodeInterface)parent).isExplicitlyCreated()) {
                parent = this.removeNodeFromTree(parent);
            }
            while (parent != null) {
                if (parent instanceof NotNodeInterface) {
                    if (parent.getChildCount() != 0) continue;
                    node = parent;
                    parent = this.removeNodeFromTree(node);
                    continue;
                }
                if (parent instanceof LogicalConditionNode) {
                    int count = parent.getChildCount();
                    if (count >= 2) break;
                    node = parent;
                    if (count > 0) {
                        FilterLogicBaseNodeInterface child = node.getChildLogicNodeAt(0);
                        parent = node.getParentLogicNode();
                        MutableTreeNode mut_child = this.getMutableTreeNode(child);
                        this.removeNodeFromParent(mut_child);
                        if (null == parent) {
                            this.removeNodeFromTree(node);
                            this.setRoot(child);
                            continue;
                        }
                        int i = parent.getIndex(node);
                        this.removeNodeFromParent(this.getMutableTreeNode(node));
                        this.insertNodeInto(mut_child, this.getMutableTreeNode(parent), i);
                        this.destroy(node);
                        continue;
                    }
                    parent = this.removeNodeFromTree(node);
                    continue;
                }
                parent = parent.getParentLogicNode();
            }
        }
        return node;
    }

    private FilterLogicBaseNodeInterface removeNodeFromTree(FilterLogicBaseNodeInterface node) {
        FilterLogicBaseNodeInterface parent = node.getParentLogicNode();
        if (parent != null) {
            this.removeNodeFromParent(this.getMutableTreeNode(node));
        } else {
            this.setRoot(null);
        }
        this.destroy(node);
        return parent;
    }

    public ConditionalRelationType getConditionalRelationType(TreeNode node, TreeNode sibling) {
        TreeNode common;
        ConditionalRelationType type = null;
        if (node != null && sibling != null && null != (common = this.getCommonParent(node, sibling)) && common instanceof LogicalConditionNodeInterface) {
            LogicalConditionNodeInterface lcn_common = (LogicalConditionNodeInterface)common;
            type = lcn_common.getLogicalCondition();
        }
        return type;
    }

    @Override
    public FilterLogicTreeInterface copy() {
        AbstractFilterLogicBaseNode newRoot;
        DefaultFilterLogicTree copy = new DefaultFilterLogicTree();
        AbstractFilterLogicBaseNode myRoot = (AbstractFilterLogicBaseNode)this.getRoot();
        if (myRoot == null) {
            newRoot = null;
        } else {
            newRoot = (AbstractFilterLogicBaseNode)myRoot.clone();
            this.copyChildren(newRoot);
        }
        copy.setRoot(newRoot);
        return copy;
    }

    protected void copyChildren(AbstractFilterLogicBaseNode parent) {
        if (parent != null) {
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                AbstractFilterLogicBaseNode child = (AbstractFilterLogicBaseNode)parent.getChildLogicNodeAt(i);
                if (child == null) continue;
                AbstractFilterLogicBaseNode copy = (AbstractFilterLogicBaseNode)child.clone();
                parent.add(copy);
                this.copyChildren(copy);
            }
        }
    }

    private boolean markGroupsUsingBooleanLogic(TreeNode treeRoot) {
        return this.markGroupsUsingBooleanLogic(treeRoot, false);
    }

    private boolean markGroupsUsingBooleanLogic(TreeNode treeRoot, boolean compoundFilterFlag) {
        boolean changed = false;
        if (treeRoot != null) {
            Stack<TreeNode> kids = new Stack<TreeNode>();
            kids.push(treeRoot);
            while (!kids.isEmpty()) {
                TreeNode node = (TreeNode)kids.pop();
                if (node instanceof LogicalConditionNode) {
                    boolean target;
                    LogicalConditionNode lcn = (LogicalConditionNode)node;
                    TreeNode parent = node.getParent();
                    if (parent == null) {
                        target = lcn.isExplicitlyCreated();
                    } else if (parent instanceof NotNodeInterface) {
                        target = true;
                    } else if (parent instanceof LogicalConditionNodeInterface) {
                        LogicalConditionNodeInterface lcnParent = (LogicalConditionNodeInterface)parent;
                        ConditionalRelationType lcnType = lcn.getLogicalCondition();
                        if (lcnType == lcnParent.getLogicalCondition()) {
                            int count = lcnParent.getChildCount();
                            target = !compoundFilterFlag || count <= 1 || lcnParent.getChildAt(count - 1) != lcn;
                        } else {
                            target = ConditionalRelationType.OR == lcnType && ConditionalRelationType.AND == lcnParent.getLogicalCondition();
                        }
                    } else {
                        target = false;
                    }
                    if (lcn.isExplicitlyCreated() != target) {
                        lcn.setExplicitlyCreated(target);
                        changed = true;
                    }
                }
                int size = node.getChildCount();
                for (int i = 0; i < size; ++i) {
                    kids.push(node.getChildAt(i));
                }
            }
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        s.writeObject(new Boolean(this.modifiable));
        if (this.root != null && this.root instanceof Serializable) {
            values.addElement("root");
            values.addElement(this.root);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Boolean isModifiable = (Boolean)s.readObject();
        this.modifiable = isModifiable;
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("root")) {
            this.root = (TreeNode)values.elementAt(++indexCounter);
            ++indexCounter;
        }
    }

    public void setQueryStandardization(boolean value) {
        if (this.markGroups != value) {
            this.markGroups = value;
        }
    }

    public boolean getQueryStandardization() {
        return this.markGroups;
    }
}

