/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.FilterableItemInterface;
import com.sas.dataselectors.filters.FilterableListModelInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

@SASScope(value="ALL")
public abstract class AbstractFilterableListModel
implements FilterableListModelInterface {
    protected Locale _locale;
    protected Object _dataSource = null;
    protected Object _initialFilter = null;
    protected boolean _initialized = false;
    protected List _filterableItems = null;
    protected int environment = 0;

    public AbstractFilterableListModel() {
    }

    public AbstractFilterableListModel(Object dataSource) {
        this();
        this.setModel(dataSource);
    }

    public AbstractFilterableListModel(Object dataSource, Object initialFilter) {
        this(dataSource);
        this.setInitialFilter(initialFilter);
    }

    public AbstractFilterableListModel(Object dataSource, int environment) {
        this();
        this.setEnvironment(environment);
        this.setModel(dataSource);
    }

    public void setInitialFilter(Object initialFilter) {
        this._initialFilter = initialFilter;
    }

    @Override
    public Object getInitialFilter() {
        return this._initialFilter;
    }

    @Override
    public Object getModel() {
        return this._dataSource;
    }

    public void setModel(Object model) {
        if (model != this._dataSource) {
            this._dataSource = model;
            this._initialized = false;
        }
    }

    @Override
    public List getFilterableItems() {
        if (!this._initialized) {
            this.createFilterableItemList();
        }
        return this._filterableItems;
    }

    @Override
    public FilterableItemInterface getFilterableItem(Object filterable) {
        FilterableItemInterface item = null;
        List filterables = this.getFilterableItems();
        if (filterables != null) {
            for (FilterableItemInterface filterableItem : filterables) {
                if (filterableItem.getFilterableItem() != filterable) continue;
                item = filterableItem;
                break;
            }
        }
        return item;
    }

    protected void createFilterableItemList() {
        if (this._dataSource != null) {
            this._filterableItems = new ArrayList();
            List filterables = this.getFilterableObjects();
            if (filterables != null) {
                Iterator i = filterables.iterator();
                while (i.hasNext()) {
                    FilterableItemInterface item = this.createFilterableItem(i.next());
                    this._filterableItems.add(item);
                }
            }
        }
        this._initialized = true;
    }

    protected abstract List getFilterableObjects();

    protected abstract FilterableItemInterface createFilterableItem(Object var1);

    @Override
    public boolean commitChanges() {
        List filterables = this.getFilterableItems();
        boolean commitOk = false;
        if (filterables != null && filterables.size() > 0) {
            boolean allCommit = true;
            for (FilterableItemInterface item : filterables) {
                if (item.getFilterModel().commitChanges()) continue;
                allCommit = false;
            }
            commitOk = allCommit;
        }
        return commitOk;
    }

    @Override
    public void cancel() {
        List filterables = this.getFilterableItems();
        if (filterables != null && filterables.size() > 0) {
            for (FilterableItemInterface item : filterables) {
                item.getFilterModel().cancel();
            }
        }
    }

    @Override
    public void clearAll() {
        List filterables = this.getFilterableItems();
        if (filterables != null) {
            for (FilterableItemInterface filterableItem : filterables) {
                filterableItem.clearFilter();
            }
        }
    }

    @Override
    public void clearFilter(int index) {
        List filterables = this.getFilterableItems();
        if (filterables != null) {
            FilterableItemInterface filterableItem = (FilterableItemInterface)filterables.get(index);
            filterableItem.clearFilter();
        }
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale != this._locale) {
            this._locale = locale;
            List filterables = this.getFilterableItems();
            if (filterables != null) {
                for (FilterableItemInterface filterableItem : filterables) {
                    filterableItem.getFilterModel().setLocale(locale);
                }
            }
        }
    }

    public void setEnvironment(int environment) {
        this.environment = environment;
    }

    public int getEnvironment() {
        return this.environment;
    }
}

