/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.relational;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.BaseCommand;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import javax.swing.table.TableModel;

public class ClearSortCommand
extends BaseCommand
implements CommandSupportedInterface,
CommandStatusInterface {
    public static final String RB_KEY = "ClearSortCommand.";
    private SortableInterface model;

    public ClearSortCommand() {
    }

    public ClearSortCommand(String name) {
        super(name);
    }

    public void setModel(SortableInterface model) {
        this.model = model;
    }

    public SortableInterface getModel() {
        return this.model;
    }

    @Override
    public void execute(Object o) {
        SortableInterface model = this.getModel();
        if (model != null && model instanceof TableModel) {
            try {
                model.sort(new String[0], new int[0]);
            }
            catch (SortException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object model = actionFilter.getAttribute("model");
        return model != null && model instanceof SortableInterface && ((SortableInterface)model).isSortAllowed();
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        Object model = filter.getAttribute("model");
        if (model != null && model instanceof SortableInterface && ((SortableInterface)model).isSortAllowed()) {
            String[] sortedColumns = ((SortableInterface)model).getSortedColumns();
            if (sortedColumns != null && sortedColumns.length > 0) {
                return 0;
            }
            return 8;
        }
        return 2;
    }
}

