/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.codepolicy.SASScope;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.PendingCommandInterface;
import com.sas.commands.dataselectors.DataSelectorCommandInterface;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.SelectorCloseInterface;
import java.io.IOException;
import java.util.HashMap;

@SASScope(value="ALL")
public class BaseSelectorCommand
extends BaseCommand
implements DataSelectorCommandInterface,
PendingCommandInterface,
ContentsChangedInterface {
    protected Object model;
    protected Object selectorModel;
    protected HashMap eventInfo = new HashMap(2);
    protected boolean contentsChanged = false;
    protected Object eventSource = null;
    protected boolean complete = false;
    protected boolean modal = true;
    public static final String SHOW_MODE = "SHOW";
    public static final String PROCESS_MODE = "PROCESS";
    public static final String CANCEL_MODE = "CANCEL";
    public static final String COMMIT_MODE = "COMMIT";
    protected DataSelectorInterface selector;
    protected String mode;
    protected String actionClass;

    public BaseSelectorCommand() {
    }

    public BaseSelectorCommand(String name) {
        super(name);
    }

    public BaseSelectorCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    @Override
    public void execute(Object o) {
        this.contentsChanged = false;
        if (SHOW_MODE.equalsIgnoreCase(this.mode)) {
            this.show(o);
        } else if (PROCESS_MODE.equalsIgnoreCase(this.mode)) {
            this.process(o);
        } else if (COMMIT_MODE.equalsIgnoreCase(this.mode)) {
            try {
                this.commit(o);
            }
            catch (IOException iOException) {}
        } else if (CANCEL_MODE.equalsIgnoreCase(this.mode)) {
            this.cancel(o);
        }
    }

    protected void show(Object o) {
        if (this.selector != null) {
            this.selector.setVisible(true);
        }
        this.setComplete(false);
    }

    protected void process(Object o) {
    }

    public void cancel(Object o) {
        if (this.selector != null) {
            this.selector.setVisible(false);
        }
        this.setComplete(true);
    }

    @Override
    public void cancel() {
        this.cancel(null);
    }

    protected void commit(Object o) throws IOException {
        if (this.selector != null) {
            this.selector.setVisible(false);
        }
        this.setComplete(true);
    }

    @Override
    public void setModel(Object model) {
        this.model = model;
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    public void setSelectorModel(Object value) {
        this.selectorModel = value;
    }

    public Object getSelectorModel() {
        return this.selectorModel;
    }

    @Override
    public void setSelector(DataSelectorInterface value) {
        this.selector = value;
    }

    @Override
    public DataSelectorInterface getSelector() {
        return this.selector;
    }

    public void setMode(String value) {
        this.mode = value;
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    @Override
    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    @Override
    public Object getEventSource() {
        return this.eventSource;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    protected void closeSelector() {
        DataSelectorInterface selector = this.getSelector();
        if (selector != null && selector instanceof SelectorCloseInterface) {
            ((SelectorCloseInterface)((Object)selector)).close();
        }
    }
}

