/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands;

import com.sas.actionprovider.BaseUtil;
import com.sas.codepolicy.SASScope;
import com.sas.commands.CompositeDynamicAttributeCommandInterface;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.RB;
import com.sas.entities.AttributeSetException;
import com.sas.entities.BaseEntity;
import com.sas.util.ApplyInterface;
import com.sas.util.Util;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.TransformException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

@SASScope(value="ALL")
public class CompositeDynamicAttributeCommand
extends BaseEntity
implements DynamicAttributeCommandInterface,
ApplyInterface,
CompositeDynamicAttributeCommandInterface {
    private static String commandPrefix = "COMMAND";
    static final String RB_KEY = "CompositeDynamicAttributeCommand.";
    private String name;
    private Locale locale;
    @SASScope
    public List commands;
    private Map commandAttributeMappings;
    @SASScope
    public List executedCommands;
    @SASScope
    public Collection appliedCommands;
    private List compositeAttrNames;
    private static BaseTransforms stringTransform;
    private boolean debug;

    public CompositeDynamicAttributeCommand() {
        this(CompositeDynamicAttributeCommand.getNextCommandName());
    }

    public CompositeDynamicAttributeCommand(String name) {
        this.setName(name);
        this.commands = new Vector(2);
        this.commandAttributeMappings = new HashMap(2);
        this.executedCommands = new Vector(6);
        this.appliedCommands = new Vector(6);
        this.compositeAttrNames = new Vector(6);
        this.debug = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public static synchronized String getNextCommandName() {
        return Util.getName((String)commandPrefix);
    }

    public void add(DynamicAttributeCommandInterface command, Map dynamicAttributeNames) {
        if (command == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullCommand.txt"));
        }
        if (dynamicAttributeNames != null) {
            Set keySet = dynamicAttributeNames.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                if (!this.compositeAttrNames.contains(iterator.next())) continue;
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "attrNameRegistered.txt"));
            }
            this.compositeAttrNames.addAll(keySet);
            this.commands.add(command);
            this.commandAttributeMappings.put(new Integer(command.hashCode()), dynamicAttributeNames);
        }
    }

    public void remove(DynamicAttributeCommandInterface command) {
        if (command == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullCommand.txt"));
        }
        this.commands.remove(command);
        this.commandAttributeMappings.remove(new Integer(command.hashCode()));
    }

    public Object clone() throws CloneNotSupportedException {
        CompositeDynamicAttributeCommand command = new CompositeDynamicAttributeCommand(this.getName());
        command.setLocale(this.getLocale());
        if (this.commands == null) {
            return command;
        }
        int size = this.commands.size();
        for (int i = 0; i < size; ++i) {
            DynamicAttributeCommandInterface subCommand = (DynamicAttributeCommandInterface)this.commands.get(i);
            DynamicAttributeCommandInterface clonedSubCommand = (DynamicAttributeCommandInterface)subCommand.clone();
            command.add(clonedSubCommand, (Map)this.commandAttributeMappings.get(new Integer(subCommand.hashCode())));
        }
        return command;
    }

    public boolean isExecutable() {
        if (this.commands == null) {
            return false;
        }
        int size = this.commands.size();
        for (int i = 0; i < size; ++i) {
            DynamicAttributeCommandInterface command = (DynamicAttributeCommandInterface)this.commands.get(i);
            this.applyCommandAttributes(command);
            if (!command.isExecutable()) continue;
            return true;
        }
        return false;
    }

    public void execute(Object obj) {
        this.executedCommands.clear();
        int size = this.commands.size();
        for (int i = 0; i < size; ++i) {
            DynamicAttributeCommandInterface command = (DynamicAttributeCommandInterface)this.commands.get(i);
            if (!this.appliedCommands.contains(new Integer(command.hashCode()))) {
                this.applyCommandAttributes(command);
            }
            if (!command.isExecutable()) continue;
            command.execute(obj);
            this.executedCommands.add(0, command);
        }
    }

    public int apply(Object obj) {
        int rc = 0;
        this.executedCommands.clear();
        int size = this.commands.size();
        for (int i = 0; i < size && rc == 0; ++i) {
            DynamicAttributeCommandInterface command = (DynamicAttributeCommandInterface)this.commands.get(i);
            if (!this.appliedCommands.contains(new Integer(command.hashCode()))) {
                this.applyCommandAttributes(command);
            }
            if (!command.isExecutable()) continue;
            if (command instanceof ApplyInterface) {
                rc = ((ApplyInterface)command).apply(obj);
                continue;
            }
            command.execute(obj);
            this.executedCommands.add(0, command);
        }
        return rc;
    }

    public boolean isUndoable() {
        int size = this.executedCommands.size();
        for (int i = 0; i < size; ++i) {
            if (((DynamicAttributeCommandInterface)this.executedCommands.get(i)).isUndoable()) continue;
            return false;
        }
        return true;
    }

    public void undo() {
        int size = this.executedCommands.size();
        for (int i = 0; i < size; ++i) {
            ((DynamicAttributeCommandInterface)this.executedCommands.get(i)).undo();
        }
    }

    public String getText() {
        return "";
    }

    public void setText(String text) {
    }

    @Override
    public void setCommonAttribute(String attributeName, Object attributeValue) {
        CompositeDynamicAttributeCommand.setCommonAttribute(this.commands, attributeName, attributeValue);
    }

    public static void setCommonAttribute(Collection commands, String attributeName, Object attributeValue) {
        if (commands != null) {
            int size = commands.size();
            Object curCommand2 = null;
            DynamicAttributeCommandInterface subCommand = null;
            for (Object curCommand2 : commands) {
                if (!(curCommand2 instanceof DynamicAttributeCommandInterface)) continue;
                subCommand = curCommand2;
                try {
                    subCommand.setAttribute(attributeName, attributeValue);
                }
                catch (AttributeSetException attributeSetException) {}
            }
        }
    }

    protected void applyCommandAttributes(DynamicAttributeCommandInterface command) {
        Map compositeAttributeNamesMap = (Map)this.commandAttributeMappings.get(new Integer(command.hashCode()));
        if (compositeAttributeNamesMap != null) {
            PropertyDescriptor[] commandDescriptors = this.getCommandDescriptors(command);
            for (String compositeAttrName : compositeAttributeNamesMap.keySet()) {
                String commandAttrName = (String)compositeAttributeNamesMap.get(compositeAttrName);
                Object attributeValue = this.transformIfNeeded(this.getAttribute(compositeAttrName), commandAttrName, commandDescriptors);
                try {
                    command.setAttribute(commandAttrName, attributeValue);
                }
                catch (AttributeSetException attributeSetException) {}
            }
        }
        this.appliedCommands.add(new Integer(command.hashCode()));
    }

    @Override
    public Collection getCommandAttributeNames() {
        return this.compositeAttrNames;
    }

    public List getCommands() {
        return this.commands;
    }

    private PropertyDescriptor[] getCommandDescriptors(DynamicAttributeCommandInterface command) {
        Class<?> commandClass = command.getClass();
        PropertyDescriptor[] pd = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(commandClass);
            if (beanInfo != null) {
                pd = beanInfo.getPropertyDescriptors();
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return pd;
    }

    private PropertyDescriptor getCommandAttributeDescriptor(PropertyDescriptor[] commandDescriptors, String commandAttributeName) {
        int length = commandDescriptors.length;
        for (int i = 0; i < length; ++i) {
            String attrName = commandDescriptors[i].getName();
            if (attrName == null || !attrName.equals(commandAttributeName)) continue;
            return commandDescriptors[i];
        }
        return null;
    }

    private Object transformIfNeeded(Object attributeValue, String commandAttributeName, PropertyDescriptor[] commandDescriptors) {
        Class<?> attributeTypeClass;
        PropertyDescriptor commandDescriptor;
        if (attributeValue != null && attributeValue instanceof String && commandDescriptors != null && (commandDescriptor = this.getCommandAttributeDescriptor(commandDescriptors, commandAttributeName)) != null && (attributeTypeClass = commandDescriptor.getPropertyType()) != null) {
            try {
                return this.getStringTransform().transform(attributeValue, attributeTypeClass);
            }
            catch (TransformException transformException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return attributeValue;
    }

    private BaseTransforms getStringTransform() {
        if (stringTransform == null) {
            stringTransform = BaseUtil.getStringToTransforms();
        }
        return stringTransform;
    }
}

