/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.tableview;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.support.BaseActionProviderSupport;
import com.sas.actionprovider.support.tableview.RelationalActionTypeKeysInterface;
import com.sas.actionprovider.support.tableview.TableViewAreaInterface;
import com.sas.swing.visuals.tableview.TableViewUtil;
import java.util.List;
import javax.swing.table.TableModel;

public abstract class BaseTableViewSupport
extends BaseActionProviderSupport
implements TableViewAreaInterface,
RelationalActionTypeKeysInterface {
    public static final String RB_KEY = "BaseTableViewSupport.";

    public BaseTableViewSupport(Class actionClass) {
        super(actionClass);
        this.registerDynamicValueInfo();
    }

    protected void registerDynamicValueInfo() {
        this.addDynamicValueInfo("TITLE_AREA", "model", null, null, null, false);
        this.addDynamicValueInfo("ROW_HEADER_AREA", "model", null, null, null, false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "model", null, null, null, false);
        this.addDynamicValueInfo("DATA_CELL_AREA", "model", null, null, null, false);
        this.addDynamicValueInfo("EDIT_COLUMN_AREA", "model", null, null, null, false);
        this.addDynamicValueInfo("EDIT_COLUMN_AREA", "model", null, null, null, false);
        this.addDynamicValueInfo("TITLE_AREA", "table", null, null, null, false);
        this.addDynamicValueInfo("ROW_HEADER_AREA", "table", null, null, null, false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "table", null, null, null, false);
        this.addDynamicValueInfo("DATA_CELL_AREA", "table", null, null, null, false);
        this.addDynamicValueInfo("EDIT_COLUMN_AREA", "table", null, null, null, false);
        this.addDynamicValueInfo("EDIT_COLUMN_AREA", "table", null, null, null, false);
    }

    @Override
    public void initialize() {
        this.createDefaultActions();
    }

    protected void createDefaultActions() {
        this.addAreaType("TITLE_AREA");
        this.addAreaType("ROW_HEADER_AREA");
        this.addAreaType("COLUMN_HEADER_AREA");
        this.addAreaType("DATA_CELL_AREA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean validArea(Area area, ActionSupportFilter filter) {
        if (this.debug) {
            System.out.println("\nBaseTableViewSupport: validArea() ");
        }
        String type = null;
        if (area != null && (type = area.getType()) != null) {
            if (this.debug) {
                System.out.println("BaseTableViewSupport: validArea(): areaType=" + area.getType());
            }
            if (this.debug) {
                System.out.println("BaseTableViewSupport: validArea(): filter areaType=" + filter.getAreaType());
            }
            List values = null;
            int size = 0;
            if (!type.equals(filter.getAreaType())) {
                return false;
            }
            values = area.getValues();
            if (values == null || (size = values.size()) <= 0) {
                return true;
            }
            if (type == "COLUMN_HEADER_AREA" || type == "ROW_HEADER_AREA") {
                String columnName = (String)filter.getAttribute("columnName");
                if (columnName != null) {
                    List list = values;
                    synchronized (list) {
                        for (Object areaValue : values) {
                            if (areaValue == null || !((String)areaValue).equals(columnName)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            if (type == "DATA_CELL_AREA") {
                if (this.debug) {
                    System.out.println("BaseTableViewSupport: validArea(): DATA_CELL_AREA");
                }
                TableModel model = (TableModel)filter.getAttribute("model");
                Integer columnNumber = (Integer)filter.getAttribute("modelColumn");
                if (model != null && columnNumber != null) {
                    if (this.debug) {
                        System.out.println("BaseTableViewSupport: validArea(): got model and columnNumer=" + columnNumber);
                    }
                    String currentHeader = TableViewUtil.getColumnName(model, columnNumber);
                    if (this.debug) {
                        System.out.println("BaseTableViewSupport: validArea(): currentHeader=" + currentHeader);
                    }
                    if (currentHeader != null) {
                        List list = values;
                        synchronized (list) {
                            for (Object areaValue : values) {
                                if (areaValue == null || !((String)areaValue).equals(currentHeader)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return type == "TITLE_AREA";
        }
        return true;
    }

    protected BaseAction createAndRegisterAction(String areaType, String actionType) {
        BaseAction action = this.newActionInstance(areaType, actionType);
        this.addDefaultAction(action, areaType);
        return action;
    }

    @Override
    protected Object getCustomAttributeValue(String attributeName, ActionSupportFilter filter) {
        Object object = filter.getAttribute("model");
        if (object instanceof TableModel) {
            Object o;
            TableModel model = (TableModel)object;
            Integer row = (Integer)filter.getAttribute("modelRow");
            if (filter.getAreaType() == "COLUMN_HEADER_AREA" && row == null) {
                return attributeName;
            }
            int count = model.getColumnCount();
            int col = -1;
            for (int i = 0; i < count; ++i) {
                if (!attributeName.equalsIgnoreCase(model.getColumnName(i))) continue;
                col = i;
                break;
            }
            if (col >= 0 && (o = model.getValueAt(row, col)) != null) {
                return o.toString();
            }
        }
        return null;
    }
}

