/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies.relational;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.strategies.relational.BaseSelectorStrategy;
import com.sas.actionprovider.strategies.relational.RB;
import com.sas.actionprovider.util.relational.RelationalActionUtil;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.SelectorDialog;
import com.sas.swing.visuals.dataselectors.totals.TotalsSelector;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TotalsSelectorStrategy
extends BaseSelectorStrategy {
    static final String RB_KEY = "RelationalStrategy.";
    private static Map viewerToSelectorsMap = new HashMap(7, 1.0f);

    public TotalsSelectorStrategy() {
    }

    public TotalsSelectorStrategy(boolean swing, RelationalActionUtil util) {
        super(swing, util);
    }

    @Override
    protected void initializeActionAttributes(BaseAction action, String areaType, Locale locale) {
        super.initializeActionAttributes(action, areaType, locale);
        try {
            Class<?> commandClass = Class.forName("com.sas.commands.dataselectors.TotalsCommand");
            Constructor<?> ctor = commandClass.getConstructor(Boolean.TYPE);
            Object[] args = new Object[]{new Boolean(!this.isSwing())};
            action.setCommand((BaseSelectorCommand)ctor.newInstance(args));
            action.getCommand().setName(RB.getStringResource(RB_KEY, "totalsSelectorLabel.txt"));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void setLocaleDependentDefaultAttributes(BaseAction action, String areaType, Locale locale) {
        super.setLocaleDependentDefaultAttributes(action, areaType, locale);
        String label = RB.getStringResource(RB_KEY, "totalsSelectorLabel.txt");
        this.setLabelAndMnemonicOnAction(action, label);
    }

    @Override
    public void setActionAttributes(BaseAction action, ActionSupportFilter filter) {
        super.setActionAttributes(action, filter);
        ActionProviderViewInterface viewer = filter.getViewer();
        if (viewer == null) {
            return;
        }
        SelectorDialog selectorDialog = (SelectorDialog)viewerToSelectorsMap.get(viewer);
        if (selectorDialog == null) {
            TotalsSelector selectorPanel = new TotalsSelector();
            selectorDialog = new SelectorDialog((Frame)Util.getParentFrame((Component)((Object)viewer)), (PanelInterface)selectorPanel, true);
            selectorDialog.pack();
            viewerToSelectorsMap.put(viewer, selectorDialog);
        }
        ((BaseSwingSelectorPanel)selectorDialog.getPanel()).setCommand(action.getCommand());
        action.putValue("selector", selectorDialog);
    }
}

