/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeFactoryInterface;
import com.sas.entities.AttributeTypeInterface;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class AttributeTypeFactory
implements AttributeTypeFactoryInterface {
    private static Map sqlTypes;
    private static Map objectTypes;

    public AttributeTypeFactory() {
        this.initTypeMaps();
    }

    private synchronized void initTypeMaps() {
        if (sqlTypes == null) {
            sqlTypes = Collections.synchronizedMap(new HashMap(24));
        }
        if (objectTypes == null) {
            objectTypes = Collections.synchronizedMap(new HashMap(24));
        }
    }

    public AttributeTypeInterface createAttributeType(String name, int sqlType, String objectType) {
        if (objectType != null) {
            if (objectTypes.containsKey(objectType)) {
                return (AttributeTypeInterface)objectTypes.get(objectType);
            }
            AttributeType attributeType = new AttributeType(name, objectType);
            objectTypes.put(objectType, attributeType);
            return attributeType;
        }
        if (sqlTypes.containsKey(Integer.toString(sqlType))) {
            return (AttributeTypeInterface)sqlTypes.get(Integer.toString(sqlType));
        }
        AttributeType attributeType = new AttributeType(name, sqlType);
        sqlTypes.put(Integer.toString(sqlType), attributeType);
        return attributeType;
    }
}

