/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.login;

import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.util.connection.ConnectionFactoryBean;
import com.sas.util.connection.WorkspaceBean;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import com.sas.util.login.LoginBean;
import com.sas.util.login.LoginBeanValidateInterface;

public class LoginBeanCFBValidate
implements LoginBeanValidateInterface {
    protected LoginBean loginBean;
    protected ConnectionFactoryBean connectionFactoryBean;
    protected boolean debug;

    public LoginBeanCFBValidate() {
        this.init();
    }

    public LoginBeanCFBValidate(LoginBean loginBean, ConnectionFactoryBean connectionFactoryBean) {
        this.init();
        this.setLoginBean(loginBean);
        this.setConnectionFactoryBean(connectionFactoryBean);
    }

    protected void init() {
        this.debug = false;
    }

    public void setLoginBean(LoginBean bean) {
        this.loginBean = bean;
    }

    public LoginBean getLoginBean() {
        return this.loginBean;
    }

    public void setConnectionFactoryBean(ConnectionFactoryBean bean) {
        this.connectionFactoryBean = bean;
    }

    public ConnectionFactoryBean getConnectionFactoryBean() {
        return this.connectionFactoryBean;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    public boolean getDebug() {
        return this.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(String username, String password) {
        boolean valid = false;
        String orgUsername = this.connectionFactoryBean.getRequestUsername();
        String orgPassword = this.connectionFactoryBean.getRequestPassword();
        try {
            this.connectionFactoryBean.setRequestUsername(username);
            this.connectionFactoryBean.setRequestPassword(password);
            ConnectionInterface connection = this.connectionFactoryBean.requestConnection();
            WorkspaceBean workspaceBean = this.connectionFactoryBean.requestWorkspace(connection);
            connection.close();
            valid = true;
        }
        catch (ConnectionFactoryException e) {
            LoggerRepository2.getLogger((String)LoginBeanCFBValidate.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            if (this.loginBean != null) {
                String s = e.toString();
                if (s.startsWith("com.sas.services.connection.LoginException")) {
                    this.loginBean.setFailureType(2);
                } else if (s.startsWith("com.sas.services.connection.FatalConnectionFactoryException")) {
                    this.loginBean.setFailureType(4);
                } else {
                    this.loginBean.setFailureType(1);
                }
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)LoginBeanCFBValidate.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            this.loginBean.setFailureType(1);
        }
        finally {
            this.connectionFactoryBean.setRequestUsername(orgUsername);
            this.connectionFactoryBean.setRequestPassword(orgPassword);
        }
        return valid;
    }

    public static void main(String[] argv) {
        System.exit(0);
    }
}

