/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.connection;

import com.sas.codepolicy.SASScope;
import com.sas.util.connection.RB;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope
public class ConnectionFactoryBeanSelectDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static String RB_KEY = "ConnectionFactoryBeanSelectDialog.";
    protected Frame parentFrame;
    protected JPanel mainPanel;
    protected String instructions;
    protected JTextArea instructionsTextArea;
    protected JLabel beansLabel;
    protected JList beansList;
    protected JScrollPane beansListScrollPane;
    protected DefaultListModel beansListModel;
    protected JPanel dialogButtonsPanel;
    protected JButton dialogOKButton;
    protected int selection;

    public ConnectionFactoryBeanSelectDialog(Frame parent, String instructions) {
        super(parent);
        this.parentFrame = parent;
        this.instructions = instructions;
        this.setTitle(RB.getStringResource(RB_KEY, "DialogTitle.txt"));
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
        this.selection = -1;
    }

    protected void createComponents() {
        this.mainPanel = new JPanel();
        this.beansLabel = new JLabel(RB.getStringResource(RB_KEY, "BeansLabel.txt"));
        this.instructionsTextArea = new JTextArea(this.instructions, 3, 40);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setFont(this.beansLabel.getFont());
        this.instructionsTextArea.setBackground(this.beansLabel.getBackground());
        this.beansList = new JList();
        this.beansList.setSelectionMode(0);
        this.beansList.setPrototypeCellValue("ABCDEFGHIJKLMNOP");
        this.beansListScrollPane = new JScrollPane(this.beansList);
        this.beansListModel = new DefaultListModel();
        this.beansList.setModel(this.beansListModel);
        this.dialogButtonsPanel = new JPanel();
        this.dialogOKButton = new JButton(RB.getStringResource(RB_KEY, "OKButton.txt"));
        this.dialogOKButton.setEnabled(false);
    }

    protected void layoutComponents() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this.mainPanel.setLayout((LayoutManager)layout);
        this.mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.mainPanel);
        this.dialogButtonsPanel.setLayout(new FlowLayout(1));
        this.dialogButtonsPanel.add(this.dialogOKButton);
        this.mainPanel.add(this.instructionsTextArea);
        this.mainPanel.add(this.beansLabel);
        this.mainPanel.add(this.beansListScrollPane);
        this.mainPanel.add(this.dialogButtonsPanel);
    }

    protected void addListeners() {
        this.beansList.addListSelectionListener(this);
        this.dialogOKButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object eSource = evt.getSource();
        if (eSource == this.dialogOKButton) {
            this.dispose();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object eSource = e.getSource();
        if (eSource == this.beansList) {
            this.selection = this.beansList.getSelectedIndex();
            if (this.selection != -1) {
                this.dialogOKButton.setEnabled(true);
            }
        }
    }

    public void addString(String s) {
        this.beansListModel.addElement(s);
    }

    public int showDialog(boolean modal) {
        this.pack();
        this.setModal(modal);
        this.setResizable(false);
        this.setLocationRelativeTo(this.parentFrame);
        this.show();
        return this.selection;
    }
}

