/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.connection;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FailoverCluster;
import com.sas.services.connection.LoadBalancingCluster;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.Server;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.connection.RB;
import com.sas.util.connection.WorkspaceBean;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Logger;
import org.omg.CORBA.Object;

public class ConnectionFactoryBean {
    public static String RB_KEY = "ConnectionFactoryBean.";
    protected boolean designTime = Util.isDesignTime();
    public static int CONFIG_TYPE_MANUAL = 0;
    public static int CONFIG_TYPE_PLATFORM = 1;
    protected int configType = CONFIG_TYPE_MANUAL;
    protected LogicalServerInterface bipServer;
    protected String serverType = "440196d4-90f0-11d0-9f41-00a024bb830c";
    protected int waitTimeOnBusyFactory = -1;
    protected int initialWorkspaceCount = 0;
    protected String requestUsername;
    protected String requestPassword;
    protected BeanPuddle puddle = null;
    protected Vector puddles = new Vector();
    protected Vector workspaceBeans = new Vector();
    protected ConnectionFactoryConfiguration factoryConfig = null;
    protected ConnectionFactoryInterface factory = null;
    protected ConnectionFactoryAdminInterface factoryAdmin = null;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    public void setDesignTime(boolean value) {
        this.designTime = value;
    }

    public int getConfigType() {
        return this.configType;
    }

    public void setConfigType(int configType) {
        this.configType = configType;
    }

    public void setConfigDataBIP(LogicalServerInterface bipServer) {
        this.bipServer = bipServer;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public int getWaitTimeOnBusyFactory() {
        return this.waitTimeOnBusyFactory;
    }

    public void setWaitTimeOnBusyFactory(int waitTimeOnFullFactory) {
        this.waitTimeOnBusyFactory = waitTimeOnFullFactory;
    }

    public int getInitialWorkspaceCount() {
        return this.initialWorkspaceCount;
    }

    public void setInitialWorkspaceCount(int value) {
        this.initialWorkspaceCount = value;
    }

    public void setRequestUsername(String username) {
        this.requestUsername = username;
    }

    public String getRequestUsername() {
        return this.requestUsername;
    }

    public void setRequestPassword(String password) {
        this.requestPassword = this.DecodePassword(password);
    }

    public String getRequestPassword() {
        return this.EncodePassword(this.requestPassword);
    }

    public PasswordCredential[] getPuddleLogins() {
        PasswordCredential[] loginArray = null;
        int puddleSize = this.puddles.size();
        if (puddleSize > 0) {
            loginArray = new PasswordCredential[puddleSize];
            for (int i = 0; i < puddleSize; ++i) {
                BeanPuddle p = (BeanPuddle)this.puddles.elementAt(i);
                loginArray[i] = p.login;
            }
        }
        return loginArray;
    }

    public void addPuddleLogin(PasswordCredential login) {
        this.puddle = new BeanPuddle();
        this.puddle.login = login;
        this.puddles.add(this.puddle);
    }

    public void addPuddleLogin(String username, String password) {
        this.addPuddleLogin(new PasswordCredential(username, password));
    }

    public void clearPuddleLogins() {
        this.puddles.clear();
    }

    public Puddle[] getPuddles() {
        Puddle[] puddleArray = null;
        int puddleSize = this.puddles.size();
        if (puddleSize > 0) {
            puddleArray = new Puddle[puddleSize];
            int j = 0;
            for (int i = 0; i < puddleSize; ++i) {
                PasswordCredential pc;
                BeanPuddle p = (BeanPuddle)this.puddles.elementAt(i);
                int serverSize = p.servers.size();
                if (serverSize <= 0) continue;
                BridgeServer[] serverArray = new BridgeServer[serverSize];
                serverArray = p.servers.toArray(serverArray);
                HashSet<PasswordCredential> userSet = null;
                int userCount = p.users.size();
                if (userCount > 0) {
                    userSet = new HashSet<PasswordCredential>();
                    for (int s = 0; s < userCount; ++s) {
                        pc = (PasswordCredential)p.users.elementAt(s);
                        userSet.add(new PasswordCredential(pc.getUserName(), this.DecodePassword(pc.getPassword())));
                    }
                }
                FailoverCluster cluster = null;
                if (p.clusterType == 1) {
                    cluster = new FailoverCluster((Server[])serverArray);
                } else if (p.clusterType == 0) {
                    cluster = new LoadBalancingCluster((Server[])serverArray);
                }
                pc = new PasswordCredential(p.login.getUserName(), this.DecodePassword(p.login.getPassword()));
                Puddle puddle = new Puddle((Cluster)cluster, (Credential)pc);
                puddle.setMinSize(p.poolMinSize);
                puddle.setMinAvail(p.poolMinAvail);
                if (userSet != null) {
                    puddle.setUserCredentials(userSet);
                }
                puddleArray[j++] = puddle;
            }
        }
        return puddleArray;
    }

    public String getEncryptionPolicy(int puddle) {
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        return p.encryptionPolicy;
    }

    public String getEncryptionContent(int puddle) {
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        return p.encryptionContent;
    }

    public String getEncryptionAlgorithms(int puddle) {
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        return p.encryptionAlgorithms;
    }

    public void setEncryption(String policy, String content, String algorithms) {
        this.puddle.encryptionPolicy = policy;
        this.puddle.encryptionContent = content;
        this.puddle.encryptionAlgorithms = algorithms;
    }

    public void setEncryption(int puddle, String policy, String content, String algorithms) {
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        p.encryptionPolicy = policy;
        p.encryptionContent = content;
        p.encryptionAlgorithms = algorithms;
    }

    public int getClusterType(int puddle) {
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        return p.clusterType;
    }

    public void setClusterType(int type) {
        this.puddle.clusterType = type;
    }

    public void setClusterType(int puddleIx, int type) {
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddleIx);
        p.clusterType = type;
    }

    public Vector getServers(PasswordCredential login) {
        int puddleSize = this.puddles.size();
        for (int i = 0; i < puddleSize; ++i) {
            BeanPuddle p = (BeanPuddle)this.puddles.elementAt(i);
            if (p.login != login) continue;
            return p.servers;
        }
        return null;
    }

    public void addServer(String hostname, int port) {
        this.addServer(hostname, port, -1, 0, 1);
    }

    public void addServer(String hostname, int port, int maxClients, int reactivationLimit, int shutdownAfterMinutes) {
        this.addServer(hostname, port, maxClients, reactivationLimit, shutdownAfterMinutes, null);
    }

    public void addServer(String hostname, int port, int maxClients, int reactivationLimit, int shutdownAfterMinutes, String serverName) {
        if (this.puddle == null) {
            return;
        }
        BridgeServer server = new BridgeServer(this.serverType, hostname, port);
        server.setEncryptionPolicy(this.puddle.encryptionPolicy);
        server.setEncryptionContent(this.puddle.encryptionContent != null ? this.puddle.encryptionContent : "all");
        server.setEncryptionAlgorithms(this.puddle.encryptionAlgorithms);
        if (serverName != null) {
            server.setServerName(serverName);
        }
        if (maxClients != -1) {
            server.setMaxClients(maxClients);
        }
        server.setReactivationLimit(reactivationLimit);
        server.setShutdownAfterMinutes(shutdownAfterMinutes);
        this.puddle.servers.add(server);
    }

    public Vector getUsers(PasswordCredential login) {
        int puddleSize = this.puddles.size();
        for (int i = 0; i < puddleSize; ++i) {
            BeanPuddle p = (BeanPuddle)this.puddles.elementAt(i);
            if (p.login != login) continue;
            return p.users;
        }
        return null;
    }

    public void addUser(String username, String password) {
        if (this.puddle == null) {
            return;
        }
        this.puddle.users.add(new PasswordCredential(username, password));
    }

    public Vector getWorkspaceBeans() {
        return this.workspaceBeans;
    }

    public void addWorkspaceBean(WorkspaceBean workspaceBean) {
        this.workspaceBeans.add(workspaceBean);
    }

    public ConnectionInterface requestConnection() throws ConnectionFactoryException {
        if (this.designTime) {
            return null;
        }
        if (this.factory == null) {
            this.getFactory();
            if (this.factory == null) {
                throw new ConnectionFactoryException(RB.getStringResource(RB_KEY, "getFactoryFailed.ex.txt"));
            }
        }
        ConnectionInterface connection = null;
        connection = this.requestUsername != null && this.requestPassword != null ? this.factory.getConnection(this.requestUsername, this.requestPassword, (long)this.waitTimeOnBusyFactory) : this.factory.getConnection((long)this.waitTimeOnBusyFactory);
        return connection;
    }

    public WorkspaceBean requestWorkspace(ConnectionInterface connection) throws ConnectionFactoryException {
        WorkspaceBean workspaceBean = null;
        if (this.designTime) {
            workspaceBean = new WorkspaceBean();
            this.addWorkspaceBean(workspaceBean);
            return workspaceBean;
        }
        Object obj = connection.getObject();
        IWorkspace workspace = IWorkspaceHelper.narrow((Object)obj);
        workspaceBean = new WorkspaceBean(workspace);
        return workspaceBean;
    }

    public WorkspaceBean requestWorkspace() throws ConnectionFactoryException {
        ConnectionInterface connection = this.requestConnection();
        return this.requestWorkspace(connection);
    }

    public int getPoolMinSize(int puddle) {
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        return p.poolMinSize;
    }

    public void setPoolMinSize(int size) {
        if (size == -1) {
            return;
        }
        this.puddle.poolMinSize = size;
    }

    public void setPoolMinSize(int puddle, int size) {
        if (size == -1) {
            return;
        }
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        p.poolMinSize = size;
    }

    public int getPoolMinAvail(int puddle) {
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        return p.poolMinAvail;
    }

    public void setPoolMinAvail(int value) {
        if (value == -1) {
            return;
        }
        this.puddle.poolMinAvail = value;
    }

    public void setPoolMinAvail(int puddle, int value) {
        if (value == -1) {
            return;
        }
        BeanPuddle p = (BeanPuddle)this.puddles.elementAt(puddle);
        p.poolMinAvail = value;
    }

    public Logger getLogger() throws ConnectionFactoryException {
        if (this.factory == null) {
            this.getFactory();
            if (this.factory == null) {
                throw new ConnectionFactoryException(RB.getStringResource(RB_KEY, "getFactoryFailed.ex.txt"));
            }
        }
        String loggerName = ConnectionFactoryManager.getConnectionFactoryLoggerName((ConnectionFactoryConfiguration)this.factoryConfig);
        Logger logger = Logger.getLogger(loggerName);
        return logger;
    }

    public void resetFactory() {
        this.factory = null;
    }

    protected void getFactory() throws ConnectionFactoryException {
        if (this.configType == CONFIG_TYPE_MANUAL) {
            if (this.puddles.size() == 0) {
                return;
            }
            Puddle[] puddleArray = this.getPuddles();
            this.factoryConfig = new ManualConnectionFactoryConfiguration(puddleArray);
        } else if (this.configType == CONFIG_TYPE_PLATFORM) {
            this.factoryConfig = new PlatformConnectionFactoryConfiguration(this.bipServer);
        }
        this.factory = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)this.factoryConfig);
        this.factoryAdmin = this.factory.getAdminInterface();
    }

    protected String EncodePassword(String password) {
        String encodingTag = "{base64}";
        String encodedPassword = password;
        if (password != null && !password.startsWith(encodingTag)) {
            try {
                encodedPassword = SasPasswordString.encode((String)"base64", (String)password);
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
        }
        return encodedPassword;
    }

    protected String DecodePassword(String password) {
        String decodedPassword = password;
        if (password != null) {
            try {
                decodedPassword = SasPasswordString.decode((String)password);
            }
            catch (SasPasswordEncodingException sasPasswordEncodingException) {
                // empty catch block
            }
        }
        return decodedPassword;
    }

    protected class BeanPuddle {
        protected PasswordCredential login;
        protected Vector servers = new Vector();
        protected Vector users = new Vector();
        protected int poolMinSize = -1;
        protected int poolMinAvail = -1;
        protected String encryptionPolicy = "none";
        protected String encryptionContent = null;
        protected String encryptionAlgorithms = null;
        protected int clusterType = 1;
    }
}

