/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.config;

import com.sas.util.Strings;
import com.sas.util.config.BaseConfigParser;
import com.sas.util.config.ESRIMapConfig;
import com.sas.util.config.ESRIMapCube;
import com.sas.util.config.ESRIMapService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ESRIMapConfigParser
extends BaseConfigParser
implements Serializable {
    private List cubes;
    private List mapServices;

    public ESRIMapConfigParser(Object config) {
        super(config);
    }

    @Override
    public void traverseTree(Node node) throws Exception {
        short type;
        if (node == null) {
            return;
        }
        ESRIMapConfig config = null;
        if (this.getConfig() != null && this.getConfig() instanceof ESRIMapConfig) {
            config = (ESRIMapConfig)this.getConfig();
        }
        if ((type = node.getNodeType()) == 9) {
            Element _element = ((Document)node).getDocumentElement();
            NodeList elements = _element.getChildNodes();
            for (int k = 0; k < elements.getLength(); ++k) {
                Node _node = elements.item(k);
                if (_node.getNodeType() != 1) continue;
                String elementName = _node.getNodeName();
                if (elementName.equalsIgnoreCase("MapServer")) {
                    NodeList childNodes = _node.getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node serverProp = childNodes.item(i);
                        if (serverProp.getNodeName().equalsIgnoreCase("Server")) {
                            config.setServer(serverProp.getChildNodes().item(0).getNodeValue().trim());
                            continue;
                        }
                        if (serverProp.getNodeName().equalsIgnoreCase("Domain")) {
                            config.setDomain(serverProp.getChildNodes().item(0).getNodeValue().trim());
                            continue;
                        }
                        if (serverProp.getNodeName().equalsIgnoreCase("Userid")) {
                            config.setUserid(serverProp.getChildNodes().item(0).getNodeValue().trim());
                            continue;
                        }
                        if (!serverProp.getNodeName().equalsIgnoreCase("Password")) continue;
                        config.setPassword(serverProp.getChildNodes().item(0).getNodeValue().trim());
                    }
                    continue;
                }
                if (elementName.equalsIgnoreCase("RenderAlgorithm")) {
                    config.setRenderAlgorithm(_node.getChildNodes().item(0).getNodeValue().trim());
                    continue;
                }
                if (elementName.equalsIgnoreCase("RenderBreakCount")) {
                    config.setRenderBreakCount(Integer.parseInt(_node.getChildNodes().item(0).getNodeValue().trim()));
                    continue;
                }
                if (elementName.equalsIgnoreCase("UseJoin")) {
                    config.setUseJoin(Boolean.valueOf(_node.getChildNodes().item(0).getNodeValue().trim()));
                    continue;
                }
                if (elementName.equalsIgnoreCase("ColorScheme")) {
                    config.setColorScheme(_node.getChildNodes().item(0).getNodeValue().trim());
                    continue;
                }
                if (elementName.equalsIgnoreCase("MapServices")) {
                    NodeList mapServiceNodes = _node.getChildNodes();
                    for (int j = 0; j < mapServiceNodes.getLength(); ++j) {
                        NamedNodeMap names = null;
                        Node mapService = mapServiceNodes.item(j);
                        if (!mapService.getNodeName().equalsIgnoreCase("MapService")) continue;
                        ESRIMapService ms = new ESRIMapService();
                        names = mapService.getAttributes();
                        HashMap<String, String> layerToFieldMap = null;
                        ms.setName(names.getNamedItem("name").getNodeValue());
                        for (int h = 0; h < mapService.getChildNodes().getLength(); ++h) {
                            Node l;
                            if (layerToFieldMap == null) {
                                layerToFieldMap = new HashMap<String, String>();
                            }
                            if (!(l = mapService.getChildNodes().item(h)).getNodeName().equalsIgnoreCase("Layer")) continue;
                            names = l.getAttributes();
                            layerToFieldMap.put(names.getNamedItem("name").getNodeValue(), names.getNamedItem("field").getNodeValue());
                        }
                        ms.setLayerToFieldMap(layerToFieldMap);
                        if (this.mapServices == null) {
                            this.mapServices = new ArrayList();
                        }
                        this.mapServices.add(ms);
                        config.setMapServices(this.mapServices);
                    }
                    continue;
                }
                if (!elementName.equalsIgnoreCase("Cubes")) continue;
                NodeList cubeNodes = _node.getChildNodes();
                NamedNodeMap names = null;
                for (int i = 0; i < cubeNodes.getLength(); ++i) {
                    Node cubeNode = cubeNodes.item(i);
                    if (!cubeNode.getNodeName().equalsIgnoreCase("Cube")) continue;
                    names = cubeNode.getAttributes();
                    String cubeName = names.getNamedItem("name").getNodeValue();
                    String mapService = names.getNamedItem("mapService").getNodeValue();
                    String olapServer = names.getNamedItem("olapServer").getNodeValue();
                    ESRIMapCube emc = new ESRIMapCube();
                    emc.setUserid(config.getUserid());
                    emc.setPassword(config.getPassword());
                    emc.setServer(config.getServer());
                    emc.setDomain(config.getDomain());
                    emc.setName(cubeName);
                    emc.setMapService(mapService);
                    emc.setOlapServer(olapServer);
                    NodeList levelsNode = cubeNode.getChildNodes();
                    HashMap<String, String> levelToLayerMap = null;
                    for (int h = 0; h < levelsNode.getLength(); ++h) {
                        String[] _level;
                        Node levelNode;
                        if (levelToLayerMap == null) {
                            levelToLayerMap = new HashMap<String, String>();
                        }
                        if (!(levelNode = levelsNode.item(h)).getNodeName().equalsIgnoreCase("Level")) continue;
                        names = levelNode.getAttributes();
                        String level = names.getNamedItem("name").getNodeValue();
                        if (level != null && level.length() > 0 && (_level = Strings.split((String)level, (String)"[", (String)"].[", (String)"]")).length == 3) {
                            level = "[" + _level[0] + "].[" + _level[2] + "]";
                        }
                        levelToLayerMap.put(level, names.getNamedItem("layer").getNodeValue());
                    }
                    emc.setLevelToLayerMap(levelToLayerMap);
                    if (this.cubes == null) {
                        this.cubes = new ArrayList();
                    }
                    this.cubes.add(emc);
                    config.setCubes(this.cubes);
                }
            }
        }
    }
}

