/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.config;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.util.config.ESRIMapConfigParser;
import com.sas.util.config.ESRIMapCube;
import com.sas.util.config.ESRIMapMetadataReader;
import com.sas.util.config.ESRIMapService;
import com.sas.util.config.RB;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;

public class ESRIMapConfig {
    private String server;
    private String domain;
    private String userid;
    private String password;
    private String renderAlgorithm;
    private int renderBreakCount;
    private String colorScheme;
    private boolean useJoin = false;
    private List cubes;
    private List mapServices;
    private boolean activeMapAvailable;
    private Locale locale;
    static final String RB_KEY = "ESRIMapConfig.";

    public ESRIMapConfig() {
    }

    public ESRIMapConfig(String xmlFile) {
        this();
        ESRIMapConfigParser dom = new ESRIMapConfigParser(this);
        Document doc = null;
        try {
            doc = dom.getDocument(xmlFile);
            dom.traverseTree(doc);
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)ESRIMapConfig.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        this.activeMapAvailable = false;
    }

    public ESRIMapConfig(SessionContextInterface sessionContext) {
        this();
        new ESRIMapMetadataReader(this, sessionContext);
    }

    public ESRIMapConfig(SessionContextInterface sessionContext, Locale locale) {
        this(sessionContext);
        this.locale = locale;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private String getRealPath(String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public String getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(String colorScheme) {
        this.colorScheme = colorScheme;
    }

    public String getRenderAlgorithm() {
        return this.renderAlgorithm;
    }

    public void setRenderAlgorithm(String renderAlgorithm) {
        this.renderAlgorithm = renderAlgorithm;
    }

    public int getRenderBreakCount() {
        return this.renderBreakCount;
    }

    public void setRenderBreakCount(int renderBreakCount) {
        this.renderBreakCount = renderBreakCount;
    }

    public List getCubes() {
        return this.cubes;
    }

    public void setCubes(List cubes) {
        this.cubes = cubes;
    }

    public List getMapServices() {
        return this.mapServices;
    }

    public void setMapServices(List mapServices) {
        this.mapServices = mapServices;
    }

    public boolean isActiveMapAvailable() {
        return this.activeMapAvailable;
    }

    public void setActiveMapAvailable(boolean activeMapAvailable) {
        this.activeMapAvailable = activeMapAvailable;
    }

    public synchronized boolean isMapEnabled(String cubeName, String olapServerName) {
        List cubes = this.getCubes();
        if (cubes != null) {
            for (int i = 0; i < cubes.size(); ++i) {
                ESRIMapCube c = (ESRIMapCube)cubes.get(i);
                if (!c.getName().equalsIgnoreCase(cubeName) || !c.getOlapServer().equalsIgnoreCase(olapServerName)) continue;
                if (this.isEmpty(c.getDomain()) || this.isEmpty(c.getUserid()) || this.isEmpty(c.getPassword()) || this.isEmpty(c.getServer())) {
                    LoggerRepository2.getLogger((String)ESRIMapConfig.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).warn(RB.getStringResource(RB_KEY, "authentication.txt", this.getLocale()));
                }
                return true;
            }
        }
        return false;
    }

    private boolean isEmpty(String value) {
        return value == null || value != null && value.length() == 0;
    }

    public boolean isMapEnabled(BusinessModel ds) {
        return this.isMapEnabled(this.getActiveCubeName(ds), this.getActiveServerName(ds));
    }

    public boolean isMapEnabled(DataSelection ds) {
        return this.isMapEnabled(this.getActiveCubeName(ds), this.getActiveServerName(ds));
    }

    public boolean isGeographic(DataItem di, String cubeName) {
        return this.isGeographic(di, this.getCube(cubeName));
    }

    public boolean isGeographic(DataItem di, ESRIMapCube cube) {
        if (cube != null) {
            String dimName = this.getDimensionName(di);
            if (cube.getDimensionName() != null && dimName != null && dimName.equals(cube.getDimensionName())) {
                return true;
            }
        }
        return false;
    }

    private String getDimensionName(DataItem di) {
        String dimensionName = null;
        try {
            dimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)di.getBusinessModel(), (DataItem)di);
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)ESRIMapConfig.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return dimensionName;
    }

    public String getActiveCubeName(BusinessModel ds) {
        DataSourceCube dsc;
        Cube cube;
        List dataSources = ds.getObjects(true, DataSourceCube.class);
        if (dataSources.size() > 0 && (cube = (dsc = (DataSourceCube)dataSources.get(0)).getCube()) != null) {
            return cube.getLabel();
        }
        return null;
    }

    public String getActiveCubeName(DataSelection ds) {
        return this.getActiveCubeName((BusinessModel)ds);
    }

    public String getActiveServerName(BusinessModel ds) {
        DataSourceCube dsc;
        Server _server;
        List dataSources = ds.getObjects(true, DataSourceCube.class);
        if (dataSources.size() > 0 && (_server = (dsc = (DataSourceCube)dataSources.get(0)).getAccessPath().getServer()) != null) {
            return _server.getLabel();
        }
        return null;
    }

    public String getActiveServerName(DataSelection ds) {
        return this.getActiveServerName((BusinessModel)ds);
    }

    public synchronized ESRIMapCube getCube(String name) {
        if (this.cubes != null) {
            for (int i = 0; i < this.cubes.size(); ++i) {
                if (!((ESRIMapCube)this.cubes.get(i)).getName().equalsIgnoreCase(name)) continue;
                return (ESRIMapCube)this.cubes.get(i);
            }
        }
        return null;
    }

    public synchronized ESRIMapService getMapService(String name) {
        return this.getMapService(name, null);
    }

    public synchronized ESRIMapService getMapService(String name, String mapServer) {
        if (this.mapServices != null) {
            for (int i = 0; i < this.mapServices.size(); ++i) {
                if (!((ESRIMapService)this.mapServices.get(i)).getName().equalsIgnoreCase(name) || (mapServer == null || !((ESRIMapService)this.mapServices.get(i)).getUniqueMapServiceName().equals(mapServer)) && mapServer != null) continue;
                return (ESRIMapService)this.mapServices.get(i);
            }
        }
        return null;
    }

    public boolean isUseJoin() {
        return this.useJoin;
    }

    public void setUseJoin(boolean useJoin) {
        this.useJoin = useJoin;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }
}

