/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.config;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BaseConfigParser
implements Serializable {
    private Object configObj;

    public BaseConfigParser(Object config) {
        this.configObj = config;
    }

    public Document getDocument(String file) throws Exception {
        DocumentBuilder db = this.getDocumentBuilder();
        Document doc = db.parse(new File(file));
        return doc;
    }

    public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(new XMLErrorHandler());
        return db;
    }

    public Document getDocument(InputStream fileStream) throws Exception {
        DocumentBuilder db = this.getDocumentBuilder();
        Document doc = db.parse(fileStream);
        return doc;
    }

    public void traverseTree(Node node) throws Exception {
    }

    public String getFirstItem(NodeList nodeList) {
        if (nodeList != null && nodeList.getLength() > -1 && nodeList.item(0) != null && nodeList.item(0).getNodeValue().trim().length() > 1) {
            return nodeList.item(0).getNodeValue().trim();
        }
        return null;
    }

    public Object getConfig() {
        return this.configObj;
    }

    static class XMLErrorHandler
    implements ErrorHandler {
        XMLErrorHandler() {
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            System.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

