/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2.rmi;

import com.sas.actionprovider.SwingAction;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.rmi.AddFolderCommand;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileComponentInterface;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;

public class AddFolderRmiAction
extends SwingAction
implements PropertyChangeListener {
    public static final String RB_KEY = "RemoteFileSelector.";
    private TableView table;
    private int actualIndex;
    private SortableTableModelAdapter tableModel;
    private boolean newRowAdded;

    public AddFolderRmiAction() {
        this.setActionType("ADD_FOLDER_ACTION");
        this.setCustom(false);
        this.newRowAdded = false;
    }

    public AddFolderRmiAction(DynamicAttributeCommandInterface command) {
        super(command);
        this.setActionType("ADD_FOLDER_ACTION");
        this.setCustom(false);
        this.newRowAdded = false;
    }

    public void actionPerformed(ActionEvent event) {
        RemoteFileComponentInterface component = (RemoteFileComponentInterface)this.getAttribute("component");
        this.table = (TableView)component.getViewComponent();
        this.tableModel = (SortableTableModelAdapter)this.table.getModel();
        this.table.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.table.isEditing()) {
            TableCellEditor editor = this.table.getCellEditor(this.table.getSelectedRow(), 0);
            editor.stopCellEditing();
        }
        this.tableModel.setAutoResortEnabled(false);
        super.actionPerformed(event);
        DynamicAttributeCommandInterface command = this.getCommand();
        if (command instanceof AddFolderCommand && ((AddFolderCommand)command).isAddFailed()) {
            this.tableModel.setAutoResortEnabled(true);
            this.newRowAdded = false;
        } else {
            this.table.setRowSelectionAllowed(true);
            this.newRowAdded = true;
        }
    }

    protected void executeCommand(DynamicAttributeCommandInterface command) {
        try {
            command.execute(null);
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog((Component)this.table, iae.getMessage(), RB.getStringResource(RB_KEY, "error.txt"), 0);
            this.tableModel.setAutoResortEnabled(true);
            this.newRowAdded = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newRowCount;
        if (evt.getPropertyName().equalsIgnoreCase("rfsDetailViewRowInsertionComplete") && (newRowCount = this.table.getRowCount()) > 0) {
            this.actualIndex = newRowCount - 1;
            this.table.setCurrentRow(this.actualIndex);
            this.table.clearSelection();
            this.table.setRowSelectionInterval(this.actualIndex, this.actualIndex);
            Rectangle rect = this.table.getCellRect(this.actualIndex, 0, true);
            this.table.scrollRectToVisible(rect);
            this.newRowAdded = false;
        }
    }
}

