/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2.informationservices;

import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadataInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class InformationServicesFileMetadataNameCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final InformationServicesFileMetadataNameCellRenderer defaultInstance = new InformationServicesFileMetadataNameCellRenderer();
    private static final ImageIcon folderImage = new ImageIcon(Resources.getImage((String)"Folder", (int)16));
    private static final ImageIcon fileImage = new ImageIcon(Resources.getImage((String)"GenericSASObject", (int)16));
    private static final ImageIcon myFolderImage = new ImageIcon(Resources.getImage((String)"MyFolder", (int)16));
    public ServerInterface server;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Icon getIcon(RemoteFileMetadataInterface node) {
        if (node instanceof InformationServicesFileMetadataInterface) {
            InformationServicesFileMetadataInterface infoNode = (InformationServicesFileMetadataInterface)node;
            String type = infoNode.getType();
            if (node.isFolder()) {
                if (!"My Folder".equals(type)) return folderImage;
                return myFolderImage;
            }
            try {
                TypeDescriptorInterface typeDescriptor;
                if (this.server == null || (typeDescriptor = this.server.getTypeDescriptor(type)) == null) return fileImage;
                String iconName = typeDescriptor.getIconName();
                try {
                    ImageIcon fileIcon;
                    if (!(iconName instanceof String) || (fileIcon = new ImageIcon(Resources.getImage((String)iconName, (int)16))) == null) return fileImage;
                    return fileIcon;
                }
                catch (IllegalArgumentException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    return fileImage;
                }
            }
            catch (ServiceException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return fileImage;
            }
            catch (RemoteException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return fileImage;
            }
        } else {
            if (!node.isFolder()) return fileImage;
            return folderImage;
        }
    }

    public void setServer(ServerInterface dataServer) {
        this.server = dataServer;
    }

    public ServerInterface getServer() {
        return this.server;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        SortableTableModelAdapter sortableModel = (SortableTableModelAdapter)table.getModel();
        row = sortableModel.convertRowIndexToModel(row);
        RemoteFileMetadataInterface node = ((BaseRemoteFileModelInterface)sortableModel.getModel()).getNodeAt(row);
        this.setIcon(this.getIcon(node));
        this.setText(node.getName());
        this.setOpaque(true);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setEnabled(table.isEnabled());
        this.setFont(table.getFont());
        return this;
    }
}

