/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2.actions;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class RenameAction
extends SwingAction
implements CellEditorListener,
FocusListener,
MouseListener {
    public static final String RB_KEY = "RemoteFileSelector.";
    private BaseRemoteFileModelInterface model;
    private SortableTableModelAdapter tableModel;
    private int index;
    private String oldName;
    private TableView table;

    public void actionPerformed(ActionEvent event) {
        this.table = (TableView)this.getAttribute("table");
        this.index = this.table.getSelectedRow();
        if (this.index >= 0) {
            this.tableModel = (SortableTableModelAdapter)this.table.getModel();
            Integer actualIndex = new Integer(this.tableModel.convertRowIndexToModel(this.index));
            this.tableModel.setAutoResortEnabled(false);
            this.oldName = this.tableModel.getValueAt(this.index, 0).toString();
            try {
                this.setAttribute("index", actualIndex);
                this.setAttribute("oldName", this.oldName);
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            TableCellEditor cellEditor = this.table.getCellEditor(this.index, 0);
            cellEditor.addCellEditorListener(this);
            this.model = (BaseRemoteFileModelInterface)this.tableModel.getModel();
            Rectangle rect = this.table.getCellRect(this.index, 0, false);
            this.table.scrollRectToVisible(rect);
            this.model.setTableEditable(true);
            this.table.setCellSelectionInterval(this.index, 0, this.index, 0);
            this.table.editCellAt(this.index, 0);
            this.table.addMouseListener((MouseListener)this);
            JTextField text = (JTextField)this.table.getEditorComponent();
            text.addFocusListener(this);
            text.selectAll();
            text.requestFocus();
        }
    }

    @Override
    public void editingStopped(ChangeEvent ce) {
        this.table.removeMouseListener((MouseListener)this);
        String newName = this.tableModel.getValueAt(this.index, 0).toString();
        TableCellEditor cellEditor = this.table.getCellEditor(this.index, 0);
        cellEditor.removeCellEditorListener(this);
        this.model.setTableEditable(false);
        if (newName != null && !newName.equals("")) {
            try {
                this.setAttribute("newName", newName);
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            DynamicAttributeCommandInterface command = this.getCommand();
            if (command != null) {
                AttributeDescriptorInterface[] adi = this.getAttributeDescriptors();
                if (adi != null) {
                    for (int i = 0; i < adi.length; ++i) {
                        try {
                            AttributeDescriptorInterface attributeDescriptor = adi[i];
                            if (!attributeDescriptor.isModifiable()) continue;
                            command.setAttribute(attributeDescriptor.getName(), this.getValue(attributeDescriptor.getName()));
                            continue;
                        }
                        catch (AttributeSetException attributeSetException) {
                            // empty catch block
                        }
                    }
                }
                this.executeCommand(command);
                SwingActionProvider actionProvider = (SwingActionProvider)this.getActionProvider();
                if (command instanceof ContentsChangedInterface && actionProvider != null && ((ContentsChangedInterface)command).isContentsChanged()) {
                    actionProvider.fireContentsChanged(new ActionProviderEvent(((ContentsChangedInterface)command).getEventSource(), (Map)((ContentsChangedInterface)command).getEventInfo()));
                }
            }
        } else {
            this.tableModel.setValueAt((Object)this.oldName, this.index, 0);
        }
        this.tableModel.setAutoResortEnabled(true);
    }

    @Override
    public void editingCanceled(ChangeEvent ce) {
        this.tableModel.setAutoResortEnabled(true);
    }

    protected void executeCommand(DynamicAttributeCommandInterface command) {
        try {
            command.execute(null);
        }
        catch (IllegalArgumentException iae) {
            this.tableModel.setValueAt((Object)this.oldName, this.index, 0);
            JOptionPane.showMessageDialog((Component)this.table, iae.getMessage(), RB.getStringResource(RB_KEY, "error.txt"), 0);
            this.tableModel.setAutoResortEnabled(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            this.table.getEditorComponent().removeFocusListener(this);
            cellEditor.stopCellEditing();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            this.table.getEditorComponent().removeFocusListener(this);
            cellEditor.stopCellEditing();
        }
    }
}

